package com.bcxin.ars.service.sb.impl;

import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.certificate.CompanyCertificateDao;
import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.SyscodeDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.SxsSbAjaxResult;
import com.bcxin.ars.dto.SxsSbAjaxResultDataObj;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.SponsorlicenseDto;
import com.bcxin.ars.dto.sb.SponsorlicenseSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.SbSponsorlicenseManager;
import com.bcxin.ars.model.sb.SbSponsorlicenseVmanager;
import com.bcxin.ars.model.sb.Shareholder;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityGuardService;
import com.bcxin.ars.service.impl.ApprovalBusinessBaseService;
import com.bcxin.ars.service.sb.SponsorlicenseService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Sponsorlicense.class)
public class SponsorlicenseServiceImpl extends ApprovalBusinessBaseService implements SponsorlicenseService {

    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;

    @Autowired
    private SponsorlicenseDaoAop sponsorlicenseDaoAop;
    /***
     * 保安师信息
     */
    @Autowired
    private SecurityGuardService securityGuardService;
    /***
     * 公司证书信息
     */
    @Autowired
    private CompanyCertificateDao companyCertificateDao;

    /***
     * 区域编码信息
     */
    @Autowired
    private SyscodeDAO syscodeDAO;

    /***
     * 公司信息
     */
    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private ShareholderDao shareholderDao;

    @Autowired
    private SbSponsorlicenseManagerDao sbSponsorlicenseManagerDao;

    @Autowired
    private SbSponsorlicenseVmanagerDao sbSponsorlicenseVmanagerDao;

    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalUtil approvalUtil;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Override
    public Sponsorlicense findById(long id) {
        Sponsorlicense result = sponsorlicenseDao.findById(id);
        if (result != null) {
            //查询审批日志信息
            result.setApproval(approvalDAO.findBybusinessidAndType(result.getId(),BusinessType.BAFWGS));

            //查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }
    @Override
    public Map searchForPrintf(long id) {
        return sponsorlicenseDao.searchForPrintf(id);
    }

    @Override
    public List<Sponsorlicense> findByBatchId(List<Approval> approvalList) {
        return sponsorlicenseDao.findByBatchId(approvalList);
    }
    @Override
    public void saveOrUpdateForApproval(Sponsorlicense sponsorlicense) {
        sponsorlicense.setUpdateTime(new Date());
        sponsorlicenseDaoAop.update(sponsorlicense);
    }


    @Override
    public void updateCensorStatus(Sponsorlicense sponsorlicense) {
        sponsorlicense.setUpdateTime(new Date());
        sponsorlicenseDaoAop.updateCensorStatus(sponsorlicense);
    }

    @Override
    public void updatePoliceId(Sponsorlicense sponsorlicense) {
        Approval approval = approvalDAO.getById(sponsorlicense.getApprovalId());
        Sponsorlicense dbsponsorlicense = sponsorlicenseDao.findById(sponsorlicense.getId());
        dbsponsorlicense.setPoliceid(sponsorlicense.getPoliceid());
        sponsorlicenseDaoAop.update(dbsponsorlicense);
        /***
         * 更新
         */
        approval.setPoliceid(sponsorlicense.getPoliceid());
        approval.setRoleid(null);
        approval.setUpdateTime(new Date());
        approvalDAO.update(approval);

    }
    @Override
    public void saveOrUpdateForIntegrate(Sponsorlicense sponsorlicense, User currentUser) {
        /***
         * 根据不同的保安公司类型获取对应的key,默认为保安服务公司
         */
        String  processKey =  Constants.ACTIVITI_PROCESS_SPONSORLICENSE;
        if(StringUtil.isNotEmpty(sponsorlicense.getSponsorlicenseType())) {
            processKey =  BusinessType.getBusinessTypeName(BusinessType.BAFWGS, sponsorlicense.getSponsorlicenseType());
        }

        if(currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4){
            sponsorlicense.setUserid(currentUser.getId());
        }
        //获得名字跟百分比数组
        String[] name = new String[0];
        String[] percentage = new String[0];
        String[] investmentnum = new String[0];
        String[] idnumber = new String[0];
        String[] type = new String[0];

        //获得公司总经理
        String[] managername = new String[0];
        String[] manageridnum = new String[0];
        String[] managerphone = new String[0];


        //获得公司副总
        String[] vmanagername = new String[0];
        String[] vmanageridnum = new String[0];
        String[] vmanagerphone = new String[0];

        //2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
        if((null!= sponsorlicense.getManagement() && !sponsorlicense.getManagement().contains("20"))||null==sponsorlicense.getManagement()){
            sponsorlicense.setOtherSecScopeType(null);
        }

        //获得公司总经理
        if (null!=sponsorlicense.getSbSponsorlicenseManager()) {
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseManager().getName())) {
                managername = sponsorlicense.getSbSponsorlicenseManager().getName().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseManager().getIdnum())) {
                manageridnum = sponsorlicense.getSbSponsorlicenseManager().getIdnum().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseManager().getPhone())) {
                managerphone = sponsorlicense.getSbSponsorlicenseManager().getPhone().split(",");
            }
        }
        if (null!=sponsorlicense.getSbSponsorlicenseVmanager()) {
            //获得公司副总经理
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVname())) {
                vmanagername = sponsorlicense.getSbSponsorlicenseVmanager().getVname().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVidnum())) {
                vmanageridnum = sponsorlicense.getSbSponsorlicenseVmanager().getVidnum().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVphone())) {
                vmanagerphone = sponsorlicense.getSbSponsorlicenseVmanager().getVphone().split(",");
            }
        }


        //获得股东信息
        if (null!= sponsorlicense.getShareholder() ) {
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getName())) {
                name = sponsorlicense.getShareholder().getName().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getPercentage())) {
                percentage = sponsorlicense.getShareholder().getPercentage().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getInvestmentnum())) {
                investmentnum = sponsorlicense.getShareholder().getInvestmentnum().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getIdnumber())) {
                idnumber = sponsorlicense.getShareholder().getIdnumber().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getType())) {
                type = sponsorlicense.getShareholder().getType().split(",");
            }
        }
        int[] a = {name.length, percentage.length, investmentnum.length, idnumber.length, type.length};
        int count = StringUtil.getMax(a);

        int[] b = {managername.length, manageridnum.length, managerphone.length};
        int countb = StringUtil.getMax(b);

        int[] c = {vmanagername.length, vmanageridnum.length, vmanagerphone.length};
        int countc = StringUtil.getMax(c);

        if(!sponsorlicense.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
            //开发任务 #10165
            Sponsorlicense checkSponsorlicense = sponsorlicenseDao.findApproveByCompanyName(sponsorlicense.getCompanyname());
            if (checkSponsorlicense != null) {
                throw new ArsException(sponsorlicense.getCompanyname() + "已备案，不能重复备案！");
            }
        }

        if (sponsorlicense.getId() == null) {
            sponsorlicense.setId(idGeneratorUtil.createID());
        }
        sponsorlicense.setActive(true);
        sponsorlicense.setCreateTime(new Date());
        sponsorlicense.setUpdateTime(new Date());
        sponsorlicense.setUpdateBy(currentUser.getUsername());
        //待审批或暂存
        sponsorlicenseDao.save(sponsorlicense);

        //保存股东出资额及所占比例
        for (int i = 0; i < count; i++) {
            Shareholder shareholder = new Shareholder();
            shareholder.setId(idGeneratorUtil.createID());
            shareholder.setActive(true);
            shareholder.setCreateTime(new Date());
            shareholder.setUpdateTime(new Date());
            shareholder.setUpdateBy(currentUser.getUsername());
            shareholder.setSponsorlicenseid(sponsorlicense.getId());
            //判断是否非空，非空则保存
            if (sponsorlicense.getShareholder() != null) {
                if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getName())) {
                    if (name.length > i) {
                        shareholder.setName(name[i]);
                    }

                }
                if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getPercentage())) {
                    if (percentage.length > i) {
                        shareholder.setPercentage(percentage[i]);
                    }

                }
                if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getInvestmentnum())) {
                    if (investmentnum.length > i) {
                        shareholder.setInvestmentnum(investmentnum[i]);
                    }

                }
                if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getIdnumber())) {
                    if (idnumber.length > i) {
                        shareholder.setIdnumber(idnumber[i]);
                    }

                }
                if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getType())) {
                    if (type.length > i) {
                        shareholder.setType(type[i]);
                    }

                }
            }
            shareholderDao.save(shareholder);
        }

        //公司总经理信息
        for (int i = 0; i < countb; i++) {
            SbSponsorlicenseManager sbSponsorlicenseManager = new SbSponsorlicenseManager();
            sbSponsorlicenseManager.setId(idGeneratorUtil.createID());
            sbSponsorlicenseManager.setActive(true);
            sbSponsorlicenseManager.setCreateTime(new Date());
            sbSponsorlicenseManager.setUpdateTime(new Date());
            sbSponsorlicenseManager.setUpdateBy(currentUser.getUsername());
            sbSponsorlicenseManager.setSponsorlicenseid(sponsorlicense.getId());
            //判断是否非空，非空则保存
            if (sponsorlicense.getSbSponsorlicenseManager() != null) {
                if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseManager().getName())) {
                    if (managername.length > i && !managername[i].equals("")) {
                        sbSponsorlicenseManager.setName(managername[i]);
                    }

                }
                if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseManager().getIdnum())) {
                    if (manageridnum.length > i && !manageridnum[i].equals("")) {
                        sbSponsorlicenseManager.setIdnum(manageridnum[i]);
                    }

                }
                if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseManager().getPhone())) {
                    if (managerphone.length > i && !managerphone[i].equals("")) {
                        sbSponsorlicenseManager.setPhone(managerphone[i]);
                    }

                }
            }
            sbSponsorlicenseManagerDao.save(sbSponsorlicenseManager);
        }

        //公司副总信息
        for (int i = 0; i < countc; i++) {
            SbSponsorlicenseVmanager sbSponsorlicenseVmanager = new SbSponsorlicenseVmanager();
            sbSponsorlicenseVmanager.setId(idGeneratorUtil.createID());
            sbSponsorlicenseVmanager.setActive(true);
            sbSponsorlicenseVmanager.setCreateTime(new Date());
            sbSponsorlicenseVmanager.setUpdateTime(new Date());
            sbSponsorlicenseVmanager.setUpdateBy(currentUser.getUsername());
            sbSponsorlicenseVmanager.setSponsorlicenseid(sponsorlicense.getId());
            //判断是否非空，非空则保存
            if (sponsorlicense.getSbSponsorlicenseManager() != null) {
                if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVname())) {
                    if (vmanagername.length > i && !vmanagername[i].equals("")) {
                        sbSponsorlicenseVmanager.setVname(vmanagername[i]);
                    }

                }
                if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVidnum())) {
                    if (vmanageridnum.length > i && !vmanageridnum[i].equals("")) {
                        sbSponsorlicenseVmanager.setVidnum(vmanageridnum[i]);
                    }

                }
                if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVphone())) {
                    if (vmanagerphone.length > i && !vmanagerphone[i].equals("")) {
                        sbSponsorlicenseVmanager.setVphone(vmanagerphone[i]);
                    }

                }
            }
            sbSponsorlicenseVmanagerDao.save(sbSponsorlicenseVmanager);
        }
        approvalUtil.saveApprovalForIntegrate(BusinessType.BAFWGS, sponsorlicense.getId(),processKey,currentUser);

    }
    @Override
    public void saveOrUpdate(Sponsorlicense sponsorlicense) {
        User currentUser = arsUtil.getCurrentUser();

        /**
         * 最后一级机构id处理
         */
        if(sponsorlicense.getOrgid() == null){
            if(sponsorlicense.getDistrictOrgId() != null){
                sponsorlicense.setOrgid(Long.parseLong(sponsorlicense.getDistrictOrgId()));
            }else if(sponsorlicense.getCityOrgId() != null){
                sponsorlicense.setOrgid(Long.parseLong(sponsorlicense.getCityOrgId()));
            }
        }

        /***
         * 根据不同的保安公司类型获取对应的key,默认为保安服务公司
         */
        String  processKey =  Constants.ACTIVITI_PROCESS_SPONSORLICENSE;
        if(StringUtil.isNotEmpty(sponsorlicense.getSponsorlicenseType())) {
            processKey =  BusinessType.getBusinessTypeName(BusinessType.BAFWGS, sponsorlicense.getSponsorlicenseType());
        }

        if(currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4 ){
            sponsorlicense.setUserid(currentUser.getId());
        }
        //获得名字跟百分比数组
        String[] name = new String[0];
        String[] percentage = new String[0];
        String[] investmentnum = new String[0];
        String[] idnumber = new String[0];
        String[] type = new String[0];
        String[] companyName = new String[0];
        String[] companyAddress = new String[0];
        String[] companyType = new String[0];
        String[] socialCode = new String[0];
        String[] companyPhone = new String[0];

        //获得公司总经理
        String[] managername = new String[0];
        String[] manageridnum = new String[0];
        String[] managerphone = new String[0];


        //获得公司副总
        String[] vmanagername = new String[0];
        String[] vmanageridnum = new String[0];
        String[] vmanagerphone = new String[0];

        //2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
        if((null!= sponsorlicense.getManagement() && !sponsorlicense.getManagement().contains("20"))||null==sponsorlicense.getManagement()){
            sponsorlicense.setOtherSecScopeType(null);
        }

        //获得公司总经理
        if (null!=sponsorlicense.getSbSponsorlicenseManager()) {
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseManager().getName())) {
                managername = sponsorlicense.getSbSponsorlicenseManager().getName().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseManager().getIdnum())) {
                manageridnum = sponsorlicense.getSbSponsorlicenseManager().getIdnum().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseManager().getPhone())) {
                managerphone = sponsorlicense.getSbSponsorlicenseManager().getPhone().split(",");
            }
        }
        if (null!=sponsorlicense.getSbSponsorlicenseVmanager()) {
            //获得公司副总经理
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVname())) {
                vmanagername = sponsorlicense.getSbSponsorlicenseVmanager().getVname().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVidnum())) {
                vmanageridnum = sponsorlicense.getSbSponsorlicenseVmanager().getVidnum().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVphone())) {
                vmanagerphone = sponsorlicense.getSbSponsorlicenseVmanager().getVphone().split(",");
            }
        }


        //获得股东信息
        if (null!= sponsorlicense.getShareholder() ) {
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getName())) {
                name = sponsorlicense.getShareholder().getName().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getPercentage())) {
                percentage = sponsorlicense.getShareholder().getPercentage().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getInvestmentnum())) {
                investmentnum = sponsorlicense.getShareholder().getInvestmentnum().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getIdnumber())) {
                idnumber = sponsorlicense.getShareholder().getIdnumber().split(",");
            }
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getType())) {
                type = sponsorlicense.getShareholder().getType().split(",");
            }
            //机构名称
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyName())) {
                companyName = sponsorlicense.getShareholder().getCompanyName().split(",");
            }

            //机构住所
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyAddress())) {
                companyAddress = sponsorlicense.getShareholder().getCompanyAddress().split(",");
            }
            //机构类型
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyType())) {
                companyType = sponsorlicense.getShareholder().getCompanyType().split(",");
            }

            //信用代码
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getSocialCode())) {
                socialCode = sponsorlicense.getShareholder().getSocialCode().split(",");
            }

            //法人手机
            if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyPhone())) {
                companyPhone = sponsorlicense.getShareholder().getCompanyPhone().split(",");
            }
        }
        int[] a = {name.length, percentage.length, investmentnum.length, idnumber.length, type.length,
                companyName.length,socialCode.length,companyAddress.length,companyType.length,companyPhone.length};
        int count = StringUtil.getMax(a);

        int[] b = {managername.length, manageridnum.length, managerphone.length};
        int countb = StringUtil.getMax(b);

        int[] c = {vmanagername.length, vmanageridnum.length, vmanagerphone.length};
        int countc = StringUtil.getMax(c);

        if (sponsorlicense.getId() == null) {
            if(!sponsorlicense.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                //开发任务 #10165
                Sponsorlicense checkSponsorlicense = sponsorlicenseDao.findApproveByCompanyName(sponsorlicense.getCompanyname());
                if (checkSponsorlicense != null) {
                    throw new ArsException(sponsorlicense.getCompanyname() + "已备案，不能重复备案！");
                }
            }

            sponsorlicense.setId(idGeneratorUtil.createID());
            sponsorlicense.setActive(true);
            sponsorlicense.setCreateTime(new Date());
            sponsorlicense.setUpdateTime(new Date());
            sponsorlicense.setUpdateBy(currentUser.getUsername());
            //待审批或暂存
            sponsorlicenseDao.save(sponsorlicense);

            //保存股东出资额及所占比例
            for (int i = 0; i < count; i++) {
                Shareholder shareholder = new Shareholder();
                shareholder.setId(idGeneratorUtil.createID());
                shareholder.setActive(true);
                shareholder.setCreateTime(new Date());
                shareholder.setUpdateTime(new Date());
                shareholder.setUpdateBy(currentUser.getUsername());
                shareholder.setSponsorlicenseid(sponsorlicense.getId());
                //判断是否非空，非空则保存
                if (sponsorlicense.getShareholder() != null) {
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getName())) {
                        if (name.length > i) {
                            shareholder.setName(name[i]);
                        }

                    }
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getPercentage())) {
                        if (percentage.length > i) {
                            shareholder.setPercentage(percentage[i]);
                        }

                    }
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getInvestmentnum())) {
                        if (investmentnum.length > i) {
                            shareholder.setInvestmentnum(investmentnum[i]);
                        }

                    }
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getIdnumber())) {
                        if (idnumber.length > i) {
                            shareholder.setIdnumber(idnumber[i]);
                        }

                    }
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getType())) {
                        if (type.length > i) {
                            shareholder.setType(type[i]);
                        }

                    }


                    //机构名称
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyName())) {
                        if (companyName.length > i) {
                            shareholder.setCompanyName(companyName[i]);
                        }

                    }


                    //机构住所
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyAddress())) {
                        if (companyAddress.length > i) {
                            shareholder.setCompanyAddress(companyAddress[i]);
                        }

                    }



                    //机构信用号
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getSocialCode())) {
                        if (socialCode.length > i) {
                            shareholder.setSocialCode(socialCode[i]);
                        }

                    }



                    //机构类型
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyType())) {
                        if (companyType.length > i) {
                            shareholder.setCompanyType(companyType[i]);
                        }

                    }

                    //法人联系手机
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyPhone())) {
                        if (companyPhone.length > i) {
                            shareholder.setCompanyPhone(companyPhone[i]);
                        }

                    }
                }
                shareholderDao.save(shareholder);
            }

            //公司总经理信息
            for (int i = 0; i < countb; i++) {
                SbSponsorlicenseManager sbSponsorlicenseManager = new SbSponsorlicenseManager();
                sbSponsorlicenseManager.setId(idGeneratorUtil.createID());
                sbSponsorlicenseManager.setActive(true);
                sbSponsorlicenseManager.setCreateTime(new Date());
                sbSponsorlicenseManager.setUpdateTime(new Date());
                sbSponsorlicenseManager.setUpdateBy(currentUser.getUsername());
                sbSponsorlicenseManager.setSponsorlicenseid(sponsorlicense.getId());
                //判断是否非空，非空则保存
                if (sponsorlicense.getSbSponsorlicenseManager() != null) {
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseManager().getName())) {
                        if (managername.length > i && !managername[i].equals("")) {
                            sbSponsorlicenseManager.setName(managername[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseManager().getIdnum())) {
                        if (manageridnum.length > i && !manageridnum[i].equals("")) {
                            sbSponsorlicenseManager.setIdnum(manageridnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseManager().getPhone())) {
                        if (managerphone.length > i && !managerphone[i].equals("")) {
                            sbSponsorlicenseManager.setPhone(managerphone[i]);
                        }

                    }
                }
                sbSponsorlicenseManagerDao.save(sbSponsorlicenseManager);
            }

            //公司副总信息
            for (int i = 0; i < countc; i++) {
                SbSponsorlicenseVmanager sbSponsorlicenseVmanager = new SbSponsorlicenseVmanager();
                sbSponsorlicenseVmanager.setId(idGeneratorUtil.createID());
                sbSponsorlicenseVmanager.setActive(true);
                sbSponsorlicenseVmanager.setCreateTime(new Date());
                sbSponsorlicenseVmanager.setUpdateTime(new Date());
                sbSponsorlicenseVmanager.setUpdateBy(currentUser.getUsername());
                sbSponsorlicenseVmanager.setSponsorlicenseid(sponsorlicense.getId());
                //判断是否非空，非空则保存
                if (sponsorlicense.getSbSponsorlicenseManager() != null) {
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVname())) {
                        if (vmanagername.length > i && !vmanagername[i].equals("")) {
                            sbSponsorlicenseVmanager.setVname(vmanagername[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVidnum())) {
                        if (vmanageridnum.length > i && !vmanageridnum[i].equals("")) {
                            sbSponsorlicenseVmanager.setVidnum(vmanageridnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVphone())) {
                        if (vmanagerphone.length > i && !vmanagerphone[i].equals("")) {
                            sbSponsorlicenseVmanager.setVphone(vmanagerphone[i]);
                        }

                    }
                }
                sbSponsorlicenseVmanagerDao.save(sbSponsorlicenseVmanager);
            }
            //TODO 保存审批信息
            if (sponsorlicense.getApprovalstate().equals(ApprovalState.DSH)) {
                approvalUtil.saveApproval(BusinessType.BAFWGS, sponsorlicense.getId(),processKey);
            }
        } else {
            if(!sponsorlicense.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                //开发任务 #10165
                Sponsorlicense checkSponsorlicense = sponsorlicenseDao.findApproveByCompanyName(sponsorlicense.getCompanyname());
                if (checkSponsorlicense != null && checkSponsorlicense.getId().longValue() != sponsorlicense.getId().longValue()) {
                    throw new ArsException(sponsorlicense.getCompanyname() + "已备案，不能重复备案！");
                }

            }

            Sponsorlicense dbSponsorlicense = sponsorlicenseDao.findById(sponsorlicense.getId());

            boolean activity = true;
            if(StringUtil.isNotEmpty(dbSponsorlicense.getApprovalstate()) && dbSponsorlicense.getApprovalstate().equals(ApprovalState.DSH)){
                if(dbSponsorlicense.getOrgid().toString().equals(sponsorlicense.getOrgid().toString())){
                    activity = false;
                    if(!dbSponsorlicense.getCompanyname().equals(sponsorlicense.getCompanyname())) {
                        Approval approval = approvalDAO.findBybusinessidAndType(sponsorlicense.getId(), BusinessType.BAFWGS);
                        if (approval != null) {
                            approvalUtil.updateContent(approval, sponsorlicense.getCompanyname());
                        }
                    }
                }
            }

            if(ApprovalState.WTJ.equals(sponsorlicense.getApprovalstate())){
                activity = false;
                BeanUtils.copyPropertiesIgnore(sponsorlicense,dbSponsorlicense,"active,createTime,userid",true);
            }else{
                BeanUtils.copyPropertiesIgnore(sponsorlicense,dbSponsorlicense,true);
            }
            dbSponsorlicense.setUpdateTime(new Date());
            dbSponsorlicense.setUpdateBy(currentUser.getUsername());
            dbSponsorlicense.setOtherSecScopeType(sponsorlicense.getOtherSecScopeType());

            if (sponsorlicense.getPoliceid() != null && !"".equals(sponsorlicense.getPoliceid())) {
                dbSponsorlicense.setPoliceid(sponsorlicense.getPoliceid());
            }
            //TODO
            //dbSponsorlicense.setUserid(currentUser.getId().intValue());
            //待审批
            if (sponsorlicense.getApprovalstate() != null && !"".equals(sponsorlicense.getApprovalstate()) && !sponsorlicense.getApprovalstate().equals(ApprovalState.DSH)) {
                dbSponsorlicense.setApprovalstate(sponsorlicense.getApprovalstate());
            } else {
                dbSponsorlicense.setApprovalstate(ApprovalState.DSH);
                dbSponsorlicense.setReplyreason("");
                dbSponsorlicense.setInfoRar("");
                dbSponsorlicense.setReplyState("");
                dbSponsorlicense.setReplyRar("");
                dbSponsorlicense.setCensorstatus("");

            }
            sponsorlicenseDaoAop.update(dbSponsorlicense);

            //先删除原有的
            shareholderDao.deleteBySid(sponsorlicense.getId().toString());
            //更新股东出资额及所占比例
            for (int i = 0; i < count; i++) {
                Shareholder shareholder = new Shareholder();
                shareholder.setActive(true);
                shareholder.setId(idGeneratorUtil.createID());
                shareholder.setCreateTime(new Date());
                shareholder.setUpdateTime(new Date());
                shareholder.setUpdateBy(currentUser.getUsername());
                shareholder.setSponsorlicenseid(sponsorlicense.getId());
                //判断是否非空，非空则保存
                if (sponsorlicense.getShareholder() != null) {
                    if (!StringUtils.isEmpty(sponsorlicense.getShareholder().getName())) {
                        if (name.length > i) {
                            shareholder.setName(name[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getShareholder().getPercentage())) {
                        if (percentage.length > i) {
                            shareholder.setPercentage(percentage[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getShareholder().getInvestmentnum())) {
                        if (investmentnum.length > i) {
                            shareholder.setInvestmentnum(investmentnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getShareholder().getIdnumber())) {
                        if (idnumber.length > i) {
                            shareholder.setIdnumber(idnumber[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getShareholder().getType())) {
                        if (type.length > i) {
                            shareholder.setType(type[i]);
                        }

                    }

                    //机构名称
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyName())) {
                        if (companyName.length > i) {
                            shareholder.setCompanyName(companyName[i]);
                        }

                    }


                    //机构住所
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyAddress())) {
                        if (companyAddress.length > i) {
                            shareholder.setCompanyAddress(companyAddress[i]);
                        }

                    }



                    //机构信用号
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getSocialCode())) {
                        if (socialCode.length > i) {
                            shareholder.setSocialCode(socialCode[i]);
                        }

                    }



                    //机构类型
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyType())) {
                        if (companyType.length > i) {
                            shareholder.setCompanyType(companyType[i]);
                        }

                    }

                    //法人联系手机
                    if (StringUtils.isNotEmpty(sponsorlicense.getShareholder().getCompanyPhone())) {
                        if (companyPhone.length > i) {
                            shareholder.setCompanyPhone(companyPhone[i]);
                        }

                    }
                }
                shareholderDao.save(shareholder);
            }
            //先删除原有的
            sbSponsorlicenseManagerDao.deleteBySid(sponsorlicense.getId());
            //更新公司总经理信息
            for (int i = 0; i < countb; i++) {
                SbSponsorlicenseManager sbSponsorlicenseManager = new SbSponsorlicenseManager();
                sbSponsorlicenseManager.setActive(true);
                sbSponsorlicenseManager.setId(idGeneratorUtil.createID());
                sbSponsorlicenseManager.setCreateTime(new Date());
                sbSponsorlicenseManager.setUpdateTime(new Date());
                sbSponsorlicenseManager.setUpdateBy(currentUser.getUsername());
                sbSponsorlicenseManager.setSponsorlicenseid(sponsorlicense.getId());
                //判断是否非空，非空则保存
                if (sponsorlicense.getSbSponsorlicenseManager() != null) {
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseManager().getName())) {
                        if (managername.length > i && !managername[i].equals("")) {
                            sbSponsorlicenseManager.setName(managername[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseManager().getIdnum())) {
                        if (manageridnum.length > i && !manageridnum[i].equals("")) {
                            sbSponsorlicenseManager.setIdnum(manageridnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseManager().getPhone())) {
                        if (managerphone.length > i && !managerphone[i].equals("")) {
                            sbSponsorlicenseManager.setPhone(managerphone[i]);
                        }

                    }
                }
                sbSponsorlicenseManagerDao.save(sbSponsorlicenseManager);
            }

            //先删除原有的
            sbSponsorlicenseVmanagerDao.deleteBySid(sponsorlicense.getId());

            //公司副总信息
            for (int i = 0; i < countc; i++) {
                SbSponsorlicenseVmanager sbSponsorlicenseVmanager = new SbSponsorlicenseVmanager();
                sbSponsorlicenseVmanager.setActive(true);
                sbSponsorlicenseVmanager.setId(idGeneratorUtil.createID());
                sbSponsorlicenseVmanager.setCreateTime(new Date());
                sbSponsorlicenseVmanager.setUpdateTime(new Date());
                sbSponsorlicenseVmanager.setUpdateBy(currentUser.getUsername());
                sbSponsorlicenseVmanager.setSponsorlicenseid(sponsorlicense.getId());
                //判断是否非空，非空则保存
                if (sponsorlicense.getSbSponsorlicenseManager() != null) {
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVname())) {
                        if (vmanagername.length > i && !vmanagername[i].equals("")) {
                            sbSponsorlicenseVmanager.setVname(vmanagername[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVidnum())) {
                        if (vmanageridnum.length > i && !vmanageridnum[i].equals("")) {
                            sbSponsorlicenseVmanager.setVidnum(vmanageridnum[i]);
                        }

                    }
                    if (!StringUtils.isEmpty(sponsorlicense.getSbSponsorlicenseVmanager().getVphone())) {
                        if (vmanagerphone.length > i && !vmanagerphone[i].equals("")) {
                            sbSponsorlicenseVmanager.setVphone(vmanagerphone[i]);
                        }

                    }
                }
                sbSponsorlicenseVmanagerDao.save(sbSponsorlicenseVmanager);
            }
            //TODO 更新审批信息
            if(activity){
                approvalUtil.saveApproval(BusinessType.BAFWGS, dbSponsorlicense.getId(), processKey);
            }
        }
    }

    @Override
    public void saveOrUpdateForDS(Sponsorlicense sponsorlicense) {
        if (sponsorlicense.getActive() == null) {
            sponsorlicense.setActive(true);
        }
        Sponsorlicense dbSponsorlicense = sponsorlicenseDao.findById(sponsorlicense.getId());
        if (dbSponsorlicense != null) {
            if (sponsorlicense.getUpdateTime().getTime() > dbSponsorlicense.getUpdateTime().getTime()) {
                //指派民警
                sponsorlicense.setPoliceid(dbSponsorlicense.getPoliceid());
                sponsorlicense.setCensorstatus(dbSponsorlicense.getCensorstatus());
                sponsorlicense.setCardState(dbSponsorlicense.getCardState());
                sponsorlicense.setReplyState(dbSponsorlicense.getReplyState());
                sponsorlicenseDaoAop.update(sponsorlicense);
            }
        } else {
            Sponsorlicense checkSponsorlicense = sponsorlicenseDao.findApproveByCompanyName(sponsorlicense.getCompanyname());
            if (checkSponsorlicense != null) {
                sponsorlicense.setApprovalstate(ApprovalState.SHBTG);
                new Thread(()->{
                    try {
                        Thread.sleep(100000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Approval approval = approvalDAO.findBybusinessidAndType(sponsorlicense.getId(),BusinessType.BAFWGS);
                    approval.setApprovalstate(ApprovalState.SHBTG);
                    approval.setApprovalreason("重复提交");
                    approval.setUpdateflag(true);
                    approval.setUpdateTime(new Date());
                    approvalDAO.update(approval);
                }).start();
            }
            sponsorlicenseDao.save(sponsorlicense);
        }
    }

    @Override
    public SponsorlicenseSearchDto search(SponsorlicenseSearchDto dto) {
        SponsorlicenseSearchDto resultDto = new SponsorlicenseSearchDto();
        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        String areacode = police.getAreacode();
        if (areacode.endsWith("0000")) {//省
            dto.setDistrict(areacode.substring(0, 2) + "____");
        } else if (areacode.endsWith("00")) {//市
            dto.setDistrict(areacode.substring(0, 4) + "__");
        } else {//区
            dto.setDistrict(areacode);
        }
        List<Sponsorlicense> list = sponsorlicenseDao.search(dto);

        resultDto.setData(list);
        resultDto.setTotalCount(sponsorlicenseDao.searchCount(dto));
        return resultDto;
    }

    @Override
    public Sponsorlicense findByUser(Long userid) {
        // TODO Auto-generated method stub
        return sponsorlicenseDao.findByUser(userid);
    }

    @Override
    public List<Sponsorlicense> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return sponsorlicenseDao.searchForDataSynchronization(searchDto);
    }

    @Override
    public List<Sponsorlicense> findAll() {
        return sponsorlicenseDao.findAll();
    }
    @Override
    public SxsSbAjaxResult find() {

        SxsSbAjaxResult sxsZwAjaxResult = new SxsSbAjaxResult();
        Long ywCount =  0l;
        Map<String, Object> baseMap = new HashMap<String, Object>();

        List<Map<String, Object>> baseList =sponsorlicenseDao.find();

        for (Map<String, Object> map:baseList     //遍历list
                ) {

            String key = map.get("tile").toString();
            Object value =map.get("sum").toString();
            ywCount += new Long(map.get("sum").toString());
            baseMap.put(key,value);
        }


        SxsSbAjaxResultDataObj dataObj = new SxsSbAjaxResultDataObj();

        dataObj.setData(baseMap);
        dataObj.setYwCount(ywCount);



        sxsZwAjaxResult.setDataObj(dataObj);


        return sxsZwAjaxResult;
    }

    @Override
    public SponsorlicenseDto getDetail(Long id) {
        SponsorlicenseDto sponsorlicenseDto = new SponsorlicenseDto();
        Sponsorlicense sponsorlicense = sponsorlicenseDao.findById(id);

        if (sponsorlicense != null) {
            //查询审批日志信息
            sponsorlicense.setApproval(approvalDAO.findBybusinessidAndType(sponsorlicense.getId(),BusinessType.BAFWGS));
            //查询机构信息
            Police police = policeDao.findById(sponsorlicense.getOrgid());
            sponsorlicense.setPolice(police);
            BeanUtils.copyPropertiesIgnore(sponsorlicense,sponsorlicenseDto,true);
            sponsorlicenseDto.setShareholderList(shareholderDao.findBySId(id.toString()));
            sponsorlicenseDto.setManageList(sbSponsorlicenseManagerDao.findBySponsorId(id));
            sponsorlicenseDto.setVmanageList(sbSponsorlicenseVmanagerDao.findBySponsorId(id));
        }

        return sponsorlicenseDto;
    }

    @Override
    public void searchForPage(SponsorlicenseSearchDto dto, AjaxPageResponse<Sponsorlicense> page) {
        arsUtil.setPoliceSearch(dto);
        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType())) {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setUserid(user.getId());
            }
        }

        sponsorlicenseDao.searchForPage(dto,page);
    }

    @Override
    public List<ReportData> findByAreaReport(ReportDataSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        return sponsorlicenseDao.findByAreaReport(searchDto);
    }

    @Override
    public PageResult searchSponsorlicenseList_table(Map<Object, Object> p) {

        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else {
            if (police != null) {
                areacode = police.getAreacode();
            }

        }
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("district", areacode.substring(0, 4) + "__");
            } else {//区
                p.put("district", areacode);
            }
        }
        if (police != null) {
            if (police.getOrgtype().equals("4")) {
                p.put("orgid", police.getId());
            }
        }
        if (p.get("checkType")!=null) {
            if (currentUser != null) {
                p.put("userid", currentUser.getId());
            }
        }

        //数据权限
        if(currentUser.getAreasList()!=null &&currentUser.getAreasList().size()>0) {
            p.put("userAreaCode",true);
            p.put("areasList",currentUser.getAreasList());
        }
        return new PageResult(sponsorlicenseDao.countSponsorlicenseList(p), sponsorlicenseDao.searchSponsorlicenseList(p));
    }

    @Override
    public void saveOrUpdateForApprovalImport(Sponsorlicense sponsorlicense) {
        sponsorlicenseDaoAop.update(sponsorlicense);
    }
    @Override
    public void saveOrUpdateForApprovalBatchImport(List<Sponsorlicense> sponsorlicenseList) {
        sponsorlicenseDaoAop.updateBatch(sponsorlicenseList);
    }


    @Override
    public void passPost(Approval approval) {
        //获取审批信息
        Sponsorlicense sponsorlicense = sponsorlicenseDao.findById(approval.getBusinessid());
        /***
         * 获取当前省份信息
         */
        Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
        //广西审批通过 审批意见即为批复意见 2019-01-17
        //#5104 广西区厅最高层级领导审批与批复意见的优化
        if(provinceConfig != null && StringUtil.isNotEmpty(provinceConfig.getValue()) && provinceConfig.getValue().startsWith(Constants.GUANGXI)) {
            //审批通过之后，下一级审批人员提示：上传批复文件
            approval.setNextPerson(Constants.APPROVAL_FILE);
        }else{
            //宁夏和陕西审批通过之后显示制证
            if( provinceConfig!=null && !Constants.NINGXIA.equals(provinceConfig.getValue()) && !Constants.SHANGXI.equals(provinceConfig.getValue())  ) {
                //审批通过之后，下一级审批人员提示：填写批复意见
                approval.setNextPerson(Constants.APPROVAL_PF);
            } else{
                //审批通过之后，下一级审批人员提示：制证
                approval.setNextPerson(Constants.APPROVAL_ZZ);
            }
        }
        /**
         * 许可通过后请将服务保安公司信息，与服务时间（申请时间）同步至保安师库相关字段
         */
        securityGuardService.updateSecurityCompany(sponsorlicense);

    }
//    @Override
//    public void saveOrUpdateForApproval(Object obj) {
//        Sponsorlicense sponsorlicense =  (Sponsorlicense)obj;
//        sponsorlicense.setUpdateTime(new Date());
//        sponsorlicenseDao.update(sponsorlicense);
//    }
}
