package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.SbSponsorlicenseVmanagerDaoAop;
import com.bcxin.ars.dao.sb.SbSponsorlicenseVmanagerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbSponsorlicenseVmanagerSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.SbSponsorlicenseVmanager;
import com.bcxin.ars.service.sb.SbSponsorlicenseVmanagerService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SbSponsorlicenseVmanager.class)
public class SbSponsorlicenseVmanagerServiceImpl implements SbSponsorlicenseVmanagerService {

	@Autowired
	private SbSponsorlicenseVmanagerDao sbSponsorlicenseVmanagerDao;

	@Autowired
	private SbSponsorlicenseVmanagerDaoAop sbSponsorlicenseVmanagerDaoAop;

	@Autowired
	private ArsUtil arsUtil;
	
	
	@Override
	public SbSponsorlicenseVmanager findById(long id) {
		return sbSponsorlicenseVmanagerDao.findById(id);
	}

	@Override
	public void saveOrUpdate(SbSponsorlicenseVmanager shareholder) {
		User currentUser = arsUtil.getCurrentUser();
		if(shareholder.getId() == null){
			shareholder.setActive(true);
			shareholder.setCreateTime(new Date());
			shareholder.setUpdateTime(new Date());
			shareholder.setUpdateBy(currentUser.getUsername());
			sbSponsorlicenseVmanagerDao.save(shareholder);
		}else{
			SbSponsorlicenseVmanager dbSbSponsorlicenseVmanager = sbSponsorlicenseVmanagerDao.findById(shareholder.getId());
			dbSbSponsorlicenseVmanager.setUpdateTime(new Date());
			dbSbSponsorlicenseVmanager.setUpdateBy(currentUser.getUsername());
			dbSbSponsorlicenseVmanager.setVname(shareholder.getVname());
			dbSbSponsorlicenseVmanager.setVidnum(shareholder.getVidnum());
			dbSbSponsorlicenseVmanager.setVphone(shareholder.getVphone());
			sbSponsorlicenseVmanagerDaoAop.update(dbSbSponsorlicenseVmanager);
		}
	}

	@Override
	public void saveOrUpdateForDS(SbSponsorlicenseVmanager sbSponsorlicenseVmanager) {
		if(sbSponsorlicenseVmanager.getActive() == null){
			sbSponsorlicenseVmanager.setActive(true);
		}

		SbSponsorlicenseVmanager dbSbSponsorlicenseVmanager = sbSponsorlicenseVmanagerDao.findById(sbSponsorlicenseVmanager.getId());
		if (dbSbSponsorlicenseVmanager != null) {
			if(sbSponsorlicenseVmanager.getUpdateTime().getTime() > dbSbSponsorlicenseVmanager.getUpdateTime().getTime()){
				sbSponsorlicenseVmanagerDao.update(sbSponsorlicenseVmanager);
			}
		} else {
			sbSponsorlicenseVmanagerDao.saveForDS(sbSponsorlicenseVmanager);
		}
	}

	@Override
	public SbSponsorlicenseVmanagerSearchDto search(SbSponsorlicenseVmanagerSearchDto dto) {
		SbSponsorlicenseVmanagerSearchDto resultDto = new SbSponsorlicenseVmanagerSearchDto();
		List<SbSponsorlicenseVmanager> list =  sbSponsorlicenseVmanagerDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(sbSponsorlicenseVmanagerDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public List<SbSponsorlicenseVmanager> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return sbSponsorlicenseVmanagerDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void deleteBySid(long sponsorlicenseid){
		sbSponsorlicenseVmanagerDao.deleteBySid(sponsorlicenseid);
	}

	@Override
	public void updateCensorStatus(SbSponsorlicenseVmanager sbSponsorlicenseVmanager) {
		User currentUser = arsUtil.getCurrentUser();
		sbSponsorlicenseVmanager.setUpdateTime(new Date());
		sbSponsorlicenseVmanager.setUpdateBy(currentUser.getUsername());
		sbSponsorlicenseVmanagerDaoAop.updateCensorStatus(sbSponsorlicenseVmanager);
	}
}
