package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.SafetyDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SafetySearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Safety;
import com.bcxin.ars.service.sb.SafetyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Safety.class)
public class SafetyServiceImpl implements SafetyService{

	@Autowired
	private SafetyDao safetyDao;
	
	@Autowired
	private ArsUtil arsUtil;

    @Autowired
    private SecurityPersonDao personDao;
	@Autowired
	private IdGeneratorUtil idGeneratorUtil;
	
	@Override
	public Safety findById(long id) {
		return safetyDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Safety safety) {
		User currentUser = arsUtil.getCurrentUser();
		if(Constants.EQUIPTYPE_AFQX.equals(safety.getSafetytype())){
        	safety.setSafetytype("安防器械");
		}else if(Constants.EQUIPTYPE_FHZB.equals(safety.getSafetytype())){
			safety.setSafetytype("防护装备");
		}else if(Constants.EQUIPTYPE_AJPB.equals(safety.getSafetytype())){
			safety.setSafetytype("安检排爆");
		}else if(Constants.EQUIPTYPE_TXSB.equals(safety.getSafetytype())){
			safety.setSafetytype("通信设备");
		}else if(Constants.EQUIPTYPE_XFJY.equals(safety.getSafetytype())){
			safety.setSafetytype("消防救援");
		}else if(Constants.EQUIPTYPE_DLGL.equals(safety.getSafetytype())){
			safety.setSafetytype("道路管理");
		}else if(Constants.EQUIPTYPE_JKSB.equals(safety.getSafetytype())){
			safety.setSafetytype("监控设备");
		}else if(Constants.EQUIPTYPE_JTGJ.equals(safety.getSafetytype())){
			safety.setSafetytype("交通工具");
		}else if(Constants.EQUIPTYPE_QTSB.equals(safety.getSafetytype())){
			safety.setSafetytype("其他设备");
		}
		boolean IsNull=true;
		if (safety.getId() != null){
			Safety dbSafety = safetyDao.findById(safety.getId());
			if (dbSafety!=null){
				IsNull=false;
				BeanUtils.copyPropertiesIgnore(safety,dbSafety,true);
				dbSafety.setUpdateBy(currentUser.getUsername());
				dbSafety.setUpdateTime(new Date());
				dbSafety.setSafetytype(safety.getSafetytype());
				safetyDao.update(dbSafety);
			}
		}
		if (safety.getId() == null||IsNull) {
			safety.setActive(true);
			safety.setCreateTime(new Date());
			safety.setUpdateTime(new Date());
			safety.setUpdateBy(currentUser.getUsername());
			safety.setUserid(currentUser.getId());
			if (safety.getId()==null){
				safety.setId(idGeneratorUtil.createID());
			}
			safetyDao.saveById(safety);
		}

		
	}

	@Override
	public SafetySearchDto search(SafetySearchDto dto) {
		SafetySearchDto resultDto = new SafetySearchDto();
		List<Safety> list =  safetyDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(safetyDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public void delete(Safety safety) {
		User currentUser = arsUtil.getCurrentUser();
		safety.setUpdateBy(currentUser.getUsername());
		safety.setUpdateTime(new Date());
		safetyDao.delete(safety);
	}

	@Override
	public List<Safety> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return safetyDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(Safety safety) {
		
		if(safety.getActive() == null){
			safety.setActive(true);
		}
		
		if(!safety.getActive()){
			safetyDao.delete(safety);
		}else{
			Safety dbSafety = safetyDao.findById(safety.getId());
			if(dbSafety == null){
				safetyDao.saveForDS(safety);
			}else{
				if(safety.getUpdateTime().getTime() > dbSafety.getUpdateTime().getTime()){
					safetyDao.update(safety);
				}
			}
		}
	}

	@Override
	public void searchForPage(SafetySearchDto searchDto, AjaxPageResponse<Safety> page) {
		arsUtil.setPoliceSearch(searchDto);
		safetyDao.searchForPage(searchDto,page);

	}

}
