package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.validation.BeanValidationResult;
import cn.hutool.extra.validation.ValidationUtil;
import cn.hutool.http.HttpUtil;
import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.MSGConstants;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.appeal.AppealDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.exam.TrainExamPersonDao;
import com.bcxin.ars.dao.msg.NewsnoticeCompanyDao;
import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.sys.SubsidyConfigDao;
import com.bcxin.ars.dao.task.AppNoticeDao;
import com.bcxin.ars.dao.task.ComContractDao;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.certificate.SecurityCertificateImPortDto;
import com.bcxin.ars.dto.page.PerconUnRegDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.report.PersonCertificateReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.*;
import com.bcxin.ars.enums.SubsidyCerType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.exception.ValidateException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.bcxin.ars.model.msg.NewsnoticeCompany;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.model.sys.SubsidyConfig;
import com.bcxin.ars.model.task.AppNotice;
import com.bcxin.ars.model.task.ComContract;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.bean.factory.CustomPersoncertificateBeanFactory;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.exam.TrainExamPersonService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.*;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.*;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Base64Utils;

import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 保安员资格证
 *
 * @author subh
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = Personcertificate.class)
@DataSyncOutAnnotation(getClazz = Personcertificate.class)
public class PersoncertificateServiceImpl extends BaseService implements PersoncertificateService {

    private static Logger logger = LoggerFactory.getLogger(PersoncertificateServiceImpl.class);

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;

    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private TrainExamPersonDao trainExamPersonDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private SecurityPersonDaoAop securityPersonDaoAop;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private ApprovalUtil approvalUtil;

    @Autowired
    private SysareaService sysareaService;

    @Autowired
    private ApprovalService approvalService;

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Autowired
    private FamilyService familyService;

    @Autowired
    private PersonworkexperienceDao workexperienceDao;

    @Autowired
    private ActivityRepairService activityRepairService;

    @Autowired
    private TrainExamPersonService trainExamPersonService;

    @Autowired
    private SecurityCertificateService securityCertificateService;

    @Autowired
    private ProblemPersonDao problemPersonDao;

    @Autowired
    private SysDictUtils sysDictUtils;

    @Autowired
    private ApprovalLogDao approvalLogDao;

    @Autowired
    private GetPersonImgUtil getPersonImgUtil;

    @Autowired
    private ThirdTrainBackgroundDao thirdTrainBackgroundDao;


    @Value("${testsearchUrl}")
    private String testsearchUrl;

    @Value("${gradesearchUrl}")
    private String gradesearchUrl;

    @Value("${personcertificate-download-folder}")
    private String tempftpFolder;
    @Autowired
    private MessageLogDao messageLogDao;

    @Autowired
    private AppNoticeDao appNoticeDao;

    @Autowired
    private SecurityCertificateDao securityCertificateDao;

    @Autowired
    private UserDao userDao;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Autowired
    private NewsnoticeCompanyDao newsnoticeCompanyDao;
    @Autowired
    private OrderDetailDao orderDetailDao;
    @Autowired
    private OrderInfoDao orderInfoDAO;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private SubsidyConfigDao subsidyConfigDao;

    @Autowired
    private ComContractDao comContractDao;

    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;

    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;

    @Autowired
    private GradeSubsidyRosterDaoAop gradeSubsidyRosterDaoAop;

    @Autowired
    private BackgroundApprovalService backgroundApprovalService;

    @Autowired
    private AppealDao appealDao;

    private static BackGroupCensorService backGroupCensorService;

    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    /**
     * 保安员资格证考试报名数据统计列表 param p by llc 2018-08-24
     */
    @Override
    public PageResult statisCertificateList(Map<Object, Object> p) {
        return new PageResult(personcertificateDao.statisCertificateCount(p),
                personcertificateDao.statisCertificateList(p));
    }


    /**
     * 保安员资格证考试报名数据统计数量
     *
     * @param p
     * @return by llc 2018-08-23
     */
    @Override
    public Map<String, Object> statisCertificate(Map<Object, Object> p) {
        return personcertificateDao.statisCertificate(p);
    }

    @Override
    public Personcertificate findById(long id) {
        Personcertificate result = personcertificateDao.findById(id);
        if (result != null) {
            // 查询审批信息
            result.setApproval(approvalDAO.findBybusinessidAndType(result.getId(), BusinessType.BAYZ));

            // 查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);

            // 查询资格证书
            SecurityCertificate securityCertificate = securityCertificateDao.findBySecuritypersonid(result.getId());

            // SecurityCertificate
            // securityCertificate=securityCertificateDao.findByIdnum(result.getCardnumber());

            if (null != securityCertificate && Constants.ZSSTATE_YX.equals(securityCertificate.getZzzt())) {
                result.setSecurityCertificate(securityCertificate);
            }

            if (result.getComContractId() != null) {
                result.setComContract(comContractDao.findById(result.getComContractId()));
            }
        }

        return result;
    }

    @Override
    public Personcertificate findDetailById(long id) {
        return personcertificateDao.findById(id);
    }

    @Override
    public List<Personcertificate> findByApprovalBatchId(List<Approval> approvalList) {
        return personcertificateDao.findByApprovalBatchId(approvalList);
    }

    @Override
    public void updateBatch(List<Personcertificate> personcertificates) {
        personcertificateDaoAop.updateBatch(personcertificates);
    }

    @Override
    public void updateTestSocre(Personcertificate personcertificate) {
        personcertificateDaoAop.update(personcertificate);
    }

    @Override
    public void saveOrUpdateForSaas(Personcertificate personcertificate) {
        User currentUser = arsUtil.getCurrentUser();/**
         * 最后一级机构id处理
         */

        if (StringUtil.isNotEmpty(personcertificate.getCardnumber())) {
            personcertificate.setCardnumber(personcertificate.getCardnumber().toUpperCase().trim());
        }

        if (StringUtil.isEmpty(personcertificate.getNaturalPer())) {
            personcertificate.setNaturalPer(Constants.NO);
        }

        if (personcertificate.getOrgid() == null) {
            throw new ArsException("机构id不能为空");
        }

        if (personcertificate.getComContractId() != null) {
            ComContract contract = comContractDao.findById(personcertificate.getComContractId());
            if (contract != null) {
                personcertificate.setContractStart(contract.getEffectStartDate());
                personcertificate.setContractEnd(contract.getEffectEndDate());
            }
        }

        Police police = policeDao.findById(personcertificate.getOrgid());

        if (StringUtil.isNotEmpty(police.getPath())) {
            String[] orgIds = police.getPath().split("/");
            List<Police> policeList = policeDao.findByOrgIds(orgIds);
            if (policeList.size() > 0) {
                policeList.forEach(p -> {
                    if (Constants.POLICE_ORGTYPE_QX.equals(p.getOrgtype())) {
                        personcertificate.setDistrictOrgId(p.getId().toString());
                    }
                    if (Constants.POLICE_ORGTYPE_SHI.equals(p.getOrgtype())) {
                        personcertificate.setCityOrgId(p.getId().toString());
                    }
                });
            }
        }


        if (StringUtil.isEmpty(personcertificate.getDistrictOrgId())) {
            personcertificate.setDistrictOrgId(null);
        } else if (StringUtil.isEmpty(personcertificate.getCityOrgId())) {
            personcertificate.setCityOrgId(null);
        }

        //saas图片地址转ars图片地址
        //健康证明
        if (StringUtil.isNotEmpty(personcertificate.getHealthExamination())) {
            personcertificate.setHealthExamination(getPhotoPath(personcertificate.getHealthExamination()));
        }
        //身份证正面
        if (StringUtil.isNotEmpty(personcertificate.getIdCardFront())) {
            personcertificate.setIdCardFront(getPhotoPath(personcertificate.getIdCardFront()));
        }
        //身份证反面
        if (StringUtil.isNotEmpty(personcertificate.getIdCardReverse())) {
            personcertificate.setIdCardReverse(getPhotoPath(personcertificate.getIdCardReverse()));
        }
        //学历证明
        if (StringUtil.isNotEmpty(personcertificate.getEduPhoto())) {
            personcertificate.setEduPhoto(getPhotoPath(personcertificate.getEduPhoto()));
        }
        //TODO  如果是新疆区域的，改成北京数据区域,兼容预发布
        if (Constants.XINJIANG.equals(personcertificate.getProvince())) {
            personcertificate.setProvince("110000");
            personcertificate.setCity("110100");
            personcertificate.setDistrict("110101");
        }
        if (StringUtil.isNotEmpty(personcertificate.getCity()) && personcertificate.getCity().startsWith(Constants.NANNING)) {
            personcertificate.setNeedApprove(false);
        }
        //头像
        String imgPath = personcertificate.getImglogo();
        if (StringUtil.isNotEmpty(imgPath)) {
            if (imgPath.indexOf(Constants.FILE_GETRESOURCE) > 0) {
                personcertificate.setImglogo(getLocalPhotoPath(imgPath));
            } else {
                personcertificate.setImglogo(getPhotoPath(imgPath));
            }
        } else {
            PersonBaseInfo baseInfo = personBaseInfoDao.findByIdNum(personcertificate.getCardnumber());
            if (baseInfo != null && StringUtil.isNotEmpty(baseInfo.getImgPath())) {
                personcertificate.setImglogo(baseInfo.getImgPath());
            }
        }

        // 验证该身份证是否已经提交，提交才需要验证
        Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());
        if (dbPersoncertificate != null) {
            switch (dbPersoncertificate.getApprovalstate()) {
                case Constants.APPROVALSTATE_DSP:
                case Constants.APPROVALSTATE_SHZ:
                    throw new ArsException("该人员报名考试审批中，不得重复提交!");
                case Constants.APPROVALSTATE_TG:
                    throw new ArsException("该人员报名考试已审批通过，不得重复提交!");
                default:
                    break;
            }
        }
        //
        //
        //// 公司
        //if (Constants.APPROVALSTATE_DSP.equals(personcertificate.getApprovalstate())
        //		&& currentUser.getPlatform() !=  Constants.PLATFORM_NATURAL_PERSON
        //		&& personcertificate.getPersonid() != null) {
        //	//通过保安员id查询待审批、审批中或者审批通过的数据
        //	Personcertificate result = personcertificateDao.findApprovaling(personcertificate.getPersonid());
        //	if (result != null) {
        //		if(ApprovalState.SHTG.equals(result.getApprovalstate())){
        //			throw new ArsException("该人员已有保安员证，不得重复报名!");
        //		}else{
        //			throw new ArsException("该人员已经报名考试，不得重复报名!");
        //		}
        //	}
        //
        //}

        if (currentUser.getPlatform() == Constants.PLATFORM_COMPANY) {
            // 公司ID
            SecurityCompany securityCompany = securityCompanyDao.findByUserid(currentUser.getId());
            personcertificate.setCompanyid(securityCompany.getId());
            personcertificate.setCompanyname(securityCompany.getName());
        }

        boolean updateFlag = false;

        if (dbPersoncertificate == null) {
            dbPersoncertificate = personcertificate;
        } else {
            updateFlag = true;
            BeanUtils.copyPropertiesIgnore(personcertificate, dbPersoncertificate, true);
        }
        dbPersoncertificate.setActive(true);
        dbPersoncertificate.setCreateTime(new Date());
        dbPersoncertificate.setUpdateTime(new Date());
        dbPersoncertificate.setUpdateBy(currentUser.getUsername());
        dbPersoncertificate.setUserid(currentUser.getId());
        // 新增时默认为待审查 add 2018-05-20 subh start
        dbPersoncertificate.setCensorStatus(Constants.CENSORSTATUS_WAIT);// 待审查
        dbPersoncertificate.setFingercardState(Constants.FINGERCARD_STATE_WJL);//指纹未记录
        dbPersoncertificate.setFingerprint("");
        dbPersoncertificate.setSumScore(null);
        dbPersoncertificate.setOperateScore(null);
        dbPersoncertificate.setWrittenScore(null);
        dbPersoncertificate.setTestState(null);
        dbPersoncertificate.setExamState(null);
        dbPersoncertificate.setConfirmOrder("0");
        dbPersoncertificate.setCensorStatus(null);
        dbPersoncertificate.setFeeState(null);
        dbPersoncertificate.setProState(null);
        dbPersoncertificate.setPayConfirm(null);
        //是否补考
        dbPersoncertificate.setIsMakeUp(null);
        //补考状态
        dbPersoncertificate.setMakeUpstate(null);
        dbPersoncertificate.setApprovalstate(ApprovalState.DSH);

        if (updateFlag) {
            personcertificateDaoAop.update(dbPersoncertificate);
        } else {
            personcertificateDao.save(dbPersoncertificate);
        }
        // TODO 更新审批信息
        approvalUtil.saveApproval(BusinessType.BAYZ, personcertificate.getId(), Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);

        //删除家庭成员信息
        familyService.deleteByPersoncertificateId(personcertificate.getId());
        //保存家庭成员信息
        if (personcertificate.getFamilyList() != null && personcertificate.getFamilyList().size() > 0) {
            personcertificate.getFamilyList().forEach(family -> {
                family.setPersoncertificateid(personcertificate.getId());
                family.setActive(true);
                family.setCreateTime(new Date());
                family.setUpdateTime(new Date());
                family.setUpdateBy(currentUser.getUsername());
                familyService.saveOrUpdate(family);
            });
        }
        //删除工作经历
        workexperienceDao.deleteByPersoncertificateId(personcertificate.getId());
        //保存工作经历
        if (personcertificate.getWorkexperienceList() != null && personcertificate.getWorkexperienceList().size() > 0) {
            personcertificate.getWorkexperienceList().forEach(workexperience -> {
                workexperience.setPersoncertificateid(personcertificate.getId());
                workexperience.setActive(true);
                workexperience.setCreateTime(new Date());
                workexperience.setUpdateTime(new Date());
                workexperience.setUpdateBy(currentUser.getUsername());
                workexperienceDao.save(workexperience);
            });
        }

    }

    @Override
    public void saveOrUpdate(Personcertificate personcertificate) {
        User currentUser = arsUtil.getCurrentUser();

        if (StringUtil.isNotEmpty(personcertificate.getCardnumber())) {
            personcertificate.setCardnumber(personcertificate.getCardnumber().toUpperCase().trim());
        }

        if (StringUtil.isEmpty(personcertificate.getNaturalPer())) {
            personcertificate.setNaturalPer(Constants.NO);
        }
        /**
         * 最后一级机构id处理
         */
        if (personcertificate.getOrgid() == null) {
            if (personcertificate.getDistrictOrgId() != null) {
                personcertificate.setOrgid(Long.parseLong(personcertificate.getDistrictOrgId()));
            } else if (personcertificate.getCityOrgId() != null) {
                personcertificate.setOrgid(Long.parseLong(personcertificate.getCityOrgId()));
            }
        }
        // 读取配置文件
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        // 验证该身份证是否已经提交，提交才需要验证
        if (Constants.APPROVALSTATE_DSP.equals(personcertificate.getApprovalstate())) {

            // 如果当前用户角色是自然人4，是没有personId的
            if (currentUser.getPlatform() != Constants.PLATFORM_NATURAL_PERSON && personcertificate.getPersonid() != null) {
                Personcertificate result = personcertificateDao.findByPersonid(personcertificate);
                if (result != null) {
                    //审批状态不通过，并且申诉中的数据
                    if(ApprovalState.SHBTG.equals(result.getApprovalstate())&&
                           "005".equals(result.getCensorStatus())){
                        throw new ArsException("该人员正在背景筛查申诉中，不得重复报名!");
                    }else if (ApprovalState.SHTG.equals(result.getApprovalstate())) {
                        throw new ArsException("该人员已有保安员证，不得重复报名!");
                    } else if(ApprovalState.DSH.equals(result.getApprovalstate())||
                            ApprovalState.SPZ.equals(result.getApprovalstate())){
                        throw new ArsException("该人员已经报名考试，不得重复报名!");
                    }
                }
            }
            //TODO，限制人员不能进行报名
            if ("452223199905153012".equals(personcertificate.getCardnumber()) || "452130199610052415".equals(personcertificate.getCardnumber()) || "450121197312081210".equals(personcertificate.getCardnumber())) {
                throw new ArsException("该人员考试中严重违规，不予报名！");
            }

            Personcertificate dbcheckpersoncertificate = this.checkCarNumRepeat(personcertificate.getCardnumber(), personcertificate.getId(), currentUser);
            if (null != dbcheckpersoncertificate) {
                if (ApprovalState.SHTG.equals(dbcheckpersoncertificate.getApprovalstate())) {
                    throw new ArsException("该人员已有保安员证，不得重复报名!");
                } else {
                    throw new ArsException("该人员已经报名考试，不得重复报名!");
                }
            }
            //如果是自然人报名，则判断身份证号是否已经录入在人员信息管理
            if (currentUser.getPlatform() == Constants.PLATFORM_NATURAL_PERSON) {
                SecurityPerson person = new SecurityPerson();
                User tempuser = new User();
                person.setIdNumber(personcertificate.getCardnumber());
                //根据身份证获取人员信息
                person = securityPersonDao.find(person);

                //如是人员信息存在则提示用公司帐号报名
                if (person != null && Constants.INCUMBENCYSTATUS_Y.equals(person.getIncumbencyStatus())) {
                    throw new ArsException("该人员已经由公司录入到系统中，请使用公司帐号报名!");
                }

            }

        }

        // 删除重复逻辑无用代码 by llc 2018-08-03
        if (personcertificate.getId() == null) {
            if (currentUser.getPlatform() == Constants.PLATFORM_COMPANY) {
                // 公司ID
                SecurityCompany securityCompany = securityCompanyDao.findByUserid(currentUser.getId());
                personcertificate.setCompanyid(securityCompany.getId());
                personcertificate.setCompanyname(securityCompany.getName());
            }

            personcertificate.setId(idWorker.nextId());

            personcertificate.setActive(true);
            personcertificate.setCreateTime(new Date());
            personcertificate.setUpdateTime(new Date());
            personcertificate.setUpdateBy(currentUser.getUsername());
            personcertificate.setUserid(currentUser.getId());
            // 新增时默认为待审查 add 2018-05-20 subh start
            personcertificate.setCensorStatus(Constants.CENSORSTATUS_WAIT);// 待审查
            personcertificate.setFingercardState(Constants.FINGERCARD_STATE_WJL);//指纹未记录
            personcertificate.setFingerprint("");
            personcertificate.setSumScore(null);
            personcertificate.setOperateScore(null);
            personcertificate.setWrittenScore(null);
            personcertificate.setTestState(null);
            personcertificate.setExamState(null);
            personcertificate.setConfirmOrder("0");
            personcertificate.setCensorStatus(null);
            personcertificate.setFeeState(null);
            personcertificate.setProState(null);
            personcertificate.setPayConfirm(null);
            if (config.getValue().equals(Constants.POLICE_IN)) {
                personcertificate.setUpdateflag(true);
            }

            // 待审批
            if (personcertificate.getApprovalstate() != null && !"".equals(personcertificate.getApprovalstate())
                    && !ApprovalState.DSH.equals(personcertificate.getApprovalstate())) {
                personcertificate.setApprovalstate(personcertificate.getApprovalstate());
                personcertificateDao.save(personcertificate);
            } else {
                personcertificate.setApprovalstate(ApprovalState.DSH);
                personcertificateDao.save(personcertificate);
                // TODO 更新审批信息
                approvalUtil.saveApproval(BusinessType.BAYZ, personcertificate.getId(),
                        Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);
            }

        } else {
            Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());
            if (ApprovalState.WTJ.equals(personcertificate.getApprovalstate())) {
                BeanUtils.copyPropertiesIgnore(personcertificate, dbPersoncertificate, "active,createTime,userid",
                        true);
            } else {
                BeanUtils.copyPropertiesIgnore(personcertificate, dbPersoncertificate, true);
            }
            dbPersoncertificate.setOrgid(personcertificate.getOrgid());
            dbPersoncertificate.setUpdateTime(new Date());
            dbPersoncertificate.setUpdateBy(currentUser.getUsername());

            // 公司ID
            if (dbPersoncertificate.getCompanyid() == null || "".equals(dbPersoncertificate.getCompanyid())) {
                if (currentUser.getPlatform() == Constants.PLATFORM_COMPANY) {
                    // 公司ID
                    SecurityCompany securityCompany = securityCompanyDao.findByUserid(currentUser.getId());
                    dbPersoncertificate.setCompanyid(securityCompany.getId());
                }

            }

            if (StringUtil.isNotEmpty(personcertificate.getCensorStatus())) {
                dbPersoncertificate.setCensorStatus(personcertificate.getCensorStatus());
            }

            // TODO
            // dbSponsorlicense.setUserid(currentUser.getId().intValue());
            // 待审批
            if (personcertificate.getApprovalstate() != null && !"".equals(personcertificate.getApprovalstate())
                    && !ApprovalState.DSH.equals(personcertificate.getApprovalstate())) {
                dbPersoncertificate.setApprovalstate(personcertificate.getApprovalstate());
            } else {
                dbPersoncertificate.setApprovalstate(ApprovalState.DSH);
            }
            if (config.getValue().equals(Constants.POLICE_IN)) {
                dbPersoncertificate.setUpdateflag(true);
            }
            dbPersoncertificate.setCensorStatus(Constants.CENSORSTATUS_WAIT);// 待审查
            dbPersoncertificate.setFingercardState(Constants.FINGERCARD_STATE_WJL);//指纹未记录
            dbPersoncertificate.setFingerprint("");
            //流程结束的提交的时候，置为未缴费
            dbPersoncertificate.setSumScore(null);
            dbPersoncertificate.setOperateScore(null);
            dbPersoncertificate.setWrittenScore(null);
            dbPersoncertificate.setTestState(null);
            dbPersoncertificate.setExamState(null);
            dbPersoncertificate.setConfirmOrder("0");
            dbPersoncertificate.setCensorStatus(null);
            dbPersoncertificate.setFeeState(null);
            dbPersoncertificate.setProState(null);
            dbPersoncertificate.setPayConfirm(null);
            //是否补考
            dbPersoncertificate.setIsMakeUp(null);
            //补考状态
            dbPersoncertificate.setMakeUpstate(null);
            personcertificateDaoAop.update(dbPersoncertificate);


            // TODO 更新审批信息
            if (ApprovalState.DSH.equals(dbPersoncertificate.getApprovalstate())) {
                approvalUtil.saveApproval(BusinessType.BAYZ, dbPersoncertificate.getId(),
                        Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);
            }
        }

    }

    @Override
    public void saveOrUpdateForDS(Personcertificate personcertificate) {
        if (personcertificate.getActive() == null) {
            personcertificate.setActive(true);
        }

        if (!personcertificate.getActive()) {
            personcertificateDaoAop.delete(personcertificate);
        } else {
            Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());
            if (dbPersoncertificate != null) {
                if (personcertificate.getUpdateTime().getTime() > dbPersoncertificate.getUpdateTime().getTime()) {
                    CustomPersoncertificateService customPersoncertificateService = CustomPersoncertificateBeanFactory.getPersoncertificateBean();
                    customPersoncertificateService.updateForDSByDiffArea(personcertificate);
                }
            } else {
                personcertificateDao.save(personcertificate);
            }
        }
    }

    @Override
    public void saveOrUpdateForImport(Personcertificate personcertificate) {
        //证书信息同步到保安人员
        SecurityPerson securityPerson = securityPersonDao.findByIdCard(personcertificate.getCardnumber());
        if (null != securityPerson) {
            securityPerson.setZgtraincompanyname(personcertificate.getCompanyname());
            securityPersonDaoAop.update(securityPerson);
        }
        if (personcertificate.getActive() == null) {
            personcertificate.setActive(true);
        }
        Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());
        if (dbPersoncertificate != null) {
            if (personcertificate.getUpdateTime().getTime() > dbPersoncertificate.getUpdateTime().getTime()) {
                sendMsg(personcertificate, dbPersoncertificate);
                personcertificateDaoAop.update(personcertificate);
            }
        }
    }

    private void saveOrUpdateForImportWithSaasJoin(Personcertificate personcertificate, Personcertificate dbPersoncertificate) {
        //证书信息同步到保安人员
        SecurityPerson securityPerson = securityPersonDao.findByIdCard(personcertificate.getCardnumber());
        if (null != securityPerson) {
            securityPerson.setZgtraincompanyname(personcertificate.getCompanyname());
            securityPersonDaoAop.update(securityPerson);
        }

        if (personcertificate.getActive() == null) {
            personcertificate.setActive(true);
        }

        if (dbPersoncertificate != null) {
            if (personcertificate.getUpdateTime().getTime() > dbPersoncertificate.getUpdateTime().getTime()) {
                //此处调用 SAAS 的通知方式
                sendMsg(personcertificate, dbPersoncertificate);
                personcertificate.setUpdateflag(false);
                try {
                    personcertificate.setUpdateTime(com.bcxin.ars.util.DateUtil.dateAdd(com.bcxin.ars.util.DateUtil.DATATYPE_SECOND, personcertificate.getUpdateTime(), 1));
                    personcertificateDaoAop.update(personcertificate);
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    e.printStackTrace();
                }
            }
        } else {
            try {
                personcertificateDao.save(personcertificate);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                e.printStackTrace();
            }
        }
    }


    @Override
    public void updateCensorStatus(Personcertificate personcertificate) {
        personcertificateDaoAop.update(personcertificate);
    }

    @Override
    public void updateExport(Personcertificate personcertificate) {
        personcertificateDaoAop.update(personcertificate);
    }

    @Override
    public PersoncertificateSearchDto search(PersoncertificateSearchDto dto) {
        User currentUser = arsUtil.getCurrentUser();
        if (currentUser.getPlatform() == 2 || currentUser.getPlatform() != 1) {
            dto.setUserid(currentUser.getId());
        }
        // 机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        if (police != null) {
            String areacode = police.getAreacode();
            if (areacode.endsWith("0000")) {// 省
                dto.setDistrict(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {// 市
                dto.setDistrict(areacode.substring(0, 4) + "__");
            } else {// 区
                dto.setDistrict(areacode);
            }
        }

        if (dto.getAreaCode() != null && !"".equals(dto.getAreaCode())) {
            String areacode = dto.getAreaCode();
            if (areacode.endsWith("0000")) {// 省
                dto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {// 市
                dto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {// 区
                dto.setAreaCode(areacode);
            }
        }

        List<Personcertificate> list = personcertificateDao.search(dto);
        dto.setData(list);
        dto.setTotalCount(personcertificateDao.searchCount(dto));
        return dto;
    }

    @Override
    public void delete(Personcertificate personcertificate) {
        User currentUser = arsUtil.getCurrentUser();
        personcertificate.setUpdateBy(currentUser.getUsername());
        personcertificate.setUpdateTime(new Date());
        personcertificate.setUpdateflag(true);
        personcertificateDaoAop.delete(personcertificate);
    }

    @Override
    public Personcertificate findByUser(Long userid) {
        return personcertificateDao.findByUser(userid);
    }

    @Override
    public List<Personcertificate> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return personcertificateDao.searchForDataSynchronization(searchDto);
    }

    @Override
    public List<Map> checkConfirmOrder(Long[] personIds) {
        return personcertificateDao.checkConfirmOrder(personIds);
    }

    @Override
    public void batchSaveConfirmOrder(Long[] personIds, String username) {
        personcertificateDaoAop.batchSaveConfirmOrder(personIds, username);
        /***************宁夏不需要制证审批，成绩通过直接生成证书 subh 20190129 start**************/
        //配置是否考试通过直接制证
        Config isNeedCardActivity = configUtils.getConfigByKey(Constants.IS_NEED_CARD_ACTIVITY);
        //判断是否考试通过直接制证,1为是，宁夏
        if (isNeedCardActivity != null && Constants.IS_NEED_CARD_ACTIVITY_YES.equals(isNeedCardActivity.getValue())) {
            for (Long id : personIds) {
                //获取保安员证信息
                Personcertificate personcertificate = personcertificateDao.findById(id);
                ApprovalDTO approvalDTO = new ApprovalDTO();
                if (personcertificate.getTestState().equals(Constants.TEST_STATE_TG)) {
                    // 考试通过，审核通过,调用方法
                    personcertificate.setApprovalstate(ApprovalState.SHTG);
                    approvalDTO.setBusinesstype(BusinessType.BAYZ);
                    approvalDTO.setBusinessid(personcertificate.getId());
                    approvalDTO.setApprovalstate(ApprovalState.SHTG);
                    approvalDTO.setApprovalreason("自动审批通过");
                    approvalDTO.setConfirmOrder(personcertificate.getConfirmOrder());
                    //是否考试通过直接制证,1为是，宁夏
                    approvalDTO.setIsNeedCardActivity(Constants.IS_NEED_CARD_ACTIVITY_YES);
                    //是否启动流程，是宁夏
                    approvalDTO.setIsNeedActivity(Constants.IS_NEED_ACTIVITY_YES);
                    personcertificateDaoAop.update(personcertificate);
                    approvalService.saveApprovalForZZ(approvalDTO);
                } else {
                    // 考试不通过，审核不通过,调用方法
                    personcertificate.setApprovalstate(ApprovalState.SHBTG);
                    approvalDTO.setBusinesstype(BusinessType.BAYZ);
                    approvalDTO.setBusinessid(personcertificate.getId());
                    approvalDTO.setApprovalstate(ApprovalState.SHBTG);
                    approvalDTO.setApprovalreason("自动审批不通过");
                    approvalDTO.setOutreason("自动审批不通过");
                    //是否考试通过直接制证,1为是，宁夏
                    approvalDTO.setIsNeedCardActivity(Constants.IS_NEED_CARD_ACTIVITY_YES);
                    //是否启动流程，是宁夏
                    approvalDTO.setIsNeedActivity(Constants.IS_NEED_ACTIVITY_YES);
                    personcertificateDaoAop.update(personcertificate);
                    approvalService.saveApprovalForZZ(approvalDTO);
                }
            }
            /***************宁夏不需要制证审批，成绩通过直接生成证书 subh 20190129 start**************/
        } else {//判断是否考试通过直接制证，0为否
            this.createCard(personIds);
        }
    }

    /***
     * 保安员资格报名列表ID和config是否启动流程，如果不需要启动流程则生成证书
     * @param personIds 保安员资格报名列表ID
     * @return 空
     */
    public void createCard(Long[] personIds) {
        //如果不需要activity流程的话，则直接生成证书
        Config isActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
        //config配置不需要activity，则生成证书
        if (isActivity != null && Constants.IS_NEED_ACTIVITY_NO.equals(isActivity.getValue())) {
            //根据保安员资格报名ID获取审批记录表
            List<Approval> approvalList = approvalDAO.batchFindApprovalBypersonId((personIds));
            //循环需要生成的审批记录列表
            for (Approval approval : approvalList) {
                //生成证书
                approvalService.createCard(approval, Constants.IS_NEED_ACTIVITY_NO);
            }
        }
    }

    /**
     * 接收考试成绩功能,根据身份证号更新成绩信息
     *
     * @param personcertificateList
     */
    @Override
    public JSONArray updateScoreByBetchID(List<Personcertificate> personcertificateList) {
        //定义返回json数组给百课堂，成功和失败都在该数组里
        JSONArray resultArr = new JSONArray();
        //保安员资格证人员返回给百课堂信息
        JSONObject resultObj = null;
        //定义成绩通过数组人员ID，成绩通过的人员ID存放在该数组里
        List<Long> personListIds = new ArrayList<Long>();
        //未通过人员id
        List<Long> personFileListIds = new ArrayList<Long>();
        List<Personcertificate> saveList = new ArrayList<>();
        List<Personcertificate> rosterList = new ArrayList<>();

        Map<Long, Personcertificate> personMap = new HashedMap();
        Map<Long, Personcertificate> hasCerMap = new HashedMap();

        //根据传过来的人员列表，查询数据库保安员资格报名人员
        List<Personcertificate> dbPersoncertificateList = personcertificateDao.findByBatchPersonId(personcertificateList);
        //判断保安员资格报名列表是否为空
        if (dbPersoncertificateList != null && dbPersoncertificateList.size() > 0) {
            List<Personcertificate> hasCertificateList = personcertificateDao.findHasCertificateListByBatchPersonId(personcertificateList);

            if (hasCertificateList != null && hasCertificateList.size() > 0) {
                dbPersoncertificateList.removeAll(hasCertificateList);
                hasCerMap = hasCertificateList.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));
            }
        }
        //判断保安员资格报名列表是否为空
        if (dbPersoncertificateList != null && dbPersoncertificateList.size() > 0) {
            personMap = dbPersoncertificateList.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));
        }
        //判断保安员资格报名列表是否为空
        for (Personcertificate personcertificate : personcertificateList) {

            resultObj = new JSONObject();
            //身份证
            resultObj.put("cardnumber", personcertificate.getCardnumber());
            //姓名
            resultObj.put("name", personcertificate.getName());
            //课堂ID
            resultObj.put("subjectID", personcertificate.getSubjectID());
            Personcertificate dbPersoncertificate = personMap.get(personcertificate.getBbdPersonID());
            if (dbPersoncertificate != null) {
                dbPersoncertificate.setTestState(personcertificate.getTestState());
                dbPersoncertificate.setSumScore(personcertificate.getSumScore());
                dbPersoncertificate.setOperateScore(personcertificate.getOperateScore());
                dbPersoncertificate.setWrittenScore(personcertificate.getWrittenScore());
                dbPersoncertificate.setExamTimes(personcertificate.getExamTimes());
                dbPersoncertificate.setSubjectID(personcertificate.getSubjectID());
                dbPersoncertificate.setTrainEndDate(new Date());
                dbPersoncertificate.setUpdateflag(true);
                dbPersoncertificate.setUpdateTime(new Date());
                dbPersoncertificate.setBbdPersonID(dbPersoncertificate.getId());
                if (StringUtil.isNotEmpty(personcertificate.getExamState())) {
                    dbPersoncertificate.setExamState(personcertificate.getExamState());
                }
                saveList.add(dbPersoncertificate);

                //有考试结果才通知
                if (StringUtil.isNotEmpty(dbPersoncertificate.getTestState())) {
                    this.dbPersoncertificateSendMessage(dbPersoncertificate);
                }

                //判断人员成绩是否通过
                if (Constants.TEST_STATE_TG.equals(dbPersoncertificate.getTestState())) {
                    //成绩通过人员，将ID加入到成功人员数组里，用于后面生成证书用
                    personListIds.add(dbPersoncertificate.getId());
                    rosterList.add(dbPersoncertificate);
                } else if (Constants.TEST_STATE_WTG.equals(dbPersoncertificate.getTestState())) {
                    //成绩通过人员，将ID加入到成功人员数组里，用于后面生成证书用
                    personFileListIds.add(dbPersoncertificate.getId());
                }

                resultObj.put("result", true);
                resultArr.add(resultObj);
            } else {
                Personcertificate hasCerPersoncertificate = hasCerMap.get(personcertificate.getBbdPersonID());
                if (hasCerPersoncertificate != null) {
                    resultObj = new JSONObject();
                    //身份证
                    resultObj.put("cardnumber", personcertificate.getCardnumber());
                    //姓名
                    resultObj.put("name", personcertificate.getName());
                    //课堂ID
                    resultObj.put("subjectID", personcertificate.getSubjectID());
                    resultObj.put("result", true);
                    resultArr.add(resultObj);
                } else {
                    resultObj.put("result", false);
                    resultObj.put("msg", "错误的准考证号：" + personcertificate.getCardnumber() + ",找不到该生信息");
                    logger.error("错误的准考证号：" + personcertificate.getCardnumber() + ",找不到该生信息,错误的bbdPersonID：" + personcertificate.getBbdPersonID());
                    resultArr.add(resultObj);
                }
            }
        }

        if (saveList.size() > 0) {
            //更新人员成绩状态
            personcertificateDaoAop.updateBatch(saveList);
        }

        //批量审批不通过
        if (personFileListIds != null && personFileListIds.size() > 0) {
            Long[] array = new Long[personFileListIds.size()];
            personFileListIds.toArray(array);
            approvalDAO.batchUpdateApprovalState(ApprovalState.SHBTG, array);
        }


        //判断数组是否有成绩通过人员，如有一个，则调用生成证书生成
        if (personListIds != null && personListIds.size() > 0) {
            //List转Long[]，定义一个长度为成绩通过人数的Long[]数组
            Long[] personIds = new Long[personListIds.size()];
            //循环将人员ID放到Long[]
            for (int i = 0; i < personListIds.size(); i++) {
                personIds[i] = personListIds.get(i);
            }
            //更新审批记录和保安员资格证的审批状态
            approvalDAO.batchUpdateApprovalState(ApprovalState.SHTG, personIds);

            if(!Constants.GUANGXI.equals(configUtils.getCurrentNative())) {
                //考试通过生成证书
                this.createCard(personIds);
                if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                    //生成补贴名单
                    this.generateSubsidyRoster(rosterList);
                }
            }
        }

        return resultArr;
    }

    /**
     * 生成补贴名单
     *
     * @param list
     */
    @Override
    public void generateSubsidyRoster(List<Personcertificate> list) {
        GradeSubsidyRoster roster = null;
//			ComContract conTract = null;
        SecurityCompany trainCom = null;
        List<GradeSubsidyRoster> rosterList = new ArrayList<>();

        List<SecurityCertificate> cerList = securityCertificateDao.findByPersoncertificateIds(list);
        Map<Long, SecurityCertificate> cerMap = cerList.stream().collect(Collectors.toMap(SecurityCertificate::getSecuritypersonid, Function.identity()));
        SecurityCertificate securityCertificate = null;
        SubsidyConfig subsidyConfig = subsidyConfigDao.findByBusinessType(Constants.SUBSIDYBUSINESSTYPE_004);
        SubsidyConfig platSerFeeSubsidyConfig = subsidyConfigDao.findByBusinessType(Constants.SUBSIDYBUSINESSTYPE_006);
        for (Personcertificate personcertificate : list) {
            if (Constants.BONUSAPPLY_1.equals(personcertificate.getBonusApply())) {
                roster = new GradeSubsidyRoster();
                roster.setId(idWorker.nextId());
                roster.setSubsidyCerType(SubsidyCerType.QUALIFICATION.getCode());
                roster.setGradeId(personcertificate.getId());
                roster.setActive(true);
                roster.setUsed(Constants.USED_N);
                roster.setCreateTime(new Date());
                roster.setUpdateTime(new Date());
                roster.setUpdateflag(false);
                roster.setName(personcertificate.getName());
                roster.setIdNum(personcertificate.getCardnumber());
                roster.setPhone(personcertificate.getPhone());
                roster.setOrgId(personcertificate.getOrgid());
                roster.setTrainId(Long.parseLong(personcertificate.getTrainOrgID()));
                roster.setTrainName(personcertificate.getTrainOrgName());
                roster.setCompanyId(personcertificate.getCompanyid());
                roster.setCompanyName(personcertificate.getCompanyname());
                roster.setResidentNature(personcertificate.getResidentType());
                roster.setResidentPlace(personcertificate.getResidentPlaceType());

                roster.setSubsidyType("保安员培训补贴");
                roster.setSubsidyPeopleType("培训机构");
                roster.setCertificateProfession("保安员");
                roster.setCertificateGrade("非等级");
                roster.setTrainProfession("保安员");
                roster.setTrainGrade("非等级");
                roster.setClassHour("10");

                roster.setSex(IdNumUtil.getSexByIdCard(personcertificate.getCardnumber()));
                if (personcertificate.getOrgid() != null) {
                    Police police = policeDao.findById(personcertificate.getOrgid());
                    roster.setOrgName(police.getOrgname());
                }
                roster.setAreaCode(personcertificate.getDistrict());

                roster.setCertificateType("其他");

                //补贴金额
                try {
                    roster.setSubsidyMoneyRate(subsidyConfig.getPercent());
                    roster.setSubsidyMoney(subsidyConfig.getAmount().toString());
                } catch (Exception e) {
                    throw new ArsException("补贴金额配置错误");
                }
                //平台服务费金额
                try {
                    roster.setPlatSerFee(platSerFeeSubsidyConfig.getAmount().toString());
                } catch (Exception e) {
                    throw new ArsException("平台服务费金额配置错误");
                }

                roster.setSubsidyStatus(Constants.SUBSIDYSTATUS_DBD);

                roster.setContractStartTime(personcertificate.getContractStart());
                roster.setContractEndTime(personcertificate.getContractEnd());


                trainCom = securityCompanyDao.findByComId(Long.parseLong(personcertificate.getTrainOrgID()));
                roster.setSocialCode(trainCom.getSocialCode());
                roster.setTrainBeginDate(personcertificate.getTrainStartDate());
                roster.setTrainEndDate(personcertificate.getTrainEndDate());

                securityCertificate = cerMap.get(personcertificate.getId());
                roster.setCertificateDate(com.bcxin.ars.util.DateUtil.convertDateToString(securityCertificate.getFzrq(), com.bcxin.ars.util.DateUtil.FORMAT2));
                roster.setCertificateNumber(securityCertificate.getZsbh());
                rosterList.add(roster);
            }
        }
        if (rosterList.size() > 0) {
            gradeSubsidyRosterDaoAop.saveBatch(rosterList);
        }
    }

    /**
     * 考试成绩信息发送给保安员证报名人员
     *
     * @return void
     * @Decription:发送消息
     * @author：zhongjianhui
     * @method dbPersoncertificateSendMessage @date：2018/8/21 16:27 @params：
     * * @param dbPersoncertificate
     */
    private void dbPersoncertificateSendMessage(Personcertificate dbPersoncertificate) {
        /****************华为短信*****************/
        String smsCode = "";
        String[] msgParams = null;
        /****************华为短信*****************/


        String title, content, newstitle;
        // 考试通知标题
        title = Constants.EXAM_NOTE_TITLE;
        /**
         * 获取百课堂传过来的笔试成绩，判断是否为空，为空则赋值空字符串，不为空转换成字符串
         */
        String writtenScore = dbPersoncertificate.getWrittenScore() == null ? "" : dbPersoncertificate.getWrittenScore().toString();
        /**
         * 获取 百课堂传过来的实操成绩，判断是否为空，为空则赋值空字符串，不为空转换成字符串
         */
        String operateScore = dbPersoncertificate.getOperateScore() == null ? "" : dbPersoncertificate.getOperateScore().toString();

        CustomPersoncertificateService customPersoncertificateService = CustomPersoncertificateBeanFactory.getPersoncertificateBean();

        //信息内容
        content = customPersoncertificateService.getMsgTemp(Constants.TEMPTYPE_CONTENT, dbPersoncertificate.getTestState());
        //信息标题
        newstitle = customPersoncertificateService.getMsgTemp(Constants.TEMPTYPE_TITLE, dbPersoncertificate.getTestState());
        //信息内容
        content = content.replace("{writtenScore}", writtenScore)
                .replace("{operateScore}", operateScore);
        //信息标题
        newstitle = newstitle.replace("{name}", dbPersoncertificate.getName())
                .replace("{writtenScore}", writtenScore)
                .replace("{operateScore}", operateScore);
        /****************华为短信*****************/
        if (Constants.TEST_STATE_TG.equals(dbPersoncertificate.getTestState())) {
            smsCode = MSGConstants.SMSCODE_B72;
        } else {
            smsCode = MSGConstants.SMSCODE_B73;
        }
        msgParams = new String[]{
                writtenScore,
                operateScore

        };
        if (StringUtil.isNotEmpty(content)) {
            /****************华为短信*****************/
            //判断是否为自然人，则用短信发送，如是公司则调用saas发送短信的接口,add subh 2019-03-30 10:30
            User user = userDao.findById(dbPersoncertificate.getUserid());
            //判断配置与SaaS对接，如有对接，则直接推送信息给SaaS，由SaaS统一发送，并且不是自然人用户
            if (Constants.PLATFORM_NATURAL_PERSON != user.getPlatform()) {
                SAASMessageDto messageDto = new SAASMessageDto();
                messageDto.setTitle(title);
                messageDto.setContent(content);
                messageDto.setMessageType(Constants.MESSAGETYPE_040104);
                messageDto.setIds(dbPersoncertificate.getPersonid().toString());
                messageDto.setPlatId("11");
                messageDto.setWay(Constants.SAAS_MESSAGE_SEND_WAY);
                messageDto.setPoliceRegionId(dbPersoncertificate.getDistrict());
                messageDto.setSendPer("百课堂安排考试");
                //推送给公安服务平台
                saasInterfaceUtil.callInterface(Constants.SAAS_MESSAGE_SEND, messageDto);
            } else {
                //百保盾内部发送
                this.sendExamMsgHuiWei(dbPersoncertificate, newstitle, title, content, smsCode, msgParams);
            }
        }
    }

    @Override
    public void updateBMStateByid(Long id) {
        Personcertificate personcertificate = personcertificateDao.findById(id);
        User currentUser = arsUtil.getCurrentUser();
        personcertificate.setUpdateBy(currentUser.getUsername());
        personcertificate.setSignConfirm("001");
        personcertificate.setUpdateTime(new Date());
        personcertificate.setUpdateflag(true);
        personcertificateDaoAop.updateSelective(personcertificate);
        /*********** 报名确认通过流程 ***************/
        //checkApproval(personcertificate, currentUser, "");
        ApprovalDTO approvalDTO = new ApprovalDTO();
        approvalDTO.setBusinesstype(BusinessType.BAYZ);
        approvalDTO.setBusinessid(personcertificate.getId());
        approvalDTO.setApprovalstate(ApprovalState.SHTG);
        approvalDTO.setApprovalreason(Constants.APPROVAL_CONTEXT_BM);
        approvalService.saveApprovalForManual(approvalDTO, Constants.APPROVAL_CONTEXT_BM);

    }

    @Override
    public void updatecardStateByIds(Personcertificate personcertificate) {
        User currentUser = arsUtil.getCurrentUser();
        personcertificate.setUpdateBy(currentUser.getUsername());
        personcertificate.setUpdateTime(new Date());
        personcertificate.setUpdateflag(true);
        personcertificateDaoAop.updateSelective(personcertificate);

    }

    private void checkApproval(Personcertificate personcertificate, User currentUser, String approvalreason) {
        Approval approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
        Config configVersion = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
        String reason = getReason(approvalreason, Constants.APPROVAL_CONTEXT_BM);
        if (approval != null && configVersion != null
                && !Constants.APPROVAL_VERSION_NEW.equals(configVersion.getValue())) {

            approval.setApprovalreason(reason);
            approval.setApprovalperson(currentUser.getRealname());
            approvalService.saveApprovalLog(approval, ApprovalState.SHTG);

        } else {
            ApprovalDTO approvalDTO = new ApprovalDTO();
            approvalDTO.setBusinesstype(BusinessType.BAYZ);
            approvalDTO.setBusinessid(personcertificate.getId());
            approvalDTO.setApprovalstate(ApprovalState.SHTG);
            approvalDTO.setApprovalreason(reason);
            approvalService.saveApprovalForManual(approvalDTO, currentUser.getRealname());
        }
    }

    @Override
    public void updateBMStateForApprovalByid(Long id, String signConfirm) {
        Personcertificate personcertificate = personcertificateDao.findById(id);
        User currentUser = arsUtil.getCurrentUser();
        personcertificate.setUpdateBy(currentUser.getUsername());
        personcertificate.setSignConfirm(signConfirm);
        personcertificate.setUpdateTime(new Date());
        personcertificate.setUpdateflag(true);
        personcertificateDaoAop.updateSelective(personcertificate);
    }

    /**
     * 根据身份证,科目编号返回制证状态
     *
     * @param personcertificate
     * @return
     */
    @Override
    public Personcertificate getCardState(Personcertificate personcertificate) {
        return personcertificateDao.getCardState(personcertificate);
    }

    /**
     * 根据身份证,科目ID返回制证状态
     *
     * @param cardnumber
     * @return
     */
    @Override
    public Personcertificate getCardStateByCardnumber(String cardnumber) {
        return personcertificateDao.getCardStateByCardnumber(cardnumber);
    }

    @Override
    public JSONArray updateBktfeeStateByBatchID(List<SecurityPersonSearchRerurnDTO> personcertificateList) {
        JSONArray resultArr = new JSONArray();
        JSONObject resultObj = null;
        resultObj = new JSONObject();
        List<Personcertificate> dbPersoncertificateList = personcertificateDao
                .findFeeStateByBatchPersonId(personcertificateList);

        Map<Long, Personcertificate> dbMap = dbPersoncertificateList.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));

        // 判断是否存在考试信息，如果存在才更新
        if (dbPersoncertificateList != null && dbPersoncertificateList.size() > 0) {
            List<SecurityPersonSearchRerurnDTO> removePersoncertificateList = new ArrayList<SecurityPersonSearchRerurnDTO>();
            for (SecurityPersonSearchRerurnDTO dto : personcertificateList) {
                resultObj = new JSONObject();
                boolean isHaveDB = false; // 是否存在数据库
                Personcertificate dbPersoncertificate = dbMap.get(dto.getBbdPersonID());
                if (dbPersoncertificate != null) {
                    isHaveDB = true;
                    resultObj.put("cardnumber", dbPersoncertificate.getCardnumber());
                    resultObj.put("name", dbPersoncertificate.getName());
                    resultObj.put("subjectID", dbPersoncertificate.getSubjectID());
                    resultArr.add(resultObj);
                    break;
                }
                // 数据库不存在，则记录错误信息和待删除列表
                if (!isHaveDB) {
                    resultObj.put("cardnumber", dto.getIdNumber());
                    resultObj.put("name", dto.getRealName());
                    resultObj.put("subjectID", "");
                    resultObj.put("result", false);
                    resultObj.put("msg", "身份证：" + dto.getIdNumber() + "报名信息不存在,更新缴费状态失败");
                    resultArr.add(resultObj);
                    removePersoncertificateList.add(dto);
                }
            }
            if (removePersoncertificateList != null && removePersoncertificateList.size() > 0) {
                personcertificateList.removeAll(removePersoncertificateList);
            }
            if (personcertificateList != null && personcertificateList.size() > 0) {
                personcertificateDaoAop.updateBktfeeStateByBatchID(personcertificateList);
            }
        }
        return resultArr;
    }

    /**
     * 通过idList查询保安员资格证考试信息
     *
     * @param paramList
     * @return by llc 2018-06-19
     */
    @Override
    public List<Personcertificate> getPersoncertificateListByParamList(List<Map<String, String>> paramList) {
        return personcertificateDao.getPersoncertificateListByParamList(paramList);
    }

    /**
     * 根据主键更新保安员证考试的缴费状态
     *
     * @param personcertificate by llc 2018-06-25
     */
    @Override
    public void updatefeeStateById(Personcertificate personcertificate) {
        User currentUser = arsUtil.getCurrentUser();
        personcertificate.setUpdateflag(true);
        personcertificate.setUpdateBy(currentUser.getUsername());
        personcertificate.setUpdateTime(new Date());
        personcertificate.setUpdateflag(true);
        personcertificateDaoAop.updateSelective(personcertificate);

        // 读取配置文件
        Config isNew = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
        if (isNew == null || !Constants.APPROVAL_VERSION_NEW.equals(isNew.getValue())) {
            // 旧审批 缴费状态走流程
            this.updatefeeStateNeedActivi(personcertificate, currentUser);
        }
    }

    private String getReason(String getApprovalreason, String status) {
        String reason;
        String r = "(操作：" + status + ")";
        if (StringUtil.isNotEmpty(getApprovalreason)) {
            reason = getApprovalreason + r;
        } else {
            reason = r;
        }
        return reason;
    }

    @Override
    public ExamSearchDto findUnScheduledPersonList(ExamSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        // TODO subjectID前期先写死
        if (StringUtil.isNotEmpty(searchDto.getSubjectID()) && searchDto.getSubjectID().equals("1")) {
            String areaCode = searchDto.getAreaCode();
            if (areaCode.endsWith("0000")) {// 省
                searchDto.setAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {// 市
                searchDto.setAreaCode(areaCode.substring(0, 4) + "__");
            } else {
                searchDto.setAreaCode(areaCode);
            }
            //配置是否需要流程
            Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
            if (isNeedActivity != null) {
                searchDto.setNeedActivity(isNeedActivity.getValue());
            }
            //是否需要缴费
            Config onlinePayConfig = configUtils.getConfigByKey(Constants.IS_PAYMENT);
            if (null != onlinePayConfig && Constants.IS_ONLINEPAY_YES.equals(onlinePayConfig.getValue())) {
                searchDto.setIsPay(Constants.IS_PAYMENT_YES);
            }
            //是否需要指纹
            Config fingerprint = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
            if (fingerprint != null && Constants.IS_SHOW_FINGERPRINT_YES.equals(fingerprint.getValue())) {
                searchDto.setFingerprint(fingerprint.getValue());
            }

            //百课堂查询地区模糊查询 edit subh 2019-01-24
            String queryAreaCode = searchDto.getQueryAreaCode();
            if (StringUtils.isNotEmpty(queryAreaCode)) {
                if (queryAreaCode.endsWith("0000")) {// 省
                    searchDto.setQueryAreaCode(queryAreaCode.substring(0, 2) + "____");
                } else if (queryAreaCode.endsWith("00")) {// 市
                    searchDto.setQueryAreaCode(queryAreaCode.substring(0, 4) + "__");
                } else {
                    searchDto.setQueryAreaCode(queryAreaCode);
                }
            }
            List<ExamDto> list = personcertificateDao.findUnScheduledPersonList(searchDto);
            searchDto.setData(list);
            searchDto.setTotalCount(personcertificateDao.searchUnScheduledCount(searchDto));
        }
        return searchDto;
    }

    @Override
    public void updateExamState(ExamDetailDto examDetail) {


        /****************华为短信*****************/
        String smsCode = "";
        String[] msgParams = null;
        /****************华为短信*****************/
        if (StringUtil.isEmpty(examDetail.getTicket())) {
            throw new ArsException("准考证号不能为空！");
        }
        if (StringUtil.isEmpty(examDetail.getExamState())) {
            throw new ArsException("考试安排状态不能为空！");
        }
        if (StringUtil.isEmpty(examDetail.getExamSubject())) {
            throw new ArsException("考试科目不能为空！");
        }
        if (StringUtil.isEmpty(examDetail.getExamPlace())) {
            throw new ArsException("理论考点地址不能为空！");
        }
        if (StringUtil.isEmpty(examDetail.getComputerStartDate())
                || StringUtil.isEmpty(examDetail.getComputerEndDate())) {
            throw new ArsException("理论考试时间不能为空！");
        }
        // if(StringUtil.isEmpty(examDetail.getStaminaAddress())) {
        // throw new ArsException("体能测试考点地址不能为空！");
        // }
        // if(StringUtil.isEmpty(examDetail.getStaminaStartDate()) ||
        // StringUtil.isEmpty(examDetail.getStaminaEndDate())) {
        // throw new ArsException("体能测试考试时间不能为空！");
        // }

        Personcertificate personcertificate;
        if (examDetail != null && examDetail.getBbdPersonID() != null && examDetail.getBbdPersonID() != "") {
            personcertificate = personcertificateDao.findById(Long.valueOf(examDetail.getBbdPersonID()));
        } else {
            personcertificate = personcertificateDao.findByIdNum(examDetail.getTicket());
        }
        if (personcertificate == null) {
            throw new ArsException("此准考证找不到报名人员！");
        }
        //去悼考试通知限制次数 edit 2019-01-24 subh
		/*if (StringUtil.isNotEmpty(personcertificate.getExamState()) && "1".equals(personcertificate.getExamState())
				&& personcertificate.getExamState().equals(examDetail.getExamState())) {
			throw new ArsException("此人员已经安排考试了！");
		}*/
        if (StringUtil.isNotEmpty(examDetail.getExamSubject())) {
            personcertificate.setExamSubject(examDetail.getExamSubject());
        }
        if (StringUtil.isNotEmpty(examDetail.getExamPlace())) {
            personcertificate.setExamAddress(examDetail.getExamPlace());
        }
        if (StringUtil.isNotEmpty(examDetail.getComputerStartDate())) {
            personcertificate.setExamStart(examDetail.getComputerStartDate());
        }
        if (StringUtil.isNotEmpty(examDetail.getComputerEndDate())) {
            personcertificate.setExamEnd(examDetail.getComputerEndDate());
        }

        if (StringUtil.isNotEmpty(examDetail.getStaminaAddress())) {
            personcertificate.setStaminaAddress(examDetail.getStaminaAddress());
        }
        if (StringUtil.isNotEmpty(examDetail.getStaminaStartDate())) {
            personcertificate.setStaminaStartDate(examDetail.getStaminaStartDate());
        }
        if (StringUtil.isNotEmpty(examDetail.getStaminaEndDate())) {
            personcertificate.setStaminaEndDate(examDetail.getStaminaEndDate());
        }
        if (examDetail.getLearnRate() != null) {
            personcertificate.setLearnRate(examDetail.getLearnRate());
        }

        personcertificate.setExamState(examDetail.getExamState());
        // 读取配置文件
        if (configUtils.isIntranet()) {
            personcertificate.setUpdateflag(true);
        }
        personcertificate.setUpdateTime(new Date());
        personcertificateDaoAop.update(personcertificate);

        /**
         * 广西环境发
         */
        if (Constants.GUANGXI.equals(configUtils.getCurrentNative())) {
            //百保盾内部发送
            // 考试安排通知
            String title = "";// 标题
            String content = "";
            String newstitle = "";
            String name = personcertificate.getName();
            if (Constants.EXAM_STATE_YAP.equals(examDetail.getExamState())) {
                title = Constants.EXAM_NEW_NOTE_TITLE;
                content = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CONTENT;
                newstitle = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_MSG;

                /****************华为短信*****************/
                //您报名的保安资格证考试已安排，请于{TXT_30}前到{TXT_50}参加考试
                smsCode = MSGConstants.SMSCODE_B79;
                msgParams = new String[]{
                        personcertificate.getExamStart(),
                        personcertificate.getExamAddress()};
                /****************华为短信*****************/

            } else if (Constants.EXAM_STATE_CANCEL.equals(examDetail.getExamState())) {
                title = Constants.EXAM_CANCEL_NOTE_TITLE;
                content = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CANCEL_CONTENT.replace("{cancelReason}",
                        examDetail.getCancelReason() == null ? "" : examDetail.getCancelReason());
                newstitle = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CANCEL_MSG.replace("{cancelReason}",
                        examDetail.getCancelReason() == null ? "" : examDetail.getCancelReason());
                /****************华为短信*****************/
                smsCode = MSGConstants.SMSCODE_B75;
                msgParams = new String[]{
                        personcertificate.getExamStart(),
                        personcertificate.getExamEnd(),
                        examDetail.getCancelReason()};
                /****************华为短信*****************/

            } else if (Constants.EXAM_STATE_UPDATE.equals(examDetail.getExamState())) {
                title = Constants.EXAM_UPDATE_NOTE_TITLE;
                content = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_UPDATE_CONTENT;
                newstitle = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_UPDATE_MSG;
                /****************华为短信*****************/
                //您报名的保安资格证考试安排已修改，请于{TXT_30}前到{TXT_50}参加考试
                smsCode = MSGConstants.SMSCODE_B80;
                msgParams = new String[]{
                        personcertificate.getExamStart(),
                        personcertificate.getExamAddress()};
                /****************华为短信*****************/
            }
            content = content.replace("{name}", name).replace("{examStart}", personcertificate.getExamStart())
                    .replace("{examEnd}", personcertificate.getExamEnd())
                    .replace("{examAddress}", personcertificate.getExamAddress());
            newstitle = newstitle.replace("{name}", name).replace("{examStart}", personcertificate.getExamStart())
                    .replace("{examEnd}", personcertificate.getExamEnd())
                    .replace("{examAddress}", personcertificate.getExamAddress());

            SAASMessageDto messageDto = new SAASMessageDto();
            messageDto.setTitle(title);
            messageDto.setContent(content);
            messageDto.setMessageType(Constants.MESSAGETYPE_040101);
            messageDto.setIds(personcertificate.getPersonid().toString());
            messageDto.setPlatId("11");
            messageDto.setWay(Constants.SAAS_MESSAGE_SEND_WAY);
            messageDto.setPoliceRegionId(personcertificate.getDistrict());
            messageDto.setSendPer("百课堂安排考试");
            saasInterfaceUtil.callInterface(Constants.SAAS_MESSAGE_SEND, messageDto);


            //百保盾内部发送
            this.sendExamMsgHuiWei(personcertificate, newstitle, title, content, smsCode, msgParams);
        }
    }

    @Override
    public List<Personcertificate> findAll() {
        return personcertificateDao.findAll();
    }

    /**
     * 查找未收入指纹的人员
     *
     * @return
     */
    @Override
    public List<Personcertificate> findNofinger() {
        return personcertificateDao.findNofinger();
    }

    // 保安员考试报名系统通知 审批内导外时调用
    @Override
    public void sendMsg(Personcertificate personcertificate, Approval approval) {

        /****************华为短信*****************/
        String smsCode = "";
        String[] msgParams = null;
        /****************华为短信*****************/

        //是否显示指纹录入环节
        Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);


        String dbApprovalstate = personcertificate.getApprovalstate();
        String newApprovalstate = approval.getApprovalstate();

        String title = "";
        String content = "";
        String newsTitle = "";

        if (ApprovalState.SHBTG.equals(newApprovalstate)) {// 材料受理不通过通知
            newsTitle = Constants.APPROVAL_PERSONCERTIFICATE_FAIL_MSG.replace("{name}", personcertificate.getName());
            title = Constants.APPROVAL_FAIL_TITLE;
            content = Constants.APPROVAL_PERSONCERTIFICATE_FAIL_CONTENT;
        } else if (!ApprovalState.SHTG.equals(dbApprovalstate) && ApprovalState.SHTG.equals(newApprovalstate)) {
            // 审批通过通知
            CustomPersoncertificateService customPersoncertificateService = CustomPersoncertificateBeanFactory.getPersoncertificateBean();

            //信息内容
            content = customPersoncertificateService.getMsgTemp(Constants.TEMPTYPE_CONTENT, personcertificate.getTestState());
            //信息标题
            newsTitle = customPersoncertificateService.getMsgTemp(Constants.TEMPTYPE_TITLE, personcertificate.getTestState());


            newsTitle = newsTitle.replace("{writtenScore}", personcertificate.getWrittenScore().toString())
                    .replace("{operateScore}", personcertificate.getOperateScore().toString());
            title = Constants.APPROVAL_PASS_TITLE;
            content = content.replace("{writtenScore}", personcertificate.getWrittenScore().toString())
                    .replace("{operateScore}", personcertificate.getOperateScore().toString());
        } else {
            // 指纹录入通知
            if (ApprovalState.DSH.equals(dbApprovalstate) && ApprovalState.SPZ.equals(newApprovalstate)) {
                if (approval.getOrgid() != null) {
                    Police police = policeDao.findById(approval.getOrgid());
                    if (police != null) {
                        //指纹环节 是否配置  不存在指纹录入环节，不发通知  wjb 2018年10月22日14:21:43
                        if (null != isShowFingerprintConfig && StringUtil.isNotEmpty(isShowFingerprintConfig.getValue()) && Constants.IS_SHOW_FINGERPRINT_NO.equals(isShowFingerprintConfig.getValue())) {
                        } else {
                            newsTitle = Constants.APPROVAL_PERSONCERTIFICATE_FINGERPRINT_MSG
                                    .replace("{name}", personcertificate.getName())
                                    .replace("{orgName}", police.getOrgname());
                            title = Constants.APPROVAL_UNFINGER_TITLE;
                            content = Constants.APPROVAL_PERSONCERTIFICATE_UNFINGER_CONTENT.replace("{orgName}",
                                    police.getOrgname());


                            /****************华为短信*****************/
                            smsCode = MSGConstants.SMSCODE_B68;
                            msgParams = new String[]{police.getOrgname()};
                            /*********************************/

                        }

                    }
                }
            }
        }

        //判断短信平台编码是否存在
        if (StringUtil.isNotEmpty(smsCode)) {
            /****************华为短信*****************/
            this.sendMsgHuaWei(personcertificate, newsTitle, title, content, smsCode, msgParams);
            /****************华为短信*****************/
        } else {
            this.sendMsg(personcertificate, newsTitle, title, content);
        }
    }

    @Override
    public Personcertificate getCardStateByIds(String id) {
        return personcertificateDao.findById(Long.parseLong(id));
    }

    /**
     * 获取指纹卡号更新
     *
     * @param personcertificate
     */
    @Override
    public void updatefingercardStateById(Personcertificate personcertificate) {
        User currentUser = arsUtil.getCurrentUser();
        personcertificate.setUpdateBy(currentUser.getUsername());
        personcertificate.setUpdateTime(new Date());
        // 读取配置文件
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        if (config.getValue().equals("1")) {
            personcertificate.setUpdateflag(true);
        }
        // 读取配置文件
        Config isNew = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
        if (isNew != null && !Constants.APPROVAL_VERSION_NEW.equals(isNew.getValue())) {
            // 更新指纹需要走流程
            this.updatefingercardStateNeedActivi(personcertificate, currentUser);
        } else {
            // 启用activitii流程
            approvalUtil.savePersonApproval(BusinessType.BAYZ, personcertificate.getId(),
                    Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);
        }
        //配置 是否需要流程
        Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
        if (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_NO.equals(isNeedActivity.getValue())) {
            personcertificate.setApprovalstate(ApprovalState.SPZ);
        }
        personcertificateDaoAop.updateSelective(personcertificate);

    }

    /**
     * @param currentUser
     * @return void
     * @Decription:获取指纹需要走流程
     * @author：zhongjianhui
     * @method updatefingercardStateNeedActivi @date：2018/8/31 17:09 @params：
     * * @param personcertificate
     */
    private void updatefingercardStateNeedActivi(Personcertificate personcertificate, User currentUser) {
        // 判断数据库是不是已采集，如果已采集则不走流程
        Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());
        if (!Constants.FINGERCARD_STATE_YCJ.equals(dbPersoncertificate.getFingercardState())) {
            // TODO 更新获取指纹流程
            /*********** 获取指纹通过流程 ***************/
            ApprovalDTO approvalDTO = new ApprovalDTO();
            approvalDTO.setBusinesstype(BusinessType.BAYZ);
            approvalDTO.setBusinessid(personcertificate.getId());
            approvalDTO.setApprovalstate(ApprovalState.SHTG);
            String reason = getReason(personcertificate.getApprovalreason(), Constants.APPROVAL_CONTEXT_ZW);
            approvalDTO.setApprovalreason(reason);

            //配置 是否需要流程
            Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
            if (isNeedActivity == null || (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue()))) {
                approvalDTO.setIsNeedActivity(Constants.IS_NEED_ACTIVITY_YES);
            }

            approvalService.saveApprovalForManual(approvalDTO, currentUser.getRealname());
        }
    }

    /**
     * @param currentUser
     * @return void
     * @Decription:更新缴费需要走流程（陕西用）
     * @author：zhongjianhui
     * @method updatefeeStateNeedActivi @date：2018/8/31 17:01 @params： * @param
     * personcertificate
     */
    private void updatefeeStateNeedActivi(Personcertificate personcertificate, User currentUser) {
        ApprovalDTO approvalDTO = new ApprovalDTO();
        approvalDTO.setBusinesstype(BusinessType.BAYZ);
        approvalDTO.setBusinessid(personcertificate.getId());

        // TODO
        if (personcertificate.getFeeState().equals(Constants.FEE_STATE_YJF)) {// 确认续费
            approvalDTO.setApprovalstate(ApprovalState.SHTG);
            String reason = getReason(personcertificate.getApprovalreason(), Constants.APPROVAL_CONTEXT_JF);
            approvalDTO.setApprovalreason(reason);
            approvalService.saveApprovalForManual(approvalDTO, currentUser.getRealname());
        } else if (personcertificate.getFeeState().equals(Constants.FEE_STATE_WJF)) {// 取消缴费
            approvalDTO.setApprovalstate(ApprovalState.JF);
            String reason = getReason(personcertificate.getApprovalreason(), Constants.APPROVAL_CONTEXT_QXJF);
            approvalDTO.setApprovalreason(reason);
            approvalService.saveApprovalForManual(approvalDTO, currentUser.getRealname());
        }
    }

    @Override
    public void updateBMStateByid(Long id, String approvalreason) {

        Personcertificate personcertificate = personcertificateDao.findById(id);
        User currentUser = arsUtil.getCurrentUser();
        personcertificate.setUpdateBy(currentUser.getUsername());
        personcertificate.setSignConfirm("001");
        personcertificate.setUpdateTime(new Date());
        personcertificate.setUpdateflag(true);
        personcertificateDaoAop.updateSelective(personcertificate);

        /*********** 报名确认通过流程 ***************/
        // 保存报名确认审批日志
        //checkApproval(personcertificate, currentUser, approvalreason);
        ApprovalDTO approvalDTO = new ApprovalDTO();
        approvalDTO.setBusinesstype(BusinessType.BAYZ);
        approvalDTO.setBusinessid(personcertificate.getId());
        approvalDTO.setApprovalstate(ApprovalState.SHTG);
        // modify zjh time :2018年8月8日 10:01:04 审批意见不是写死的
        String reason = getReason(approvalreason, Constants.APPROVAL_CONTEXT_BM);
        approvalDTO.setApprovalreason(reason);
        approvalService.saveApprovalForManual(approvalDTO, currentUser.getRealname());

    }

    /**
     * 保安员考试报名系统通知 保安员证内导外时调用
     *
     * @param personcertificate
     * @param dbPersoncertificate
     */
    @Override
    public void sendMsg(Personcertificate personcertificate, Personcertificate dbPersoncertificate) {
        //是否显示指纹录入环节
        Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
        // 是否要发送短信标记 add 2018-06-09 start
        boolean msgflag = false;
        // 是否要发送短信标记 add 2018-06-09 end
        String dbApprovalstate = dbPersoncertificate.getApprovalstate();
        String newApprovalstate = personcertificate.getApprovalstate();
        // 考试安排状态:0未安排，1已安排，2已取消,3, 已修改
        String dbExamState = dbPersoncertificate.getExamState();
        String newExamState = personcertificate.getExamState();
        // 考试状态:1通过0不通过
        String dbTestState = dbPersoncertificate.getTestState() == null ? "" : dbPersoncertificate.getTestState();
        String newTestState = personcertificate.getTestState() == null ? "" : personcertificate.getTestState();
        // 背景筛查
        String dbCensorStatus = dbPersoncertificate.getCensorStatus() == null ? ""
                : dbPersoncertificate.getCensorStatus();
        String newCensorStatus = personcertificate.getCensorStatus() == null ? "" : personcertificate.getCensorStatus();
        String name = personcertificate.getName();
        String title = "";
        String content = "";
        String newsTitle = "";
        String newsContent = "";
        //消息类型
        String messageType = "";

        /****************华为短信*****************/
        String smsCode = "";
        String[] msgParams = null;
        /****************华为短信*****************/

        if (ApprovalState.SHBTG.equals(newApprovalstate)) {
            // 材料受理不通过通知
            newsTitle = Constants.APPROVAL_PERSONCERTIFICATE_FAIL_MSG.replace("{name}", name);
            title = Constants.APPROVAL_FAIL_TITLE;
            content = Constants.APPROVAL_PERSONCERTIFICATE_FAIL_CONTENT;
            messageType = Constants.MESSAGETYPE_050203;
            msgflag = true;
            /****************华为短信*****************/
            smsCode = MSGConstants.SMSCODE_B69;
            msgParams = new String[]{};
            /*********************************/
        } else if (!ApprovalState.SHTG.equals(dbApprovalstate) && ApprovalState.SHTG.equals(newApprovalstate)) {
            Config webConfig = configUtils.getConfigByKey(Constants.WEBHOST);
            if (webConfig != null) {
                title = Constants.APPROVAL_PASS_TITLE;
                content = Constants.APPROVAL_PERSONCERTIFICATE_PASS_NEW_CONTENT.replace("{webHost}",
                        webConfig.getValue());
                messageType = Constants.MESSAGETYPE_050203;
                /****************华为短信*****************/
                smsCode = MSGConstants.SMSCODE_B10;
                msgParams = new String[]{webConfig.getValue()};
                /*********************************/
                msgflag = true;
            }
        } else {
            /**
             * 是否需要缴费
             */
            Config onlinePayConfig = null;
            Config c = configUtils.getConfigByKey(Constants.CONFIGFEE + personcertificate.getCity());
            //是否需要 缴费确认 环节
            if (null != c && Constants.CONFIGFEE_YES.equals(c.getValue())) {
                // 是否在线缴费
                onlinePayConfig = configUtils.getConfigByKey(Constants.IS_ONLINEPAY);
            }
            // 新保安员证流程
            // 规则：内网待审批,内网无指纹，背景筛查通过，修改时间>外网的修改时间
            // 录入指纹通知：暂不发送站内信
            if (ApprovalState.DSH.equals(dbApprovalstate) && ApprovalState.DSH.equals(newApprovalstate)
                    && !newCensorStatus.equals(dbCensorStatus)
                    && Constants.CENSORSTATUS_PASS.equals(newCensorStatus)
                    && StringUtil.isEmpty(personcertificate.getFingerprint())) {
                if (personcertificate.getOrgid() != null) {
                    Police police = policeDao.findById(personcertificate.getOrgid());
                    if (police != null) {
                        title = Constants.APPROVAL_UNFINGER_TITLE;
                        content = Constants.APPROVAL_PERSONCERTIFICATE_UNFINGER_CONTENT.replace("{orgName}",
                                police.getOrgname());
                        messageType = Constants.MESSAGETYPE_050201;
                        msgflag = true;
                        //配置 不存在指纹录入环节  所以不发通知
                        if (null != isShowFingerprintConfig && StringUtil.isNotEmpty(isShowFingerprintConfig.getValue()) && Constants.IS_SHOW_FINGERPRINT_NO.equals(isShowFingerprintConfig.getValue())) {
                            msgflag = false;
                        }
                        /****************华为短信*****************/
                        smsCode = MSGConstants.SMSCODE_B68;
                        msgParams = new String[]{police.getOrgname()};
                        /*********************************/
                    }
                }
            } else if (ApprovalState.SPZ.equals(newApprovalstate)
                    && StringUtil.isNotEmpty(personcertificate.getGroupid())
                    && (StringUtil.isEmpty(personcertificate.getFeeState())
                    || !Constants.FEE_STATE_YJF.equals(personcertificate.getFeeState()))
                    && (StringUtil.isNotEmpty(personcertificate.getGroupid()) && personcertificate.getGroupid().indexOf("999") >= 0)) {
                // 待考试安排阶段判断缴费通知
                // 未缴费状态
                // 缴费通知
                // 短信或者app
                title = Constants.APPROVAL_PAY_TITLE;
                newsTitle = Constants.APPROVAL_PERSONCERTIFICATE_PAY_NEWS_TITLE.replace("{name}", name);
                if (onlinePayConfig != null && StringUtil.isNotEmpty(onlinePayConfig.getValue())
                        && Constants.IS_ONLINEPAY_YES.equals(onlinePayConfig.getValue())) {
                    // 在线缴费
                    content = Constants.APPROVAL_PERSONCERTIFICATE_ONLINE_PAY_CONTENT;
                    newsContent = Constants.APPROVAL_PERSONCERTIFICATE_ONLINE_PAY_NEWS_CONTENT.replace("{name}",
                            name);
                    /****************华为短信*****************/
                    smsCode = MSGConstants.SMSCODE_B67;
                    msgParams = new String[]{};
                    /*********************************/
                } else {
                    // 人员短信线下缴费通知：
                    content = Constants.APPROVAL_PERSONCERTIFICATE_PAY_CONTENT;
                    //  公司站内信通知
                    newsContent = Constants.APPROVAL_PERSONCERTIFICATE_PAY_NEWS_CONTENT.replace("{name}", name);
                    /****************华为短信*****************/
                    smsCode = MSGConstants.SMSCODE_B65;
                    msgParams = new String[]{};
                    /*********************************/
                }
                msgflag = true;
                messageType = Constants.MESSAGETYPE_050202;
                /***********************与saas对接站内信不需要注释 start subh 2019-06-13************************************/
                // 2018-09-04目前只有缴费通知有站内信
                // 站内信
                //this.sendCompanyMsg(dbPersoncertificate, newsTitle, newsContent);
                /***********************与saas对接站内信不需要 start subh 2019-06-13************************************/
            }
        }
        /***********************内到内没有成绩通知注释 start subh 2019-06-13************************************/
		/*if (!Constants.EXAM_STATE_YAP.equals(dbExamState) && Constants.EXAM_STATE_YAP.equals(newExamState)) {
			// 考试安排通知
			title = Constants.EXAM_NEW_NOTE_TITLE;
			messageType = Constants.MESSAGETYPE_040101;
			content = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CONTENT;
			newsTitle = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_MSG;
			//考试开始时间
			if(personcertificate.getExamStart()!=null && personcertificate.getExamEnd()!=null && personcertificate.getExamAddress()!=null){
				content = content.replace("{name}", name).replace("{examStart}", personcertificate.getExamStart())
						.replace("{examEnd}", personcertificate.getExamEnd())
						.replace("{examAddress}", personcertificate.getExamAddress());
				newsTitle = newsTitle.replace("{name}", name).replace("{examStart}", personcertificate.getExamStart())
						.replace("{examEnd}", personcertificate.getExamEnd())
						.replace("{examAddress}", personcertificate.getExamAddress());
				this.sendExamMsg(dbPersoncertificate, newsTitle, title, content);
			}

		}
		if (StringUtils.isNotEmpty(newTestState) && !newTestState.equals(dbTestState)) {
			// 考试成绩通知
			title = Constants.EXAM_NOTE_TITLE;// 考试通知标题
			messageType = Constants.MESSAGETYPE_040104;
			CustomPersoncertificateService customPersoncertificateService = CustomPersoncertificateBeanFactory.getPersoncertificateBean();
			//信息内容
			content = customPersoncertificateService.getMsgTemp_V1172(Constants.TEMPTYPE_CONTENT,personcertificate.getTestState());
			//信息标题
			newsTitle = customPersoncertificateService.getMsgTemp_V1172(Constants.TEMPTYPE_TITLE,personcertificate.getTestState());

			content = content.replace("{writtenScore}", personcertificate.getWrittenScore().toString())
					.replace("{operateScore}", personcertificate.getOperateScore().toString());
			newsTitle = newsTitle.replace("{name}", personcertificate.getName())
					.replace("{writtenScore}", personcertificate.getWrittenScore().toString())
					.replace("{operateScore}", personcertificate.getOperateScore().toString());

			this.sendExamMsg(dbPersoncertificate, newsTitle, title, content);
		}*/
        /***********************内到内没有成绩通知注释 start subh 2019-06-13************************************/
        // 短信标识为true发送短信
        if (msgflag) {
            //有人员ID直接发给公共服务安全平台消息通知
            if (dbPersoncertificate.getPersonid() != null) {
                //url地址
                String url = configUtils.saas_data_host + Constants.SAAS_MESSAGE_SEND;
                Map params = CollUtil.newHashMap();
                params.put("title", title);
                params.put("content", content);
                // 消息类型
                params.put("messageType", messageType);
                // 接收人
                params.put("ids", dbPersoncertificate.getPersonid());
                //平台标识
                params.put("platId", "11");
                //APP
                params.put("way", Constants.SAAS_MESSAGE_SEND_WAY);
                //区域编码
                params.put("policeRegionId", personcertificate.getCity());
                //发送人
                params.put("sendPer", "system");
                try {
                    HttpUtil.post(url, params);
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            } else {
                //判断短信平台编码是否存在
                if (StringUtil.isNotEmpty(smsCode)) {
                    /****************华为短信*****************/
                    this.sendMsgHuaWei(dbPersoncertificate, newsTitle, title, content, smsCode, msgParams);
                    /****************华为短信*****************/
                } else {
                    this.sendMsg(dbPersoncertificate, newsTitle, title, content);
                }
            }

        }
    }

    private void sendCompanyMsg(Personcertificate personcertificate, String newsTitle, String newsContent) {
        new Thread(() -> {
            try {
                if (personcertificate.getCompanyid() != null) {
                    if (StringUtil.isNotEmpty(newsTitle) && StringUtil.isNotEmpty(newsContent)) {// WEB站内消息
                        NewsnoticeCompany newsnoticeCompany = new NewsnoticeCompany();
                        newsnoticeCompany.setActive(true);
                        newsnoticeCompany.setCompanyId(personcertificate.getCompanyid());
                        newsnoticeCompany.setReadstate(Constants.READSTATUS_UNREAD);
                        newsnoticeCompany.setSendname("系统管理员");
                        newsnoticeCompany.setSendorgname("系统管理员");
                        newsnoticeCompany.setNewscontext(newsContent);
                        newsnoticeCompany.setNewstitle(newsTitle);
                        newsnoticeCompany.setUpdateflag(false);
                        newsnoticeCompany.setCreateTime(new Date());
                        newsnoticeCompany.setUpdateBy("system");
                        newsnoticeCompany.setUpdateTime(new Date());
                        newsnoticeCompany.setId(idGeneratorUtil.createID());
                        newsnoticeCompany.setUndoState(Constants.DOSTATE);
                        newsnoticeCompanyDao.save(newsnoticeCompany);
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }).start();
    }

    @Override
    public void sendMsg(Personcertificate personcertificate, String newsTitle, String title, String content) {
        new Thread(() -> {
            try {
                if (StringUtil.isEmpty(title) || StringUtil.isEmpty(content)) {
                    // 如果消息为空 直接返回
                    return;
                }
                // 判断是否有app
                boolean hasApp = false;
                // 推送ID
                String registrationID = "";
                SecurityPerson person = securityPersonDao.findByIdCard(personcertificate.getCardnumber());

                if (hasApp) {
                    // APP推送通知
                    AppNotice appNotice = new AppNotice();
                    appNotice.setNoticeTitle(title);
                    appNotice.setCreateTime(new Date());
                    appNotice.setActive(true);
                    appNotice.setNoticeContent("【系统通知】" + content.replaceAll("，", "\\\\n"));
                    appNotice.setNoticeTypeID(1L);
                    appNotice.setPersonId(person.getId());
                    appNotice.setReadStatus("0");
                    appNotice.setUpdateTime(new Date());
                    appNoticeDao.save(appNotice);
                    JPushUtil.sendMessage(title, "【系统通知】" + content, registrationID);
                } else {
                    // 自然人审报 短信 或者 公司保安员未注册app
                    MessageUtil.sendMessage(personcertificate.getPhone(), content, messageLogDao);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }).start();
    }

    @Override
    public void sendMsgHuaWei(Personcertificate personcertificate, String newsTitle, String title, String content, String smsCode, String[] parems) {
        new Thread(() -> {
            try {
                if (StringUtil.isEmpty(title) || StringUtil.isEmpty(content)) {
                    // 如果消息为空 直接返回
                    return;
                }
                // 判断是否有app
                boolean hasApp = false;
                // 推送ID
                String registrationID = "";
                SecurityPerson person = securityPersonDao.findByIdCard(personcertificate.getCardnumber());

                if (hasApp) {
                    // APP推送通知
                    AppNotice appNotice = new AppNotice();
                    appNotice.setNoticeTitle(title);
                    appNotice.setCreateTime(new Date());
                    appNotice.setActive(true);
                    appNotice.setNoticeContent("【系统通知】" + content.replaceAll("，", "\\\\n"));
                    appNotice.setNoticeTypeID(1L);
                    appNotice.setPersonId(person.getId());
                    appNotice.setReadStatus("0");
                    appNotice.setUpdateTime(new Date());
                    appNoticeDao.save(appNotice);
                    JPushUtil.sendMessage(title, "【系统通知】" + content, registrationID);
                } else {
                    // 自然人审报 短信 或者 公司保安员未注册app
                    MessageUtil.sendMessageHuaWei(personcertificate.getPhone(), content, messageLogDao, parems, smsCode);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }).start();
    }

    @Override
    public void temporarySave(Personcertificate personcertificate) {
        // 读取配置文件
        Config config = configUtils.getConfigByKey("police");
        User currentUser = arsUtil.getCurrentUser();
        if (personcertificate.getId() == null) {
            personcertificate.setApprovalstate(Constants.APPROVALSTATE_WTJ);
            personcertificate.setCreateTime(new Date());
            personcertificate.setUpdateTime(new Date());
            personcertificate.setActive(true);
            personcertificate.setUserid(currentUser.getId());
            personcertificate.setUpdateBy(currentUser.getUsername());

            // 状态初始化默认值
            // 新增时默认为待审查 add 2018-05-20 subh start
            personcertificate.setCensorStatus(Constants.CENSORSTATUS_WAIT);// 待审查
            // 新增时默认为待审查 add 2018-05-20 subh end
            // 状态初始化默认值
            /*
             * personcertificate.setCardState(Constants.CARD_STATE_WZZ);//未制证
             * personcertificate.setTestState(Constants.TEST_STATE_WTG);//考试未通过
             * personcertificate.setExamState(Constants.EXAM_STATE_WAP);//考试未安排
             * personcertificate.setFeeState(Constants.FEE_STATE_WJF);//未缴费
             *
             * personcertificate.setFingercardState(Constants.
             * FINGERCARD_STATE_WJL);//指纹未记录
             */

            personcertificate.setId(idWorker.nextId());
            personcertificateDao.save(personcertificate);
        } else {
            Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());

            if (ApprovalState.WTJ.equals(personcertificate.getApprovalstate())) {
                // 2018年8月8日14:11:42 wjb 暂存时设置审查状态
                BeanUtils.copyPropertiesIgnore(personcertificate, dbPersoncertificate,
                        "active,createTime,userid,censorStatus", true);
            } else {
                BeanUtils.copyPropertiesIgnore(personcertificate, dbPersoncertificate, true);
            }

            dbPersoncertificate.setUpdateTime(new Date());
            dbPersoncertificate.setUpdateBy(currentUser.getUsername());

            personcertificateDaoAop.update(dbPersoncertificate);
        }
    }

    @Override
    public PersonCertificateReportData dataStatisticsReport(ReportDataSearchDto searchDto) {
        PersonCertificateReportData data = new PersonCertificateReportData();

        User currentUser = arsUtil.getCurrentUser();
        searchDto.setPath(currentUser.getPolice().getPath());
        searchDto.setUserid(currentUser.getId());
        String areacode = searchDto.getAreaCode();
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {// 省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {// 市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {// 区
                searchDto.setAreaCode(areacode);
            }
        }

        ReportDataSearchDto searchLastDto = new ReportDataSearchDto();
        searchLastDto.setAreaCode(searchDto.getAreaCode());

        searchLastDto.setPath(currentUser.getPolice().getPath());
        searchLastDto.setUserid(currentUser.getId());
        DecimalFormat df = new DecimalFormat("#0.00");

        Long censorLastCount = null;
        Long testLastCount = null;
        Long printLastCount = null;
        Long approvalPassLastCount = null;
        Long approvalUnPassLastCount = null;
        Long approvalIngLastCount = null;
        Long lastTotal = null;
        if (StringUtil.isNotEmpty(searchDto.getType())) {
            if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISDAY)) {
                searchLastDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTDAY);
            } else if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISWEEK)) {
                searchLastDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTWEEK);
            } else if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISMONTH)) {
                searchLastDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTMONTH);
            } else if (searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_THISYEAR)) {
                searchLastDto.setType(Constants.DATASTATISTICS_DATETYPE_LASTYEAR);
            }
        }
        PersonCertificateReportData lastData = null;
        if (StringUtil.isNotEmpty(searchDto.getType())
                && !searchDto.getType().equals(Constants.DATASTATISTICS_DATETYPE_DIY)) {
            censorLastCount = personcertificateDao.dataStatisticsCensorReport(searchLastDto);
            testLastCount = personcertificateDao.dataStatisticsTestReport(searchLastDto);
            printLastCount = personcertificateDao.dataStatisticsPrintReport(searchLastDto);
            approvalPassLastCount = 0l;
            approvalUnPassLastCount = 0l;
            approvalIngLastCount = 0l;
            List<ReportData> list = personcertificateDao.dataStatisticsApprovalReport(searchLastDto);
            lastTotal = 0l;
            for (ReportData reportData : list) {
                lastTotal = lastTotal + reportData.getValue();
                if (reportData.getName().equals(ApprovalState.SHTG)) {
                    approvalPassLastCount = reportData.getValue();
                } else if (reportData.getName().equals(ApprovalState.SHBTG)) {
                    approvalUnPassLastCount = reportData.getValue();
                } else if (reportData.getName().equals(ApprovalState.DSH)
                        || reportData.getName().equals(ApprovalState.SPZ)) {
                    approvalIngLastCount = approvalIngLastCount + reportData.getValue();
                }
            }
            lastData = new PersonCertificateReportData();
            lastData.setApprovalIngCount(approvalIngLastCount);
            lastData.setApprovalPassCount(approvalPassLastCount);
            lastData.setApprovalUnPassCount(approvalUnPassLastCount);
            lastData.setTotal(lastTotal);
            lastData.setTestPassCount(testLastCount);
            lastData.setPrintCount(printLastCount);
            lastData.setCensorPassCount(censorLastCount);
        }

        Long censorCount = personcertificateDao.dataStatisticsCensorReport(searchDto);
        Long testCount = personcertificateDao.dataStatisticsTestReport(searchDto);
        Long testUnPassCount = personcertificateDao.dataStatisticsTestUnPassReport(searchDto);
        Long printCount = personcertificateDao.dataStatisticsPrintReport(searchDto);
        Long approvalPassCount = 0l;
        Long approvalUnPassCount = 0l;
        Long approvalIngCount = 0l;
        List<ReportData> list = personcertificateDao.dataStatisticsApprovalReport(searchDto);
        Long total = 0l;
        for (ReportData reportData : list) {
            total = total + reportData.getValue();
            if (reportData.getName().equals(ApprovalState.SHTG)) {
                approvalPassCount = reportData.getValue();
            } else if (reportData.getName().equals(ApprovalState.SHBTG)) {
                approvalUnPassCount = reportData.getValue();
            } else if (reportData.getName().equals(ApprovalState.DSH)
                    || reportData.getName().equals(ApprovalState.SPZ)) {
                approvalIngCount = approvalIngCount + reportData.getValue();
            }
        }
        data.setApprovalIngCount(approvalIngCount);
        data.setApprovalPassCount(approvalPassCount);
        data.setApprovalUnPassCount(approvalUnPassCount);
        data.setTotal(total);
        data.setTestPassCount(testCount);
        data.setPrintCount(printCount);
        data.setCensorPassCount(censorCount);
        if (testCount < 1) {
            data.setExamPassRate("0");
        } else if (testUnPassCount > 0) {
            data.setExamPassRate(df.format(testCount * 100 / (testUnPassCount + testCount)));
        } else {
            data.setExamPassRate("100");
        }
        if (lastData != null) {
            if (lastTotal > 0) {
                data.setTotalRate(df.format((total - lastTotal) * 100.0 / lastTotal));
            } else if (total < 1) {
                data.setTotalRate("0");
            } else {
                data.setTotalRate("100");
            }

            if (approvalIngLastCount > 0) {
                data.setApprovalIngRate(
                        df.format((approvalIngCount - approvalIngLastCount) * 100.0 / approvalIngLastCount));
            } else if (approvalIngCount < 1) {
                data.setApprovalIngRate("0");
            } else {
                data.setApprovalIngRate("100");
            }

            if (approvalPassLastCount > 0) {
                data.setApprovalPassRate(
                        df.format((approvalPassCount - approvalPassLastCount) * 100.0 / approvalPassLastCount));
            } else if (approvalPassCount < 1) {
                data.setApprovalPassRate("0");
            } else {
                data.setApprovalPassRate("100");
            }

            if (approvalUnPassLastCount > 0) {
                data.setApprovalUnPassRate(
                        df.format((approvalUnPassCount - approvalUnPassLastCount) * 100.0 / approvalUnPassLastCount));
            } else if (approvalUnPassCount < 1) {
                data.setApprovalUnPassRate("0");
            } else {
                data.setApprovalUnPassRate("100");
            }

            if (censorLastCount > 0) {
                data.setCensorPassRate(df.format((censorCount - censorLastCount) * 100.0 / censorLastCount));
            } else if (censorCount < 1) {
                data.setCensorPassRate("0");
            } else {
                data.setCensorPassRate("100");
            }

            if (testLastCount > 0) {
                data.setTestPassRate(df.format((testCount - testLastCount) * 100.0 / testLastCount));
            } else if (testCount < 1) {
                data.setTestPassRate("0");
            } else {
                data.setTestPassRate("100");
            }
        }
        return data;
    }

    @Override
    public PageResult searchPrintList(Map<Object, Object> p) {
        //资格证打印北京默认查询去悼排序，优化速度
        if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            return new PageResult(personcertificateDao.countPrintList(p), personcertificateDao.searchPrintListForBj(p));
        } else {
            return new PageResult(personcertificateDao.countPrintList(p), personcertificateDao.searchPrintList(p));
        }
    }

    @Override
    public void exportSecurityCertificate(List<Personcertificate> data, File file) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("保安员证书信息");
            // wb.setSheetHidden(1, true);
            // 标题
            String[] handers = {"姓名", "身份证号", "手机号", "性别", "住址", "公司名称", "理论成绩", "实践成绩", "发证日期", "发证机关", "证书编号"}; // 列标题
            // 生成sheet1内容
            HSSFRow rowFirst = sheet1.createRow(0);// 第一个sheet的第一行为标题
            // 样式
            CellStyle style = ExcelUtil.getCommonTitleStyle(wb);
            // 写标题

            for (int i = 0; i < handers.length; i++) {
                HSSFCell cell = rowFirst.createCell(i); // 获取第一行的每个单元格
                sheet1.setColumnWidth(i, 5000); // 设置每列的列宽
                // cell.setCellStyle(style);
                cell.setCellValue(handers[i]); // 往单元格里写数据
            }
            int index = 1;
            HSSFRow row = null;
            for (Personcertificate personcertificate : data) {
                row = sheet1.createRow(index++);
                if (personcertificate != null && personcertificate.getSecurityCertificate() != null) {
                    HSSFCell nameCell = row.createCell(0);
                    nameCell.setCellValue(personcertificate.getSecurityCertificate().getXm()); // 往单元格里写数据

                    HSSFCell idnumCell = row.createCell(1);
                    idnumCell.setCellValue(personcertificate.getSecurityCertificate().getIdnum());

                    HSSFCell phoneCell = row.createCell(2);
                    phoneCell.setCellValue(personcertificate.getPhone()); // 往单元格里写数据

                    HSSFCell sexCell = row.createCell(3);
                    sexCell.setCellValue(
                            IdNumUtil.getGenderByIdCard(personcertificate.getSecurityCertificate().getIdnum())); // 往单元格里写数据

                    HSSFCell addressCell = row.createCell(4);
                    addressCell.setCellValue(personcertificate.getSecurityCertificate().getAddress()); // 往单元格里写数据

                    HSSFCell companynameCell = row.createCell(5);
                    if (personcertificate.getSecurityCompany() != null) {
                        companynameCell.setCellValue(personcertificate.getSecurityCompany().getName()); // 往单元格里写数据
                    }

                    HSSFCell writtenScoreCell = row.createCell(6);
                    writtenScoreCell.setCellValue(personcertificate.getWrittenScore() == null ? ""
                            : personcertificate.getWrittenScore().toString());

                    HSSFCell operateScoreCell = row.createCell(7);
                    operateScoreCell.setCellValue(personcertificate.getOperateScore() == null ? ""
                            : personcertificate.getOperateScore().toString());

                    HSSFCell fzrqCell = row.createCell(8);
                    fzrqCell.setCellValue(
                            DateUtil.formatDate(personcertificate.getSecurityCertificate().getFzrq(), "yyyy-MM-dd")); // 往单元格里写数据

                    HSSFCell fzjgCell = row.createCell(9);
                    fzjgCell.setCellValue(personcertificate.getSecurityCertificate().getFzjgmc());

                    HSSFCell zsbhCell = row.createCell(10);
                    zsbhCell.setCellValue(personcertificate.getSecurityCertificate().getZsbh());
                }

            }
            // 输出模板
            FileOutputStream fileOut;
            fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PersoncertificateSearchDto searchExport(PersoncertificateSearchDto dto) {
        PersoncertificateSearchDto resultDto = new PersoncertificateSearchDto();
        User currentUser = arsUtil.getCurrentUser();
        // 机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        if (police != null) {
            String areacode = police.getAreacode();
            if (areacode.endsWith("0000")) {// 省
                dto.setDistrict(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {// 市
                dto.setDistrict(areacode.substring(0, 4) + "__");
            } else {// 区
                dto.setDistrict(areacode);
            }
        }

        if (dto.getAreaCode() != null && !"".equals(dto.getAreaCode())) {
            String areacode = dto.getAreaCode();
            if (areacode.endsWith("0000")) {// 省
                dto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {// 市
                dto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {// 区
                dto.setAreaCode(areacode);
            }
        }

        List<Personcertificate> list = personcertificateDao.searchExport(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(personcertificateDao.searchCount(dto));
        return resultDto;
    }

    @Override
    public void updatePayConfirm(Personcertificate personcertificate) {
        personcertificate.setUpdateflag(true);
        personcertificate.setUpdateTime(new Date());
        personcertificateDaoAop.updateSelective(personcertificate);
    }

    private void writeTxtFile(String readStr, String type) {
        // logger.info(type);
        try {
            String basePath = tempftpFolder; // 路径
            String filePath = basePath + com.bcxin.ars.util.DateUtil.getCurrentDate() + File.separator;// 保存路径

            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                logger.info("文件夹已创建");
            }
            String fullFilePath = filePath + fileName + "_"
                    + com.bcxin.ars.util.DateUtil.getCurrentDateTime(com.bcxin.ars.util.DateUtil.FORMAT8) + fileType;

            // 文件处理：写入文件
            File newFile = new File(fullFilePath);
            Files.write(readStr.getBytes(), newFile);
        } catch (Exception e) {
            logger.info("导出失败！");
        }
    }

    @Override
    public PageResult queryTable(PersoncertificateSearchDto searchDto) {
        User currentUser = arsUtil.getCurrentUser();
        if (currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4) {
            searchDto.setUserid(currentUser.getId());
        }
        // 机构信息
        Police police = currentUser.getPolice();
        if (police != null) {
            String areacode = police.getAreacode();
            if (areacode.endsWith("0000")) {// 省
                searchDto.setDistrict(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {// 市
                searchDto.setDistrict(areacode.substring(0, 4) + "__");
            } else {// 区
                searchDto.setDistrict(areacode);
            }
            if (police.getOrgtype().equals("4")) {
                searchDto.setOrgid(police.getId());
            }
        }

        if (searchDto.getAreaCode() != null && !"".equals(searchDto.getAreaCode())) {
            String areacode = searchDto.getAreaCode();
            if (areacode.endsWith("0000")) {// 省
                searchDto.setAreaCode(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {// 市
                searchDto.setAreaCode(areacode.substring(0, 4) + "__");
            } else {// 区
                searchDto.setAreaCode(areacode);
            }
        }

        searchDto.setPlatform(currentUser.getPlatform().toString());
        searchDto.getStart();


        /***
         * 数据权限过滤
         */
        if (currentUser.getAreasList() != null && currentUser.getAreasList().size() > 0) {
            searchDto.setAreasList(currentUser.getAreasList());

        }


        List<PersoncertificateDto> list = personcertificateDao.queryTable(searchDto);
        Long count = personcertificateDao.queryTableCount(searchDto);


        return new PageResult(count.intValue(), list);
    }

    @Override
    public void insertBatchTemp(List<Personcertificate> personlist) {
        personcertificateDao.insertBatchTemp(personlist);
    }

    @Override
    public void deleteTempData() {
        personcertificateDao.deleteTempData();
    }

    @Override
    public List<Personcertificate> findUpdateListFromTemp() {
        return personcertificateDao.findUpdateListFromTemp();
    }

    @Override
    public void updatefingercardState(Personcertificate personcertificate) {
        // 判断数据库是不是已采集，如果已采集则不走流程
        Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());
        if (Constants.FINGERCARD_STATE_WJL.equals(dbPersoncertificate.getFingercardState()) ||
                dbPersoncertificate.getFingercardState() == null ||
                "".equals(dbPersoncertificate.getFingercardState())
        ) {
            // TODO 更新获取指纹流程
            approvalUtil.savePersonApproval(BusinessType.BAYZ, personcertificate.getId(),
                    Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE);
        }
        personcertificateDaoAop.updateSelective(personcertificate);

    }

    @Override
    public List<Personcertificate> findByNumberIdArr(PersoncertificateSearchDto dto) {
        return personcertificateDao.findByNumberIdArr(dto);
    }

    /**
     * 通过id集合查询保安员证考试报名
     *
     * @param dto by llc 2018-06-22
     */
    @Override
    public List<Personcertificate> findByDtoIdArr(PersoncertificateSearchDto dto) {
        return personcertificateDao.findByDtoIdArr(dto);
    }

    @Override
    public List<ZTree> getPersonPayTree() {
        User currentUser = arsUtil.getCurrentUser();
        return personcertificateDao.getPersonPayTreeByUserId(currentUser.getId());
    }

    @Override
    public void saveOrUpdateForApprovalImport(Personcertificate personcertificate) {
        personcertificateDaoAop.update(personcertificate);
    }

    @Override
    public PageResult query(ExamSearchDto searchDto) {
        AjaxPageResponse<ExamSearchDto> page = new AjaxPageResponse<ExamSearchDto>();
        User user = arsUtil.getCurrentUser();
        //配置 是否需要流程
        Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
        if (isNeedActivity == null || (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue()))) {
            /**
             * 是否需要缴费
             */
            Config c = configUtils.getConfigByKey(Constants.CONFIGFEE + user.getCityAreaCode());
            //是否需要 缴费确认 环节
            if (null != c && Constants.CONFIGFEE_YES.equals(c.getValue())) {
                searchDto.setIsPay(c.getValue());
            }
        }

        //是否补考
        if (StringUtil.isNotEmpty(searchDto.getPersonFilterType())) {
            searchDto.setIsMakeUp(searchDto.getPersonFilterType());
        }

        if (searchDto.getPageNum() == 0) {
            page.setPageNumber(1);
        } else {
            page.setPageNumber(searchDto.getPageNum() + 1);
        }
        page.setPageSize(searchDto.getNumPerPage());
        personcertificateDao.query(searchDto, page);
        return new PageResult((int) page.getTotal(), page.getData());
    }

    /**
     * 验证身份证号是否已经提交
     *
     * @param cardNum
     * @param filterId
     * @param currentUser
     * @return
     */
    public Personcertificate checkCarNumRepeat(String cardNum, Long filterId, User currentUser) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("cardNum", cardNum);
        List<String> notIncludeStateList = new ArrayList<String>();
        notIncludeStateList.add(Constants.APPROVALSTATE_WTJ);
        notIncludeStateList.add(Constants.APPROVALSTATE_BTG);
        notIncludeStateList.add(Constants.APPROVALSTATE_YCX);
        map.put("notincludestatelist", notIncludeStateList);
        if (filterId != null) {
            map.put("filterId", filterId);
        }

        // 保安公司,需要增加company过滤,可能出现A,B就职，A有申请记录[控制为不同保安公司可以为同一个人进行报名]
        //2021-03-26 与冠南确认 存在报名中或者报名通过的，则不允许再报名
        //if (currentUser.getPlatform() == 2L) {
        //	// 公司ID
        //	SecurityCompany securityCompany = securityCompanyDao.findByUserid(currentUser.getId());
        //	map.put("companyId", securityCompany.getId());
        //}

        Personcertificate personcertificate = personcertificateDao.checkCarNumRepeat(map);
        return personcertificate;
    }

    @Override
    public void saveOrUpdateForApproval(Personcertificate personcertificate) {
        personcertificate.setUpdateTime(new Date());
        personcertificateDaoAop.update(personcertificate);
    }

    /**
     * 处理保安员证业务逻辑 by llc 2018-08-08
     *
     * @param list
     */
    @Override
    public List<Map<String, String>> saveSecurityCertificate(List<Map<String, String>> list, User user) {

        User currentUser = arsUtil.getCurrentUser();

        /***** 查询本次校验失败的保安员信息 ****/
        List<Map<String, String>> failList = new ArrayList<>();
        //根据数据数量情况，切分不同的大小
        int limit = configUtils.limitSize;
        //计算拆分次数
        int count = new Double(Math.ceil(list.size() * 1.0 / limit)).intValue();
        //存放拆分数据
        List<Map<String, String>> subList = null;
        //循环拆分次数 生成相应数据文件
        for (int i = 0; i < count; i++) {
            subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());


            int batchId = personcertificateDao.getNextVal("seq_batchId");

            /***** 批量插入保安员证临时表 ****/
            personcertificateDao.insertTmpSecurityCertificate(subList, batchId);

            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("prm_batchId", batchId);
            paramMap.put("prm_policeId", user.getId());
            paramMap.put("prm_areaCode", user.getPolice().getAreacode());
            /***** 调用存储过程处理业务逻辑 ****/
            List<SecurityCertificateImPortDto> cerList = securityCertificateDao.prc_batchImportCertificate_query(paramMap);
            List<SecurityCertificate> certificateList = new ArrayList<>();
            List<Personcertificate> personList = new ArrayList<>();
            SecurityCertificate securityCertificate = null;
            Personcertificate personcertificate = null;
            Long secPersonId = null;
            for (SecurityCertificateImPortDto certificateImPortDto : cerList) {
                securityCertificate = new SecurityCertificate();
                BeanUtils.copyPropertiesIgnore(certificateImPortDto, securityCertificate, true);

                secPersonId = idWorker.nextId();
                securityCertificate.setId(idWorker.nextId());
                securityCertificate.setUpdateBy(currentUser.getUsername());
                securityCertificate.setSecuritypersonid(secPersonId);

                securityCertificate.setAreaCode(certificateImPortDto.getDistrict());
                securityCertificate.setSex(IdNumUtil.getGenderByIdCard(certificateImPortDto.getIdnum()));

                certificateList.add(securityCertificate);
                personcertificate = new Personcertificate();
                personcertificate.setActive(true);
                personcertificate.setUpdateflag(true);
                personcertificate.setUpdateBy(certificateImPortDto.getUpdateBy());
                personcertificate.setCreateTime(certificateImPortDto.getCreateTime());
                personcertificate.setUpdateTime(certificateImPortDto.getUpdateTime());
                personcertificate.setPersonid(certificateImPortDto.getPersonId());
                personcertificate.setId(secPersonId);
                personcertificate.setCompanyid(certificateImPortDto.getCompanyId());
                personcertificate.setName(certificateImPortDto.getXm());
                personcertificate.setSex(IdNumUtil.getGenderByIdCard(certificateImPortDto.getIdnum()));
                personcertificate.setCardnumber(certificateImPortDto.getIdnum());
                personcertificate.setBrith(certificateImPortDto.getCsrq());
                personcertificate.setAddress(certificateImPortDto.getAddress());
                personcertificate.setCompanyname(certificateImPortDto.getCompanyName());
                personcertificate.setCardState("2");
                personcertificate.setApprovalstate("003");
                personcertificate.setProvince(certificateImPortDto.getProvince());
                personcertificate.setCity(certificateImPortDto.getCity());
                personcertificate.setDistrict(certificateImPortDto.getDistrict());
                personcertificate.setSzss(certificateImPortDto.getSzss());
                personcertificate.setUpdateBy(currentUser.getUsername());
                personList.add(personcertificate);
            }

            if (personList.size() > 0) {
                personcertificateDaoAop.updateBatch(personList);
            }
            if (certificateList.size() > 0) {
                securityCertificateDao.saveBatch(certificateList);
            }

            /***** 查询本次校验失败的保安员信息 ****/
            failList.addAll(personcertificateDao.getFailList(batchId));

            /***** 删除本次导入的保安员信息 ****/

            personcertificateDao.deleteTmpSecurityCertificate(batchId);
        }
        return failList;
    }

    @Override
    public JSONObject payForPersonCertificate(List<Personcertificate> personcertificateList,
                                              List<OrgPriceDTO> orgPriceDTOList, String organID, String userName, Long payId) {
        JSONObject object = new JSONObject();

        if (payId != null || (personcertificateList != null && personcertificateList.size() > 0)) {
            Long orderInfoID;
            List<Personcertificate> dbPersoncertificateList = new ArrayList<>();
            if (payId != null) {
                orderInfoID = payId;
            } else {
                orderInfoID = idGeneratorUtil.createID();

                dbPersoncertificateList = personcertificateDao.findByBatchPersonId(personcertificateList);
                if (dbPersoncertificateList != null && dbPersoncertificateList.size() > 0) {
                    boolean haveRepeatPerson = false;
                    String repeatPerson = "重复缴费人员名单：";
                    for (Personcertificate dbpersoncertificate : dbPersoncertificateList) {
                        if (Constants.FEE_STATE_YJF.equals(dbpersoncertificate.getFeeState())) {
                            haveRepeatPerson = true;
                            repeatPerson += dbpersoncertificate.getName();
                            break;
                        }
                    }
                    if (haveRepeatPerson) {
                        object.put("successful", false);
                        object.put("message", repeatPerson);
                        return object;
                    }
                } else {
                    object.put("successful", false);
                    object.put("message", "查找不到人员");
                    return object;
                }
            }

            if (orgPriceDTOList != null && orgPriceDTOList.size() > 0) {
                for (OrgPriceDTO orgPriceDTO : orgPriceDTOList) {
                    if (StringUtil.isNotEmpty(organID) && organID.equals(orgPriceDTO.getOrganID())) {
                        /* /新增订单信息 */
                        int length = personcertificateList.size();
                        OrderInfo orderInfo = new OrderInfo();
                        orderInfo.setId(orderInfoID);
                        if (payId != null) {
                            orderInfo = orderInfoDAO.findById(orderInfoID);
                        }
                        orderInfo.setCreateBy(userName);
                        orderInfo.setCreateTime(new Date());
                        orderInfo.setUpdateBy(userName);
                        orderInfo.setUpdateTime(new Date());
                        orderInfo.setActive(true);
                        orderInfo.setBktCourseId(orgPriceDTO.getTrackid());
                        orderInfo.setBktOrgId(orgPriceDTO.getOrganID());
                        orderInfo.setBktOrgName(orgPriceDTO.getOrganName());
                        orderInfo.setOrderSumMoney(orgPriceDTO.getTrackPrice() * length);
                        orderInfo.setBktCourseName(orgPriceDTO.getTrackname());
                        orderInfo.setOrderPersonNum(length);
                        orderInfo.setOrderStatus(Constants.ORDERSTATUS_WAIT);
                        /* /新增订单信息 */
                        if (payId == null) {
                            orderInfoDAO.insert(orderInfo);
                            // 保存订单详情
                            OrderDetail orderDetail = new OrderDetail();
                            List<OrderDetail> orderDetailList = new ArrayList<>();
                            BeanUtils.copyPropertiesIgnore(orderInfo, orderDetail);
                            orderDetail.setOrderInfoId(orderInfoID);
                            orderDetail.setOrderMoney(orgPriceDTO.getTrackPrice());
                            for (Personcertificate personcertificate : dbPersoncertificateList) {
                                orderDetail.setId(idGeneratorUtil.createID());
                                orderDetail.setSbPersoncertificateId(personcertificate.getId());
                                orderDetail.setPersonId(personcertificate.getPersonid());
                                orderDetailList.add(orderDetail);
                            }
                            // 批量更新
                            orderDetailDao.insertbatch(orderDetailList);
                        } else {
                            orderInfoDAO.update(orderInfo);
                        }

                        object.put("orderInfoID", orderInfoID.toString());
                        object.put("successful", true);
                        object.put("message", "保存成功");
                        break;
                    }
                }
            } else {
                object.put("successful", false);
                object.put("message", "保存失败:查找不到机构信息");
            }
        } else {
            object.put("successful", false);
            object.put("message", "保存失败:人员信息为空或订单信息为空");
        }
        return object;

    }

    /**
     * 发送考试安排通知
     *
     * @param personcertificate
     * @param newsTitle
     * @param title
     * @param content
     */
    private void sendExamMsg(Personcertificate personcertificate, String newsTitle, String title, String content) {
        if (StringUtils.isEmpty(newsTitle) || StringUtils.isEmpty(title) || StringUtils.isEmpty(content)) {
            logger.error("PersoncertificateServiceImpl类sendExamMsg方法：发送消息通知传递参数newsTitle或者title或者content为空");
            return;
        }
        new Thread(() -> {
            try {
                if (personcertificate.getPersonid() == null) {
                    // 自然人考试报名,手机号码不为空则发送短信
                    if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
                        MessageUtil.sendMessage(personcertificate.getPhone(), title + "：" + content, messageLogDao);
                    }
                } else {
                    // 判断是否有app
                    boolean hasApp = false;
                    // 推送ID
                    String registrationID = "";
                    SecurityPerson person = securityPersonDao.findById(personcertificate.getPersonid());
                    // 判断考试人员是否在职
                    if (personcertificate.getCompanyid() != null) {
                        // 有APP登陆信息，则发送APP推送通知、APP站内消息
                        if (hasApp) {
                            AppNotice appNotice = new AppNotice();
                            appNotice.setNoticeTitle(title);
                            appNotice.setCreateTime(new Date());
                            appNotice.setActive(true);
                            appNotice.setNoticeContent("【考试通知】" + content.replaceAll("，", "\\\\n"));
                            appNotice.setNoticeTypeID(2L);
                            appNotice.setPersonId(person.getId());
                            appNotice.setReadStatus("0");
                            appNotice.setUpdateTime(new Date());
                            appNoticeDao.save(appNotice);
                            JPushUtil.sendMessage(title, "【考试通知】" + content, registrationID);
                        } else {
                            // 发送短信通知
                            if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
                                MessageUtil.sendMessage(personcertificate.getPhone(), title + "：" + content,
                                        messageLogDao);
                            }
                        }
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }).start();
    }

    /**
     * 发送考试安排通知(华为)
     *
     * @param personcertificate
     * @param newsTitle
     * @param title
     * @param content
     */
    private void sendExamMsgHuiWei(Personcertificate personcertificate, String newsTitle, String title, String content, String smsCode, String[] parems) {
        if (StringUtils.isEmpty(newsTitle) || StringUtils.isEmpty(title) || StringUtils.isEmpty(content)) {
            logger.error("PersoncertificateServiceImpl类sendExamMsg方法：发送消息通知传递参数newsTitle或者title或者content为空");
            return;
        }
        new Thread(() -> {
            try {
                if (personcertificate.getPersonid() == null) {
                    // 自然人考试报名,手机号码不为空则发送短信
                    if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
                        MessageUtil.sendMessageHuaWei(personcertificate.getPhone(), content, messageLogDao, parems, smsCode);
                    }
                } else {
                    // 判断是否有app
                    boolean hasApp = false;
                    // 推送ID
                    String registrationID = "";
                    SecurityPerson person = securityPersonDao.findById(personcertificate.getPersonid());
                    // 判断考试人员是否在职
                    if (personcertificate.getCompanyid() != null) {
                        // 有APP登陆信息，则发送APP推送通知、APP站内消息
                        if (hasApp) {
                            AppNotice appNotice = new AppNotice();
                            appNotice.setNoticeTitle(title);
                            appNotice.setCreateTime(new Date());
                            appNotice.setActive(true);
                            appNotice.setNoticeContent("【考试通知】" + content.replaceAll("，", "\\\\n"));
                            appNotice.setNoticeTypeID(2L);
                            appNotice.setPersonId(person.getId());
                            appNotice.setReadStatus("0");
                            appNotice.setUpdateTime(new Date());
                            appNoticeDao.save(appNotice);
                            JPushUtil.sendMessage(title, "【考试通知】" + content, registrationID);
                        } else {
                            // 发送短信通知
                            if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
                                MessageUtil.sendMessageHuaWei(personcertificate.getPhone(), content, messageLogDao, parems, smsCode);
                            }
                        }
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }).start();
    }

    /**
     * 手动结束流程
     *
     * @param personcertificate
     */
    @Override
    public void updateProState(Personcertificate personcertificate) {

        User currentUser = arsUtil.getCurrentUser();
        //配置 是否需要流程
        Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
        Config policeConfig = configUtils.getConfigByKey(Constants.POLICE);
        ApprovalDTO approvalDTO = new ApprovalDTO();
        // 审核不通过,调用方法
        approvalDTO.setBusinesstype(BusinessType.BAYZ);
        approvalDTO.setBusinessid(personcertificate.getId());
        approvalDTO.setApprovalstate(ApprovalState.SHBTG);
        approvalDTO.setApprovalreason("手动结束考试");
        approvalDTO.setApprovalperson(currentUser.getRealname());
        approvalDTO.setProstate(Constants.PROSTATE_YES);

        //不需要走流程
        if (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_NO.equals(isNeedActivity.getValue())) {
            approvalDTO.setIsNeedActivity(Constants.IS_NEED_ACTIVITY_NO);
        }
        //外网结束考试不触发流程
        if (null != policeConfig && Constants.POLICE_OUT.equals(policeConfig.getValue())) {
            approvalDTO.setIsNeedActivity(Constants.IS_NEED_ACTIVITY_NO);
        }

        approvalService.saveApprovalForZZ(approvalDTO);

        Personcertificate dbPersoncertificate = personcertificateDao.findById(personcertificate.getId());

        dbPersoncertificate.setUpdateflag(true);
        dbPersoncertificate.setProState(Constants.PROSTATE_YES);
        dbPersoncertificate.setUpdateTime(new Date());
        dbPersoncertificate.setApprovalstate(ApprovalState.SHBTG);
        personcertificateDaoAop.updateSelective(dbPersoncertificate);
    }

    @Override
    public void updateProstateByNumberIdArr(PersoncertificateSearchDto dto, String examID) {
        User currentUser = arsUtil.getCurrentUser();
        List<Personcertificate> personcertificateList = personcertificateDao.findByNumberIdArr(dto);
        ApprovalDTO approvalDTO = new ApprovalDTO();
        //配置 是否需要流程
        Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
        Config policeConfig = configUtils.getConfigByKey(Constants.POLICE);
        for (Personcertificate p : personcertificateList) {
            // 审核不通过,调用方法
            approvalDTO.setBusinesstype(BusinessType.BAYZ);
            approvalDTO.setBusinessid(p.getId());
            approvalDTO.setApprovalstate(ApprovalState.SHBTG);
            approvalDTO.setApprovalreason("手动结束考试");
            approvalDTO.setApprovalperson(currentUser.getRealname());
            approvalDTO.setProstate(Constants.PROSTATE_YES);

            if (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_NO.equals(isNeedActivity.getValue())) {
                approvalDTO.setIsNeedActivity(Constants.IS_NEED_ACTIVITY_NO);
            }

            //外网结束考试不触发流程
            if (null != policeConfig && Constants.POLICE_OUT.equals(policeConfig.getValue())) {
                approvalDTO.setIsNeedActivity(Constants.IS_NEED_ACTIVITY_NO);
            }
            approvalService.saveApprovalForZZ(approvalDTO);

            p.setProState(Constants.PROSTATE_YES);
            TrainExamPerson trainExamPerson = trainExamPersonDao.findByExamIdAndIDNumber(p.getCardnumber(), examID);
            if (null != trainExamPerson) {
                int examTimes = 1;// 考试次数
                p.setWrittenScore(trainExamPerson.getWrittenScore());
                // 理论成绩
                p.setOperateScore(trainExamPerson.getOperateScore());
                // 实操成绩
                p.setSumScore(trainExamPerson.getSumScore().doubleValue());//
                // 总成绩
                p.setTestState(trainExamPerson.getTestState());
                //已安排
                p.setExamState(Constants.EXAMSTATE_YES);
                p.setExamTimes(examTimes);
                p.setApprovalstate(ApprovalState.SHBTG);
            }
            personcertificateDaoAop.update(p);
        }
    }

    @Override
    public List<Personcertificate> findNoCensorStatus() {
        return personcertificateDao.findNoCensorStatus();
    }

    @Override
    public void autoUpdateCensorStatus() {
        List<Personcertificate> personcertificateList = personcertificateDao.findNoCensorStatus();
        //定时器更新指纹卡号，指纹状态
        updateCensorStatusForAuto(personcertificateList);
    }

    private void updateCensorStatusForAuto(List<Personcertificate> personcertificateList) {
        //获取背景筛查对象
        getBackGroupCensorService();
        //配置 是否需要流程
        Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
        //是否显示指纹录入环节
        Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
        Boolean needActiviti = false;
        Boolean needFingerprint = false;
        //启动流程
        if (isNeedActivity == null || (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue()))) {
            needActiviti = true;
        }
        //不需要指纹
        if (isShowFingerprintConfig != null && StringUtil.isNotEmpty(isShowFingerprintConfig.getValue()) && Constants.IS_SHOW_FINGERPRINT_YES.equals(isShowFingerprintConfig.getValue())
        ) {
            needFingerprint = true;
        }
        Long policeId = 0L;
        String testState = StringUtil.EMPTY;
        //定时器更新指纹卡号，指纹状态
        for (Personcertificate personcertificate : personcertificateList) {
            try {
                if (ApprovalState.DSH.equals(personcertificate.getApprovalstate())) {
                    testState = personcertificate.getTestState();
                    Boolean pass = true;
                    Boolean qkFlag = false;
                    Boolean startActiviti = false;
                    Date d = new Date();
                    Approval approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
                    //背景筛查开始
                    BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
                    backgroundApprovalDto.setBusinessid(personcertificate.getId());
                    backgroundApprovalDto.setBusinesstype(Constants.BAYZ);
                    backgroundApprovalDto.setIdNumber(personcertificate.getCardnumber());
                    backgroundApprovalDto.setRealName(personcertificate.getName());
                    //设置户籍人口库地址信息
                    PersonBaseInfo personBaseInfo = backGroupCensorService.getPopulationInfo(personcertificate.getCardnumber(),false);
                    if (personBaseInfo != null && StringUtil.isNotEmpty(personBaseInfo.getAddress())) {
                        personcertificate.setPopulationAddress(personBaseInfo.getAddress());
                    }
                    //对接八大库查询
                    backgroundApprovalService.approval(backgroundApprovalDto);
                    //查询结果
                    String approvalReason = null;
                    List<BackgroundApproval> list = backgroundApprovalService.query(backgroundApprovalDto);
                    for (BackgroundApproval backgroundApproval : list) {
                        if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                            if (Constants.LIBRARYTYPE_CZ.equals(backgroundApproval.getLibraryType())) {
                                approvalReason = "背景筛查不通过，原因：" + backgroundApproval.getApprovalreason();
                            } else {
                                qkFlag = true;
                                approvalReason = Constants.BACKGROUNDAPPROVAL_FAIL;
                            }
                            pass = false;
                            break;
                        }
                    }
                    //如果审批不通过，则获取问题人员，判断是否公安有处理，公安处理意见为留用，则背景筛查则自动通过
                    if (!pass && qkFlag) {
                        //只有北京环境
                        if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                            //问题人员如果公安处理意见是留用，但背景筛查通过
                            List<ProblemPerson> problemPersonList = problemPersonDao.findByPersonId(personcertificate.getPersonid());
                            if (problemPersonList != null && problemPersonList.size() > 0) {
                                for (ProblemPerson p :
                                        problemPersonList) {
                                    //留用
                                    if (Constants.INFORM_STAY.equals(p.getInform())) {
                                        pass = true;
                                        approvalReason = null;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    /**
                     * 如果背景筛查不通过 设置审批意见
                     */
                    approval.setApprovalreason(approvalReason);
                    //对外审批意见
                    if (StringUtil.isNotEmpty(approvalReason)) {
                        approval.setOutreason(approvalReason);
                    }
                    personcertificate.setApprovalreason(approvalReason);
                    if (pass) {
                        //背景筛查通过
                        personcertificate.setCensorStatus(Constants.CENSORSTATUS_PASS);
                        //审批中
                        approval.setApprovalstate(Constants.APPROVALSTATE_SHZ);
                        //审批中
                        personcertificate.setApprovalstate(Constants.APPROVALSTATE_SHZ);
                        //启动流程，但不需要指纹
                        if (needActiviti && !needFingerprint) {
                            startActiviti = true;
                        }
                    } else {
                        //背景筛查不通过
                        personcertificate.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
                        if (needActiviti) {
                            startActiviti = true;
                        } else {
                            personcertificate.setApprovalstate(ApprovalState.SHBTG);
                            approval.setApprovalstate(ApprovalState.SHBTG);
                        }
                    }
                    //更新背景筛查状态
                    personcertificate.setUpdateTime(d);
                    personcertificate.setUpdateflag(true);


                    //更新审批信息
                    approval.setUpdateTime(d);
                    approval.setUpdateflag(true);

                    personcertificateDaoAop.update(personcertificate);
                    approvalDAO.update(approval);
                    if (!startActiviti) {
                        continue;
                    }
                    approvalService.startApproval(approval, policeId, testState);
                }
            } catch (Exception e) {
                System.out.println("异常" + personcertificate.getCardnumber());
            }
        }
    }

    @Override
    public void updateCensorStatusForAuto(Personcertificate personcertificate) {
        //背景筛查开始
        BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
        backgroundApprovalDto.setBusinessid(personcertificate.getId());
        backgroundApprovalDto.setBusinesstype(Constants.BAYZ);
        backgroundApprovalDto.setIdNumber(personcertificate.getCardnumber());
        backgroundApprovalDto.setRealName(personcertificate.getName());
        //查询结果
        List<BackgroundApproval> list = backgroundApprovalService.query(backgroundApprovalDto);
        updateCensorStatusForAuto(personcertificate,list);

    }

    @Override
    public void updateCensorStatusForAuto(Personcertificate personcertificate,List<BackgroundApproval> list) {
        //获取背景筛查对象
        getBackGroupCensorService();
        //配置 是否需要流程
        Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
        //是否显示指纹录入环节
        Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
        Boolean needActiviti = false;
        Boolean needFingerprint = false;
        //启动流程
        if (isNeedActivity == null || (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue()))) {
            needActiviti = true;
        }



        //不需要指纹
        if (isShowFingerprintConfig != null && StringUtil.isNotEmpty(isShowFingerprintConfig.getValue()) && Constants.IS_SHOW_FINGERPRINT_YES.equals(isShowFingerprintConfig.getValue())
        ) {
            needFingerprint = true;
        }

        if(!personcertificate.getNeedApprove()){
            needActiviti = false;
            needFingerprint = false;
        }


        Long policeId = 0L;
        String testState = StringUtil.EMPTY;
        //定时器更新指纹卡号，指纹状态
        try {
            if (ApprovalState.DSH.equals(personcertificate.getApprovalstate())) {
                testState = personcertificate.getTestState();
                Boolean pass = true;
                Boolean qkFlag = false;
                Boolean startActiviti = false;
                Date d = new Date();
                Approval approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
                //查询结果
                String approvalReason = null;
                //背景筛查结果为空则证明背景筛查异常
                if (list == null || list.size() == 0) {
                    return;
                }
                for (BackgroundApproval backgroundApproval : list) {
                    if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                        if (Constants.LIBRARYTYPE_CZ.equals(backgroundApproval.getLibraryType())) {
                            approvalReason = "背景筛查不通过，原因：" + backgroundApproval.getApprovalreason();
                        } else {
                            qkFlag = true;
                            approvalReason = Constants.BACKGROUNDAPPROVAL_FAIL;
                        }
                        pass = false;
                        break;
                    }
                }
                //如果审批不通过，则获取问题人员，判断是否公安有处理，公安处理意见为留用，则背景筛查则自动通过
                if (!pass && qkFlag) {
                    //只有北京环境
                    if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                        //问题人员如果公安处理意见是留用，但背景筛查通过
                        List<ProblemPerson> problemPersonList = problemPersonDao.findByPersonId(personcertificate.getPersonid());
                        if (problemPersonList != null && problemPersonList.size() > 0) {
                            for (ProblemPerson p :
                                    problemPersonList) {
                                //留用
                                if (Constants.INFORM_STAY.equals(p.getInform())) {
                                    pass = true;
                                    approvalReason = null;
                                    break;
                                }
                            }
                        }
                    }
                }
                /**
                 * 如果背景筛查不通过 设置审批意见
                 */
                approval.setApprovalreason(approvalReason);
                //对外审批意见
                if (StringUtil.isNotEmpty(approvalReason)) {
                    approval.setOutreason(approvalReason);
                }
                personcertificate.setApprovalreason(approvalReason);
                if (pass) {
                    //背景筛查通过
                    personcertificate.setCensorStatus(Constants.CENSORSTATUS_PASS);
                    //审批中
                    approval.setApprovalstate(Constants.APPROVALSTATE_SHZ);
                    //审批中
                    personcertificate.setApprovalstate(Constants.APPROVALSTATE_SHZ);
                    //启动流程，但不需要指纹
                    if (needActiviti && !needFingerprint) {
                        startActiviti = true;
                    }
                } else {
                    //背景筛查不通过
                    personcertificate.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
                    if (needActiviti) {
                        startActiviti = true;
                    } else {
                        personcertificate.setApprovalstate(ApprovalState.SHBTG);
                        approval.setApprovalstate(ApprovalState.SHBTG);
                    }
                }
                //更新背景筛查状态
                personcertificate.setUpdateTime(d);
                personcertificate.setUpdateflag(true);
                //更新审批信息
                approval.setUpdateTime(d);
                approval.setUpdateflag(true);

                personcertificateDaoAop.update(personcertificate);
                approvalDAO.update(approval);
                if (!startActiviti) {
                    return;
                }
                approvalService.startApproval(approval, policeId, testState);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            e.printStackTrace();
        }
    }


    @Override
    public Personcertificate findBySecurityPersonId(Long personId) {
        return personcertificateDao.findBySecurityPersonId(personId);
    }

    @Override
    public List<Personcertificate> findDSOutList(String startDate) {
        return personcertificateDao.searchForExport(startDate);
    }

    @Override
    public void importBatch(List<Personcertificate> list) {
        List<Personcertificate> dbList = personcertificateDao.findByBatchId(list);
        Map<Long, Personcertificate> dbCensorStatusMap = new HashMap<>();
        if (dbList.size() > 0) {
            dbCensorStatusMap = dbList.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));
        }
        //北京、延安 资格证报名背景筛查状态同步百课堂
        if (Constants.BEIJING.equals(configUtils.getCurrentNative()) || Constants.SHANGXI.equals(configUtils.getCurrentNative()) || Constants.GUANGXI.equals(configUtils.getCurrentNative())) {
            try {
                this.sendCensorToBKT(list, dbCensorStatusMap);
            } catch (Exception e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
        if (Constants.SHANGXI.equals(configUtils.getCurrentNative())) {
            //陕西延安 指纹采集状态同步给百课堂？
            try {
                this.sendFingerprintToBKT(list, dbCensorStatusMap);
            } catch (Exception e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }

        }
        ///证书信息同步到保安人员
        if (list != null && list.size() > 0) {
            for (Personcertificate personcertificate : list) {
                try {
                    Personcertificate dbPersoncertificate = dbCensorStatusMap.get(personcertificate.getId());
                    this.saveOrUpdateForImportWithSaasJoin(personcertificate, dbPersoncertificate);
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 北京 资格证报名背景筛查状态同步百课堂
     *
     * @param list
     */
    private void sendCensorToBKT(List<Personcertificate> list, Map<Long, Personcertificate> dbCensorStatusMap) {
        if (list == null || list.size() < 1) {
            return;
        }
        JSONArray paramArr = new JSONArray();
        JSONObject rosterObj = null;
        for (Personcertificate personcertificate : list) {
            if(StringUtil.isEmpty(personcertificate.getCity())){
                continue;
            }
            if (Constants.SHANGXI.equals(configUtils.getCurrentNative())
                    && !personcertificate.getCity().startsWith(Constants.YANAN_S)
                    && !personcertificate.getCity().startsWith(Constants.SHANGLUO_S)) {
                continue;
            }
            if (Constants.GUANGXI.equals(configUtils.getCurrentNative()) && !personcertificate.getCity().startsWith(Constants.NANNING)) {
                continue;
            }
            Personcertificate dbPersoncertificate = dbCensorStatusMap.get(personcertificate.getId());
            if (dbPersoncertificate != null) {
                if (personcertificate.getUpdateTime().getTime() > dbPersoncertificate.getUpdateTime().getTime()) {
                    if (!ObjectUtil.equal(personcertificate.getCensorStatus(), dbPersoncertificate.getCensorStatus())) {
                        rosterObj = new JSONObject();
                        rosterObj.put("backgroundType", "1");
                        rosterObj.put("qualifyApplyId", personcertificate.getId() + "");
                        rosterObj.put("backgroundStatus", personcertificate.getCensorStatus());
                        rosterObj.put("backgroundFailReason", personcertificate.getApprovalreason());
                        paramArr.add(rosterObj);
                    }
                }
            }
        }

        //personList：[{"qualifyApplyId":"123123","backgroundStatus":"003","backgroundFailReason":"失败原因","backgroundType":"1"}]
        if (paramArr.size() > 0) {
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("personList", JSON.toJSONString(paramArr));
            AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_PERSONQUALIFY_CENSOR_URL, paramMap);
            if (!result.isSuccessful()) {
                logger.error("【资格证报名背景筛查状态同步】" + result.getMsg());
                //throw new ArsException("【资格证报名背景筛查状态同步】"+result.getMsg());
            } else {
                logger.error("【资格证报名背景筛查状态同步成功】");
            }
        }
    }


    /**
     * 陕西延安 指纹录入状态同步百课堂
     *
     * @param list
     */
    private void sendFingerprintToBKT(List<Personcertificate> list, Map<Long, Personcertificate> dbCensorStatusMap) {
        if (list == null || list.size() < 1) {
            return;
        }
        JSONArray paramArr = new JSONArray();
        JSONObject rosterObj = null;
        for (Personcertificate personcertificate : list) {
            Personcertificate dbPersoncertificate = dbCensorStatusMap.get(personcertificate.getId());
            if (dbPersoncertificate != null) {
                if (Constants.YANAN.equals(personcertificate.getCity()) || Constants.SHANGLUO.equals(personcertificate.getCity())) {
                    if (personcertificate.getUpdateTime().getTime() > dbPersoncertificate.getUpdateTime().getTime()) {
                        if (!ObjectUtil.equal(personcertificate.getFingercardState(), dbPersoncertificate.getFingercardState())) {
                            paramArr.add(personcertificate.getId() + "");
                        }
                    }
                }
            }
        }

        //personList：["1","2","3"]
        if (paramArr.size() > 0) {
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("personList", JSON.toJSONString(paramArr));
            //百课堂url
            AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_FINGERPRINT_CENSOR_URL, paramMap);
            if (!result.isSuccessful()) {
                logger.error("【资格证报名指纹录入状态同步】" + result.getMsg());
                //throw new ArsException("【资格证报名背景筛查状态同步】"+result.getMsg());
            }
        }
    }

    @Override
    public void autoUpdateCensorForImportOldData() {
        List<Personcertificate> personcertificateList = personcertificateDao.findNoCensorForImportOldData();
        //定时器更新指纹卡号，指纹状态
        updateCensorStatusForAutoAndImportOldData(personcertificateList);
    }

    @Override
    public SAASPersonCerDto getDetailForSAAS(Long id) {
        return personcertificateDao.getDetailForSAAS(id);
    }

    @Override
    public void searchForSAASPage(SAASPersonCertificateSearchDto searchDto, AjaxPageResponse<SAASPersonCertificateDto> page) {
        personcertificateDao.searchForSAASPage(searchDto, page);
    }

    @Override
    public int checkApplyForSAAS(Long personId) {
        int canApply = 1;
        SecurityPerson securityPerson = securityPersonDao.findById(personId);
        SecurityCompany company = securityPerson.getRelation().getCompany();
        if (company != null && StringUtil.isNotEmpty(company.getAreaCode())
                && (Constants.YANAN_S.equals(company.getAreaCode().substring(0, 4))
                || Constants.SHANGLUO_S.equals(company.getAreaCode().substring(0, 4)))) {
            //通过保安员id查询待审批、审批中或者审批通过的数据checkStatusForApply
            Personcertificate personcertificate = personcertificateDao.findApprovalingByIdNumForYanAn(securityPerson.getIdNumber());
            if (personcertificate != null) {
                canApply = 0;
            }
        } else {
            //通过保安员id查询待审批、审批中或者审批通过的数据
            Personcertificate personcertificate = personcertificateDao.findApprovaling(personId);

            //如果数据不为空。说明 不能再提交
            if (personcertificate != null) {
                canApply = 0;
            }
        }
        return canApply;
    }

    @Override
    public List<Personcertificate> findByIdArr(Long[] personIds) {
        return personcertificateDao.findByIdArr(personIds);
    }

    @Override
    public JSONObject batchRepulse(Long[] longIds, String returnreason) {
        JSONObject result = new JSONObject();

        Map<Long, Personcertificate> allMap = new HashedMap();
        Map<Long, Personcertificate> noReturnMap = new HashedMap();

        List<Personcertificate> allList = findByIdArr(longIds);
        //根据环境获取不同的打回实现接口
        CustomPersoncertificateService customPersoncertificateService = CustomPersoncertificateBeanFactory.getPersoncertificateBean();
        //执行
        List<Personcertificate> noReturnList = customPersoncertificateService.getNoReturnList(longIds);

        JSONArray successList = new JSONArray();
        JSONArray failList = customPersoncertificateService.checkReturnList(noReturnList);
        allList.removeAll(noReturnList);

        if (allList.size() > 0) {
            allMap = allList.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));
        }

        if (noReturnList.size() > 0) {
            noReturnMap = noReturnList.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));
        }

        for (int i = 0; i < longIds.length; i++) {
            JSONObject obj = new JSONObject();
            obj.put("id", longIds[i]);
            obj.put("successful", false);

            if (noReturnMap.get(longIds[i]) != null) {
                continue;
            }

            if (allMap.get(longIds[i]) != null) {
                obj.put("successful", true);
                successList.add(obj);
            } else {
                obj.put("message", "id不存在");
                failList.add(obj);
            }

        }

        result.put("failList", failList);
        result.put("successList", successList);
        if (allList.size() > 0) {
            List<Long> personList = allList.stream().map(Personcertificate::getId).collect(Collectors.toList());
            Long[] array = personList.toArray(new Long[personList.size()]);
            activityRepairService.batchRepulseAndNotFeeState(array);
            List<Long> list = activityRepairService.checkCanReturnPerson(array);

            ApprovalDTO approval = new ApprovalDTO();
            approval.setApprovalstate(Constants.APPROVALSTATE_BTG);
            approval.setOutreason("打回意见：" + returnreason);
            approval.setApprovalperson("打回");
            trainExamPersonService.deleteTestForApporvalId(array);
            if (list.size() > 0) {
                for (Long id : list) {
                    approval.setId(id);
                    approvalService.saveApprovalOutreason(approval);
                }
            }
        }
        return result;
    }

    @Override
    public void searchForPage(PersoncertificateSearchDto dto, AjaxPageResponse<PersoncertificateDto> page) {
        arsUtil.setPoliceSearch(dto);
        personcertificateDao.searchForPage(dto, page);
    }

    @Override
    public void searchPage(SearchPersonCertificateDto dto, AjaxPageResponse<VPersoncertificate> page) {
        arsUtil.setPoliceSearch(dto);
        personcertificateDao.searchPage(dto, page);
    }

    /**
     * 通过id查询人口地址
     *
     * @param idArray
     * @return
     */
    @Override
    public List<Personcertificate> findAddressByIdArr(Long[] idArray) {
        return personcertificateDao.findAddressByIdArr(idArray);
    }

    /**
     * 通过id查询人口地址
     *
     * @param id
     * @return
     */
    @Override
    public Personcertificate findAddressById(Long id) {
        return personcertificateDao.findAddressById(id);
    }


    /**
     * 通过身份证号码查询保安员资格证书信息
     *
     * @return
     */
    @Override
    public List<SecurityCertificateInfoDto> findCertificate() {
        /*String nativeCode = configUtils.getCurrentNative();*/
        //随机返回200个未抽取的保安员资格证信息
        //取照片优先级
        //1报名照片
        //2证件照片
        //3人口库照片
        List<SecurityCertificate> list = personcertificateDao.findCertificateByIdNumber(null);
        List<SecurityCertificateInfoDto> seCerInList = new ArrayList<SecurityCertificateInfoDto>();
        if (list != null && list.size() > 0) {
            list.forEach(securityCertificate -> {
                try {
                    //设置图片信息
                    securityCertificate.setPhoto(GetPersonImgUtil.GetImageStr(getResourcePath(securityCertificate.getHeadImg())));
                    SecurityCertificateInfoDto securityCertificateInfoDto = new SecurityCertificateInfoDto();
                    //获取照片
                    securityCertificateInfoDto.setImglogo(securityCertificate.getPhoto());
                    //证书编号
                    securityCertificateInfoDto.setZsbh(securityCertificate.getZsbh());
                    //姓名
                    securityCertificateInfoDto.setXm(securityCertificate.getXm());
                    //发证日期
                    securityCertificateInfoDto.setFzrq(securityCertificate.getFzrq());
                    //卡面标题
                    securityCertificateInfoDto.setTitle(Constants.BEIJIN_CERTIFICATE);
                    //身份证号
                    securityCertificateInfoDto.setIdNumber(securityCertificate.getIdnum());

                    //TODO 待优化
                    Personcertificate personcertificate = personcertificateDao.findById(securityCertificate.getSecuritypersonid());
                    //查询资格证书二维码信息并生成
                    //民族
                    securityCertificate.setNation(sysDictUtils.getDictTypeValue("nation", StringUtil.isEmpty(personcertificate.getNation()) ? "01" : personcertificate.getNation()));
                    securityCertificate.setAddress(personcertificate.getAddress());
                    //没关联快照则生成并关联
                    if (securityCertificate.getSnapshotId() == null) {
                        //生成预览记录
                        securityCertificateService.savePerCerSnapshot(securityCertificate, securityCertificate.getHeadImg());
                    }
                    //二维码
                    Base64Utils.encodeToString(securityCertificate.getSnapshotId().toString().getBytes("UTF-8"));
                    securityCertificateInfoDto.setSnapshotPhoto(securityCertificateService.getQRCodeForThirdParty(DES3.encode(securityCertificate.getSnapshotId().toString())));

                    seCerInList.add(securityCertificateInfoDto);
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    e.printStackTrace();
                }
            });
            securityCertificateService.updateBatchSnapshotId(list);
        } else {
            return null;
        }
        return seCerInList;

    }

    @Override
    public void batchUpdate(List<Personcertificate> list) {
        List<Personcertificate> dbList = personcertificateDao.findByBatchId(list);

        if (dbList.size() > 0) {
            Map<Long, Personcertificate> personcertificateMap = list.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));

            Personcertificate personcertificate = null;
            for (Personcertificate dbPersoncertificate : dbList) {
                personcertificate = personcertificateMap.get(dbPersoncertificate.getId());
                personcertificate.setCensorStatus(dbPersoncertificate.getCensorStatus());

                //如果传的是待审批。以子站审批状态为准（陕西延安获取指纹后面就是审批中，百课堂材料核对同步过来传的待审批）
                if (StringUtil.isNotEmpty(personcertificate.getApprovalstate()) && ApprovalState.DSH.equals(personcertificate.getApprovalstate())) {
                    personcertificate.setApprovalstate(dbPersoncertificate.getApprovalstate());
                }
                //saas图片地址转ars图片地址
                //健康证明
                if (StringUtil.isNotEmpty(personcertificate.getHealthExamination())) {
                    personcertificate.setHealthExamination(getPhotoPath(personcertificate.getHealthExamination()));
                }
                //身份证正面
                if (StringUtil.isNotEmpty(personcertificate.getIdCardFront())) {
                    personcertificate.setIdCardFront(getPhotoPath(personcertificate.getIdCardFront()));
                }
                //身份证反面
                if (StringUtil.isNotEmpty(personcertificate.getIdCardReverse())) {
                    personcertificate.setIdCardReverse(getPhotoPath(personcertificate.getIdCardReverse()));
                }
                //学历证明
                if (StringUtil.isNotEmpty(personcertificate.getEduPhoto())) {
                    personcertificate.setEduPhoto(getPhotoPath(personcertificate.getEduPhoto()));
                }
                //头像
                String imgPath = personcertificate.getImglogo();
                if (StringUtil.isNotEmpty(imgPath)) {
                    if (imgPath.indexOf(Constants.FILE_GETRESOURCE) > 0) {
                        personcertificate.setImglogo(getLocalPhotoPath(imgPath));
                    } else {
                        personcertificate.setImglogo(getPhotoPath(imgPath));
                    }
                }

                if (personcertificate.getComContractId() != null) {
                    ComContract contract = comContractDao.findById(personcertificate.getComContractId());
                    if (contract != null) {
                        personcertificate.setContractStart(contract.getEffectStartDate());
                        personcertificate.setContractEnd(contract.getEffectEndDate());
                    }
                }

                BeanUtils.copyPropertiesIgnore(personcertificate, dbPersoncertificate, true);
                dbPersoncertificate.setUpdateTime(new Date());
                dbPersoncertificate.setUpdateflag(true);
                approvalDAO.updatePersoncertificateStatus(dbPersoncertificate);
            }
            personcertificateDaoAop.updateBatch(dbList);
        }
    }

    @Override
    public void searchUnRegisterForPage(PersonPageSearchDto dto, AjaxPageResponse<PerconUnRegDto> page) {
        personcertificateDao.searchUnRegisterForPage(dto, page);
    }

    /**
     * 通过身份证号码查询保安员资格证书信息
     *
     * @return
     */
    @Override
    public List<SecurityCertificateInfoDto> findCerInfoByIdNums(String[] idNums) {
        List<SecurityCertificate> list = securityCertificateDao.findByIdNums(idNums);
        List<SecurityCertificateInfoDto> seCerInList = new ArrayList<SecurityCertificateInfoDto>();
        if (list != null && list.size() > 0) {
            list.forEach(securityCertificate -> {
                try {
                    //获取照片
                    String photo = securityCertificate.getHeadImg();
                    //设置图片信息
                    securityCertificate.setPhoto(GetPersonImgUtil.GetImageStr(getResourcePath(photo)));
                    SecurityCertificateInfoDto securityCertificateInfoDto = new SecurityCertificateInfoDto();
                    securityCertificateInfoDto.setImglogo(securityCertificate.getPhoto());
                    //证书编号
                    securityCertificateInfoDto.setZsbh(securityCertificate.getZsbh());
                    //姓名
                    securityCertificateInfoDto.setXm(securityCertificate.getXm());
                    //发证日期
                    securityCertificateInfoDto.setFzrq(securityCertificate.getFzrq());
                    //卡面标题
                    securityCertificateInfoDto.setTitle(Constants.BEIJIN_CERTIFICATE);
                    //身份证号
                    securityCertificateInfoDto.setIdNumber(securityCertificate.getIdnum());
                    //查询资格证书二维码信息并生成
                    //民族
                    securityCertificate.setNation(sysDictUtils.getDictTypeValue("nation", StringUtil.isEmpty(securityCertificate.getNation()) ? "01" : securityCertificate.getNation()));

                    //没关联快照则生成并关联
                    if (securityCertificate.getSnapshotId() == null) {
                        //生成预览记录
                        securityCertificateService.savePerCerSnapshot(securityCertificate, photo);
                    }
                    //二维码
                    Base64Utils.encodeToString(securityCertificate.getSnapshotId().toString().getBytes("UTF-8"));
                    securityCertificateInfoDto.setSnapshotPhoto(securityCertificateService.getQRCodeForThirdParty(DES3.encode(securityCertificate.getSnapshotId().toString())));

                    seCerInList.add(securityCertificateInfoDto);
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    e.printStackTrace();
                }
            });
            securityCertificateService.updateBatchSnapshotId(list);
        } else {
            return null;
        }
        return seCerInList;
    }

    @Override
    public void updateTrainMaterials(List<Personcertificate> personcertificate) {

        String trainMaterialsUrl = "";
        if (personcertificate.size() > 0) {
            if (StringUtil.isNotEmpty(personcertificate.get(0).getTrainMaterials())) {
                trainMaterialsUrl = getAttPath(personcertificate.get(0).getTrainMaterials());
            }
        }
        personcertificateDao.updateTrainMaterials(personcertificate, trainMaterialsUrl);

    }


    @Override
    public JSONObject cancelFeeState(Long[] personIds) {
        JSONObject result = new JSONObject();
        JSONArray successList = new JSONArray();
        JSONArray failList = new JSONArray();
        PersoncertificateSearchDto dto = new PersoncertificateSearchDto();
        dto.setIdArrs(personIds);
        List<Personcertificate> allList = personcertificateDao.findByDtoIdArr(dto);
        List<Personcertificate> canList = personcertificateDao.findCancelFeedStateByIdArr(personIds);
        allList.removeAll(canList);

        Map<Long, Personcertificate> allMap = new HashedMap();
        Map<Long, Personcertificate> canMap = new HashedMap();

        if (allList.size() > 0) {
            allMap = allList.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));
        }

        if (canList.size() > 0) {
            canMap = canList.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));
            personcertificateDaoAop.cancelFeeState(personIds);
        }

        for (int i = 0; i < personIds.length; i++) {
            JSONObject obj = new JSONObject();
            obj.put("id", personIds[i]);

            if (canMap.get(personIds[i]) != null) {
                obj.put("successful", true);
                successList.add(obj);
                continue;
            }

            obj.put("successful", false);
            if (allMap.get(personIds[i]) != null) {
                Personcertificate detail = allMap.get(personIds[i]);
                if (StringUtil.isNotEmpty(detail.getTestState())) {
                    obj.put("message", "已考试人员不能取消缴费");
                } else if (!Constants.FEE_STATE_YJF.equals(detail.getFeeState())) {
                    obj.put("message", "未缴费人员无需取消缴费");
                } else {
                    obj.put("message", "不能取消缴费");
                }
            } else {
                obj.put("message", "id不存在");
            }

            failList.add(obj);
        }

        result.put("failList", failList);
        result.put("successList", successList);

        return result;
    }

    private void updateCensorStatusForAutoAndImportOldData(List<Personcertificate> personcertificateList) {
        for (Personcertificate personcertificate : personcertificateList) {
            Boolean pass = true;
            //背景筛查开始
            BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
            backgroundApprovalDto.setBusinessid(personcertificate.getId());
            backgroundApprovalDto.setBusinesstype(Constants.BAYZ);
            backgroundApprovalDto.setIdNumber(personcertificate.getCardnumber());
            backgroundApprovalDto.setRealName(personcertificate.getName());
            //对接八大库查询
            backgroundApprovalService.approval(backgroundApprovalDto);
            //查询结果
            String approvalReason = null;

            List<BackgroundApproval> list = backgroundApprovalService.query(backgroundApprovalDto);
            for (BackgroundApproval backgroundApproval : list) {
                if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                    if (Constants.LIBRARYTYPE_CZ.equals(backgroundApproval.getLibraryType())) {
                        approvalReason = backgroundApproval.getApprovalreason();
                    } else {
                        approvalReason = Constants.BACKGROUNDAPPROVAL_FAIL;
                    }
                    pass = false;
                    break;
                }
            }

            if (pass) {
                //背景筛查通过
                personcertificate.setCensorStatus(Constants.CENSORSTATUS_PASS);
            } else {
                //背景筛查不通过
                personcertificate.setCensorStatus(Constants.CENSORSTATUS_UNPASS);

                /**
                 * 如果背景筛查不通过 设置审批意见
                 */
                personcertificate.setApprovalreason(approvalReason);
            }
            //更新背景筛查状态
            personcertificate.setUpdateTime(new Date());
            personcertificate.setUpdateflag(true);
            personcertificateDaoAop.update(personcertificate);
        }
    }

    @Override
    public void updateSelective(Personcertificate personcertificate) {
        personcertificate.setUpdateflag(true);
        personcertificate.setUpdateTime(new Date());
        personcertificateDaoAop.updateSelective(personcertificate);
    }

    @Override
    public void inputFingerprint(Personcertificate personcertificate) {

        User currentUser = arsUtil.getCurrentUser();

        personcertificate.setUpdateBy(currentUser.getUsername());

        personcertificateDaoAop.updateSelective(personcertificate);

        ApprovalLog approvalLog = new ApprovalLog();
        approvalLog.setApprovalperson(currentUser.getRealname());
        approvalLog.setUpdateBy(currentUser.getUsername());
        approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
        approvalLog.setActive(true);
        approvalLog.setType(Constants.APPROVAL_LOG_IN);
        approvalLog.setCreateTime(new Date());
        approvalLog.setUpdateTime(new Date());
        approvalLog.setApprovaldate(new Date());
        approvalLog.setApprovalreason("已录指纹但省库没有");
        approvalLog.setApprovalstate("手动录入指纹【" + personcertificate.getFingerprint() + "】");

        Approval approval = approvalDAO.findBybusinessidAndType(personcertificate.getId(), BusinessType.BAYZ);
        approvalLog.setApprovalid(approval.getId().toString());
        approvalLogDao.save(approvalLog);
    }

    @Override
    public List<Personcertificate> findUnGenerateSubsidyRoster() {
        return personcertificateDao.findUnGenerateSubsidyRoster();
    }

    @Override
    public AjaxResult personCertificateApply(String personCertificates) throws ValidateException {
        String subject = JwtUtil.parseJWT(personCertificates).getSubject();
        AjaxResult ajaxResult = new AjaxResult();

        PersoncertificateDto personCertificate = JSON.parseObject(subject, PersoncertificateDto.class);
        User currentUser = arsUtil.getCurrentUser();

        // 最后一级机构id处理
        if (personCertificate.getOrgid() == null) {
            if (personCertificate.getDistrictOrgId() != null) {
                personCertificate.setOrgid(Long.parseLong(personCertificate.getDistrictOrgId()));
            } else if (personCertificate.getCityOrgId() != null) {
                personCertificate.setOrgid(Long.parseLong(personCertificate.getCityOrgId()));
            }
        }

        // 读取配置文件
        Config config = configUtils.getConfigByKey(Constants.POLICE);
        // 判断是否能报名资格证
        boolean canApply = securityCertificateService.checkCanApplySecurityCertificate(personCertificate.getCardnumber());
        if (!canApply) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("报名失败");
            return ajaxResult;
        }
        // 验证该身份证是否已经提交，提交才需要验证
        if (Constants.APPROVALSTATE_DSP.equals(personCertificate.getApprovalstate())) {

            // 限制人员不能进行报名
            if ("452223199905153012".equals(personCertificate.getCardnumber())
                    || "452130199610052415".equals(personCertificate.getCardnumber())
                    || "450121197312081210".equals(personCertificate.getCardnumber())) {
                throw new ArsException("该人员考试中严重违规，不予报名！");
            }

            Personcertificate dbCheckPersonCertificate = checkCarNumRepeat(personCertificate.getCardnumber(), personCertificate.getId(), currentUser);

            if (null != dbCheckPersonCertificate) {
                if (ApprovalState.SHTG.equals(dbCheckPersonCertificate.getApprovalstate())) {
                    throw new ArsException("该人员已有保安员证，不得重复报名!");
                } else {
                    throw new ArsException("该人员已经报名考试，不得重复报名!");
                }
            }

        }
        long id = idWorker.nextId();
        if (personCertificate.getId() == null) {
            // 校验一下参数
            BeanValidationResult beanValidationResult = ValidationUtil.warpValidate(personCertificate, ThirdPartyTrain.class);
            // 校验不通过, 抛出异常
            if (!beanValidationResult.isSuccess()) {
                Set<String> errorMessages = beanValidationResult.getErrorMessages().stream().map((BeanValidationResult.ErrorMessage::getMessage)).collect(Collectors.toSet());
                throw new ValidateException(errorMessages);
            }
            ThirdTrainBackground thirdTrainBackground = new ThirdTrainBackground();
            personCertificate.setId(id);
            personCertificate.setActive(true);
            personCertificate.setCreateTime(new Date());
            personCertificate.setUpdateTime(new Date());
            personCertificate.setUpdateBy(currentUser.getUsername());
            personCertificate.setUserid(currentUser.getId());
            // 新增时默认为待审查
            personCertificate.setCensorStatus(Constants.CENSORSTATUS_WAIT);// 待审查
            personCertificate.setFingercardState(Constants.FINGERCARD_STATE_WJL);//指纹未记录
            personCertificate.setBrith(IdNumUtil.getBirthdayByIdCard(personCertificate.getCardnumber()));
            personCertificate.setSex(IdNumUtil.getSexByIdCard(personCertificate.getCardnumber()));
            personCertificate.setFingerprint("");
            personCertificate.setSumScore(null);
            personCertificate.setOperateScore(null);
            personCertificate.setWrittenScore(null);
            personCertificate.setTestState(null);
            personCertificate.setExamState(null);
            personCertificate.setConfirmOrder("0");
            personCertificate.setFeeState(null);
            personCertificate.setProState(null);
            personCertificate.setPayConfirm(null);
            personCertificate.setIdCardFront(getPhotoPath(personCertificate.getIdCardFront()));
            personCertificate.setIdCardReverse(getPhotoPath(personCertificate.getIdCardReverse()));
            if (config.getValue().equals(Constants.POLICE_IN)) {
                personCertificate.setUpdateflag(true);
            }
            Long companyId = personCertificate.getCompanyid();
            SecurityCompany company = securityCompanyDao.findById(companyId);
            if (company != null) {
                personCertificate.setDistrictOrgId(company.getDistrictOrgId());
                personCertificate.setDistrict(company.getAreaCode());
                personCertificate.setAreaCode(company.getAreaCode());
                personCertificate.setCompanyname(company.getName());
                thirdTrainBackground.setAreaCode(company.getAreaCode());
            } else {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("该公司不存在");
                return ajaxResult;
            }

            // 待审批
            if (personCertificate.getApprovalstate() != null &&
                    !"".equals(personCertificate.getApprovalstate())
                    && !ApprovalState.DSH.equals(personCertificate.getApprovalstate())) {
                personCertificate.setApprovalstate(personCertificate.getApprovalstate());
                personcertificateDao.save(personCertificate);
            } else {
                personCertificate.setApprovalstate(ApprovalState.DSH);
                personcertificateDao.save(personCertificate);
                // 更新审批信息
                approvalUtil.saveApprovalForThirdPartyTrain(
                        BusinessType.BAYZ,
                        personCertificate.getId(),
                        Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE,
                        currentUser.getAreaCode()
                );
            }
            // third_train_background
            thirdTrainBackground.setId(idWorker.nextId());
            thirdTrainBackground.setBusinessType(Constants.BUSINESS_TYPE_CERTIFICATE);
            thirdTrainBackground.setRealName(personCertificate.getName());
            thirdTrainBackground.setIdNumber(personCertificate.getCardnumber());
            // 系统业务id存资格证id
            thirdTrainBackground.setArsBusinessId(id);
            thirdTrainBackground.setBusinessId(personCertificate.getBusinessId());
            thirdTrainBackground.setActive(true);
            thirdTrainBackground.setUpdateBy(currentUser.getUsername());
            thirdTrainBackground.setUpdateTime(new Date());
            thirdTrainBackground.setCreateTime(new Date());
            thirdTrainBackground.setUpdateflag(true);
            thirdTrainBackground.setUserid(currentUser.getId());

            int count = thirdTrainBackgroundDao.selectCount(thirdTrainBackground);

            if (count == 0) {
                thirdTrainBackgroundDao.save(thirdTrainBackground);
            }
            // 将id返回
            ajaxResult.setData(JwtUtil.createJWT(String.valueOf(id)));
        } else {
            Personcertificate dbPersonCertificate = personcertificateDao.findById(personCertificate.getId());
            if (ApprovalState.WTJ.equals(personCertificate.getApprovalstate())) {
                BeanUtils.copyPropertiesIgnore(personCertificate, dbPersonCertificate, "active,createTime,userid", true);
            } else {
                BeanUtils.copyPropertiesIgnore(personCertificate, dbPersonCertificate, true);
            }
            dbPersonCertificate.setOrgid(personCertificate.getOrgid());
            dbPersonCertificate.setUpdateTime(new Date());
            dbPersonCertificate.setUpdateBy(currentUser.getUsername());
            // 待审批
            if (personCertificate.getApprovalstate() != null &&
                    !"".equals(personCertificate.getApprovalstate()) &&
                    !ApprovalState.DSH.equals(personCertificate.getApprovalstate())) {
                dbPersonCertificate.setApprovalstate(personCertificate.getApprovalstate());
            } else {
                dbPersonCertificate.setApprovalstate(ApprovalState.DSH);
            }
            if (config.getValue().equals(Constants.POLICE_IN)) {
                dbPersonCertificate.setUpdateflag(true);
            }
            dbPersonCertificate.setCensorStatus(Constants.CENSORSTATUS_WAIT);// 待审查
            dbPersonCertificate.setFingercardState(Constants.FINGERCARD_STATE_WJL);//指纹未记录
            dbPersonCertificate.setFingerprint("");
            //流程结束的提交的时候，置为未缴费
            dbPersonCertificate.setSumScore(null);
            dbPersonCertificate.setOperateScore(null);
            dbPersonCertificate.setWrittenScore(null);
            dbPersonCertificate.setTestState(null);
            dbPersonCertificate.setExamState(null);
            dbPersonCertificate.setConfirmOrder("0");
            dbPersonCertificate.setCensorStatus(null);
            dbPersonCertificate.setFeeState(null);
            dbPersonCertificate.setProState(null);
            dbPersonCertificate.setPayConfirm(null);
            //是否补考
            dbPersonCertificate.setIsMakeUp(null);
            //补考状态
            dbPersonCertificate.setMakeUpstate(null);
            personcertificateDaoAop.update(dbPersonCertificate);

            // 更新审批信息
            if (ApprovalState.DSH.equals(dbPersonCertificate.getApprovalstate())) {
                approvalUtil.saveApprovalForThirdPartyTrain(
                        BusinessType.BAYZ,
                        dbPersonCertificate.getId(),
                        Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE,
                        currentUser.getAreaCode()
                );
            }
        }
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("成功");
        return ajaxResult;
    }


    @Override
    public AjaxResult cancelPersonCertificateApply(String personCertificateId) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(personCertificateId).getSubject();

        // 背景筛查中、申诉中、已安排考试 这几个不能撤销
        Personcertificate personCertificate = personcertificateDao.findById(Long.valueOf(subject));
        // 背景筛查状态
        String censorStatus = personCertificate.getCensorStatus();
        // 申诉状态
        List<Appeal> appealList = appealDao.findByBusinessIdAndType(subject, Constants.APPEALTYPE_PERSONCERTIFICATE);
        boolean isAppeal = false;
        for (Appeal appeal : appealList) {
            if (Constants.APPEALSTATE_ING.equals(appeal.getAppealState())) {
                isAppeal = true;
                break;
            }
        }
        // 已安排考试
        String examState = personCertificate.getExamState();
        if ((censorStatus != null && censorStatus.equals(Constants.CENSORSTATUS_WAIT))
                || isAppeal
                || (examState != null && (examState.equals(Constants.EXAM_STATE_YAP) || examState.equals(Constants.EXAM_STATE_UPDATE)))) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("背景筛查中、申诉中、已安排考试不能撤销");
            return ajaxResult;
        }
        personCertificate.setApprovalstate(Constants.APPROVALSTATE_YCX);
        personcertificateDaoAop.update(personCertificate);
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    @Override
    public AjaxResult signUpSecurityCertificate(String securityCertificates) {
        String subject = JwtUtil.parseJWT(securityCertificates).getSubject();
        List<Personcertificate> personCertificateList = JSON.parseArray(subject, Personcertificate.class);
        AjaxResult ajaxResult = new AjaxResult();

        //定义成绩通过数组人员ID，成绩通过的人员ID存放在该数组里
        List<Long> personListIds = new ArrayList<>();
        //未通过人员id
        List<Long> personFailedListIds = new ArrayList<>();

        List<Personcertificate> saveList = new ArrayList<>();

        List<Personcertificate> rosterList = new ArrayList<>();

        Map<Long, Personcertificate> personMap;

        // 已存在的
        List<Long> existsList = null;

        // 保存成功的
        List<Long> successList = null;

        //根据传过来的人员列表，查询数据库保安员资格报名人员
        List<Personcertificate> dbPersonCertificateList = personcertificateDao.findByBatchPersonIdOnApproval(personCertificateList);

        //判断保安员资格报名列表是否为空
        if (dbPersonCertificateList != null && dbPersonCertificateList.size() > 0) {
            List<Personcertificate> hasCertificateList = personcertificateDao.findHasCertificateListByBatchPersonId(personCertificateList);

            // 已生成证书的
            if (hasCertificateList != null && hasCertificateList.size() > 0) {
                dbPersonCertificateList.removeAll(hasCertificateList);
                existsList = hasCertificateList.stream().map(Personcertificate::getId).collect(Collectors.toList());
            }
        } else {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("报名列表为空或背景筛查未通过");
            return ajaxResult;
        }
        personMap = dbPersonCertificateList.stream().collect(Collectors.toMap(Personcertificate::getId, Function.identity()));
        User currentUser = arsUtil.getCurrentUser();
        Date now = new Date();
        //判断保安员资格报名列表是否为空
        for (Personcertificate personcertificate : personCertificateList) {

            Personcertificate dbPersonCertificate = personMap.get(personcertificate.getBbdPersonID());
            if (dbPersonCertificate != null) {
                dbPersonCertificate.setTestState(personcertificate.getTestState());
                dbPersonCertificate.setSumScore(personcertificate.getSumScore());
                dbPersonCertificate.setOperateScore(personcertificate.getOperateScore());
                dbPersonCertificate.setWrittenScore(personcertificate.getWrittenScore());
                dbPersonCertificate.setExamTimes(personcertificate.getExamTimes());
                dbPersonCertificate.setSubjectID(personcertificate.getSubjectID());
                dbPersonCertificate.setTrainEndDate(now);
                dbPersonCertificate.setUpdateTime(now);
                dbPersonCertificate.setUpdateflag(true);
                dbPersonCertificate.setUserid(currentUser.getId());
                dbPersonCertificate.setBbdPersonID(dbPersonCertificate.getId());
                if (StringUtil.isNotEmpty(personcertificate.getExamState())) {
                    dbPersonCertificate.setExamState(personcertificate.getExamState());
                }
                saveList.add(dbPersonCertificate);


                //判断人员成绩是否通过
                if (Constants.TEST_STATE_TG.equals(dbPersonCertificate.getTestState())) {
                    // 成绩通过, 审批通过
                    dbPersonCertificate.setApprovalstate(Constants.APPROVALSTATE_TG);
                    //成绩通过人员，将ID加入到成功人员数组里，用于后面生成证书用
                    personListIds.add(dbPersonCertificate.getId());
                    rosterList.add(dbPersonCertificate);
                } else if (Constants.TEST_STATE_WTG.equals(dbPersonCertificate.getTestState())) {
                    // 成绩未通过, 审批不通过
                    dbPersonCertificate.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    //成绩未通过人员，将ID加入到失败人员数组里
                    personFailedListIds.add(dbPersonCertificate.getId());
                }

            }
        }

        if (saveList.size() > 0) {
            //更新人员成绩状态
            personcertificateDaoAop.updateBatch(saveList);
            successList = saveList.stream().map(Personcertificate::getId).collect(Collectors.toList());
        }

        //批量审批不通过
        if (personFailedListIds.size() > 0) {
            Long[] array = new Long[personFailedListIds.size()];
            personFailedListIds.toArray(array);
            approvalDAO.batchUpdateApprovalState(ApprovalState.SHBTG, array);
        }

        //判断数组是否有成绩通过人员，如有一个，则调用生成证书生成
        if (personListIds.size() > 0) {
            //List转Long[]，定义一个长度为成绩通过人数的Long[]数组
            Long[] personIds = new Long[personListIds.size()];
            //循环将人员ID放到Long[]
            for (int i = 0; i < personListIds.size(); i++) {
                personIds[i] = personListIds.get(i);
            }
            //更新审批记录和保安员资格证的审批状态
            approvalDAO.batchUpdateApprovalState(ApprovalState.SHTG, personIds);
            //考试通过生成证书
            this.createCard(personIds);
            //生成补贴名单
            this.generateSubsidyRoster(rosterList);
        }
        Map<String, Object> resultData = Maps.newHashMap();
        // 已存在的
        resultData.put("existsList", existsList);
        // 成功保存的
        resultData.put("successList", successList);
        ajaxResult.setData(JwtUtil.createJWT(JSON.toJSONString(resultData, SerializerFeature.WriteMapNullValue)));
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    @Override
    public void searchSubsidyPage(SearchPersonCertificateDto dto, AjaxPageResponse<VPersoncertificate> page) {
        arsUtil.setPoliceSearch(dto);
        personcertificateDao.searchSubsidyPage(dto, page);
    }
}
