package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.LegalchangeworkexperienceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.LegalchangeworkexperienceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Legalchangeworkexperience;
import com.bcxin.ars.service.sb.LegalchangeworkexperienceService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = Legalchangeworkexperience.class)
public class LegalchangeworkexperienceServiceImpl implements LegalchangeworkexperienceService{

	@Autowired
	private LegalchangeworkexperienceDao workexperienceDao;
	
	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private IdGeneratorUtil idGeneratorUtil;
	
	@Override
	public Legalchangeworkexperience findById(long id) {
		return workexperienceDao.findById(id);
	}

	@Override
	public void saveOrUpdate(Legalchangeworkexperience workexperience) {
		User currentUser = arsUtil.getCurrentUser();
		if(workexperience.getId() == null){
			workexperience.setId(idGeneratorUtil.createID());
			workexperience.setActive(true);
			workexperience.setCreateTime(new Date());
			workexperience.setUpdateTime(new Date());
			workexperience.setUpdateBy(currentUser.getUsername());
			workexperienceDao.save(workexperience);
		}else{
			Legalchangeworkexperience dbLegalchangeworkexperience = workexperienceDao.findById(workexperience.getId());
			dbLegalchangeworkexperience.setUpdateTime(new Date());
			dbLegalchangeworkexperience.setCompanyname(workexperience.getCompanyname());
			dbLegalchangeworkexperience.setEnddate(workexperience.getEnddate());
			dbLegalchangeworkexperience.setPost(workexperience.getPost());
			dbLegalchangeworkexperience.setStartdate(workexperience.getStartdate());
			dbLegalchangeworkexperience.setUpdateBy(currentUser.getUsername());
			dbLegalchangeworkexperience.setUpdateTime(new Date());
			workexperienceDao.update(dbLegalchangeworkexperience);
		}
		
	}

	@Override
	public LegalchangeworkexperienceSearchDto search(LegalchangeworkexperienceSearchDto dto) {
		LegalchangeworkexperienceSearchDto resultDto = new LegalchangeworkexperienceSearchDto();
		List<Legalchangeworkexperience> list =  workexperienceDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(workexperienceDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public void delete(Long workexperienceId) {
		User currentUser = arsUtil.getCurrentUser();
		Legalchangeworkexperience workexperience = workexperienceDao.findById(workexperienceId);
		workexperience.setUpdateBy(currentUser.getUsername());
		workexperience.setUpdateTime(new Date());
		workexperienceDao.delete(workexperience);
	}

	@Override
	public void deleteByLegalchangeId(Long legalchangeId) {
		User currentUser = arsUtil.getCurrentUser();
		Legalchangeworkexperience workexperience = new Legalchangeworkexperience();
		workexperience.setLegalchangeId(legalchangeId);
		workexperience.setUpdateBy(currentUser.getUsername());
		workexperience.setUpdateTime(new Date());
		workexperienceDao.deleteByLegalchangeId(workexperience);
	}

	@Override
	public List<Legalchangeworkexperience> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return workexperienceDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(Legalchangeworkexperience legalchangeworkexperience) {
		if (legalchangeworkexperience.getActive() == null){
			legalchangeworkexperience.setActive(true);
		}
		Legalchangeworkexperience dbLegalchangeworkexperience = workexperienceDao.findById(legalchangeworkexperience.getId());
        if (dbLegalchangeworkexperience != null) {
        	if(legalchangeworkexperience.getUpdateTime().getTime() > dbLegalchangeworkexperience.getUpdateTime().getTime()){
				workexperienceDao.update(legalchangeworkexperience);
			}
        } else {
        	workexperienceDao.saveForDS(legalchangeworkexperience);
        }
	}

	@Override
	public List<Legalchangeworkexperience> findByLegalchangeId(Long legalchangeId) {
		return workexperienceDao.findByLegalchangeId(legalchangeId);
	}

}
