package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.sb.LegalchangeDao;
import com.bcxin.ars.dao.sb.LegalchangeDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.LegalchangeSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Legalchangeworkexperience;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.LegalchangeService;
import com.bcxin.ars.service.sb.LegalchangeworkexperienceService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = Legalchange.class)
public class LegalchangeServiceImpl implements LegalchangeService {

    @Autowired
    private LegalchangeDao legalchangeDao;

    @Autowired
    private LegalchangeDaoAop legalchangeDaoAop;

    @Autowired
    private LegalchangeworkexperienceService workexperienceService;

    @Autowired
    private UserDao userDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityScopeDao securityScopeDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Override
    public Legalchange findById(long id) {
        Legalchange result = legalchangeDao.findById(id);
        if (result != null) {
            result.setApproval(approvalDAO.findBybusinessidAndType(id,BusinessType.FRBG));
            if(StringUtil.isNotEmpty(result.getSecurityScopes())) {
                List<SecurityScope> securityScope = securityScopeDao.findByIds(result.getSecurityScopes().split(","));
                result.setSecurityScope(securityScope);
            }

            //查询机构信息
            Police police = policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }
    @Override
    public  List<Legalchange> findByBatchId(List<Approval> approvalList){
        return  legalchangeDao.findByBatchId(approvalList);
    }
    @Override
    public Map searchForPrintf(long id) {
        return legalchangeDao.searchForPrintf(id);
    }
    @Override
    public  void updateBatch(List<Legalchange> list){
        legalchangeDaoAop.updateBatch(list);
    }

    /**
     * 仅适用于申报与暂存
     * @param legalchange
     */
    @Override
    public void saveOrUpdate(Legalchange legalchange) {
        User currentUser = arsUtil.getCurrentUser();

        /**
         * 最后一级机构id处理
         */
        if(legalchange.getOrgid() == null){
            if(legalchange.getDistrictOrgId() != null){
                legalchange.setOrgid(Long.parseLong(legalchange.getDistrictOrgId()));
            }else if(legalchange.getCityOrgId() != null){
                legalchange.setOrgid(Long.parseLong(legalchange.getCityOrgId()));
            }
        }

        Long userId = currentUser.getId();
        SecurityCompany company = securityCompanyDao.findByUserid(userId);

        if(!legalchange.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)&&company!=null){
            if(StringUtil.isNotEmpty(legalchange.getSecurityScopes())){
                String oldSecurityScope = company.getSecurityScopeType();
                if(StringUtil.isEmpty(oldSecurityScope) &&(
                        StringUtil.isEmpty(company.getInstitutionType())
                        || company.getInstitutionType().equals(Constants.INSTITUTIONTYPE_FWGS)
                        || company.getInstitutionType().equals(Constants.INSTITUTIONTYPE_FGS))
                        ){
                    throw new ArsException("公司原服务范围未维护，请联系系统管理员维护！");
                }

                if(ObjectUtil.equal(oldSecurityScope,legalchange.getSecurityScopes())){
                    throw new ArsException("服务范围与原本的一致，没有变更无需填写！");
                }
            }
            if(StringUtil.isNotEmpty(legalchange.getCompanyname())){
                if(company.getName().equals(legalchange.getCompanyname())){
                    throw new ArsException("公司名称与原本的一致，没有变更无需填写！");
                }
            }
            if(StringUtil.isNotEmpty(legalchange.getAddress())){
                if(company.getLocation()!=null && company.getLocation().equals(legalchange.getAddress())){
                    throw new ArsException("公司地址与原本的一致，没有变更无需填写！");
                }
            }
            if(legalchange.getBgregisteredMoney() != null && company.getRegisteredMoney() != null){
                if(legalchange.getBgregisteredMoney().toString().equals(company.getRegisteredMoney().toString())){
                    throw new ArsException("注册资本与原本的一致，没有变更无需填写！");
                }
            }

            List<Legalchange> checkLegalchanges = legalchangeDao.findApproveByUserId(userId);
            if(checkLegalchanges != null && checkLegalchanges.size() > 0){
                String checkMsg = "";
                for (Legalchange checkLegalchange : checkLegalchanges){
                    if(StringUtil.isNotEmpty(legalchange.getNdlegalname()) && StringUtil.isNotEmpty(checkLegalchange.getNdlegalname())){
                        //checkMsg = checkMsg + "法定代表人:" + checkLegalchange.getNdlegalname() + "、";
                        checkMsg = checkMsg + "法定代表人、";
                    }
                    if(StringUtil.isNotEmpty(legalchange.getAddress()) && StringUtil.isNotEmpty(checkLegalchange.getAddress())){
                        //checkMsg = checkMsg + "办公地址:" + checkLegalchange.getAddress() + "、";
                        checkMsg = checkMsg + "办公地址、";
                    }
                    if(StringUtil.isNotEmpty(legalchange.getCompanyname()) && StringUtil.isNotEmpty(checkLegalchange.getCompanyname())){
                        //checkMsg = checkMsg + "公司名称:" + checkLegalchange.getCompanyname() + "、";
                        checkMsg = checkMsg + "公司名称、";
                    }
                    if(legalchange.getBgregisteredMoney() != null && checkLegalchange.getBgregisteredMoney() != null){
                        //checkMsg = checkMsg + "注册资本:" + checkLegalchange.getBgregisteredMoney() + "、";
                        checkMsg = checkMsg + "注册资本、";
                    }
                    if(StringUtil.isNotEmpty(legalchange.getSecurityScopes()) && StringUtil.isNotEmpty(checkLegalchange.getSecurityScopes())){
                        //checkMsg = checkMsg + "服务范围:" + checkLegalchange.getSecurityScopes() + "、";
                        checkMsg = checkMsg + "服务范围、";
                    }
                }
                if(StringUtil.isNotEmpty(checkMsg)){
                    checkMsg = checkMsg.substring(0,checkMsg.length()-1) + "已提交正在审批，请不要重复提交！";
                    throw new ArsException(checkMsg);
                }
            }
        }

        //2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
        if((null!=legalchange.getSecurityScopes() && !legalchange.getSecurityScopes().contains("20"))||null == legalchange.getSecurityScopes()){
            legalchange.setOtherSecScopeType(null);
        }

        legalchange.setActive(true);
        legalchange.setUpdateTime(new Date());
        legalchange.setUpdateBy(currentUser.getUsername());
        legalchange.setUserid(userId);

        legalchange.setOldaddress(company.getLocation());
        legalchange.setOldcompanyname(company.getName());
        if(company.getRegisteredMoney()!=null) {
            legalchange.setOldregisteredMoney(company.getRegisteredMoney().toString());
        }
        legalchange.setOldsecurityScopes(company.getSecurityScopeType());

        if (legalchange.getId() == null) {
            legalchange.setId(idGeneratorUtil.createID());
            legalchange.setCreateTime(new Date());
            legalchangeDao.save(legalchange);
            //TODO 保存审批信息
            if(legalchange.getApprovalstate().equals(ApprovalState.DSH)) {
            	approvalUtil.saveApproval(BusinessType.FRBG, legalchange.getId(), Constants.ACTIVITI_PROCESS_LEGALCHANGE);
            }
        } else {
            Legalchange dbLegalchange = legalchangeDao.findById(legalchange.getId());
            boolean activity = true;
            if(StringUtil.isNotEmpty(dbLegalchange.getApprovalstate()) && dbLegalchange.getApprovalstate().equals(ApprovalState.DSH)){
                if(dbLegalchange.getOrgid().toString().equals(legalchange.getOrgid().toString())){
                    activity = false;
                    if(StringUtil.isEmpty(legalchange.getCompanyname()) && StringUtil.isEmpty(legalchange.getOldcompanyname())){

                    }else{
                        String companyName = StringUtil.isEmpty(legalchange.getCompanyname())?legalchange.getOldcompanyname():legalchange.getCompanyname();
                        String oldCompanyName = StringUtil.isEmpty(dbLegalchange.getCompanyname())?dbLegalchange.getOldcompanyname():dbLegalchange.getCompanyname();
                        if(!companyName.equals(oldCompanyName)) {
                            Approval approval = approvalDAO.findBybusinessidAndType(legalchange.getId(), BusinessType.FRBG);
                            if (approval != null) {
                                approvalUtil.updateContent(approval, StringUtil.isEmpty(legalchange.getCompanyname())?legalchange.getOldcompanyname():legalchange.getCompanyname());
                            }
                        }
                    }

                }
            }

            BeanUtils.copyPropertiesIgnore(legalchange,dbLegalchange,"active,createTime,userid",true);

            //BeanUtils.copyPropertiesIgnore(legalchange,dbLegalchange,true);
            dbLegalchange.setUpdateBy(currentUser.getUsername());
            dbLegalchange.setUpdateTime(new Date());
            dbLegalchange.setOtherSecScopeType(legalchange.getOtherSecScopeType());
            //待审批
            if (!(legalchange.getApprovalstate() != null && !"".equals(legalchange.getApprovalstate()) && !legalchange.getApprovalstate().equals(ApprovalState.DSH))) {
                dbLegalchange.setApprovalstate(ApprovalState.DSH);
                dbLegalchange.setChargecensorstatus("");
                dbLegalchange.setLegalcensorstatus("");

            }
            legalchangeDaoAop.update(dbLegalchange);

            //TODO 保存审批信息
            if(activity && ApprovalState.DSH.equals(dbLegalchange.getApprovalstate())){
                approvalUtil.saveApproval(BusinessType.FRBG, dbLegalchange.getId(), Constants.ACTIVITI_PROCESS_LEGALCHANGE);
            }
        }

    }




    @Override
    public void saveOrUpdateForIntegrate(Legalchange legalchange, User currentUser) {
        Long userId = currentUser.getId();
        SecurityCompany company = securityCompanyDao.findByUserid(userId);

        if(!legalchange.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)&&company!=null){

            if(StringUtil.isNotEmpty(legalchange.getSecurityScopes())){
                String oldSecurityScope = company.getSecurityScopeType();

                if(oldSecurityScope.equals(legalchange.getSecurityScopes())){
                    throw new ArsException("服务范围与原本的一致，没有变更无需填写！");
                }
            }
            if(StringUtil.isNotEmpty(legalchange.getCompanyname())){
                if(company.getName().equals(legalchange.getCompanyname())){
                    throw new ArsException("公司名称与原本的一致，没有变更无需填写！");
                }
            }
            if(StringUtil.isNotEmpty(legalchange.getAddress())){
                if(company.getLocation()!=null && company.getLocation().equals(legalchange.getAddress())){
                    throw new ArsException("公司地址与原本的一致，没有变更无需填写！");
                }
            }
            if(legalchange.getBgregisteredMoney() != null && company.getRegisteredMoney() != null){
                if(legalchange.getBgregisteredMoney().toString().equals(company.getRegisteredMoney().toString())){
                    throw new ArsException("注册资本与原本的一致，没有变更无需填写！");
                }
            }

            List<Legalchange> checkLegalchanges = legalchangeDao.findApproveByUserId(userId);
            if(checkLegalchanges != null && checkLegalchanges.size() > 0){
                String checkMsg = "";
                for (Legalchange checkLegalchange : checkLegalchanges){
                    if(StringUtil.isNotEmpty(legalchange.getNdlegalname()) && StringUtil.isNotEmpty(checkLegalchange.getNdlegalname())){
                        //checkMsg = checkMsg + "法定代表人:" + checkLegalchange.getNdlegalname() + "、";
                        checkMsg = checkMsg + "法定代表人、";
                    }
                    if(StringUtil.isNotEmpty(legalchange.getAddress()) && StringUtil.isNotEmpty(checkLegalchange.getAddress())){
                        //checkMsg = checkMsg + "办公地址:" + checkLegalchange.getAddress() + "、";
                        checkMsg = checkMsg + "办公地址、";
                    }
                    if(StringUtil.isNotEmpty(legalchange.getCompanyname()) && StringUtil.isNotEmpty(checkLegalchange.getCompanyname())){
                        //checkMsg = checkMsg + "公司名称:" + checkLegalchange.getCompanyname() + "、";
                        checkMsg = checkMsg + "公司名称、";
                    }
                    if(legalchange.getBgregisteredMoney() != null && checkLegalchange.getBgregisteredMoney() != null){
                        //checkMsg = checkMsg + "注册资本:" + checkLegalchange.getBgregisteredMoney() + "、";
                        checkMsg = checkMsg + "注册资本、";
                    }
                    if(StringUtil.isNotEmpty(legalchange.getSecurityScopes()) && StringUtil.isNotEmpty(checkLegalchange.getSecurityScopes())){
                        //checkMsg = checkMsg + "服务范围:" + checkLegalchange.getSecurityScopes() + "、";
                        checkMsg = checkMsg + "服务范围、";
                    }
                }
               /* if(StringUtil.isNotEmpty(checkMsg)){
                    checkMsg = checkMsg.substring(0,checkMsg.length()-1) + "已提交正在审批，请不要重复提交！";
                    throw new ArsException(checkMsg);
                }*/
            }
        }

        //2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
        if((null!=legalchange.getSecurityScopes() && !legalchange.getSecurityScopes().contains("20"))||null == legalchange.getSecurityScopes()){
            legalchange.setOtherSecScopeType(null);
        }
        if (legalchange.getId() == null) {
            legalchange.setId(idGeneratorUtil.createID());
            legalchange.setActive(true);
            legalchange.setCreateTime(new Date());
            legalchange.setUpdateTime(new Date());
            legalchange.setUpdateBy(currentUser.getUsername());
            legalchange.setUserid(userId);

            legalchange.setOldaddress(company.getLocation());
            legalchange.setOldcompanyname(company.getName());
            if(company.getRegisteredMoney()!=null) {
                legalchange.setOldregisteredMoney(company.getRegisteredMoney().toString());
            }
            String securityScopes = company.getSecurityScopeType();
            legalchange.setOldsecurityScopes(securityScopes);
            legalchangeDao.save(legalchange);

            approvalUtil.saveApprovalForIntegrate(BusinessType.FRBG, legalchange.getId(), Constants.ACTIVITI_PROCESS_LEGALCHANGE,currentUser);
        }
    }

    @Override
    public void  saveOrUpdateForDS(Legalchange legalchange) {
        Legalchange dbLegalchange = legalchangeDao.findById(legalchange.getId());
        if(legalchange.getActive() == null){
        	legalchange.setActive(true);
        }
        if (dbLegalchange != null) {
        	if(legalchange.getUpdateTime().getTime() > dbLegalchange.getUpdateTime().getTime()){
        		legalchange.setNdlegalcensorstatus(dbLegalchange.getNdlegalcensorstatus());
                legalchange.setLegalcensorstatus(dbLegalchange.getLegalcensorstatus());
                legalchange.setChargecensorstatus(dbLegalchange.getChargecensorstatus());
				legalchangeDaoAop.update(legalchange);
			}
        } else {
            if(legalchange.getApprovalstate().equals(Constants.APPROVALSTATE_DSP)){
                List<Legalchange> checkLegalchanges = legalchangeDao.findApproveByUserId(legalchange.getUserid());
                if(checkLegalchanges != null && checkLegalchanges.size() > 0){
                    String checkMsg = "";
                    for (Legalchange checkLegalchange : checkLegalchanges){
                        if(StringUtil.isNotEmpty(legalchange.getNdlegalname()) && StringUtil.isNotEmpty(checkLegalchange.getNdlegalname())){
                            checkMsg = checkMsg + "法定代表人、";
                        }
                        if(StringUtil.isNotEmpty(legalchange.getAddress()) && StringUtil.isNotEmpty(checkLegalchange.getAddress())){
                            checkMsg = checkMsg + "办公地址、";
                        }
                        if(StringUtil.isNotEmpty(legalchange.getCompanyname()) && StringUtil.isNotEmpty(checkLegalchange.getCompanyname())){
                            checkMsg = checkMsg + "公司名称、";
                        }
                        if(legalchange.getBgregisteredMoney() != null && checkLegalchange.getBgregisteredMoney() != null){
                            checkMsg = checkMsg + "注册资本、";
                        }
                        if(StringUtil.isNotEmpty(legalchange.getSecurityScopes()) && StringUtil.isNotEmpty(checkLegalchange.getSecurityScopes())){
                            checkMsg = checkMsg + "服务范围、";
                        }
                    }
               if(StringUtil.isNotEmpty(checkMsg)){
//                    checkMsg = checkMsg.substring(0,checkMsg.length()-1) + "已提交正在审批，请不要重复提交！";
                   legalchange.setApprovalstate(ApprovalState.SHBTG);
                   new Thread(()->{
                       try {
                           Thread.sleep(100000);
                       } catch (InterruptedException e) {
                           e.printStackTrace();
                       }
                       Approval approval = approvalDAO.findBybusinessidAndType(legalchange.getId(),BusinessType.FRBG);
                       approval.setApprovalstate(ApprovalState.SHBTG);
                       approval.setApprovalreason("重复提交");
                       approval.setUpdateflag(true);
                       approval.setUpdateTime(new Date());
                       approvalDAO.update(approval);
                   }).start();
                }
                }
            }

            legalchangeDao.save(legalchange);
        }
    }

    @Override
    public void updatePoliceId(Legalchange legalchange) {
        Approval approval =  approvalDAO.getById(legalchange.getApprovalId());
        Legalchange dbLegalchange  = legalchangeDao.findById(legalchange.getId());
        dbLegalchange.setPoliceid(legalchange.getPoliceid());
        dbLegalchange.setUpdateTime(new Date());
        legalchangeDaoAop.update(dbLegalchange);
        /***
         * 更新
         */
        approval.setPoliceid(legalchange.getPoliceid());
        approval.setRoleid(null);
        approval.setUpdateTime(new Date());
        approvalDAO.update(approval);

    }

    @Override
    public LegalchangeSearchDto search(LegalchangeSearchDto dto) {
        LegalchangeSearchDto resultDto = new LegalchangeSearchDto();

        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        if (police!=null){
            String areacode =  police.getAreacode();
            if(areacode.endsWith("0000")){//省
                dto.setDistrict(areacode.substring(0,2)+"____");
            }else if(areacode.endsWith("00")){//市
                dto.setDistrict(areacode.substring(0,4)+"__");
            }else{//区
                dto.setDistrict(areacode);
            }
        }
        List<Legalchange> list = legalchangeDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(legalchangeDao.searchCount(dto));
        return resultDto;
    }


    @Override
    public LegalchangeSearchDto searchCompanyCertificate(LegalchangeSearchDto dto) {

        arsUtil.setPoliceSearch(dto);
        LegalchangeSearchDto resultDto = new LegalchangeSearchDto();
        List<Legalchange> list = legalchangeDao.searchCompanyCertificate(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(legalchangeDao.searchCompanyCertificateCount(dto));
        return resultDto;
    }

    @Override
    public void delete(Legalchange legalchange) {
        User currentUser = arsUtil.getCurrentUser();
        legalchange.setUpdateBy(currentUser.getUsername());
        legalchange.setUpdateTime(new Date());
        legalchangeDaoAop.delete(legalchange);
    }

    @Override
    public Legalchange findByUser(Long userid) {
        return legalchangeDao.findByUser(userid);
    }

    @Override
    public void updateAndSaveWorkExperience(Legalchange legalchange, Date[] startdate, Date[] enddate, String[] workCompanyname, String[] post) {
        saveOrUpdate(legalchange);

        User currentUser = arsUtil.getCurrentUser();
        workexperienceService.deleteByLegalchangeId(legalchange.getId());
        Legalchangeworkexperience legalchangeworkexperience = null;
        if (startdate != null) {
            for (int i = 0; i < startdate.length; i++) {
                legalchangeworkexperience = new Legalchangeworkexperience();
                //legalchangeworkexperience.setId(idGeneratorUtil.createID());
                legalchangeworkexperience.setActive(true);
                if(workCompanyname.length>i){
                    legalchangeworkexperience.setCompanyname(workCompanyname[i]);
                }
                legalchangeworkexperience.setCreateTime(new Date());
                if(enddate.length>i){
                    legalchangeworkexperience.setEnddate(enddate[i]);
                }
                legalchangeworkexperience.setLegalchangeId(legalchange.getId());
                if(post.length>i){
                    legalchangeworkexperience.setPost(post[i]);
                }
                legalchangeworkexperience.setStartdate(startdate[i]);
                legalchangeworkexperience.setUpdateBy(currentUser.getUsername());
                legalchangeworkexperience.setUpdateTime(new Date());
                workexperienceService.saveOrUpdate(legalchangeworkexperience);
            }
        }
    }

    @Override
    public List<Legalchange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return legalchangeDao.searchForDataSynchronization(searchDto);
    }

	@Override
	public List<Legalchange> findAll() {
		return legalchangeDao.findAll();
	}

    @Override
    public PageResult searchLegalchangeList_table(Map<Object, Object> p) {
        User currentUser = arsUtil.getCurrentUser();
        //机构信息
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else {
            if (police != null) {
                areacode = police.getAreacode();
            }

        }
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("district", areacode.substring(0, 4) + "__");
            } else {//区
                p.put("district", areacode);
            }
        }

        if (police != null) {
            if (police.getOrgtype().equals("4")) {
                p.put("orgid", police.getId());
            }
        }
        if (p.get("checkType")!=null) {
            if (currentUser != null) {
                p.put("userid", currentUser.getId());
            }
        }
        return new PageResult(legalchangeDao.countLegalchangeList(p), legalchangeDao.searchLegalchangeList(p));
    }

    @Override
    public void saveOrUpdateForApproval(Legalchange legalchange) {
        legalchange.setUpdateTime(new Date());
        legalchangeDaoAop.update(legalchange);
    }

    @Override
    public void updateCensorStatus(Legalchange legalchange) {
        legalchangeDaoAop.update(legalchange);
    }

    @Override
    public List<Legalchange> findApprovePassByCompanyId(Long companyId) {
        return legalchangeDao.findApprovePassByCompanyId(companyId);
    }

    @Override
    public void saveOrUpdateForApprovalImport(Legalchange legalchange) {
        legalchangeDaoAop.update(legalchange);
    }

    @Override
    public void searchForPage(LegalchangeSearchDto dto, AjaxPageResponse<Legalchange> page) {
        arsUtil.setPoliceSearch(dto);
        legalchangeDao.searchForPage(dto,page);
    }
}
