package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchDao;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchDaoAop;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchRosterDao;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchRosterDaoAop;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDaoAop;
import com.bcxin.ars.dao.subsidy.TrainSubsidyConfigDao;
import com.bcxin.ars.dao.subsidy.TrainSubsidyConfigDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.dao.sys.SubsidyConfigDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.GradeSubsidyBatchPageSearchDto;
import com.bcxin.ars.dto.sb.GradeSubsidyBatchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.enums.SubsidyCerType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.bcxin.ars.model.sb.GradeSubsidyBatchRoster;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.model.subsidy.TrainSubsidyConfig;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.GradeSubsidyBatchService;
import com.bcxin.ars.service.util.*;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

/**
 * 等级证补贴批次Service实现类
 *
 * @author linqinglin
 * @Date 2020-05-18 19:43:23
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = GradeSubsidyBatch.class, getImportType = ImportType.BATCH, getMethodName = "importBatch")
@DataSyncOutAnnotation(getClazz = GradeSubsidyBatch.class, getImportType = ImportType.BATCH)
public class GradeSubsidyBatchServiceImpl extends BaseService implements GradeSubsidyBatchService {

    Logger logger = LoggerFactory.getLogger(GradeSubsidyBatchServiceImpl.class);

    @Autowired
    private GradeSubsidyBatchDao gradeSubsidyBatchDao;

    @Autowired
    private GradeSubsidyBatchDaoAop gradeSubsidyBatchDaoAop;

    @Autowired
    private GradeSubsidyBatchRosterDaoAop gradeSubsidyBatchRosterDaoAop;


    @Autowired
    private GradeSubsidyBatchRosterDao  gradeSubsidyBatchRosterDao;

    @Autowired
    private GradeSubsidyRosterDaoAop gradeSubsidyRosterDaoAop;

    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;

    @Autowired
    private TrainSubsidyConfigDaoAop trainSubsidyConfigDaoAop;

    @Autowired
    private TrainSubsidyConfigDao trainSubsidyConfigDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private SubsidyConfigDao subsidyConfigDao;

    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private ApprovalLogDao approvalLogDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private ApprovalUtil approvalUtil;

    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    @Autowired
    private IdWorker idWorker;

    @Override
    public int delete(GradeSubsidyBatch gradeSubsidyBatch) {
        User currentUser = arsUtil.getCurrentUser();
        gradeSubsidyBatch.setUpdateTime(new Date());
        gradeSubsidyBatch.setUpdateBy(currentUser.getUsername());
        return gradeSubsidyBatchDaoAop.delete(gradeSubsidyBatch);
    }

    @Override
    public void save(GradeSubsidyBatch gradeSubsidyBatch) {
        User currentUser = arsUtil.getCurrentUser();
        SecurityCompany company = securityCompanyDao.findByUserid(currentUser.getId());

        SubsidyCerType subsidyCerType = null;
        if(gradeSubsidyBatch.getId() == null){
            subsidyCerType = SubsidyCerType.getByCode(gradeSubsidyBatch.getSubsidyCerType());
            gradeSubsidyBatch.setCreateTime(new Date());
            gradeSubsidyBatch.setId(idWorker.nextId());
            if(ApprovalState.WTJ.equals(gradeSubsidyBatch.getApprovalstate())){
                gradeSubsidyBatch.setOffApprovalState(ApprovalState.WTJ);
            }else{
                gradeSubsidyBatch.setOffApprovalState(ApprovalState.DSH);
            }
            try {
                TrainSubsidyConfig trainSubsidyConfig = trainSubsidyConfigDao.findByTrainIdAndSubsidyCerType(Long.parseLong(company.getComId()),gradeSubsidyBatch.getSubsidyCerType());
                trainSubsidyConfig.setBatchNo(trainSubsidyConfig.getBatchNo() + 1);
                trainSubsidyConfigDaoAop.save(trainSubsidyConfig);
                String batchName = Constants.BATCH_NAME_TEMP.replace("{trainName}", trainSubsidyConfig.getShortName())
                        .replace("{subsidyCerTypeName}",subsidyCerType.getName())
                        .replace("{batchNo}", trainSubsidyConfig.getBatchNo().toString());
                gradeSubsidyBatch.setBatchName(batchName);
            }catch (Exception e){
                e.printStackTrace();
                throw new ArsException("培训单位补贴简称未配置，请联系系统管理员处理");
            }
        }else{
            GradeSubsidyBatch dbGradeSubsidyBatch = gradeSubsidyBatchDao.findById(gradeSubsidyBatch.getId());
            BeanUtils.copyPropertiesIgnore(gradeSubsidyBatch,dbGradeSubsidyBatch,true);
            BeanUtils.copyPropertiesIgnore(dbGradeSubsidyBatch,gradeSubsidyBatch,false);

            if(!ApprovalState.WTJ.equals(gradeSubsidyBatch.getApprovalstate())
                    &&ApprovalState.WTJ.equals(gradeSubsidyBatch.getOffApprovalState())){
                gradeSubsidyBatch.setOffApprovalState(ApprovalState.DSH);
            }

            subsidyCerType = SubsidyCerType.getByCode(gradeSubsidyBatch.getSubsidyCerType());
        }

        if(gradeSubsidyBatch.getRosterIds() != null){
            List<GradeSubsidyBatchRoster> list = new ArrayList<>();
            GradeSubsidyBatchRoster batchRoster = null;
            for (Long rosterId : gradeSubsidyBatch.getRosterIds()) {
                //TODO 保存关联关系
                batchRoster = new GradeSubsidyBatchRoster();
                batchRoster.setBatchId(gradeSubsidyBatch.getId());
                batchRoster.setRosterId(rosterId);
                batchRoster.setActive(true);
                batchRoster.setUpdateflag(true);
                batchRoster.setCreateTime(new Date());
                batchRoster.setUpdateTime(new Date());
                list.add(batchRoster);
            }
            gradeSubsidyBatchRosterDaoAop.saveBatch(list);
            gradeSubsidyRosterDaoAop.updateBatchUsed(gradeSubsidyBatch);
        }

        if(StringUtil.isEmpty(gradeSubsidyBatch.getDistrict())){
            gradeSubsidyBatch.setDistrict(gradeSubsidyBatch.getCity());
            gradeSubsidyBatch.setDistrictOrgId(gradeSubsidyBatch.getCityOrgId());
        }
        if(gradeSubsidyBatch.getOrgid() == null){
            gradeSubsidyBatch.setOrgid(Long.parseLong(gradeSubsidyBatch.getDistrictOrgId()));
        }
        gradeSubsidyBatch.setActive(true);
        gradeSubsidyBatch.setUpdateBy(currentUser.getUsername());
        gradeSubsidyBatch.setUpdateTime(new Date());
        if(ApprovalState.DSH.equals(gradeSubsidyBatch.getApprovalstate())) {
            gradeSubsidyBatch.setApplyTime(new Date());
        }
        gradeSubsidyBatch.setUpdateflag(true);
        //gradeSubsidyBatch.setApprovalstate(ApprovalState.DSH);
        gradeSubsidyBatchDaoAop.save(gradeSubsidyBatch);
        // 更新审批信息

        if(ApprovalState.DSH.equals(gradeSubsidyBatch.getApprovalstate())) {
            switch (subsidyCerType) {
                case GRADE:
                    gradeSubsidyBatch.setOrgName(approvalUtil.getApprovalOrg(gradeSubsidyBatch,BusinessType.DJZBT).getOrgname());
                    approvalUtil.saveApproval(BusinessType.DJZBT, gradeSubsidyBatch.getId(), Constants.ACTIVITI_PROCESS_GRADESUBSIDY);
                    //TODO 状态同步百课堂
                    this.sendApprovalStateToBKT(gradeSubsidyBatch);
                    break;
                case QUALIFICATION:
                    gradeSubsidyBatch.setOrgName(approvalUtil.getApprovalOrg(gradeSubsidyBatch,BusinessType.ZGZBT).getOrgname());
                    approvalUtil.saveApproval(BusinessType.ZGZBT, gradeSubsidyBatch.getId(), Constants.ACTIVITI_PROCESS_QUALIFICATIONSUBSIDY);
                    break;
                default:
                    break;
            }
            gradeSubsidyBatchDaoAop.save(gradeSubsidyBatch);
        }
    }

    @Override
    public GradeSubsidyBatch findById(Long id) {
        return gradeSubsidyBatchDao.findById(id);
    }

    @Override
    public void searchForPage(GradeSubsidyBatchPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        gradeSubsidyBatchDao.searchForPage(dto,page);


    }

    @Override
    public void importBatch(List<GradeSubsidyBatch> list) {
        List<GradeSubsidyBatch> dbList = gradeSubsidyBatchDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (GradeSubsidyBatch gradeSubsidyBatch : list) {
                gradeSubsidyBatch.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                       gradeSubsidyBatch.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, gradeSubsidyBatch.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gradeSubsidyBatchDaoAop.saveBatch(list);
            if(!configUtils.isIntranet()) {
                //状态同步百课堂
                this.sendApprovalStateToBKT(list);
            }
        }
    }

    private void sendApprovalStateToBKT(GradeSubsidyBatch gradeSubsidyBatch){
        List<GradeSubsidyRoster>  rosterList = gradeSubsidyRosterDao.findBySubsidyBatchId(gradeSubsidyBatch.getId());
        JSONArray paramArr = new JSONArray();
        JSONObject rosterObj =null;
        for (GradeSubsidyRoster roster : rosterList) {
            rosterObj = new JSONObject();
            rosterObj.put("gradeApplyId",roster.getGradeId()+"");
            rosterObj.put("approvalStatus",gradeSubsidyBatch.getApprovalstate());
            paramArr.add(rosterObj);
        }
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("personList", JSON.toJSONString(paramArr));
        AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_GRADE_PERSON_APPROVALSTATUS_URL,paramMap);
        if(!result.isSuccessful()){
            //throw new ArsException("【等级证批次审批状态同步】"+result.getMsg());
            logger.error("【等级证批次审批状态同步】"+result.getMsg());
        }
    }

    private void sendApprovalStateToBKT(List<GradeSubsidyBatch> list){
        for (GradeSubsidyBatch gradeSubsidyBatch : list) {
            this.sendApprovalStateToBKT(gradeSubsidyBatch);
        }
    }

    @Override
    public List<GradeSubsidyBatch> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return gradeSubsidyBatchDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<GradeSubsidyBatch> findDSOutList(String startDate) {
        return gradeSubsidyBatchDao.findDSOutList(startDate);
    }

    @Override
    public List<GradeSubsidyBatch> findByBatchId(List<GradeSubsidyBatch> list) {
        return gradeSubsidyBatchDao.findByBatchId(list);
    }

    @Override
    public void searchForPageInterface(GradeSubsidyBatchPageSearchDto dto, AjaxPageResponse<GradeSubsidyBatch> page) {
        arsUtil.setPoliceSearch(dto);
        gradeSubsidyBatchDao.searchForPageInterface(dto,page);

        List<Map> maps = gradeSubsidyBatchDao.searchSubsidyMoney(dto);
        BigDecimal sum = new BigDecimal(0.00);
        for (Map   gsb:maps) {
            String subsidyMoney = gsb.get("subsidyMoney").toString();
            if(StringUtil.isNotEmpty(subsidyMoney)){
                sum=sum.add(new BigDecimal(subsidyMoney));
            }
        }
        Map<String,String> map=new HashMap<>();
        map.put("count",String.valueOf(maps.size()));
        map.put("money",sum.toString());
        page.setUserData(map);


    }

    @Override
    public void repulse(GradeSubsidyBatch gradeSubsidyBatch) {
        gradeSubsidyBatch.setOffApprovalState(Constants.APPROVALSTATE_BTG);
        this.updateSelective(gradeSubsidyBatch);
        /***
         * 审批日志，公安端
         */
        User currentUser=arsUtil.getCurrentUser();
        ApprovalLog approvalLog = new ApprovalLog();
        if (currentUser == null) {
            approvalLog.setUpdateBy("system");
            approvalLog.setApprovalorg("系统自动");
            approvalLog.setApprovalperson("系统自动");
        } else {
            approvalLog.setApprovalperson(currentUser.getRealname());
            approvalLog.setUpdateBy(currentUser.getUsername());
            approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
        }
        approvalLog.setActive(true);
        approvalLog.setType(Constants.APPROVAL_LOG_IN);
        approvalLog.setCreateTime(new Date());
        approvalLog.setUpdateTime(new Date());
        approvalLog.setApprovaldate(new Date());
        approvalLog.setApprovalreason(gradeSubsidyBatch.getReason());
        approvalLog.setApprovalstate(ApprovalState.convertCode(Constants.APPROVALSTATE_BTG));

        String businessType = BusinessType.DJZBT;
        if(Constants.SUBSIDYCERTYPE_ZGZ.equals(gradeSubsidyBatch.getSubsidyCerType())){
            businessType = BusinessType.ZGZBT;
        }
        Approval approval = approvalDAO.findBybusinessidAndType(gradeSubsidyBatch.getId(),businessType);
        approvalLog.setApprovalid(approval.getId().toString());
        approvalLogDao.save(approvalLog);
        gradeSubsidyRosterDaoAop.updateUnUsedByBatchId(gradeSubsidyBatch.getId());
    }

    @Override
    public void updateSelective(GradeSubsidyBatch gradeSubsidyBatch) {
        User currentUser = arsUtil.getCurrentUser();
        gradeSubsidyBatch.setUpdateTime(new Date());
        if(null!=currentUser){
            gradeSubsidyBatch.setUpdateBy(currentUser.getUsername());
        }
        gradeSubsidyBatch.setUpdateflag(true);
        gradeSubsidyBatchDaoAop.updateSelective(gradeSubsidyBatch);
    }

    @Override
    public void uploadCommitFile(GradeSubsidyBatch gradeSubsidyBatch) {
        User currentUser = arsUtil.getCurrentUser();
        if(null!=currentUser){
            gradeSubsidyBatch.setUpdateBy(currentUser.getUsername());
        }
        gradeSubsidyBatch.setUpdateflag(true);
        gradeSubsidyBatchDaoAop.updateSelective(gradeSubsidyBatch);
    }

    @Override
    public void updateGrantState(String id) {
        gradeSubsidyBatchDao.updateGrantState(id);
    }

    @Override
    public AjaxResult subsidyApplicationStatusInquiry(String batchNameSubject) {
        AjaxResult ajaxResult = new AjaxResult();
        // 获取批次名
        String batchName = JwtUtil.parseJWT(batchNameSubject).getSubject();

        // 根据批次名查询补贴申请状态
        String approvalStatus = gradeSubsidyBatchDao.findApprovalStatusByBatchName(batchName);

        ajaxResult.setData(JwtUtil.createJWT(approvalStatus));
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("查询成功");
        return ajaxResult;
    }


    @Override
    public AjaxResult newSubsidyApplication(String gradeSubsidyBatchInfo) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(gradeSubsidyBatchInfo).getSubject();
        GradeSubsidyBatchDto gradeSubsidyBatch = JSON.parseObject(subject, GradeSubsidyBatchDto.class);
        String batchName = gradeSubsidyBatch.getBatchName();
        // 判断是否为空
        if (StringUtil.isBlank(batchName)) {
            ajaxResult.setMsg("失败, 批次名为空");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }
        // 判断是否存在
        int count = gradeSubsidyBatchDao.findCountByBatchName(batchName);
        if (count > 0) {
            ajaxResult.setMsg("失败, 批次名已存在");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }
        User currentUser = arsUtil.getCurrentUser();
        long batchId = idWorker.nextId();
        // 进行添加批次操作
        Date now = new Date();
        Long userId = currentUser.getId();
        gradeSubsidyBatch.setId(batchId);
        gradeSubsidyBatch.setApprovalstate(Constants.APPROVALSTATE_DSP);
        gradeSubsidyBatch.setOffApprovalState(Constants.APPROVALSTATE_DSP);
        gradeSubsidyBatch.setActive(true);
        gradeSubsidyBatch.setUpdateflag(true);
        gradeSubsidyBatch.setUpdateTime(now);
        gradeSubsidyBatch.setApplyTime(now);
        gradeSubsidyBatch.setCreateTime(now);
        gradeSubsidyBatch.setUserid(userId);
        String currentUsername = currentUser.getUsername();
        gradeSubsidyBatch.setCreateBy(currentUsername);
        gradeSubsidyBatch.setUpdateBy(currentUsername);

        // 附件承诺书路径
        gradeSubsidyBatch.setCommitPath(getPhotoPath(gradeSubsidyBatch.getCommitPath()));
        // 附件下载资金表
        gradeSubsidyBatch.setTemplateRar(getPhotoPath(gradeSubsidyBatch.getTemplateRar()));

        gradeSubsidyBatch.setDistrict(currentUser.getAreaCode());

        // 根据身份证集合和补贴类型获取花名册
        List<GradeSubsidyRoster> dbGradeSubsidyRosterList = gradeSubsidyRosterDao.findByIdNumbersAndType(gradeSubsidyBatch);

        // 名单 补贴关联表
        List<GradeSubsidyBatchRoster> gradeSubsidyBatchRosters = Lists.newArrayList();

        gradeSubsidyBatch.setPerNum(String.valueOf(dbGradeSubsidyRosterList.size()));
        // 保存批次
        gradeSubsidyBatchDao.insertSelective(gradeSubsidyBatch);

        for (GradeSubsidyRoster gradeSubsidyRoster : dbGradeSubsidyRosterList) {
            // 处理名单

            long gradeSubsidyBatchRosterId = idWorker.nextId();
            // 关联关系中间表
            GradeSubsidyBatchRoster gradeSubsidyBatchRoster = new GradeSubsidyBatchRoster();
            gradeSubsidyBatchRoster.setId(gradeSubsidyBatchRosterId);
            gradeSubsidyBatchRoster.setBatchId(batchId);
            gradeSubsidyBatchRoster.setRosterId(gradeSubsidyRoster.getId());
            gradeSubsidyBatchRoster.setActive(true);
            gradeSubsidyBatchRoster.setUpdateflag(true);
            gradeSubsidyBatchRoster.setUpdateBy(currentUsername);
            gradeSubsidyBatchRoster.setCreateTime(now);
            gradeSubsidyBatchRoster.setUpdateTime(now);
            gradeSubsidyBatchRosters.add(gradeSubsidyBatchRoster);

            // 花名册表存batchId
            gradeSubsidyRoster.setBatchId(batchId);
            // 设置待比对状态
            gradeSubsidyRoster.setSubsidyStatus(Constants.SUBSIDY_COMPARED);
        }

        if (!gradeSubsidyBatchRosters.isEmpty()) {
            // 保存关联表
            gradeSubsidyBatchRosterDao.saveBatch(gradeSubsidyBatchRosters);
        }
        ajaxResult.setData(JwtUtil.createJWT(String.valueOf(batchId)));
        ajaxResult.setMsg("成功");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

}
