package com.bcxin.ars.service.sb.impl;


import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.CerLearnAuthRecordDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CerLearnAuthRecordPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.CerLearnAuthRecord;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.CerLearnAuthRecordService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 资格证/等级证学习认证记录Service业务层处理
 * 
 * @author lin
 * @date 2020-09-08
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = CerLearnAuthRecord.class,getMethodName="importBatch",getImportType= ImportType.BATCH)
public class CerLearnAuthRecordServiceImpl extends BaseService implements CerLearnAuthRecordService {
    
    Logger logger = LoggerFactory.getLogger(CerLearnAuthRecordServiceImpl.class);
    
    @Autowired
    private CerLearnAuthRecordDao cerLearnAuthRecordDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(CerLearnAuthRecord cerLearnAuthRecord) {
        User currentUser = arsUtil.getCurrentUser();
        cerLearnAuthRecord.setUpdateTime(new Date());
        cerLearnAuthRecord.setUpdateBy(currentUser.getUsername());
        return cerLearnAuthRecordDao.delete(cerLearnAuthRecord);
    }

    @Override
    public int save(CerLearnAuthRecord cerLearnAuthRecord) {
        //User currentUser = arsUtil.getCurrentUser();

        if(cerLearnAuthRecord.getId() == null){
            cerLearnAuthRecord.setCreateTime(new Date());
        }else{
            CerLearnAuthRecord dbCerLearnAuthRecord = cerLearnAuthRecordDao.findById(cerLearnAuthRecord.getId());
            BeanUtils.copyPropertiesIgnore(cerLearnAuthRecord,dbCerLearnAuthRecord,true);
            BeanUtils.copyPropertiesIgnore(dbCerLearnAuthRecord,cerLearnAuthRecord,false);
        }

        cerLearnAuthRecord.setActive(true);
        cerLearnAuthRecord.setUpdateTime(new Date());
        cerLearnAuthRecord.setUpdateflag(true);
        cerLearnAuthRecord.setUpdateBy("apiSystem");
        //cerLearnAuthRecord.setUpdateBy(currentUser.getUsername());
        //cerLearnAuthRecord.setUserid(currentUser.getId());
        //cerLearnAuthRecord.setAreaCode(currentUser.getPolice().getAreacode());
        return cerLearnAuthRecordDao.save(cerLearnAuthRecord);
    }

    @Override
    public CerLearnAuthRecord findById(Long id) {
        return cerLearnAuthRecordDao.findById(id);
    }

    @Override
    public void searchForPage(CerLearnAuthRecordPageSearchDto dto, AjaxPageResponse page) {
        cerLearnAuthRecordDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<CerLearnAuthRecord> list) {
        List<CerLearnAuthRecord> dbList = cerLearnAuthRecordDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (CerLearnAuthRecord cerLearnAuthRecord : list) {
                cerLearnAuthRecord.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        cerLearnAuthRecord.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, cerLearnAuthRecord.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            cerLearnAuthRecordDao.saveBatch(list);
        }
    }

    @Override
    public List<CerLearnAuthRecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return cerLearnAuthRecordDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<CerLearnAuthRecord> findDSOutList(String startDate) {
        return cerLearnAuthRecordDao.findDSOutList(startDate);
    }

    @Override
    public List<CerLearnAuthRecord> findByBatchId(List<CerLearnAuthRecord> list) {
        return cerLearnAuthRecordDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(CerLearnAuthRecord cerLearnAuthRecord) {
        User currentUser = arsUtil.getCurrentUser();
        cerLearnAuthRecord.setUpdateTime(new Date());
        cerLearnAuthRecord.setUpdateBy(currentUser.getUsername());
        cerLearnAuthRecordDao.updateSelective(cerLearnAuthRecord);
    }
}
