package com.bcxin.ars.service.sb.impl;


import com.bcxin.ars.dao.sb.ApproveAttachmentDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ApproveAttachmentPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.ApproveAttachment;
import com.bcxin.ars.service.sb.ApproveAttachmentService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 审批补充材料Service业务层处理
 * 
 * @author lin
 * @date 2021-05-06
 */
@Service
public class ApproveAttachmentServiceImpl implements ApproveAttachmentService {
    
    Logger logger = LoggerFactory.getLogger(ApproveAttachmentServiceImpl.class);
    
    @Autowired
    private ApproveAttachmentDao approveAttachmentDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(ApproveAttachment approveAttachment) {
        User currentUser = arsUtil.getCurrentUser();
        approveAttachment.setUpdateTime(new Date());
        approveAttachment.setUpdateBy(currentUser.getUsername());
        return approveAttachmentDao.delete(approveAttachment);
    }

    @Override
    public int save(ApproveAttachment approveAttachment) {
        User currentUser = arsUtil.getCurrentUser();
        if(approveAttachment.getId() == null){
            approveAttachment.setCreateTime(new Date());
        }else{
            ApproveAttachment dbApproveAttachment = approveAttachmentDao.findById(approveAttachment.getId());
            BeanUtils.copyPropertiesIgnore(approveAttachment,dbApproveAttachment,true);
            BeanUtils.copyPropertiesIgnore(dbApproveAttachment,approveAttachment,false);
        }

        approveAttachment.setActive(true);
        approveAttachment.setUpdateBy(currentUser.getUsername());
        approveAttachment.setUpdateTime(new Date());
        approveAttachment.setUpdateflag(true);
        approveAttachment.setUserId(currentUser.getId());
        approveAttachment.setUploader(currentUser.getRealname());
        return approveAttachmentDao.save(approveAttachment);
    }

    @Override
    public ApproveAttachment findById(Long id) {
        return approveAttachmentDao.findById(id);
    }

    @Override
    public void searchForPage(ApproveAttachmentPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        approveAttachmentDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<ApproveAttachment> list) {
        List<ApproveAttachment> dbList = approveAttachmentDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ApproveAttachment approveAttachment : list) {
                approveAttachment.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        approveAttachment.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, approveAttachment.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            approveAttachmentDao.saveBatch(list);
        }
    }

    @Override
    public List<ApproveAttachment> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return approveAttachmentDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ApproveAttachment> findDSOutList(String startDate) {
        return approveAttachmentDao.findDSOutList(startDate);
    }

    @Override
    public List<ApproveAttachment> findByBatchId(List<ApproveAttachment> list) {
        return approveAttachmentDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(ApproveAttachment approveAttachment) {
        User currentUser = arsUtil.getCurrentUser();
        approveAttachment.setUpdateTime(new Date());
        approveAttachment.setUpdateBy(currentUser.getUsername());
        approveAttachmentDao.updateSelective(approveAttachment);
    }
}
