package com.bcxin.ars.service.nxWeb.impl;

import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.nxWeb.NXWebService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DES3;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * @author：wangcy
 * @date：2018/03/26 0026 15:22
 * @description：
 */
@Service
@Transactional
public class NXWebServiceImpl implements NXWebService {

    Logger logger = LoggerFactory.getLogger(NXWebServiceImpl.class);

    @Autowired
    private UserService userService;

    @Autowired
    private LoginLogService loginLogService;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private UserDao userDao;

    @Autowired
    private RegisterpersonService registerpersonService;


    @Value("${message-code-timeout}")
    private int messageCodeTimeout = 2;

    @Value("${login-timeout}")
    private int loginTimeout = 10;

    @Value("${JWT_SECRET}")
    public String JWT_SECRET = ""; //私钥

    @Value("${BLB_PARTY}")
    public String BLB_PARTY ="ARS-NC";
    /**
     * @Author: wangcy
     * @Description:单点登录验证
     * @Date: 2018/03/27 0027 15:22
     */
    @Override
    public AjaxResult verifySX(String phone, String key,HttpServletRequest request) {
        AjaxResult ajaxResult = new AjaxResult();
        try {
            //成功
            if ("BCXIN-ARS-NX-640000".equals(DES3.decode(key))) {
                    //查询是否存在sql中 不存在添加
                    User user = new User();
                    user.setPhone(phone);
                    List<User> data = userDao.searchByDto(user);

                    //如果不存在该用户 帮其注册
                    if (data.size() == 0) {
                        //注册
                        AjaxResult userAjaxResult = registerpersonService.SXNWregister(user);
                        //注册失败
                        if (!userAjaxResult.isSuccessful()) {
                            ajaxResult.setState(Constants.STATUS_ERROR);
                            ajaxResult.setMsg("注册失败");
                            throw new ArsException("注册失败！");
                        }
                        //如果自动注册则设置手机号码后六位
                        user.setPassword(phone.substring(phone.length() - 6,phone.length()));
                    } else {
                        //获取已经存在的用户信息
                        user = data.get(0);
                    }
                    //登录
                    AjaxResult loginAjaxResult = new AjaxResult();
                    try {
                        loginAjaxResult = webLogin(user.getUsername(), user.getPassword(),request);
                    } catch (Exception e) {
                        //登录失败
                        logger.error(e.getMessage(), e);
                        ajaxResult.setState(Constants.STATUS_ERROR);
                        ajaxResult.setSuccessful(false);
                        ajaxResult.setMsg("登录失败");
                    }
                    if (!loginAjaxResult.isSuccessful()) {
                        ajaxResult.setState(Constants.STATUS_ERROR);
                        ajaxResult.setMsg("登录失败");
                        ajaxResult.setSuccessful(false);
                        throw new ArsException("登录失败！");
                    }
                    //验证成功，登录成功
                    ajaxResult.setState(Constants.STATUS_SUCCESS);
                    ajaxResult.setSuccessful(true);
                //验证失败
            } else {
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("验证失败");
            }
        }catch (Exception e){
            ajaxResult.setState(Constants.STATUS_ERROR);
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("验证失败");
        }

        return ajaxResult;
    }

    /**
    * @Author: wangcy
    * @Description:登录
    * @Date: 2018/03/28 0028 10:31
    */
    public AjaxResult webLogin(String username, String password,HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password);
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            token.setHost(String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg("用户名/密码错误");
            }
            //判断是否登录成功！
            if(currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = userService.findByUsername(username,String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
                System.out.println("当前登录用户是：" + user.getUsername());
                //更新一下登陆状态
                user.setLoginstate(1);
                //登录次数+1
                if (user.getLoginNum() != null) {
                    user.setLoginNum(user.getLoginNum() + 1);
                } else {
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                //sessionID
                user.setSessionId(session.getId().toString());
                //设置超时时间
                arsUtil.setCurrentUser(user, 1000 * 120 * loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
            }
        } catch (UnknownAccountException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (IncorrectCredentialsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (ExcessiveAttemptsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("登录失败多次，账户锁定10分钟");
        } catch (AuthenticationException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
