package com.bcxin.ars.service.msg.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.msg.NewsCompanyRelationshipDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.msg.NewsCompanyRelationship;
import com.bcxin.ars.service.msg.NewsCompanyRelationshipService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = NewsCompanyRelationship.class)
@DataSyncOutAnnotation(getClazz = NewsCompanyRelationship.class)
public class NewsCompanyRelationshipServiceImpl implements NewsCompanyRelationshipService {


	Logger logger = LoggerFactory.getLogger(NewsCompanyRelationshipServiceImpl.class);
	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private NewsCompanyRelationshipDao newsCompanyRelationshipDao;


	@Override
	public List<NewsCompanyRelationship> findDSOutList(String startDate) {
		return newsCompanyRelationshipDao.searchFromInToOutForExport(startDate);
	}

	@Override
	public void saveOrUpdateForImport(NewsCompanyRelationship newsCompanyRelationship) {
		try {
			newsCompanyRelationship.setUpdateflag(false);
			NewsCompanyRelationship dbNewsCompanyRelationship = newsCompanyRelationshipDao.findById(newsCompanyRelationship.getId());
			if(dbNewsCompanyRelationship == null){
				newsCompanyRelationship.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, newsCompanyRelationship.getUpdateTime(), 1));
				newsCompanyRelationshipDao.saveForDS(newsCompanyRelationship);
			}else{
				if(newsCompanyRelationship.getUpdateTime().getTime() > dbNewsCompanyRelationship.getUpdateTime().getTime()){
					newsCompanyRelationship.setUpdateTime(DateUtil.dateAdd2(DateUtil.DATATYPE_SECOND, newsCompanyRelationship.getUpdateTime(), 1));
					newsCompanyRelationshipDao.updateForDS(newsCompanyRelationship);
				}
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	@Override
	public List<NewsCompanyRelationship> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return newsCompanyRelationshipDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(NewsCompanyRelationship newsCompanyRelationship) {
		newsCompanyRelationship.setUpdateflag(false);
		if(newsCompanyRelationship.getActive() == null){
			newsCompanyRelationship.setActive(true);
		}
		//和数据进行比较有就更新无就创建
		NewsCompanyRelationship dbnewsCompanyRelationship = newsCompanyRelationshipDao.findById(newsCompanyRelationship.getId());
		if (dbnewsCompanyRelationship != null) {
			if(newsCompanyRelationship.getUpdateTime().getTime() > dbnewsCompanyRelationship.getUpdateTime().getTime()){
				newsCompanyRelationshipDao.updateForDS(newsCompanyRelationship);
			}
		} /*else {
			newsCompanyRelationshipDao.saveForDS(newsCompanyRelationship);
		}*/
	}

	@Override
	public void importBatch(List<NewsCompanyRelationship> list) {
		List<NewsCompanyRelationship> dbList = newsCompanyRelationshipDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);

		if (list.size()>0){
			for(NewsCompanyRelationship detail:list){
				detail.setUpdateflag(false);
				try {
					detail.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
				}catch (Exception e){
					logger.error(e.getMessage(),e);
				}
			}
			//批量保存
			newsCompanyRelationshipDao.saveBatch(list);
		}
	}
}
