package com.bcxin.ars.service.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.xjd.XjdRepayDao;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.XjdOrderService;
import com.bcxin.ars.util.HttpGetByJson;
import com.bcxin.ars.xjd.ResultLoan;
import com.bcxin.ars.xjd.ResultRepay;
import com.bcxin.ars.xjd.XjdOrderSearchDto;
import com.bcxin.ars.xjd.XjdRepay;

@Service
@Transactional
public class XjdOrderServiceImpl implements XjdOrderService {

	@Value("${XJD_QUERY_URL}")
	private String XJD_QUERY_URL;

	@Autowired
	private UserService userService;
	
	@Autowired
	private XjdRepayDao xjdRepayDao;
	
	@Override
	public void autoGetXjdOrder() throws Exception {
		
//		XjdOrderSearchDto searchDto = new XjdOrderSearchDto();
//		searchDto.setPage("1");
//		searchDto.setUserId("100679949");
//		String params = JSONObject.toJSON(searchDto).toString();;
//		String resultjson = HttpGetByJson.sendPostRequest(XJD_QUERY_URL, params);
////		{"respCode":"1000","respMsg":"[0xe6][0x88][0x90][0xe5][0x8a][0x9f].","data":{"hasNextPage":true,"repayList":[{"applyDays":7,"audiTime":1449587280000,"applyAmount":0.0,"status":"10"},{"applyDays":7,"audiTime":null,"applyAmount":500.0,"status":"7"},{"applyDays":7,"audiTime":null,"applyAmount":500.0,"status":"6"},{"applyDays":7,"audiTime":null,"applyAmount":500.0,"status":"6"},{"applyDays":7,"audiTime":null,"applyAmount":500.0,"status":"7"},{"applyDays":7,"audiTime":null,"applyAmount":500.0,"status":"10"},{"applyDays":7,"audiTime":null,"applyAmount":500.0,"status":"6"},{"applyDays":7,"audiTime":null,"applyAmount":500.0,"status":"6"},{"applyDays":7,"audiTime":null,"applyAmount":500.0,"status":"6"},{"applyDays":7,"audiTime":null,"applyAmount":500.0,"status":"6"}]},"userEncrypt":false}"
//
//		System.out.println(resultjson);
//		
//		ResultRepay resultRepay = JSONObject.parseObject(resultjson, ResultRepay.class);
//		
//		if(resultRepay != null && resultRepay.getData() != null && resultRepay.getData().getRepayList() != null  && resultRepay.getData().getRepayList().size() > 0 ) {
//			xjdRepayDao.deleteByUserId("100679949");
//			List<XjdRepay> repayList = resultRepay.getData().getRepayList();
//			for (XjdRepay xjdRepay : repayList) {
//				xjdRepay.setActive(true);
//				xjdRepay.setUserId("100679949");
//				xjdRepay.setCreateTime(new Date());
//				xjdRepay.setUpdateTime(new Date());
//				xjdRepayDao.save(xjdRepay);
//			}
//		}
//		System.out.println(resultjson);
		
		List<User> users = userService.findXjdUserList();
		XjdOrderSearchDto searchDto = new XjdOrderSearchDto();
		searchDto.setPage("1");
		for (User user : users) {
			searchDto.setUserId(user.getXjdUserId());
			String params = JSONObject.toJSON(searchDto).toString();;
			String resultjson = HttpGetByJson.sendPostRequest(XJD_QUERY_URL, params);
			System.out.println(resultjson);
			ResultRepay resultRepay = JSONObject.parseObject(resultjson, ResultRepay.class);
			
			if(resultRepay != null && resultRepay.getData() != null && resultRepay.getData().getRepayList() != null  && resultRepay.getData().getRepayList().size() > 0 ) {
				xjdRepayDao.deleteByUserId(user.getId().toString());
				List<XjdRepay> repayList = resultRepay.getData().getRepayList();
				for (XjdRepay xjdRepay : repayList) {
					xjdRepay.setActive(true);
					xjdRepay.setUserId(user.getId().toString());
					xjdRepay.setXjdUserId(user.getXjdUserId());
					xjdRepay.setCreateTime(new Date());
					xjdRepay.setUpdateTime(new Date());
					xjdRepayDao.save(xjdRepay);
				}
			}
		}
	}
}
