package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SbSubsidiaryBaseDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbSubsidiaryBaseSearchDto;
import com.bcxin.ars.model.SbSubsidiaryBase;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SbSubsidiaryBaseService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.webservice.ClientUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SbSubsidiaryBase.class)
public class SbSubsidiaryBaseServiceImpl implements SbSubsidiaryBaseService {

    @Autowired
    private SbSubsidiaryBaseDao sbSubsidiaryBaseDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private SecurityPersonDao personDao;
    
    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private  ClientUtil clientUtil;

    /**
     * 保存或更新
     *
     * @param sbSubsidiaryBase
     */
    @Override
    public void saveOrUpdate(SbSubsidiaryBase sbSubsidiaryBase) {
    	User currentUser = arsUtil.getCurrentUser();
        //判断是否存在，如果存在则为更新否则为保存
        SbSubsidiaryBase dbSbSubsidiaryBase = sbSubsidiaryBaseDao.findById(sbSubsidiaryBase.getId());
        if (dbSbSubsidiaryBase != null) {
            //设置修改时间
            dbSbSubsidiaryBase.setUpdateTime(new Date());
            //设置修改者
            dbSbSubsidiaryBase.setUpdateBy(currentUser.getUsername());
            //如果不为空，则更新相应字段的值
            /*if(!StringUtils.isEmpty(sbSubsidiaryBase.getCode())) {
                dbSbSubsidiaryBase.setCode(sbSubsidiaryBase.getCode());
			}*/
            if (!StringUtils.isEmpty(sbSubsidiaryBase.getCompanyName())) {
                dbSbSubsidiaryBase.setCompanyName(sbSubsidiaryBase.getCompanyName());
            }
            if (!StringUtils.isEmpty(sbSubsidiaryBase.getBusinessPlace())) {
                dbSbSubsidiaryBase.setBusinessPlace(sbSubsidiaryBase.getBusinessPlace());
            }
            if (!StringUtils.isEmpty(sbSubsidiaryBase.getFilingAuthorityCode())) {
                dbSbSubsidiaryBase.setFilingAuthorityCode(sbSubsidiaryBase.getFilingAuthorityCode());
            }
            if (!StringUtils.isEmpty(sbSubsidiaryBase.getFilingAuthorityName())) {
                dbSbSubsidiaryBase.setFilingAuthorityName(sbSubsidiaryBase.getFilingAuthorityName());
            }
            if (!StringUtils.isEmpty(sbSubsidiaryBase.getFilingAuthorityDate())) {
                dbSbSubsidiaryBase.setFilingAuthorityDate(sbSubsidiaryBase.getFilingAuthorityDate());
            }
            /*if(!StringUtils.isEmpty(sbSubsidiaryBase.getMoneyPrincipal())) {
                dbSbSubsidiaryBase.setMoneyPrincipal(sbSubsidiaryBase.getMoneyPrincipal());
			}
			if(!StringUtils.isEmpty(sbSubsidiaryBase.getMoneyPrincipalId())) {
				dbSbSubsidiaryBase.setMoneyPrincipalId(sbSubsidiaryBase.getMoneyPrincipalId());
			}
			if(!StringUtils.isEmpty(sbSubsidiaryBase.getMoneyPrincipalPhone())) {
				dbSbSubsidiaryBase.setMoneyPrincipalPhone(sbSubsidiaryBase.getMoneyPrincipalPhone());
			}*/
            if (!StringUtils.isEmpty(sbSubsidiaryBase.getRegisterAddress())) {
                dbSbSubsidiaryBase.setRegisterAddress(sbSubsidiaryBase.getRegisterAddress());
            }

            dbSbSubsidiaryBase.setCode(sbSubsidiaryBase.getCode());
            dbSbSubsidiaryBase.setMoneyPrincipal(sbSubsidiaryBase.getMoneyPrincipal());
            dbSbSubsidiaryBase.setMoneyPrincipalId(sbSubsidiaryBase.getMoneyPrincipalId());
            dbSbSubsidiaryBase.setMoneyPrincipalPhone(sbSubsidiaryBase.getMoneyPrincipalPhone());

            sbSubsidiaryBaseDao.update(dbSbSubsidiaryBase);

        } else {
        	if(sbSubsidiaryBase.getUserid() == null){
        		sbSubsidiaryBase.setUserid(currentUser.getId());
        	}
            //修改时间，创建时间在保存的时候一样
            sbSubsidiaryBase.setCreateTime(new Date());
            sbSubsidiaryBase.setUpdateTime(sbSubsidiaryBase.getCreateTime());
            //默认可用
            sbSubsidiaryBase.setActive(true);
            sbSubsidiaryBase.setUpdateBy(currentUser.getUsername());
            sbSubsidiaryBaseDao.save(sbSubsidiaryBase);
           /* //调用webService服务
            new Thread(()->{ //异步处理
            	try {
            		buildWebServiceEntity(sbSubsidiaryBase);
            		
            	} catch(Exception e) {
            		e.printStackTrace();
            	}
            }).start();*/
        }
    }

    /**
     * 删除
     *
     * @param sbSubsidiaryBase
     */
    @Override
    public void delete(SbSubsidiaryBase sbSubsidiaryBase) {
        sbSubsidiaryBase.setUpdateTime(new Date());
        sbSubsidiaryBaseDao.delete(sbSubsidiaryBase);
    }

    /**
     * 根据ID查询
     *
     * @param id
     * @return
     */
    @Override
    public SbSubsidiaryBase findById(long id) {
        return sbSubsidiaryBaseDao.findById(id);
    }


    /**
     * 查询
     *
     * @param dto
     * @return
     */
    @Override
    public SbSubsidiaryBaseSearchDto search(SbSubsidiaryBaseSearchDto dto) {
        SbSubsidiaryBaseSearchDto resultDto = new SbSubsidiaryBaseSearchDto();
        List<SbSubsidiaryBase> list = sbSubsidiaryBaseDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(sbSubsidiaryBaseDao.count(dto));
        return resultDto;
    }

    @Override
    public List<SbSubsidiaryBase> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return sbSubsidiaryBaseDao.searchForDataSynchronization(searchDto);
    }

    @Override
    public void saveOrUpdateForDS(SbSubsidiaryBase sbSubsidiaryBase) {

        if (sbSubsidiaryBase.getActive() == null) {
            sbSubsidiaryBase.setActive(true);
        }

        if (!sbSubsidiaryBase.getActive()) {
            sbSubsidiaryBaseDao.delete(sbSubsidiaryBase);
        } else {
            SbSubsidiaryBase dbSbSubsidiaryBase = sbSubsidiaryBaseDao.findById(sbSubsidiaryBase.getId());
            if (dbSbSubsidiaryBase == null) {
                sbSubsidiaryBaseDao.saveForDS(sbSubsidiaryBase);
            } else {
                if (sbSubsidiaryBase.getUpdateTime().getTime() > dbSbSubsidiaryBase.getUpdateTime().getTime()) {
                    sbSubsidiaryBaseDao.update(sbSubsidiaryBase);
                }
            }
        }
    }


}


