package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SbRewardDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbRewardSearchDto;
import com.bcxin.ars.model.SbReward;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SbRewardService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.Babzjl;
import com.bcxin.ars.webservice.ClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SbReward.class)
public class SbRewardServiceImpl implements SbRewardService {
	private static Logger logger = LoggerFactory.getLogger(SbRewardServiceImpl.class);
	@Autowired
	private SbRewardDao sbRewardDao;

	@Autowired
	private SecurityPersonDao securityPersonDao;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ClientUtil clientUtil;
	/**
	 * 保存或更新
	 * @param sbReward
	 */
	@Override
	public void saveOrUpdate(SbReward sbReward) {
        User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存
		SbReward dbSbReward = sbRewardDao.findById(sbReward.getId());
		//如果不为空，则更新相应字段的值
		if(dbSbReward != null) {
			if(!StringUtils.isEmpty(sbReward.getDepartname())) {
				dbSbReward.setDepartname(sbReward.getDepartname());
			}
			if(!StringUtils.isEmpty(sbReward.getEmployeeid())) {
				dbSbReward.setEmployeeid(sbReward.getEmployeeid());
			}
			if(!StringUtils.isEmpty(sbReward.getIdNumber())) {
				dbSbReward.setIdNumber(sbReward.getIdNumber());
			}
			if(!StringUtils.isEmpty(sbReward.getName())) {
				dbSbReward.setName(sbReward.getName());
			}
			if(!StringUtils.isEmpty(sbReward.getRemarks())) {
				dbSbReward.setRemarks(sbReward.getRemarks());
			}

			if(!StringUtils.isEmpty(sbReward.getRewardContext())) {
				dbSbReward.setRewardContext(sbReward.getRewardContext());
			}
			if(!StringUtils.isEmpty(sbReward.getRewardDate())) {
				dbSbReward.setRewardDate(sbReward.getRewardDate());
			}
			if(!StringUtils.isEmpty(sbReward.getRewardReason())) {
				dbSbReward.setRewardReason(sbReward.getRewardReason());
			}

			dbSbReward.setIsByPolice(sbReward.getIsByPolice());
			dbSbReward.setRewardCompany(sbReward.getRewardCompany());

            //设置修改时间
			dbSbReward.setUpdateTime(new Date());
			//设置修改者
			dbSbReward.setUpdateBy(user.getRealname());
			sbRewardDao.update(dbSbReward);
		}else{
			if(user.getPlatform()==2){
				sbReward.setUserid(user.getId());
			}
			//修改时间，创建时间在保存的时候一样
			sbReward.setCreateTime(new Date());
			sbReward.setUpdateTime(sbReward.getCreateTime());
			//默认可用
			sbReward.setActive(true);
			sbReward.setUpdateBy(user.getUsername());
			sbRewardDao.save(sbReward);


		}
		}


	/**
	 * 删除
	 * @param sbReward
	 */
	@Override
	public void delete(SbReward sbReward) {
		sbReward.setUpdateTime(new Date());
		sbRewardDao.delete(sbReward);
	}

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	@Override
	public SbReward findById(long id){
		return sbRewardDao.findById(id);
	}


	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public SbRewardSearchDto search(SbRewardSearchDto dto) {
		SbRewardSearchDto resultDto = new SbRewardSearchDto();
		List<SbReward> list =  sbRewardDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(sbRewardDao.count(dto));
		return resultDto;
	}

	@Override
	public List<SbReward> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return sbRewardDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(SbReward sbReward) {

		if(sbReward.getActive() == null){
			sbReward.setActive(true);
		}
		
		if(!sbReward.getActive()){
			sbRewardDao.delete(sbReward);
		}else{
			SbReward dbSbReward = sbRewardDao.findById(sbReward.getId());
			if(dbSbReward == null){
				sbRewardDao.saveForDS(sbReward);
				/**********************************部级上报开始 start**************************************************************************/
				//部级接口对接
				new Thread(()->{ //异步处理
					try {
						//确定对接的属性对应关系
						//key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
						String[] key={"bjldxlb"};
						String[] value={"4"}; // 4：保安员
						//源实体类的列，目标实体类的列
						sbReward.setIdNumber("12222111111112222");
						sbReward.setRewardDate(sbReward.getRewardDate().replaceAll("-",""));
						String[] srccol = {"idNumber","rewardcontext","rewardDate","rewardcompany"};
						String[] desccol = {"bjldxbm","jlsj","jlrq","jldwmc"};
						//生成实体
						Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,sbReward,new Babzjl(),key,value);
						Babzjl babzjlxx =(Babzjl)desc;
		/*			babzjlxx.setBjldxlb("4");
					babzjlxx.setBjldxbm("12222111111112222");
					babzjlxx.setJlrq(sbReward.getRewardDate().replaceAll("-",""));*/
						//调用send方法完成对接
						clientUtil.send(Constants.XXBA_BABZJLXX,babzjlxx);
					} catch(Exception e) {
						logger.error(e.getMessage(),e);
					}
				}).start();
				/**********************************部级上报结束 end **************************************************************************/
			}else{
				if(sbReward.getUpdateTime().getTime() > dbSbReward.getUpdateTime().getTime()){
					sbRewardDao.update(sbReward);
				}
			}
		}
	}

	@Override
	public void saveOrUpdateForSAAS(List<SbReward> sbRewardList) {

		User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存
		if(null!=sbRewardList&&null!=sbRewardList.get(0)){
			List<SbReward>  dbSbRewardList = sbRewardDao.findByAwardId(sbRewardList.get(0).getAwardId());
			//如果不为空，则更新相应字段的值
			if(null!=dbSbRewardList&&dbSbRewardList.size()>0) {
				sbRewardDao.deleteByawardId(sbRewardList.get(0).getAwardId());
			}
		}
		for (SbReward sbReward: sbRewardList) {
			if(user.getPlatform()==2){
				sbReward.setUserid(user.getId());
			}
			//修改时间，创建时间在保存的时候一样
			sbReward.setCreateTime(new Date());
			sbReward.setUpdateTime(sbReward.getCreateTime());
			//默认可用
			sbReward.setActive(true);
			sbReward.setUpdateBy(user.getUsername());
			sbRewardDao.save(sbReward);
		}

	}

	@Override
	public List<SbReward> findByAwardId(Long awardId) {
		return sbRewardDao.findByAwardId(awardId);
	}

	@Override
	public void deleteByawardId(Long awardId) {
		sbRewardDao.deleteByawardId(awardId);
	}
}


