package com.bcxin.ars.service.impl;


import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SbBusinessOutsideManagementDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbBusinessOutsideManagementSearchDto;
import com.bcxin.ars.model.*;
import com.bcxin.ars.service.SbBusinessOutsideManagementService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.CodeChangeUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Hwjyxx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SbBusinessOutsideManagement.class)
public class SbBusinessOutsideManagementServiceImpl implements SbBusinessOutsideManagementService {


	private static Logger logger = LoggerFactory.getLogger(SbBusinessOutsideManagementServiceImpl.class);
	@Autowired
	private SbBusinessOutsideManagementDao sbBusinessOutsideManagementDao;

	@Autowired
	private SecurityCompanyDao securityCompanyDao;
	@Autowired
	private SecurityPersonDao securityPersonDao;


	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ClientUtil clientUtil;


	@Autowired
	private IdGeneratorUtil idGeneratorUtil;


	@Autowired
	private UserDao userDao;
	/**
	 * 保存或更新
	 * @param sbBusinessOutsideManagement
	 */
	@Override
	public void saveOrUpdate(SbBusinessOutsideManagement sbBusinessOutsideManagement) {
        User user = arsUtil.getCurrentUser();
		//2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
		if((null!=sbBusinessOutsideManagement.getSecurityScope() && !sbBusinessOutsideManagement.getSecurityScope().contains("20"))||null == sbBusinessOutsideManagement.getSecurityScope()){
			sbBusinessOutsideManagement.setOtherSecScopeType(null);
		}
		//判断是否存在，如果存在则为更新否则为保存
		SbBusinessOutsideManagement dbSbBusinessOutsideManagement = sbBusinessOutsideManagementDao.findById(sbBusinessOutsideManagement.getId());
		if(dbSbBusinessOutsideManagement != null) {
			//设置修改时间
			dbSbBusinessOutsideManagement.setUpdateTime(new Date());
			//设置修改者
			dbSbBusinessOutsideManagement.setUpdateBy(user.getRealname());
			BeanUtils.copyPropertiesIgnore(sbBusinessOutsideManagement,dbSbBusinessOutsideManagement,true);

			dbSbBusinessOutsideManagement.setOtherSecScopeType(sbBusinessOutsideManagement.getOtherSecScopeType());
			sbBusinessOutsideManagementDao.update(dbSbBusinessOutsideManagement);

		}else{
			if(user.getPlatform()==2){
				sbBusinessOutsideManagement.setUserid(user.getId());
			}
            //修改时间，创建时间在保存的时候一样
			sbBusinessOutsideManagement.setCreateTime(new Date());
			sbBusinessOutsideManagement.setUpdateTime(sbBusinessOutsideManagement.getCreateTime());
			//默认可用
			sbBusinessOutsideManagement.setActive(true);
			sbBusinessOutsideManagement.setUpdateBy(user.getUsername());
			if (sbBusinessOutsideManagement.getId()==null){
				sbBusinessOutsideManagement.setId(idGeneratorUtil.createID());
			}
			sbBusinessOutsideManagementDao.saveById(sbBusinessOutsideManagement);



		}
		}

	/**
	 * 删除
	 * @param sbBusinessOutsideManagement
	 */
	@Override
	public void delete(SbBusinessOutsideManagement sbBusinessOutsideManagement) {
		sbBusinessOutsideManagement.setUpdateTime(new Date());
		sbBusinessOutsideManagementDao.delete(sbBusinessOutsideManagement);
	}

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	@Override
	public SbBusinessOutsideManagement findById(long id){
		return sbBusinessOutsideManagementDao.findById(id);
	}



	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public SbBusinessOutsideManagementSearchDto search(SbBusinessOutsideManagementSearchDto dto) {
		SbBusinessOutsideManagementSearchDto resultDto = new SbBusinessOutsideManagementSearchDto();
		List<SbBusinessOutsideManagement> list =  sbBusinessOutsideManagementDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(sbBusinessOutsideManagementDao.count(dto));
		return resultDto;
	}

	@Override
	public List<SbBusinessOutsideManagement> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return sbBusinessOutsideManagementDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(SbBusinessOutsideManagement sbBusinessOutsideManagement) {

		if(sbBusinessOutsideManagement.getActive() == null){
			sbBusinessOutsideManagement.setActive(true);
		}
		
		if(!sbBusinessOutsideManagement.getActive()){
			sbBusinessOutsideManagementDao.delete(sbBusinessOutsideManagement);
		}else{
			SbBusinessOutsideManagement dbSbBusinessOutsideManagement = sbBusinessOutsideManagementDao.findById(sbBusinessOutsideManagement.getId());
			if(dbSbBusinessOutsideManagement == null){
				sbBusinessOutsideManagementDao.saveForDS(sbBusinessOutsideManagement);

				/**********************************部级上报开始 start**************************************************************************/
				User user  = 	userDao.findById(sbBusinessOutsideManagement.getUserid());

				SecurityCompany securityCompany = securityCompanyDao.findByUserid(user.getId());
				//部级接口对接
				new Thread(()->{ //异步处理
					try {
						//确定对接的属性对应关系
						//key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
						String[] key={"bagsmc","bagsbm","gj"};
						//TODO 部级接口
						String[] value={user.getRealname(),securityCompany.getCompanyCode(),sbBusinessOutsideManagement.getNational()};
						//源实体类的列，目标实体类的列
						sbBusinessOutsideManagement.setNational(CodeChangeUtil.getValue(sbBusinessOutsideManagement.getNational()));
						String[] srccol = {"national","securityType","businessModel","businessStartTime","businessEndTime","filingAuthorityName","filingAuthorityDate"};
						String[] desccol = {"gj","fwlx","jyms","jyksrq","jyjsrq","bajgmc","barq"};
						//生成实体
						Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,sbBusinessOutsideManagement,new Hwjyxx(),key,value);
						Hwjyxx hwjyxx =(Hwjyxx)desc;
						//调用send方法完成对接
						clientUtil.send(Constants.XXBA_HWJYXX,hwjyxx);
					} catch(Exception e) {
						logger.error(e.getMessage(),e);
					}
				}).start();
				/**********************************部级上报结束 end **************************************************************************/
			}else{
				if(sbBusinessOutsideManagement.getUpdateTime().getTime() > dbSbBusinessOutsideManagement.getUpdateTime().getTime()){
					sbBusinessOutsideManagementDao.update(sbBusinessOutsideManagement);
				}
			}
		}
	}
}


