package com.bcxin.ars.service.impl;


import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SbBusinessManagementDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbBusinessManagementSearchDto;
import com.bcxin.ars.model.SbBusinessManagement;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SbBusinessManagementService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.webservice.ClientUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = SbBusinessManagement.class)
public class SbBusinessManagementServiceImpl implements SbBusinessManagementService {

	@Autowired
	private SbBusinessManagementDao sbBusinessManagementDao;

	@Autowired
	private SecurityCompanyDao securityCompanyDao;

	@Autowired
	private SecurityPersonDao securityPersonDao;


	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ClientUtil clientUtil;
	@Autowired
	private IdGeneratorUtil idGeneratorUtil;
	/**
	 * 保存或更新
	 * @param sbBusinessManagement
	 */
	@Override
	public void saveOrUpdate(SbBusinessManagement sbBusinessManagement) {
        User user = arsUtil.getCurrentUser();
		//2018年8月22日17:28:43 wjb 如果不包含其他，则其他的名称设为空
		if((null!=sbBusinessManagement.getSecurityScope() && !sbBusinessManagement.getSecurityScope().contains("20"))||null == sbBusinessManagement.getSecurityScope()){
			sbBusinessManagement.setOtherSecScopeType(null);
		}
		//判断是否存在，如果存在则为更新否则为保存
		SbBusinessManagement dbSbBusinessManagement = sbBusinessManagementDao.findById(sbBusinessManagement.getId());
		if(dbSbBusinessManagement != null) {
			//设置修改时间
			dbSbBusinessManagement.setUpdateTime(new Date());
			//设置修改者
			dbSbBusinessManagement.setUpdateBy(user.getRealname());

			BeanUtils.copyPropertiesIgnore(sbBusinessManagement,dbSbBusinessManagement,true);

			if(!StringUtils.isEmpty(sbBusinessManagement.getCrossCityBusinessProvince())) {
				dbSbBusinessManagement.setCrossCityBusinessProvince(sbBusinessManagement.getCrossCityBusinessProvince());
				if(sbBusinessManagement.getCrossCityBusinessProvince().equals("台湾省")){
					dbSbBusinessManagement.setCrossCityBusinessCity("");
					dbSbBusinessManagement.setCrossCityBusinessCounty("");
				}else if(sbBusinessManagement.getCrossCityBusinessProvince().equals("香港特别行政区")||sbBusinessManagement.getCrossCityBusinessProvince().equals("澳门特别行政区")){
					dbSbBusinessManagement.setCrossCityBusinessCounty("");
					dbSbBusinessManagement.setCrossCityBusinessCity(sbBusinessManagement.getCrossCityBusinessCity());
				}
				else{
					if(!StringUtils.isEmpty(sbBusinessManagement.getCrossCityBusinessCity())) {
						dbSbBusinessManagement.setCrossCityBusinessCity(sbBusinessManagement.getCrossCityBusinessCity());
					}
					if(!StringUtils.isEmpty(sbBusinessManagement.getCrossCityBusinessCounty())) {
						dbSbBusinessManagement.setCrossCityBusinessCounty(sbBusinessManagement.getCrossCityBusinessCounty());
					}
				}
			}

			sbBusinessManagementDao.update(dbSbBusinessManagement);
		}else{
			if(user.getPlatform()==2){
				sbBusinessManagement.setUserid(user.getId());
			}
			//修改时间，创建时间在保存的时候一样
			sbBusinessManagement.setCreateTime(new Date());
			sbBusinessManagement.setUpdateTime(sbBusinessManagement.getCreateTime());
			//默认可用
			sbBusinessManagement.setActive(true);
			sbBusinessManagement.setUpdateBy(user.getUsername());
			if (sbBusinessManagement.getId()==null){
				sbBusinessManagement.setId(idGeneratorUtil.createID());
			}
			sbBusinessManagementDao.save(sbBusinessManagement);

		}
	}

	/**
	 * 删除
	 * @param sbBusinessManagement
	 */
	@Override
	public void delete(SbBusinessManagement sbBusinessManagement) {
		sbBusinessManagement.setUpdateTime(new Date());
		sbBusinessManagementDao.delete(sbBusinessManagement);
	}

	/**
	 * 根据ID查询
	 * @param id
	 * @return
	 */
	@Override
	public SbBusinessManagement findById(long id){
		return sbBusinessManagementDao.findById(id);
	}



	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public SbBusinessManagementSearchDto search(SbBusinessManagementSearchDto dto) {
		SbBusinessManagementSearchDto resultDto = new SbBusinessManagementSearchDto();
		List<SbBusinessManagement> list =  sbBusinessManagementDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(sbBusinessManagementDao.count(dto));
		return resultDto;
	}

	@Override
	public List<SbBusinessManagement> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return sbBusinessManagementDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(SbBusinessManagement sbBusinessManagement) {

		if(sbBusinessManagement.getActive() == null){
			sbBusinessManagement.setActive(true);
		}
		
		if(!sbBusinessManagement.getActive()){
			sbBusinessManagementDao.delete(sbBusinessManagement);
		}else{
			SbBusinessManagement dbSbBusinessManagement = sbBusinessManagementDao.findById(sbBusinessManagement.getId());
			if(dbSbBusinessManagement == null){
				sbBusinessManagementDao.saveForDS(sbBusinessManagement);
			}else{
				if(sbBusinessManagement.getUpdateTime().getTime() > dbSbBusinessManagement.getUpdateTime().getTime()){
					sbBusinessManagementDao.update(sbBusinessManagement);
				}
			}
		}
	}
}


