package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dao.datasync.FileRecordDetailDao;
import com.bcxin.ars.dto.page.FilerecordPageSearchDto;
import com.bcxin.ars.dto.sb.FilerecordSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.service.FilerecordService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.EmailUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


@Service
@Transactional
//@DataSyncOutAnnotation(getClazz = Filerecord.class,getMethodName = "importBatchFilerecord")
public class FilerecordServiceImpl implements FilerecordService {

	Logger logger = LoggerFactory.getLogger(FilerecordServiceImpl.class);

	@Autowired
	private FilerecordDao filerecordDao;

	@Autowired
	private FileRecordDetailDao fileRecordDetailDao;

	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private EmailUtil emailUtil;

	/**
	 * 保存或更新
	 * @param filerecord
	 */
	@Override
	public void saveOrUpdate(Filerecord filerecord) {
			filerecordDao.save(filerecord);
		}


	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public Filerecord findById(long id){
		return filerecordDao.findById(id);
	}

	/**
	 *根据filepath查询
	 * @param filepath
	 */
	@Override
	public Filerecord findByFilepath(String filepath){
		return filerecordDao.findByFilepath(filepath);
	}


	@Override
	public void save(Filerecord filerecord) {
		filerecordDao.save(filerecord);
	}

	@Override
	public List<Filerecord> findFilerecordByTime(String startDate, String endDate) {
		return filerecordDao.findFilerecordByTime(startDate);
	}

	@Override
	public List<Filerecord> findByBatchId(List<Filerecord> filerecordList){
		return filerecordDao.findByBatchId(filerecordList);
	}
	@Override
	public void importBatchFilerecord(List<Filerecord> filerecordList){
		List<Filerecord> dbExistIDList = this.findByBatchId(filerecordList);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		filerecordList.removeAll(dbExistIDList);
		if(filerecordList.size() > 0){
			filerecordList.forEach(detail->{
				detail.setUpdateflag(false);
				try {
					/**
					 * 更新外网同步状态
					 */
					if( detail.getErrorDetailList() != null && detail.getErrorDetailList().size() > 0){
						fileRecordDetailDao.saveBatch(detail.getErrorDetailList());
						detail.getErrorDetailList().forEach(errorDetail->{
							this.sendFailEmail(errorDetail.getData(),errorDetail.getError(),detail.getFilepath());
						});
					}
				}catch (Exception e){
					logger.error(e.getMessage(),e);
				}
			});

			filerecordDao.saveBatch(filerecordList);

		}
	}

	@Override
	public FilerecordSearchDto search(FilerecordSearchDto dto) {
		FilerecordSearchDto resultDto = new FilerecordSearchDto();
		List<Filerecord> list =  filerecordDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(filerecordDao.count(dto));
		return resultDto;
	}

	@Override
	public List<Filerecord> findDSOutList(String startDate) {
		List<Filerecord> list = filerecordDao.findFilerecordByTime(startDate);
		if(configUtils.isIntranet()) {
			list.forEach(record -> {
				record.setErrorDetailList(fileRecordDetailDao.findByRecordId(record.getId()));
			});
		}
		filerecordDao.updateFlagBatch(list);
		return list;
	}

	@Override
	public void delete(Long id) {
		filerecordDao.delete(id);
	}

	private void sendFailEmail(String data,String errorMsg,String fileName){
		Config receiveUserConfig = configUtils.getConfigByKey(Constants.DATASYNC_RECEIVEUSER);
		Config currentNativeName = configUtils.getConfigByKey(Constants.CURRENT_NATIVE_NAME);
		if(receiveUserConfig != null && currentNativeName != null) {
			new Thread(()->{
				String sendHtml = Constants.DATASYNC_SENDHTML_OUT2IN.replace("{fileName}",fileName)
						.replace("{data}",data)
						.replace("{errorMsg}",errorMsg)
						.replace("{currentNativeName}", currentNativeName.getValue())
						.replace("url",configUtils.getWebHost());

				String receiveUser = receiveUserConfig.getValue();

				emailUtil.sendEmail(Constants.DATASYNC_SUBJECT, sendHtml, receiveUser);
			}).start();
		}
	}

	@Override
	public void searchForPage(FilerecordPageSearchDto dto, AjaxPageResponse page) {
		filerecordDao.searchForPage(dto,page);
	}
}


