package com.bcxin.ars.service.impl;


import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.EnrolmentLeaveBeijingDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.EnrolmentLeaveBeijingSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.EnrolmentLeaveBeijing;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComTempTask;
import com.bcxin.ars.service.EnrolmentLeaveBeijingService;

import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;

import java.util.List;

/**
 * 保安员离京登记Service业务层处理
 *
 * @author zyt
 * @date 2021-02-01
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = EnrolmentLeaveBeijing.class, getImportType = ImportType.BATCH, getMethodName = "importBatch")
public class EnrolmentLeaveBeijingServiceImpl implements EnrolmentLeaveBeijingService {

    Logger logger = LoggerFactory.getLogger(EnrolmentLeaveBeijingServiceImpl.class);

    @Autowired
    private EnrolmentLeaveBeijingDao enrolmentLeaveBeijingDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(EnrolmentLeaveBeijing enrolmentLeaveBeijing) {
        User currentUser = arsUtil.getCurrentUser();
        enrolmentLeaveBeijing.setUpdateTime(new Date());
        enrolmentLeaveBeijing.setUpdateBy(currentUser.getUsername());
        return enrolmentLeaveBeijingDao.delete(enrolmentLeaveBeijing);
    }

    @Override
    public int save(EnrolmentLeaveBeijing enrolmentLeaveBeijing) {
        User currentUser = arsUtil.getCurrentUser();
        if(enrolmentLeaveBeijing.getId() == null){
            enrolmentLeaveBeijing.setCreateTime(new Date());
        }else{
            EnrolmentLeaveBeijing dbEnrolmentLeaveBeijing = enrolmentLeaveBeijingDao.findById(enrolmentLeaveBeijing.getId());
            BeanUtils.copyPropertiesIgnore(enrolmentLeaveBeijing,dbEnrolmentLeaveBeijing,true);
            BeanUtils.copyPropertiesIgnore(dbEnrolmentLeaveBeijing,enrolmentLeaveBeijing,false);
        }

        if(Constants.PLATFORM_COMPANY == currentUser.getPlatform()){
            SecurityCompany company = securityCompanyDao.findByUserid(currentUser.getId());
            enrolmentLeaveBeijing.setComId(company.getId());
            if(StringUtil.isNotEmpty(company.getOrgId())){
                enrolmentLeaveBeijing.setOrgId(Long.parseLong(company.getOrgId()));
            }
            enrolmentLeaveBeijing.setComName(company.getName());
            enrolmentLeaveBeijing.setAreaCode(company.getAreaCode());
        }
        enrolmentLeaveBeijing.setFillerName(currentUser.getRealname());
        enrolmentLeaveBeijing.setFillerPhone(currentUser.getPhone());

        enrolmentLeaveBeijing.setActive(true);
        enrolmentLeaveBeijing.setUpdateBy(currentUser.getUsername());
        enrolmentLeaveBeijing.setUpdateTime(new Date());
        enrolmentLeaveBeijing.setUpdateflag(true);
        return enrolmentLeaveBeijingDao.save(enrolmentLeaveBeijing);
    }

    @Override
    public EnrolmentLeaveBeijing findById(Long id) {
        return enrolmentLeaveBeijingDao.findById(id);
    }

    @Override
    public void searchForPage(EnrolmentLeaveBeijingSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        User currrentUser = arsUtil.getCurrentUser();
        if(currrentUser.getPlatform() == Constants.PLATFORM_COMPANY){
            SecurityCompany company = securityCompanyDao.findByUserid(currrentUser.getId());
            dto.setComId(company.getId());
        }
        enrolmentLeaveBeijingDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<EnrolmentLeaveBeijing> list) {
        List<EnrolmentLeaveBeijing> dbList = enrolmentLeaveBeijingDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (EnrolmentLeaveBeijing enrolmentLeaveBeijing : list) {
                enrolmentLeaveBeijing.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        enrolmentLeaveBeijing.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, enrolmentLeaveBeijing.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            enrolmentLeaveBeijingDao.saveBatch(list);
        }
    }

    @Override
    public List<EnrolmentLeaveBeijing> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return enrolmentLeaveBeijingDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<EnrolmentLeaveBeijing> findDSOutList(String startDate) {
        return enrolmentLeaveBeijingDao.findDSOutList(startDate);
    }

    @Override
    public List<EnrolmentLeaveBeijing> findByBatchId(List<EnrolmentLeaveBeijing> list) {
        return enrolmentLeaveBeijingDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(EnrolmentLeaveBeijing enrolmentLeaveBeijing) {
        User currentUser = arsUtil.getCurrentUser();
        enrolmentLeaveBeijing.setUpdateTime(new Date());
        enrolmentLeaveBeijing.setUpdateBy(currentUser.getUsername());
        enrolmentLeaveBeijingDao.updateSelective(enrolmentLeaveBeijing);
    }
}
