package com.bcxin.ars.service.gxhlwWeb.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.gxhlwWebDto.AcceptDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.gxhlwWeb.GxhlwWebService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DES3;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.ars.webservice.Result;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * @author：wangcy
 * @date：2018/03/26 0026 15:22
 * @description：
 */
@Service
@Transactional
public class gxhlwWebServiceImpl implements GxhlwWebService {

    Logger logger = LoggerFactory.getLogger(gxhlwWebServiceImpl.class);

    @Autowired
    private UserService userService;

    @Autowired
    private PermissionService permissionService;

    @Autowired
    private PoliceService policeService;

    @Autowired
    private LoginLogService loginLogService;

    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private PoliceRoleService policeRoleService;

    @Autowired
    private ApprovalService approvalService;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private UserDao userDao;

    @Autowired
    private ClientUtil clientUtil;

    @Autowired
    private RegisterpersonService registerpersonService;

    @Value("${message-code-timeout}")
    private int messageCodeTimeout = 2;

    @Value("${login-timeout}")
    private int loginTimeout = 10;

    @Value("${JWT_SECRET}")
    public String JWT_SECRET = ""; //私钥

    @Value("${BLB_PARTY}")
    public String BLB_PARTY ="ARS-NC";
    /**
     * @Author: wangcy
     * @Description:单点登录验证
     * @Date: 2018/03/27 0027 15:22
     */
    @Override
    public AjaxResult verifySX(String username, String pwd,HttpServletRequest request) {
        AjaxResult ajaxResult = new AjaxResult();
        //陕西南威公司登录验证 （通信协议：WebService）
        Result result = clientUtil.verifySXNW(username,pwd);

        //成功
        if (result.getCODE().equals(Constants.MINISTRY_CODE_SUCCES_SXNW)){
            ajaxResult = JSONObject.parseObject(result.getDATE().toString(), AjaxResult.class);

            //如果为1 ，登录成功，并且返回相应的信息
            if ( ajaxResult.getState().equals(Constants.STATUS_SUCCESS)){
                AcceptDto acceptDto = JSONObject.parseObject(ajaxResult.getData().toString(), AcceptDto.class);

                //查询是否存在sql中 不存在添加
                User user = new User();
                String  a = acceptDto.getIdcardaddr() ;
                acceptDto.setIdcardaddr(null);
                user.setIdNumber(acceptDto.getIdcardaddr());
                user.setPhone(acceptDto.getMoblie());
                user.setPassword(acceptDto.getMoblie().substring(acceptDto.getMoblie().length()-6,acceptDto.getMoblie().length()));
                user.setRealname(acceptDto.getName());
                user.setUsername(acceptDto.getMoblie());
                List<User> data = userDao.searchByDto(user);

                //如果不存在该用户 帮其注册
                if (data.size()==0){
                    //注册
                    AjaxResult userAjaxResult = registerpersonService.SXNWregister(user);
                    //注册失败
                    if (!userAjaxResult.isSuccessful()){
                        ajaxResult.setState(Constants.STATUS_ERROR);
                        ajaxResult.setMsg("注册失败");
                        throw new ArsException("注册失败！");
                    }
                    //如果自动注册则设置手机号码后六位
                    user.setPassword(acceptDto.getMoblie().substring(acceptDto.getMoblie().length()-6,acceptDto.getMoblie().length()));
                }else{
                    //获取已经存在的用户信息
                    user = data.get(0);
                }
                //登录
                AjaxResult loginAjaxResult = new AjaxResult();
                try {
                    loginAjaxResult = webLogin(user.getUsername(),user.getPassword(),Constants.PLATFORM_NATURAL_PERSON, request);
                } catch (Exception e) {
                    //登录失败
                    logger.error(e.getMessage(), e);
                    ajaxResult.setState(Constants.STATUS_ERROR);
                    ajaxResult.setSuccessful(false);
                    ajaxResult.setMsg("登录失败");
                }
                if (!loginAjaxResult.isSuccessful()){
                    ajaxResult.setState(Constants.STATUS_ERROR);
                    ajaxResult.setMsg("登录失败");
                    ajaxResult.setSuccessful(false);
                    throw new ArsException("登录失败！");
                }

                //验证成功，登录成功
                ajaxResult.setState(Constants.STATUS_SUCCESS);
                ajaxResult.setSuccessful(true);
            }else {
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("账号或者密码不匹配");
            }
        //验证失败
        }else{
            ajaxResult.setState(Constants.STATUS_ERROR);
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("验证失败");
        }

        return ajaxResult;
    }

    /**
     * @Author: wangcy
     * @Description:单点登录验证
     * @Date: 2018/03/27 0027 15:22
     */
    @Override
    public AjaxResult verifyGXNW(String username, String key,HttpServletRequest request) {
        AjaxResult ajaxResult = new AjaxResult();
        try {
            //成功
            if ("BCXIN-ARS-GX-450000".equals(DES3.decode(key))) {
                //查询是否存在sql中 不存在添加
                User user = new User();
                user.setUsername(username);
                User  dbuser = userDao.find(user);
                 if(dbuser==null){
                     ajaxResult.setState(Constants.STATUS_ERROR);
                     ajaxResult.setMsg("警号用户不存在");
                     ajaxResult.setSuccessful(false);
                     throw new ArsException("登录失败！");
                 }
                //登录
                AjaxResult loginAjaxResult = new AjaxResult();
                try {
                    loginAjaxResult = webLogin(user.getUsername(), user.getPassword(),Constants.PLATFORM_POLICE, request);
                } catch (Exception e) {
                    //登录失败
                    logger.error(e.getMessage(), e);
                    ajaxResult.setState(Constants.STATUS_ERROR);
                    ajaxResult.setSuccessful(false);
                    ajaxResult.setMsg("登录失败");
                }
                if (!loginAjaxResult.isSuccessful()) {
                    ajaxResult.setState(Constants.STATUS_ERROR);
                    ajaxResult.setMsg("登录失败");
                    ajaxResult.setSuccessful(false);
                    throw new ArsException("登录失败！");
                }
                //验证成功，登录成功
                ajaxResult.setState(Constants.STATUS_SUCCESS);
                ajaxResult.setSuccessful(true);
                //验证失败
            } else {
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("验证失败");
            }
        }catch (Exception e){
            ajaxResult.setState(Constants.STATUS_ERROR);
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("验证失败");
        }
        return ajaxResult;
    }


    /**
     * 登陆
     * @param username 用户名
     * @param password 密码
     * @param platform 角色
     * @return
     * @throws Exception
     */
    public AjaxResult webLogin(String username, String password,Integer platform,HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password,Constants.SXNWCode);
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg("用户名/密码错误");
            }
            //判断是否登录成功！
            if(currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = userService.findByUsername(username,platform.toString());
                System.out.println("当前登录用户是：" + user.getUsername());
                //更新一下登陆状态
                user.setLoginstate(1);
                //登录次数+1
                if (user.getLoginNum() != null) {
                    user.setLoginNum(user.getLoginNum() + 1);
                } else {
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                //sessionID
                user.setSessionId(session.getId().toString());
                //设置超时时间
                arsUtil.setCurrentUser(user, 1000 * 120 * loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
            }
        } catch (UnknownAccountException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (IncorrectCredentialsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (ExcessiveAttemptsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("登录失败多次，账户锁定10分钟");
        } catch (AuthenticationException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
