package com.bcxin.ars.service.gx;


import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.gx.InternetPlusBusinessDao;
import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.dao.sys.SysareaDAO;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.gx.RequestDto;
import com.bcxin.ars.dto.gx.SecCompanyDto;
import com.bcxin.ars.dto.sb.LegalchangeDto;
import com.bcxin.ars.dto.sb.WorkexperienceDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.gx.InternetPlusBusiness;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.service.sb.LegalchangeService;
import com.bcxin.ars.service.sb.PerCerGrantService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.util.Date;
import java.util.List;

/**
 * 广西一体化申报请求数据Service业务层处理
 * 
 * @author lin
 * @date 2022-04-13
 */
@Service
public class InternetPlusBusinessServiceImpl implements InternetPlusBusinessService {

    Logger logger = LoggerFactory.getLogger(InternetPlusBusinessServiceImpl.class);

    @Autowired
    private InternetPlusBusinessDao internetPlusBusinessDao;

    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;

    @Autowired
    private LegalchangeService legalchangeService;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private SysareaDAO sysareaDAO;

    @Autowired
    private UserDao userDao;

    @Autowired
    private LegalchangeworkexperienceDao workexperienceDao;

    @Autowired
    private ShareholderDao shareholderDao;

    @Autowired
    private SbSponsorlicenseManagerDao sponsorlicenseManagerDao;

    @Autowired
    private SbSponsorlicenseVmanagerDao sponsorlicenseVmanagerDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    @Autowired
    private ApprovalUtil approvalUtil;

    @Autowired
    private PerCerGrantService perCerGrantService;

    @Autowired
    private SecurityCertificateDao securityCertificateDao;

    @Override
    public int delete(InternetPlusBusiness internetPlusBusiness) {
        User currentUser = arsUtil.getCurrentUser();
        internetPlusBusiness.setUpdateTime(new Date());
        internetPlusBusiness.setUpdateBy(currentUser.getUsername());
        return internetPlusBusinessDao.delete(internetPlusBusiness);
    }

    @Override
    public int save(InternetPlusBusiness internetPlusBusiness) {
        if(internetPlusBusiness.getId() == null){
            internetPlusBusiness.setCreateTime(new Date());
        }else{
            InternetPlusBusiness dbInternetPlusBusiness = internetPlusBusinessDao.findById(internetPlusBusiness.getId());
            BeanUtils.copyPropertiesIgnore(internetPlusBusiness,dbInternetPlusBusiness,true);
            BeanUtils.copyPropertiesIgnore(dbInternetPlusBusiness,internetPlusBusiness,false);
        }

        internetPlusBusiness.setActive(true);
        internetPlusBusiness.setUpdateTime(new Date());
        internetPlusBusiness.setUpdateflag(true);
        return internetPlusBusinessDao.save(internetPlusBusiness);
    }

    @Override
    public InternetPlusBusiness findById(Long id) {
        return internetPlusBusinessDao.findById(id);
    }

    @Override
    public void importBatch(List<InternetPlusBusiness> list) {
        List<InternetPlusBusiness> dbList = internetPlusBusinessDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (InternetPlusBusiness internetPlusBusiness : list) {
                internetPlusBusiness.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        internetPlusBusiness.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, internetPlusBusiness.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            internetPlusBusinessDao.saveBatch(list);
        }
    }

    @Override
    public List<InternetPlusBusiness> findDSOutList(String startDate) {
        return internetPlusBusinessDao.findDSOutList(startDate);
    }

    @Override
    public List<InternetPlusBusiness> findByBatchId(List<InternetPlusBusiness> list) {
        return internetPlusBusinessDao.findByBatchId(list);
    }
    @Override
    @Transactional
    public AjaxResult saveSponsorlicense(RequestDto requestDto) {
        try {
            if(internetPlusBusinessDao.findBySdono(requestDto.getSdono()) != null){
                throw new ArsException("业务编号已存在，请勿重复提交");
            }//若有加密 则需要先解密
            SecCompanyDto sponsorlicenseDto = JSON.parseObject(JSON.toJSONString(requestDto.getSdata()),SecCompanyDto.class);

            //判断是否有注册自然人，如果没有则自动注册一个
            User currentUser =userDao.findByUsername(requestDto.getSapptel(),String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
            if(currentUser == null){
                currentUser =  new User();
                //角色为自然人
                currentUser.setPlatform(Constants.PLATFORM_NATURAL_PERSON);
                //用户名
                currentUser.setUsername(requestDto.getSapptel());
                //手机号
                currentUser.setPhone(requestDto.getSapptel());
                //更新者
                currentUser.setUpdateBy(requestDto.getSapptel());
                //默认密码
                currentUser.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
                //姓名
                currentUser.setRealname(requestDto.getSappname());
                //默认头像
                currentUser.setPhoto("assets/images/defaultHead/male.png");
                //用户ID
                currentUser.setId(idGeneratorUtil.createID());
                currentUser.setNativeCode(45L);
                currentUser.setActive(true);
                currentUser.setCreateTime(new Date());
                currentUser.setUpdateTime(new Date());
                currentUser.setUpdateBy("system");
                userDao.save(currentUser);
            }
            //保安服务公司信息
            Sponsorlicense sponsorlicense = new Sponsorlicense();
            BeanUtils.copyPropertiesIgnore(sponsorlicenseDto,sponsorlicense);
            //区域
            sponsorlicense.setProvince(Constants.GUANGXICODE);
            if(StringUtil.isEmpty(sponsorlicense.getDistrict())){
                return AjaxResult.error("区县代码不能为空");
            }
            sponsorlicense.setCity(sponsorlicense.getDistrict().substring(0, 4)+"00");
            Police police = policeDao.findByAreaCode(sponsorlicense.getDistrict());
            if(police == null){
                return AjaxResult.error("区县代码找不到办事机构");
            }

            //办事区域
            sponsorlicense.setDistrictOrgId(police.getId().toString());
            sponsorlicense.setCityOrgId(police.getParentorg().toString());
            sponsorlicense.setOrgid(police.getId());

            //保安服务公司申报类型
            sponsorlicense.setSponsorlicenseType(Constants.SPONSORLICENSE_FW);
            //审批状态
            sponsorlicense.setApprovalstate(ApprovalState.DSH);
            //用户
            sponsorlicense.setUserid(currentUser.getId());
            try {
                //添加股东出资金额及所占比例
                Shareholder shareholder=  new Shareholder();
                //公司总经理信息
                SbSponsorlicenseManager sbSponsorlicenseManager =new SbSponsorlicenseManager();
                //公司副总经理信息
                SbSponsorlicenseVmanager sbSponsorlicenseVmanager=  new SbSponsorlicenseVmanager();
                sponsorlicense.setShareholder(shareholder);
                sponsorlicense.setSbSponsorlicenseManager(sbSponsorlicenseManager);
                sponsorlicense.setSbSponsorlicenseVmanager(sbSponsorlicenseVmanager);
            }catch (Exception e ){
                logger.error(e.getMessage(),e);
            }
            //获取附件
            try {
                if(StrUtil.isNotEmpty(sponsorlicense.getTemplateRar())) {
                    String localPath = configUtils.uploadFolder + DateUtil.getCurrentDate();
                    FileUtil.downloadFile(sponsorlicense.getTemplateRar(), localPath);
                    sponsorlicense.setTemplateRar(localPath);
                }
            } catch (Exception e) {
                logger.error("附件下载失败");
            }
            //提交申报信息
            /***
             * 根据不同的保安公司类型获取对应的key,默认为保安服务公司
             */
            String  processKey =  Constants.ACTIVITI_PROCESS_SPONSORLICENSE;
            if(StringUtil.isNotEmpty(sponsorlicense.getSponsorlicenseType())) {
                processKey =  BusinessType.getBusinessTypeName(BusinessType.BAFWGS, sponsorlicense.getSponsorlicenseType());
            }

            sponsorlicense.setUserid(currentUser.getId());
            if(!sponsorlicense.getApprovalstate().equals(Constants.APPROVALSTATE_WTJ)){
                //开发任务 #10165
                Sponsorlicense checkSponsorlicense = sponsorlicenseDao.findApproveByCompanyName(sponsorlicense.getCompanyname());
                if (checkSponsorlicense != null) {
                    throw new ArsException(sponsorlicense.getCompanyname() + "已备案，不能重复备案！");
                }
            }

            sponsorlicense.setId(idGeneratorUtil.createID());
            sponsorlicense.setActive(true);
            sponsorlicense.setCreateTime(new Date());
            sponsorlicense.setUpdateTime(new Date());
            sponsorlicense.setUpdateBy(currentUser.getUsername());
            //待审批或暂存
            sponsorlicenseDao.save(sponsorlicense);

            //保存股东出资额及所占比例
            if( sponsorlicenseDto.getShareholderList() != null){
                for (Shareholder shareholder : sponsorlicenseDto.getShareholderList()) {
                    shareholder.setId(idGeneratorUtil.createID());
                    shareholder.setActive(true);
                    shareholder.setCreateTime(new Date());
                    shareholder.setUpdateTime(new Date());
                    shareholder.setSponsorlicenseid(sponsorlicense.getId());
                    shareholderDao.save(shareholder);
                }
            }
            //保存总经理
            if( sponsorlicenseDto.getGeneralList() != null){
                for (SbSponsorlicenseManager sponsorlicenseManager : sponsorlicenseDto.getGeneralList()) {
                    sponsorlicenseManager.setId(idGeneratorUtil.createID());
                    sponsorlicenseManager.setActive(true);
                    sponsorlicenseManager.setCreateTime(new Date());
                    sponsorlicenseManager.setUpdateTime(new Date());
                    sponsorlicenseManager.setSponsorlicenseid(sponsorlicense.getId());
                    sponsorlicenseManagerDao.save(sponsorlicenseManager);
                }
            }
            //保存副总经理
            if( sponsorlicenseDto.getViceGeneralList() != null){
                for (SbSponsorlicenseVmanager sponsorlicenseVmanager : sponsorlicenseDto.getViceGeneralList()) {
                    sponsorlicenseVmanager.setId(idGeneratorUtil.createID());
                    sponsorlicenseVmanager.setActive(true);
                    sponsorlicenseVmanager.setCreateTime(new Date());
                    sponsorlicenseVmanager.setUpdateTime(new Date());
                    sponsorlicenseVmanager.setSponsorlicenseid(sponsorlicense.getId());
                    sponsorlicenseVmanagerDao.save(sponsorlicenseVmanager);
                }
            }
            approvalUtil.saveApprovalForIntegrate(BusinessType.BAFWGS, sponsorlicense.getId(),processKey,currentUser);
            requestDto.setBusinessId(sponsorlicense.getId());
            return AjaxResult.success();
        }catch (Exception e){
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return AjaxResult.error(e.getMessage());
        }finally {
            new Thread(()->{
                this.save(requestDto);
            }).start();
        }
    }

    @Override
    public void updateSelective(InternetPlusBusiness internetPlusBusiness) {
        User currentUser = arsUtil.getCurrentUser();
        internetPlusBusiness.setUpdateTime(new Date());
        internetPlusBusiness.setUpdateBy(currentUser.getUsername());
        internetPlusBusinessDao.updateSelective(internetPlusBusiness);
    }

    @Override
    @Transactional
    public AjaxResult saveLegalchange(RequestDto requestDto) {
        try {
            if(internetPlusBusinessDao.findBySdono(requestDto.getSdono()) != null){
                return AjaxResult.error("业务编号已存在，请勿重复提交");
            }
            //若有加密 则需要先解密
            // AESUtil.decrypt(requestDto.getData(),"");
            LegalchangeDto legalchangeDto = JSON.parseObject(JSON.toJSONString(requestDto.getSdata()),LegalchangeDto.class);
            SecurityCompany company = securityCompanyDao.findByName(legalchangeDto.getComName());
            if (company == null) {
                return AjaxResult.error("无法获取【" + legalchangeDto.getComName() + "】公司信息，请与客服热线400-662-9696咨询！");
            }
            Legalchange legalchange = new Legalchange();
            BeanUtils.copyPropertiesIgnore(legalchangeDto, legalchange);
//            legalchange.setId(idGeneratorUtil.createID());
            //公司名称
            legalchange.setOldcompanyname(company.getName());
            //公司地址
            legalchange.setOldaddress(company.getAddress());
            //许可证号
            legalchange.setLicencenum(company.getPublicSecurityLicenseNumber());
            //原定法人证件类型 1身份证号
            legalchange.setLegalcardtype(Constants.NDLEGALCARDTYPE_CARD);
            //拟法人证件类型 1身份证号
            legalchange.setNdlegalcardtype(Constants.NDLEGALCARDTYPE_CARD);
            //区域
            legalchange.setProvince(Constants.GUANGXICODE);
            legalchange.setCity(company.getAreaCode().substring(0, 4) + "00");
            legalchange.setDistrict(company.getAreaCode());
            //办事事项
            Police police = policeDao.findById(Long.parseLong(company.getOrgId()));
            if (police != null) {
                if (Constants.POLICE_ORGTYPE_QX.equals(police.getOrgtype())) {
                    legalchange.setOrgid(police.getId());
                    legalchange.setDistrictOrgId(police.getId().toString());
                    legalchange.setCityOrgId(police.getParentorg().toString());
                } else {
                    Police cityPolice = policeDao.findById(police.getParentorg());
                    legalchange.setOrgid(police.getId());
                    legalchange.setCityOrgId(police.getId().toString());
                    if (cityPolice != null && Constants.POLICE_ORGTYPE_QX.equals(cityPolice.getOrgtype())) {
                        legalchange.setCityOrgId(cityPolice.getId().toString());
                    }
                }
            }

            Sysarea sysarea = sysareaDAO.findByCode(company.getAreaCode());
            legalchange.setSzss(sysarea.getRegionFullName());
            //用户
            legalchange.setUserid(company.getUser().getId());
            //公司ID
            legalchange.setCompanyid(company.getId());
            //审批状态
            legalchange.setApprovalstate(ApprovalState.DSH);
            //获取附件
            try {
                if(StrUtil.isNotEmpty(legalchangeDto.getTemplateRar())) {
                    String localPath = configUtils.uploadFolder + DateUtil.getCurrentDate();
                    FileUtil.downloadFile(legalchangeDto.getTemplateRar(), localPath);
                    legalchange.setTemplateRar(localPath);
                }
            } catch (Exception e) {
                logger.error("附件下载失败");
            }
            //启动流程
            legalchangeService.saveOrUpdateForIntegrate(legalchange, company.getUser());
            requestDto.setBusinessId(legalchange.getId());
            //工作经历
            Legalchangeworkexperience legalchangeworkexperience = null;
            if (legalchangeDto.getWorkexperienceList() != null) {
                for (WorkexperienceDto workexperienceDto : legalchangeDto.getWorkexperienceList()) {
                    legalchangeworkexperience = new Legalchangeworkexperience();
                    legalchangeworkexperience.setActive(true);
                    legalchangeworkexperience.setCompanyname(workexperienceDto.getCompanyname());
                    legalchangeworkexperience.setCreateTime(new Date());
                    legalchangeworkexperience.setEnddate(workexperienceDto.getEnddate());
                    legalchangeworkexperience.setLegalchangeId(legalchange.getId());
                    legalchangeworkexperience.setPost(workexperienceDto.getPost());
                    legalchangeworkexperience.setStartdate(workexperienceDto.getStartdate());
                    legalchangeworkexperience.setUpdateTime(new Date());
                    legalchangeworkexperience.setActive(true);
                    legalchangeworkexperience.setCreateTime(new Date());
                    legalchangeworkexperience.setUpdateTime(new Date());
                    legalchangeworkexperience.setUpdateBy(company.getUser().getUsername());
                    legalchangeworkexperience.setId(idGeneratorUtil.createID());
                    workexperienceDao.save(legalchangeworkexperience);
                }
            }
            return AjaxResult.success();
        }catch (Exception e){
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return AjaxResult.error(e.getMessage());
        }finally {
            new Thread(()->{
                this.save(requestDto);
            }).start();
        }
    }
    @Override
    public AjaxResult saveCertificateVerification(RequestDto requestDto) {
        try{
            if(internetPlusBusinessDao.findBySdono(requestDto.getSdono()) != null){
                throw new ArsException("业务编号已存在，请勿重复提交");
            }
            //获取申请业务参数
            PerCerGrant perCerGrant = JSON.parseObject(JSON.toJSONString(requestDto.getSdata()),PerCerGrant.class);
            SecurityCertificate securityCertificate = securityCertificateDao.findByIdnum(perCerGrant.getIdnumber());
            //判断保安员证是否存在
            if(securityCertificate == null || StrUtil.isEmpty(securityCertificate.getAreaCode())){
                return AjaxResult.success("","保安员证不存在");
            }else {
                User currentUser = null;
                if(securityCertificate.getUserid() == null){
                    currentUser = new User();
                    //角色为自然人
                    currentUser.setPlatform(Constants.PLATFORM_NATURAL_PERSON);
                    //用户名
                    currentUser.setUsername(StrUtil.isEmpty(requestDto.getSapptel()) ? perCerGrant.getPhone():requestDto.getSapptel());
                    //手机号
                    currentUser.setPhone(StrUtil.isEmpty(requestDto.getSapptel()) ? perCerGrant.getPhone():requestDto.getSapptel());
                    //默认密码
                    currentUser.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
                    //姓名
                    currentUser.setUsername(StrUtil.isEmpty(requestDto.getSappname()) ? perCerGrant.getName():requestDto.getSappname());
                    //用户ID
                    currentUser.setId(idGeneratorUtil.createID());
                    currentUser.setNativeCode(45L);
                    currentUser.setActive(true);
                    currentUser.setCreateTime(new Date());
                    currentUser.setUpdateTime(new Date());
                    currentUser.setUpdateBy("system");
                    userDao.save(currentUser);
                }else{
                    currentUser = userDao.findById(securityCertificate.getUserid());
                }
                perCerGrant.setApprovalstate(ApprovalState.DSH);
                perCerGrant.setCreateBy("system");
                perCerGrant.setUpdateBy("system");
                perCerGrant.setUserid(currentUser.getId());
                perCerGrant.setProvince(Constants.GUANGXICODE);
                perCerGrant.setCity(securityCertificate.getAreaCode().substring(0, 4) + "00");
                perCerGrant.setDistrict(securityCertificate.getAreaCode());

                Police police = policeDao.findById(securityCertificate.getOrgId());
                if (police != null) {
                    if (Constants.POLICE_ORGTYPE_QX.equals(police.getOrgtype())) {
                        perCerGrant.setOrgid(police.getId());
                        perCerGrant.setDistrictOrgId(police.getId().toString());
                        perCerGrant.setCityOrgId(police.getParentorg().toString());
                    } else {
                        Police cityPolice = policeDao.findById(police.getParentorg());
                        perCerGrant.setOrgid(police.getId());
                        perCerGrant.setCityOrgId(police.getId().toString());
                        if (cityPolice != null && Constants.POLICE_ORGTYPE_QX.equals(cityPolice.getOrgtype())) {
                            perCerGrant.setCityOrgId(cityPolice.getId().toString());
                        }
                    }
                }

                Sysarea sysarea = sysareaDAO.findByCode(perCerGrant.getDistrict());
                perCerGrant.setSzss(sysarea.getRegionFullName());

                //获取附件
                try {
                    if(StrUtil.isNotEmpty(perCerGrant.getTemplateRar())) {
                        String localPath = configUtils.uploadFolder + DateUtil.getCurrentDate();
                        FileUtil.downloadFile(perCerGrant.getTemplateRar(), localPath);
                        perCerGrant.setTemplateRar(localPath);
                    }
                } catch (Exception e) {
                    logger.error("附件下载失败");
                }
                //启动流程
                perCerGrantService.saveOrUpdateForIntegrate(perCerGrant,currentUser);

                //保存业务数据
                requestDto.setBusinessId(perCerGrant.getId());
                return AjaxResult.success();
            }
        }catch (Exception e){
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return AjaxResult.error(e.getMessage());
        }finally {
            //业务记录保存
            new Thread(()->{
                this.save(requestDto);
            }).start();
        }
    }

}
