package com.bcxin.ars.service.gx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.dao.gx.InternetPlusBusinessDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.gx.InternetPlusBusiness;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.util.gx.HttpClientUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class InterfaceNoticeServiceImpl implements InterfaceNoticeService {
    //请求的url
    private static String url = "http://71.4.152.20/gzmhgxhlwService/gzmh/ars-rest/callback";
    /**
     * 日志
     */
    private final static Logger logger = LoggerFactory.getLogger(InterfaceNoticeServiceImpl.class);

    @Autowired
    ApprovalDAO approvalDAO;

    @Autowired
    PoliceDao policeDao;

    @Autowired
    InternetPlusBusinessDao internetPlusBusinessDao;

    @Override
    public void approvalNotice(Approval approval) {
        try {
            InternetPlusBusiness internetPlusBusiness = internetPlusBusinessDao.findByBusinessId(approval.getBusinessid());
            if (internetPlusBusiness == null) {
                return;
            }
            JSONObject jsonObject =new JSONObject();
            jsonObject.put("sdono", internetPlusBusiness.getSdono());
            //查询审批状态
            if (approval != null) {
               /*
                0-办理完成
                1-审核不通过
                2-需补齐补正*/

                if (approval.getApprovalstate().equals(ApprovalState.SHTG)) {
                    //审批通过
                    jsonObject.put("status", "0");
                } else if (approval.getApprovalstate().equals(ApprovalState.SHBTG)) {
                    //审批不通过
                    jsonObject.put("status", "1");
                }
                //审批意见
                jsonObject.put("msg", approval.getApprovalreason());
               /* //受理单位
                Police police = policeDao.findById(approval.getOrgid());
                jsonObject.put("dealUnit", police.getOrgname());
                //受理单位代码
                jsonObject.put("dealUnitCode", police.getCode());*/
                JSONObject sdata =  JSON.parseObject(internetPlusBusiness.getSData());
                //数据来源
                jsonObject.put("sjly",sdata.get("dataSource"));
                //受理人员姓名
                jsonObject.put("name", approval.getApprovalperson());
            /*    //受理人身份证号 可空
                jsonObject.put("dealPolciePid", "");
                //受理人警号 可空
                jsonObject.put("dealPoliceNo", "");*/
                //受理人员账号
                jsonObject.put("userno", approval.getUpdateBy());
                List<Object> imageList= new ArrayList<>();
                JSONObject fileName=new  JSONObject();
                fileName.put("fileName","");
                imageList.add(fileName);
                /*//受理人手机号 可空
                jsonObject.put("dealPoliceTel", "");
                //受理时间
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String updateTime = simpleDateFormat.format(approval.getUpdateTime());
                jsonObject.put("rebackDate", updateTime);*/
            }
            logger.info("审批通知请求参数：" + jsonObject);
            String result = HttpClientUtil.doPost(url, jsonObject, "UTF-8");
            logger.info("审批通知响应参数：" + result);
        } catch (Exception e) {
            logger.error("审批通知httpclient error:" + e.getMessage());
        }
    }

}
