package com.bcxin.ars.service.gx;

import cn.hutool.http.HttpUtil;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.gx.IntegratedDao;
import com.bcxin.ars.dao.gx.IntegratedLogDao;
import com.bcxin.ars.dao.sb.LegalchangeworkexperienceDao;
import com.bcxin.ars.dao.sb.SponsorlicenseDao;
import com.bcxin.ars.dao.sb.TraincompanyapplyDao;
import com.bcxin.ars.dto.gx.*;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.gx.IntegratedLog;
import com.bcxin.ars.model.gx.IntegratedResult;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.LegalchangeService;
import com.bcxin.ars.service.sb.SponsorlicenseService;
import com.bcxin.ars.service.sb.TraincompanyapplyService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.gx.IntegratedConstants;
import com.bcxin.ars.util.xml.JaxbUtil;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;

/**
 * 广西公安互联网+平台推送流水号到业务办理系统服务层
 * @author subh
 * @since jdk1.8
 * @see IntegratedService
 * @see IntegratedApplyDto
 * @see IntegratedDao
 */
@Service
public class IntegratedServiceImpl extends BaseService implements IntegratedService {


    /**
     * 日志
     */
    private final static Logger logger = LoggerFactory.getLogger(IntegratedServiceImpl.class);


    @Autowired
    private LegalchangeworkexperienceDao workexperienceDao;
    @Autowired
    private IntegratedDao integratedDao;

    @Autowired
    private IntegratedLogDao integratedLogDao;
    /**
     * 上传文件路径
     */
    @Value("${upload-folder}")
    private String uploadFolder;

    /***
     * 保安服务公司
     */
    @Autowired
    private SponsorlicenseService sponsorlicenseService;


    /***
     * 培训单位
     */
    @Autowired
    private TraincompanyapplyService traincompanyapplyService;

    /***
     * 项目变更
     */
    @Autowired
    private LegalchangeService legalchangeService;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    /***
     * 培训单位
     */
    @Autowired
    private TraincompanyapplyDao traincompanyapplyDao;

    /***
     * 保安公司
     */
    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;

    /***
     * 公安机构
     */
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ConfigUtils configUtils;
    /***
     * 用户
     */
    @Autowired
    private UserDao userDao;
    /**
     * 系统统一分配给接口使用方的身份标识，作为接口账号
     */
    @Value("${integrated-key}")
    private String integratedKey;
    /**
     * 系统统一分配给接口使用方的密钥，用于保证应用程序来源的可靠性，避免应用程序被伪造，作为接口密钥
     */
    @Value("${integrated-secret}")
    private String integratedSecret;

    /***
     * 广西公安互联网+平台接口地址
     */
    @Value("${integrated-resturl}")
    private String integratedRestURL;

    @Override
    public void save(IntegratedApplyDto dto) {
        //1.xml转换成bean
        try{
            ApproveDataInfo approveDataInfo = JaxbUtil.converyToJavaBean(dto.getXmlStr(), ApproveDataInfo.class);
            //设置流水号
            dto.setApplyNo(approveDataInfo.getSblsh_short());
            //设置事项编号
            dto.setBusinessNo(approveDataInfo.getSxbm());
        }catch (Exception e ){
            throw new ArsException("xml格式有错，无法解析！！");
        }
        if(StringUtil.isEmpty(dto.getApplyNo())){
            throw new ArsException("缺失流水号参数！！");
        }
        if(StringUtil.isEmpty(dto.getBusinessNo())){
            throw new ArsException("缺失事项编码参数！！");
        }
        //2、查询流水号是否重复
        List list =  query(dto);
        if(list!=null && list.size()>0){
            throw new ArsException("流水号重复，请不要重复提交！！");
        }
        //获取tonken
        IntegratedResult result = getToken();
        ResultXML xm = JaxbUtil.converyToJavaBean(result.getDesc(), ResultXML.class);
        if(StringUtil.isEmpty(xm.getToken())){
            throw new ArsException("获取token失败！！");
        }
       // xm.setToken("76b2c2b73c31688158b32fb2abd57818");
        String token =xm.getToken();
        String SBLSH_SHORT = dto.getApplyNo();
        String SXBM = dto.getBusinessNo();

        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        //token
        params.put("token", token);
        //请求格式，流水号和申报事项
        params.put("xmlStr", "<APPROVEDATAINFO><SBLSH_SHORT>" + SBLSH_SHORT + "</SBLSH_SHORT><SXBM>" + SXBM + "</SXBM><GDBSSPCL></GDBSSPCL></APPROVEDATAINFO>");
        String xmlStr = HttpUtil.post(integratedRestURL + IntegratedConstants.APPLYINFO, params);

        logger.error(xmlStr);
        //将报文转换成IntegratedResponse实体
        IntegratedResponse data = JaxbUtil.converyToJavaBean(xmlStr, IntegratedResponse.class);
        //判断请求是否正确
        if(!IntegratedResult.SUCCESS.equals(data.getStatus())){
            throw new ArsException("解析xml文件出错！！内容："+xmlStr);
        }
        TableCols tableCols = data.getData().getIntegratedSpshenqin().getIntegratedXML_data().getSPItemListDef().getTableCols();
        if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            tableCols.setOrgId(13L);
            tableCols.setDistrictOrgId("13");
            tableCols.setCityOrgId("1");
            tableCols.setSzss("北京北京市昌平区");
        }else {
            if(StringUtil.isEmpty(tableCols.getQuXianJi())){
                throw new ArsException("quXianJi不能为空");
            }
            Police police = policeDao.findByAreaCode(tableCols.getQuXianJi());

            if(police != null){
                if( Constants.POLICE_ORGTYPE_QX.equals(police.getOrgtype())){
                    Police cityPolice =  policeDao.findById(police.getParentorg().longValue());
                    tableCols.setOrgId(police.getId());
                    tableCols.setDistrictOrgId(police.getId().toString());
                    tableCols.setCityOrgId(police.getParentorg().toString());
                    tableCols.setSzss("广西壮族自治区"+cityPolice.getArea()+police.getArea());
                }else{
                    tableCols.setOrgId(police.getId());
                    //tableCols.setDistrictOrgId(police.getId().toString());
                    tableCols.setCityOrgId(police.getId().toString());
                    tableCols.setSzss("广西壮族自治区"+police.getArea());
                }
            }
        }
        //获取申请人信息
        IntegratedSprenyuan integratedSprenyuan = data.getData().getIntegratedSprenyuan();
        //保安服务公司
        if(IntegratedConstants.BUSINESSNO_FWGS.equals(dto.getBusinessNo())) {
            //判断是否有注册自然人，如果没有则自动注册一个
            User dbUser =userDao.findByUsername(integratedSprenyuan.getLINKPHONE(),String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
            if(dbUser == null){
                dbUser =  new User();
                //角色为自然人
                dbUser.setPlatform(Constants.PLATFORM_NATURAL_PERSON);
                //用户名
                dbUser.setUsername(integratedSprenyuan.getLINKPHONE());
                //手机号
                dbUser.setPhone(integratedSprenyuan.getLINKPHONE());
                //更新者
                dbUser.setUpdateBy(integratedSprenyuan.getLINKPHONE());
                //默认密码
                dbUser.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
                //姓名
                dbUser.setRealname(integratedSprenyuan.getNAME());
                //默认头像
                dbUser.setPhoto("assets/images/defaultHead/male.png");
                //用户ID
                dbUser.setId(idGeneratorUtil.createID());
                dbUser.setNativeCode(45L);
                dbUser.setActive(true);
                dbUser.setCreateTime(new Date());
                dbUser.setUpdateTime(new Date());
                dbUser.setUpdateBy("system");
                userDao.save(dbUser);
            }
            //保安服务公司信息
            Sponsorlicense sponsorlicense = new Sponsorlicense();
            //公司名称
            sponsorlicense.setCompanyname(tableCols.getGongSiMingChen());
            //地址
            sponsorlicense.setAddress(tableCols.getGongSiDiZhi());
            //企业类型
            sponsorlicense.setEnterprisetype(tableCols.getQiYeLeiXing());
            //服务范围
            StringBuffer management = new StringBuffer();
            String JingYingFanWei = tableCols.getJingYingFanWei();
            if ("门卫".equals(JingYingFanWei)) {
                management.append("1,");
            } else if ("巡逻".equals(JingYingFanWei)) {
                management.append("2,");
            } else if ("守护".equals(JingYingFanWei)) {
                management.append("3,");
            } else if ("随身护卫".equals(JingYingFanWei)) {
                management.append("4,");
            } else if ("押运".equals(JingYingFanWei)) {
                management.append("5,");
            } else if ("区域秩序维护".equals(JingYingFanWei)) {
                management.append("6,");
            } else if ("安全检查".equals(JingYingFanWei)) {
                management.append("7,");
            } else if ("安全风险评估".equals(JingYingFanWei)) {
                management.append("8,");
            } else if ("安全技术防范".equals(JingYingFanWei)) {
                management.append("9,");
            }
            sponsorlicense.setManagement(management.toString());
            //邮编
            sponsorlicense.setZipcode(tableCols.getYouBian());
            //注册资本验资或评估机构
            sponsorlicense.setAssessmentorg(tableCols.getZhuCeZiBenYanZiHuoPingGuJiGou());
            //电话
            sponsorlicense.setTel(tableCols.getGongSiDianHua());
            //公司管理人员数
            if(StringUtil.isNotEmpty(tableCols.getGongSiGuanLiRenYuanShu())) {
                sponsorlicense.setCompanymanger(Integer.valueOf(tableCols.getGongSiGuanLiRenYuanShu()));
            }
            //专业技术人员数
            if(StringUtil.isNotEmpty(tableCols.getZhuanYeJiShuRenYuanShu())) {
                sponsorlicense.setTechnologynum(Integer.valueOf(tableCols.getZhuanYeJiShuRenYuanShu()));
            }
            //公司用房面积
            sponsorlicense.setAreanum(tableCols.getGongSiYongFangMianJi());
            //注册资本
            if(StringUtil.isNotEmpty(tableCols.getZhuCeZiBen())) {
                sponsorlicense.setRegcapital(Integer.valueOf(tableCols.getZhuCeZiBen()));
            }
            //货币资本
            if(StringUtil.isNotEmpty(tableCols.getHuoBiZiBen())) {
                sponsorlicense.setCurrency(Integer.valueOf(tableCols.getHuoBiZiBen()));
            }
            //货币资本占比
            sponsorlicense.setCurrencybf(tableCols.getHuoBiZiBenZhanBi());
            //货币评估资本
            if(StringUtil.isNotEmpty(tableCols.getZiChanPingGuJiaZhi())){
                sponsorlicense.setCurrencyvalue(Integer.valueOf(tableCols.getZiChanPingGuJiaZhi()));
            }
            //归属
            sponsorlicense.setAscription(tableCols.getChanQuanGuiShu());
            //货币评估资本占比
            sponsorlicense.setCurrencyvaluebf(tableCols.getHuoBiPingGuZiBenZhanBi());
            //专用运输车辆数
            if(StringUtil.isNotEmpty(tableCols.getZhuanYongYunShuCheLiangShu())) {
                sponsorlicense.setAscriptionvehicle(Integer.valueOf(tableCols.getZhuanYongYunShuCheLiangShu()));
            }
            //防爆枪支数
            if(StringUtil.isNotEmpty(tableCols.getFangBaoQiangZhiShu())) {
                sponsorlicense.setGunnum(Integer.valueOf(tableCols.getFangBaoQiangZhiShu()));
            }
            //法人姓名
            sponsorlicense.setRepresentative(tableCols.getFaRenXingMing());
            //法人身份证号
            sponsorlicense.setLegalPersonNo(tableCols.getFaRenShenFenZhengHao());
            //法人手机
            sponsorlicense.setPhone(tableCols.getFaRenDaiBiaoShouJiHao());
            //区域
            if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                sponsorlicense.setProvince("110000");
                sponsorlicense.setCity("110100");
                sponsorlicense.setDistrict("110114");
            }else {
                sponsorlicense.setProvince(Constants.GUANGXICODE);
                sponsorlicense.setCity(tableCols.getShiJi());
                sponsorlicense.setDistrict(tableCols.getQuXianJi());
            }
            //办事区域
            sponsorlicense.setOrgid(tableCols.getOrgId());
            sponsorlicense.setDistrictOrgId(tableCols.getDistrictOrgId());
            sponsorlicense.setCityOrgId(tableCols.getCityOrgId());
            sponsorlicense.setSzss(tableCols.getSzss());
            //保安服务公司申报类型
            sponsorlicense.setSponsorlicenseType(Constants.SPONSORLICENSE_FW);
            //审批状态
            sponsorlicense.setApprovalstate(ApprovalState.DSH);
            //用户
            sponsorlicense.setUserid(dbUser.getId());
            try {
                //添加股东出资金额及所占比例
                Shareholder shareholder=  new Shareholder();
                //公司总经理信息
                SbSponsorlicenseManager sbSponsorlicenseManager =new SbSponsorlicenseManager();
                //公司副总经理信息
                SbSponsorlicenseVmanager sbSponsorlicenseVmanager=  new SbSponsorlicenseVmanager();
                SAXReader reader = new SAXReader();
                org.dom4j.Document doc = reader.read(new ByteArrayInputStream(xmlStr.getBytes(Constants.CHARSETUTF8)));
                org.dom4j.Element root = doc.getRootElement();
                List<Element> valueList = root.element("DATA").element("SPSHENQIN").element("XML_DATA").element("SPItemListDef").element("TableCols").elements("List");
                //System.out.println(valueElement);
                if(valueList!=null && valueList.size()>0) {
                    for (Element valueElement :
                            valueList) {
                        //股东
                        if("BaoAnFuWuGongSiGongSiGuDongXin".equals(valueElement.attribute("name").getValue())){
                            List<Element> listElement = valueElement.elements();
                            for (Element e : listElement
                            ) {
                                List<Element> list1 = e.elements();
                                for (Element e1 :
                                        list1) {
                                    if("GuDongXingMing".equals(e1.getName())) {
                                        //姓名
                                        shareholder.setName( ( shareholder.getName()==null?"":shareholder.getName() ) + e1.getStringValue() + ",");
                                    }
                                    if("SuoChuZiJinZhanBi".equals(e1.getName())) {
                                        //出资占比
                                        shareholder.setPercentage( ( shareholder.getPercentage()==null?"":shareholder.getPercentage()) + e1.getStringValue() + ",");
                                    }
                                    if("GuDongLeiXing".equals(e1.getName())) {
                                        //股东类型
                                        shareholder.setType( ( shareholder.getType()==null?"":shareholder.getType()) + e1.getStringValue() + ",");
                                    }
                                    if("GuDongShenFenZhengHao".equals(e1.getName())) {
                                        //身份证号
                                        shareholder.setIdnumber( ( shareholder.getIdnumber()==null?"":shareholder.getIdnumber()) + e1.getStringValue() + ",");
                                    }
                                    if("SuoChuZiJin".equals(e1.getName())) {
                                        //出资金额
                                        shareholder.setInvestmentnum(( shareholder.getInvestmentnum()==null?"":shareholder.getInvestmentnum() ) + e1.getStringValue() + ",");
                                    }
                                }
                            }
                            //总经理
                        }else if("BaoAnFuWuGongSiGongSiZongJingL".equals(valueElement.attribute("name").getValue())){
                            List<Element> listElement = valueElement.elements();
                            for (Element e : listElement
                            ) {
                                List<Element> list1 = e.elements();
                                for (Element e1 :
                                        list1) {
                                    if("ZongJingLiXingMing".equals(e1.getName())) {
                                        //姓名
                                        sbSponsorlicenseManager.setName( ( sbSponsorlicenseManager.getName()==null?"":sbSponsorlicenseManager.getName())  + e1.getStringValue() + ",");
                                    }
                                    if("ZongJingLiShouJiHao".equals(e1.getName())) {
                                        //手机号码
                                        sbSponsorlicenseManager.setPhone( ( sbSponsorlicenseManager.getPhone()==null?"":sbSponsorlicenseManager.getPhone() ) + e1.getStringValue() + ",");
                                    }
                                    if("ZongJingLiShenFenZhengHao".equals(e1.getName())) {
                                        //身份证号
                                        sbSponsorlicenseManager.setIdnum( ( sbSponsorlicenseManager.getIdnum()==null?"":sbSponsorlicenseManager.getIdnum() ) + e1.getStringValue() + ",");
                                    }
                                }
                            }
                            //副总经理
                        }else if("BaoAnFuWuGongSiGongSiFuZongJin".equals(valueElement.attribute("name").getValue())){



                            List<Element> listElement = valueElement.elements();
                            for (Element e : listElement
                            ) {
                                List<Element> list1 = e.elements();
                                for (Element e1 :
                                        list1) {
                                    if("FuZongJingLiXingMing".equals(e1.getName())) {
                                        //姓名
                                        sbSponsorlicenseVmanager.setVname((sbSponsorlicenseVmanager.getVname()==null?"":sbSponsorlicenseVmanager.getVname()) + e1.getStringValue() + ",");
                                    }
                                    if("FuZongJingLiShouJiHao".equals(e1.getName())) {
                                        //出资占比
                                        sbSponsorlicenseVmanager.setVphone( ( sbSponsorlicenseVmanager.getVphone()==null?"":sbSponsorlicenseVmanager.getVphone() ) + e1.getStringValue() + ",");
                                    }
                                    if("FuZongJingLiShenFenZhengHao".equals(e1.getName())) {
                                        //身份证号
                                        sbSponsorlicenseVmanager.setVidnum( ( sbSponsorlicenseVmanager.getVidnum()==null?"":sbSponsorlicenseVmanager.getVidnum() )+ e1.getStringValue() + ",");
                                    }
                                }
                            }
                        }

                    }
                }
                sponsorlicense.setShareholder(shareholder);
                sponsorlicense.setSbSponsorlicenseManager(sbSponsorlicenseManager);
                sponsorlicense.setSbSponsorlicenseVmanager(sbSponsorlicenseVmanager);
            }catch (Exception e ){
                logger.error(e.getMessage(),e);
            }
            //获取附件
            sponsorlicense.setTemplateRar(getAttr(params));
            //提交申报信息
            sponsorlicenseService.saveOrUpdateForIntegrate(sponsorlicense,dbUser);
            dto.setBusinessId(sponsorlicense.getId()+"");
        }else if(IntegratedConstants.BUSINESSNO_XMBG.equals(dto.getBusinessNo())){
            if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                tableCols.setOrgId(1L);
                tableCols.setDistrictOrgId("1");
                tableCols.setCityOrgId("1");
                tableCols.setSzss("北京北京市");
            }
            //获取单位名称，检查单位是否有帐号，如果没有帐号则提示
            String companyName = tableCols.getShenQingDanWeiMingChen();
            //临时
            SecurityCompany company = securityCompanyDao.findByName(companyName);
            if(company == null ){
                throw new ArsException("无法获取【"+companyName+"】公司信息，请与客服热线400-662-9696咨询！");
            }
            //法人信息
            Legalchange legalchange = new Legalchange();
            //公司名称
            legalchange.setOldcompanyname(tableCols.getDanWeiJiBenQingKuang());
            //公司地址
            legalchange.setOldaddress(tableCols.getBanGongDiZhi());
            //许可证号
            legalchange.setLicencenum(tableCols.getXuKeZhengHao());
            //原法人姓名
            legalchange.setLegalname(tableCols.getXingMing());
            //原法人性别
            legalchange.setLegalcardtype(tableCols.getZhengJianLeiXing());
            //原法人身份证号
            legalchange.setLegalcardnumber(tableCols.getZhengJianHaoMa());
            //原法人任职时间
            if(StringUtil.isNotEmpty(tableCols.getRenZhiShiJian())) {
                legalchange.setOfficetime(DateUtil.convertStringToDate(tableCols.getRenZhiShiJian()));
            }

            //拟定法人 姓名
            legalchange.setNdlegalname(tableCols.getXingMing());
            //拟定法人 性别
            legalchange.setNdlegalcardtype(tableCols.getZhengJianLeiXing());
            //拟定法人身份证号码
            legalchange.setNdlegalcardnum(tableCols.getZhengJianHaoMa());
            //拟任法定代表人国籍
            legalchange.setNdlegalnationality(tableCols.getGuoJi());
            //拟定法人证件类型 1身份证号
            legalchange.setNdlegalcardtype(Constants.NDLEGALCARDTYPE_CARD);
            //实际居住地址
            legalchange.setNdleaglsjaddress(tableCols.getShiJiJiZhuDiZhi());
            //户籍所在地址／境外住址
            legalchange.setNdlegaladdress(tableCols.getHuJiSuoZaiDiZhiJingWaiZhuZhi());
            //文化程序
            legalchange.setNdlegalculture(tableCols.getWenHuaChengDu());
            //出生年月
            if(StringUtil.isNotEmpty(tableCols.getChuShengNianYue())) {
                legalchange.setNdlegalbrith(DateUtil.convertStringToDate(tableCols.getChuShengNianYue()));
            }
            //手机号码
            legalchange.setNdlegalphone(tableCols.getShouJiHaoMa());
            //区域
            if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                legalchange.setProvince("110000");
                legalchange.setCity("110100");
                legalchange.setDistrict("110100");
            }else {
                legalchange.setProvince(Constants.GUANGXICODE);
                legalchange.setCity(tableCols.getShiJi());
                legalchange.setDistrict(tableCols.getQuXianJi());
            }
            //办事事项
            legalchange.setOrgid(tableCols.getOrgId());
            legalchange.setDistrictOrgId(tableCols.getDistrictOrgId());
            legalchange.setCityOrgId(tableCols.getCityOrgId());
            legalchange.setSzss(tableCols.getSzss());



            //用户
            legalchange.setUserid(company.getUser().getId());
            //公司ID
            legalchange.setCompanyid(company.getId());
            //审批状态
            legalchange.setApprovalstate(ApprovalState.DSH);
            //获取附件
            legalchange.setTemplateRar(getAttr(params));
            //启动流程
            legalchangeService.saveOrUpdateForIntegrate(legalchange,company.getUser());

            //工作经历
            try {
                SAXReader reader = new SAXReader();
                org.dom4j.Document doc = reader.read(new ByteArrayInputStream(xmlStr.getBytes(Constants.CHARSETUTF8)));
                org.dom4j.Element root = doc.getRootElement();
                List<Element> valueList = root.element("DATA").element("SPSHENQIN").element("XML_DATA").element("SPItemListDef").element("TableCols").elements("List");
                //System.out.println(valueElement);
                if(valueList!=null && valueList.size()>0) {
                    for (Element valueElement :
                            valueList) {
                        //股东
                        if ("NiRenFaDingDaiBiaoRenJianLi".equals(valueElement.attribute("name").getValue())) {
                            List<Element> listElement = valueElement.elements();
                            //添加股东出资金额及所占比例
                            Legalchangeworkexperience legalchangeworkexperience=  new Legalchangeworkexperience();
                            for (Element e : listElement
                            ) {
                                List<Element> list1 = e.elements();
                                for (Element e1 :
                                        list1) {
                                    if ("GangWeiZhiWu".equals(e1.getName())) {
                                        //岗位
                                        legalchangeworkexperience.setPost(e1.getStringValue());
                                    }
                                    if ("GongZuoDanWei".equals(e1.getName())) {
                                        //公司
                                        legalchangeworkexperience.setCompanyname(e1.getStringValue());
                                    }
                                    if ("ShiJianZhi".equals(e1.getName())) {
                                        //结束时间
                                        if(e1.getStringValue()!=null){
                                            legalchangeworkexperience.setEnddate(DateUtil.convertStringToDate(e1.getStringValue()));
                                        }
                                    }
                                    if ("ShiJianQi".equals(e1.getName())) {
                                        //开始时间
                                        legalchangeworkexperience.setStartdate(DateUtil.convertStringToDate(e1.getStringValue()));
                                    }
                                }
                                legalchangeworkexperience.setActive(true);
                                legalchangeworkexperience.setCreateTime(new Date());
                                legalchangeworkexperience.setUpdateTime(new Date());
                                legalchangeworkexperience.setUpdateBy(Constants.SYSTEM);
                                legalchangeworkexperience.setLegalchangeId(legalchange.getId());
                                workexperienceDao.save(legalchangeworkexperience);
                            }
                        }
                    }
                }
            }catch (Exception e ){
                logger.error(e.getMessage(),e);
            }
            dto.setBusinessId(legalchange.getId()+"");
        }else if(IntegratedConstants.BUSINESSNO_PXDW.equals(dto.getBusinessNo())){
            //判断是否有注册自然人，如果没有则自动注册一个
            User dbUser =userDao.findByUsername(integratedSprenyuan.getLINKPHONE(),String.valueOf(Constants.PLATFORM_NATURAL_PERSON));
            if(dbUser == null){
                dbUser =  new User();
                //角色为自然人
                dbUser.setPlatform(Constants.PLATFORM_NATURAL_PERSON);
                //用户名
                dbUser.setUsername(integratedSprenyuan.getLINKPHONE());
                //手机号
                dbUser.setPhone(integratedSprenyuan.getLINKPHONE());
                //更新者
                dbUser.setUpdateBy(integratedSprenyuan.getLINKPHONE());
                //默认密码
                dbUser.setPassword(Sha1Util.entryptPassword(Constants.DEFAULT_PASSWORD));
                //姓名
                dbUser.setRealname(integratedSprenyuan.getNAME());
                //默认头像
                dbUser.setPhoto("assets/images/defaultHead/male.png");
                dbUser.setNativeCode(45L);
                dbUser.setActive(true);
                dbUser.setCreateTime(new Date());
                dbUser.setUpdateTime(new Date());
                dbUser.setUpdateBy("system");
                //用户ID
                dbUser.setId(idGeneratorUtil.createID());
                userDao.save(dbUser);
            }


            //培训单位信息
            Traincompanyapply  traincompanyapply = new Traincompanyapply();

            //保安服务许可证编号
            traincompanyapply.setAllownumber(tableCols.getBaoAnFuWuXuKeZhengBianHao());

            //法人身份证号
            traincompanyapply.setLegalcode(tableCols.getFaRenShenFenZhengHao());
            //法人姓名
            traincompanyapply.setLegalname(tableCols.getFaDingDaiBiaoRenXingMing());
            //法人手机号码
            traincompanyapply.setLegalphone(tableCols.getFaRenDaiBiaoShouJiHao());
            //公司用房面积
            traincompanyapply.setCompanyHoseArea(tableCols.getGongSiYongFangMianJi());


            //单位名称
            traincompanyapply.setCompanyname(tableCols.getDanWeiMingChen());

            //单位地址
            traincompanyapply.setAddress(tableCols.getDanWeiDiZhi());

            //邮政编码
            traincompanyapply.setZipcode(tableCols.getYouZhengBianMa());
            //专用运输车辆数
            if(StringUtil.isNotEmpty(tableCols.getZhuanYongYunShuCheLiangShu())) {
                traincompanyapply.setAscriptionvehicle(Integer.valueOf(tableCols.getZhuanYongYunShuCheLiangShu()));
            }
            //营业执照编号
            traincompanyapply.setBusinessnumber(tableCols.getYingYeZhiZhaoBianHao());

            // 拟设保安培训机构名称
            traincompanyapply.setTraincompanyname(tableCols.getDanWeiMingChen2());
            // 拟设保安培训机构名称邮政编码
            traincompanyapply.setTrainzipcode(tableCols.getYouZhengBianMa2());


            /**
             * 单位性质
             */
            traincompanyapply.setCompanytype(tableCols.getDanWeiXingZhi());


            /***
             * 拟设保安培训机构名称
             */
            traincompanyapply.setTraincreditcode(tableCols.getFaRenShenFenZhengHao2());

            /**
             * 拟设保安培训法人姓名
             */
            traincompanyapply.setTrainlegalname(tableCols.getFaRenXingMing2());
            /**
             * 拟设保安培训法人手机
             */
            traincompanyapply.setTrainphone(tableCols.getFaRenShouJiHao2());
            /**
             * 学校、职业培训机构批准机关及文号
             */
            traincompanyapply.setOrgansallownumber(tableCols.getXueXiaoZhiYePeiXunJiGouPiZhunJ());
            /***
             * 拟设保安培训地址
             */
            traincompanyapply.setTrainaddress(tableCols.getDanWeiDiZhi2());


            /**
             * 培训内容
             */
            traincompanyapply.setTraincontent(tableCols.getPeiXunNaRong());


            /**
             * 产权归属
             */
            traincompanyapply.setAscription(tableCols.getChanQuanGuiShu());

            /***
             * 防爆枪支数
             */
            if(StringUtil.isNotEmpty(tableCols.getFangBaoQiangZhiShu())) {
               // traincompanyapply.setGunnum(Integer.valueOf(tableCols.getFangBaoQiangZhiShu()));
            }

            /**
             * 培训规模
             */
            traincompanyapply.setTrainsize(tableCols.getPeiXunGuiMo());

            //区域
            if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                traincompanyapply.setProvince("110000");
                traincompanyapply.setCity("110100");
                traincompanyapply.setDistrict("110114");
            }else {
                traincompanyapply.setProvince(Constants.GUANGXICODE);
                traincompanyapply.setCity(tableCols.getShiJi());
                traincompanyapply.setDistrict(tableCols.getQuXianJi());
            }
            //办事事项
            traincompanyapply.setOrgid(tableCols.getOrgId());
            traincompanyapply.setDistrictOrgId(tableCols.getDistrictOrgId());
            traincompanyapply.setCityOrgId(tableCols.getCityOrgId());
            traincompanyapply.setSzss(tableCols.getSzss());

            //审批状态
            traincompanyapply.setApprovalstate(ApprovalState.DSH);
            //用户
            traincompanyapply.setUserid(dbUser.getId());

            traincompanyapplyService.saveOrUpdateForIntegrate(traincompanyapply,dbUser);
            //获取附件
            traincompanyapply.setTemplateRar(getAttr(params));
            dto.setBusinessId(traincompanyapply.getId()+"");

        }
        //设置默认值
        dto.setActive(true);
        dto.setCreateTime(new Date());
        dto.setUpdateTime(new Date());
        dto.setUpdateBy(Constants.SYSTEM);
        //3、保存数据
        integratedDao.save(dto);
    }
    @Override
    public List query(IntegratedApplyDto dto) {
        return integratedDao.query(dto);
    }

    @Override
    public IntegratedResult getToken() {
        //返回对接
        IntegratedResult result = new IntegratedResult();
        //参数
        Map<String,Object> params =  new HashMap<>();
        params.put(IntegratedConstants.KEY,integratedKey);
        params.put(IntegratedConstants.VALUE,integratedSecret);
        //发送请求
        result.setDesc(HttpClientUtils.doPostHttpURL(integratedRestURL+ IntegratedConstants.GETTOKEN,params));
        logger.error(result.getDesc());
        return result;
    }

    @Override
    public void checkCompanyName(IntegratedApplyDto dto) {
        //1.xml转换成bean
        ApproveDataInfo  approveDataInfo = null;
        try{
            approveDataInfo = JaxbUtil.converyToJavaBean(dto.getXmlStr(), ApproveDataInfo.class);
            if(approveDataInfo == null ){
                throw new ArsException("xml格式有错，无法解析！！");
            }
        }catch (Exception e ){
            throw new ArsException("xml格式有错，无法解析！！");
        }
        if(StringUtil.isEmpty(approveDataInfo.getCompanyName())){
            throw new ArsException("公司名称参数不存在！！");
        }
        if(StringUtil.isEmpty(approveDataInfo.getSxbm())){
            throw new ArsException("业务参数不存在！！");
        }
        //业务参数
        dto.setBusinessNo(approveDataInfo.getSxbm());
        //公司名称
        dto.setCompanyName(approveDataInfo.getCompanyName());

        //保安服务公司
        if(IntegratedConstants.BUSINESSNO_FWGS.equals(dto.getBusinessNo())) {
            Sponsorlicense checkSponsorlicense = sponsorlicenseDao.findApproveByCompanyName(dto.getCompanyName());
            if (checkSponsorlicense != null) {
                throw new ArsException("【" + dto.getCompanyName() + "】已备案，不能重复备案！");
            }
        }else if(IntegratedConstants.BUSINESSNO_PXDW.equals(dto.getBusinessNo())){
            Traincompanyapply checkTraincompanyapply = traincompanyapplyDao.findApproveByCompanyName(dto.getCompanyName());
            if(checkTraincompanyapply != null){
                throw new ArsException("【" + dto.getCompanyName() + "】已备案，不能重复备案！");
            }
        }else  if(IntegratedConstants.BUSINESSNO_XMBG.equals(dto.getBusinessNo())){
            SecurityCompany company = securityCompanyDao.findByName(dto.getCompanyName());
            if (company == null) {
                throw new ArsException("【" + dto.getCompanyName() + "】不存在，请联系客服！！");
            }
        }else{
            throw new ArsException("业务编码类型有错！");
        }
    }

    @Override
    public void saveLog(IntegratedApplyDto dto) {
        //日志
        IntegratedLog log  = new IntegratedLog();
        log.setActive(true);
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        log.setUpdateBy(Constants.SYSTEM);
        log.setRequestContext(dto.getXmlStr());
        log.setExceptionContext(dto.getExceptionContext());
        integratedLogDao.save(log);
    }

    /***
     * 根据url获取SaaS的图片信息
     * @param url 图片地址
     * @return 百保盾路径
     */
    public  String getPath(String url,String fileName,String doc_id) {
        //定义输出流对象，用于生成文件
        FileOutputStream outStream = null;
        //定义输入流对象，用于获取文件流
        InputStream inStream = null;
        //返回对易用
        StringBuffer result = new StringBuffer("");
        try {
            //多张照片用，号隔开
            String[] urls = url.split(Constants.COMMA);
            for (String urlStr: urls){
                //获取图片地址信息
                URL imgPath = new URL(urlStr);
                //打开链接
                HttpURLConnection conn = (HttpURLConnection)imgPath.openConnection();
                //设置请求方式为"GET"
                conn.setRequestMethod("GET");
                //超时响应时间为5秒
                conn.setConnectTimeout(5 * 1000);
                //通过输入流获取图片数据
                inStream = conn.getInputStream();
                //得到图片的二进制数据，以二进制封装得到数据，具有通用性
                byte[] data = readInputStream(inStream);
                //日期
                Date now = new Date();
                //对图片地址以逗号，如 XXXX.png 分割成数据，array[0]=XXXX,array[1]=png
                String[] fileTypes = urlStr.split("\\.");
                //获取文件类型
                String materialFileType = fileTypes[fileTypes.length-1]; //文件类型
                Random random = new Random();
                int rannum = (int) (random.nextDouble() * (99 - 10 + 1)) + 100;// 获取5位随机数
                //获取当前日期
                String dirDate = DateUtil.systemDate.format(now);
                //定义目录file对象，用于判断文件夹是否存在
                File dir = new File(uploadFolder + dirDate);
                //判断文件是否存在，如不存在则创建
                if(!dir.exists()) {
                    dir.mkdirs();
                }
                //操作系统真实路径
                String targetPath = uploadFolder + dirDate + "/" + fileName;

                //new一个文件对象用来保存图片，默认保存当前工程根目录
                File imageFile = new File(targetPath);
                if(imageFile.exists()) {
                    //操作系统真实路径
                    targetPath = uploadFolder + dirDate + "/" + doc_id + fileName;
                    imageFile = new File(targetPath);
                }
                result.append(targetPath);
                //创建输出流
                outStream = new FileOutputStream(imageFile);
                //写入文件数据
                outStream.write(data);
                //刷新输出流
                outStream.flush();
                logger.info("本地文件上传成功!");
            }

        } catch(Exception e) {
            result.append(url);
            logger.error(e.getMessage(), e);
        } finally {
            try {
                //关闭输入流
                if (inStream != null) {
                    inStream.close();
                }
                //关闭输出流
                if (outStream != null) {
                    outStream.close();
                }
            }catch (Exception e){
                logger.error(e.getMessage(), e);
            }
        }
        return result.toString();
    }


    /***
     * 获取目录
     * @param params
     * @return
     */
    public String getAttr(Map<String,Object> params){

        String token =  (String)params.get("token");
        String  xmlStr  =   HttpClientUtils.doPostHttpURL(integratedRestURL+"/rest/apidd/getApplyAttaInfo",params);
        logger.error(xmlStr);
        String result ="";
        //定义输出流对象，用于生成文件
        FileOutputStream outStream = null;
        //附件 TODO
        try {
            List<String> filePaths =  new ArrayList<>();
            SAXReader reader = new SAXReader();
            org.dom4j.Document doc = reader.read(new ByteArrayInputStream(xmlStr.getBytes(Constants.CHARSETUTF8)));
            org.dom4j.Element root = doc.getRootElement();
            List<Element> valueList = root.element("DATA").element("RECORDS").elements("RECORD");
            if(valueList!=null && valueList.size()>0) {
                for (Element valueElement :
                        valueList) {
                    List<Element> listElement = valueElement.elements();
                    String path = "";
                    String fileName = "";
                    for (Element e : listElement
                    ) {
                        if("ATTACH_PATH".equals(e.getName())) {
                            path =  e.getStringValue();

                        }
                        if("ATTACH_NAME".equals(e.getName())) {
                            fileName =  e.getStringValue();
                        }
                    }
                    if(StringUtil.isNotEmpty(path)){
                        String url =integratedRestURL+"/rest/apidd/WebDiskServerDemo?doc_id="+path+"&fileName="+fileName+"&token="+token;
                        filePaths.add( getPath(url,fileName,path));
                    }
                }

                if(filePaths.size() > 0) {
                    Date now = new Date();
                    //获取当前日期
                    String dirDate = DateUtil.systemDate.format(now);
                    //生成同步数据文件压缩包
                    String fileName = now.getTime() + Constants.ZIP;
                    FileUtil.zipFiles(filePaths, uploadFolder  + dirDate + "/" +fileName);
                    //删除临时文件
                    filePaths.forEach(tempPath->{
                        if(tempPath.indexOf(Constants.TEMP)>0){
                            FileUtil.deleteFile(tempPath);
                        }
                    });

                    //文件的完整路径
                    String key = "upload/" + dirDate + "/" + fileName;
                    result = "getResource.do?path=" + key;
                }
            }
        }catch (Exception e ){
            logger.error(e.getMessage(),e);
        }
        return result;
    }



    public static void main(String[] args) {
/*        ResultXML xm = new ResultXML();
        xm = JaxbUtil.converyToJavaBean("<?xml version=\"1.0\" encoding=\"UTF-8\"?><RESULT><TIME>20190425195029</TIME><DESC>请求成功！</DESC><DATA>B0A176D563BBDEBFB7D362A1795462CB</DATA><STATUS>200</STATUS><TOKEN>B0A176D563BBDEBFB7D362A1795462CB</TOKEN></RESULT>",ResultXML.class);
        System.out.println(xm.getToken());*/
        String token = "76b2c2b73c31688158b32fb2abd57818";
        String SBLSH_SHORT = "X00agea191205-77253";
        String  SXBM ="11450000007566082U2000109002000";
        String  doc_id ="938592F7AF1C410D8D95485E84C41083";
        //获取申报信息
        Map<String,Object> params =  new HashMap<>();
        params.put("token",token);
        params.put("doc_id",doc_id);
        params.put("xmlStr","<APPROVEDATAINFO><SBLSH_SHORT>"+SBLSH_SHORT+"</SBLSH_SHORT><SXBM>"+SXBM+"</SXBM><GDBSSPCL></GDBSSPCL></APPROVEDATAINFO>");
        String  xmlStr = HttpUtil.post("http://221.7.197.161:90/rest/apidd/getApplyInfo",params);
     //  String  xmlStr  =   HttpClientUtils.doPostHttpURL("http://221.7.197.161:90/rest/apidd/getApplyAttaInfo",params);


        System.out.println(xmlStr);
        //System.out.println(HttpClientUtils.doPostHttpURL("http://59.211.219.71/share/WebDiskServerDemo",params));

      //  IntegratedResponse data =  JaxbUtil.converyToJavaBean(xmlStr,IntegratedResponse.class);
 ///      System.out.println(xmlStr);
       /* try {
            //添加股东出资金额及所占比例
            Shareholder shareholder=  new Shareholder();
            //公司总经理信息
            SbSponsorlicenseManager sbSponsorlicenseManager =new SbSponsorlicenseManager();
            //公司副总经理信息
            SbSponsorlicenseVmanager sbSponsorlicenseVmanager=  new SbSponsorlicenseVmanager();
            SAXReader reader = new SAXReader();
            org.dom4j.Document doc = reader.read(new ByteArrayInputStream(xmlStr.getBytes(Constants.CHARSETUTF8)));
            org.dom4j.Element root = doc.getRootElement();
            List<Element> valueList = root.element("DATA").element("SPSHENQIN").element("XML_DATA").element("SPItemListDef").element("TableCols").elements("List");
            //System.out.println(valueElement);
            if(valueList!=null && valueList.size()>0) {
                for (Element valueElement :
                        valueList) {
                    //股东
                    if("BaoAnFuWuGongSiGongSiGuDongXin".equals(valueElement.attribute("name").getValue())){
                        List<Element> list = valueElement.elements();
                            for (Element e : list
                            ) {
                                List<Element> list1 = e.elements();
                                for (Element e1 :
                                        list1) {
                                    if("GuDongXingMing".equals(e1.getName())) {
                                        //姓名
                                        shareholder.setName( ( shareholder.getName()==null?"":shareholder.getName() ) + e1.getStringValue() + ",");
                                    }
                                    if("SuoChuZiJinZhanBi".equals(e1.getName())) {
                                        //出资占比
                                        shareholder.setPercentage( ( shareholder.getPercentage()==null?"":shareholder.getPercentage()) + e1.getStringValue() + ",");
                                    }
                                    if("GuDongLeiXing".equals(e1.getName())) {
                                        //股东类型
                                        shareholder.setType( ( shareholder.getType()==null?"":shareholder.getType()) + e1.getStringValue() + ",");
                                    }
                                    if("GuDongShenFenZhengHao".equals(e1.getName())) {
                                        //身份证号
                                        shareholder.setIdnumber( ( shareholder.getIdnumber()==null?"":shareholder.getIdnumber()) + e1.getStringValue() + ",");
                                    }
                                    if("SuoChuZiJin".equals(e1.getName())) {
                                        //出资金额
                                        shareholder.setInvestmentnum(( shareholder.getInvestmentnum()==null?"":shareholder.getInvestmentnum() ) + e1.getStringValue() + ",");
                                    }
                                }
                        }
                        //总经理
                    }else if("BaoAnFuWuGongSiGongSiZongJingL".equals(valueElement.attribute("name").getValue())){
                        List<Element> list = valueElement.elements();
                        for (Element e : list
                        ) {
                            List<Element> list1 = e.elements();
                            for (Element e1 :
                                    list1) {
                                if("ZongJingLiXingMing".equals(e1.getName())) {
                                    //姓名
                                    sbSponsorlicenseManager.setName( ( sbSponsorlicenseManager.getName()==null?"":sbSponsorlicenseManager.getName())  + e1.getStringValue() + ",");
                                }
                                if("ZongJingLiShouJiHao".equals(e1.getName())) {
                                    //手机号码
                                    sbSponsorlicenseManager.setPhone( ( sbSponsorlicenseManager.getPhone()==null?"":sbSponsorlicenseManager.getPhone() ) + e1.getStringValue() + ",");
                                }
                                if("ZongJingLiShenFenZhengHao".equals(e1.getName())) {
                                    //身份证号
                                    sbSponsorlicenseManager.setIdnum( ( sbSponsorlicenseManager.getIdnum()==null?"":sbSponsorlicenseManager.getIdnum() ) + e1.getStringValue() + ",");
                                }
                            }
                        }
                        //副总经理
                    }else if("BaoAnFuWuGongSiGongSiFuZongJin".equals(valueElement.attribute("name").getValue())){



                        List<Element> list = valueElement.elements();
                        for (Element e : list
                        ) {
                            List<Element> list1 = e.elements();
                            for (Element e1 :
                                    list1) {
                                if("FuZongJingLiXingMing".equals(e1.getName())) {
                                    //姓名
                                    sbSponsorlicenseVmanager.setVname((sbSponsorlicenseVmanager.getVname()==null?"":sbSponsorlicenseVmanager.getVname()) + e1.getStringValue() + ",");
                                }
                                if("FuZongJingLiShouJiHao".equals(e1.getName())) {
                                    //出资占比
                                    sbSponsorlicenseVmanager.setVphone( ( sbSponsorlicenseVmanager.getVphone()==null?"":sbSponsorlicenseVmanager.getVphone() ) + e1.getStringValue() + ",");
                                }
                                if("FuZongJingLiShenFenZhengHao".equals(e1.getName())) {
                                    //身份证号
                                    sbSponsorlicenseVmanager.setVidnum( ( sbSponsorlicenseVmanager.getVidnum()==null?"":sbSponsorlicenseVmanager.getVidnum() )+ e1.getStringValue() + ",");
                                }
                            }
                        }
                    }

                }
            }
            System.out.println(shareholder);
            System.out.println(sbSponsorlicenseManager);
            System.out.println(sbSponsorlicenseVmanager);
        }catch (Exception e ){
            e.printStackTrace();
        }*/
//        Map<String,Object> params2 =  new HashMap<>();
//        params2.put("token",token);
//        params2.put("xmlStr","<APPROVEDATAINFO><SBLSH_SHORT>"+SBLSH_SHORT+"</SBLSH_SHORT><SXBM>"+SXBM+"</SXBM><GDBSSPCL></GDBSSPCL></APPROVEDATAINFO>");
//        System.out.println(HttpClientUtils.doPostHttpURL("http://221.7.197.161:90/rest/apidd/getApplyAttaInfo",params2));
//        TableCols tableCols = data.getData().getIntegratedSpshenqin().getIntegratedXML_data().getSPItemListDef().getTableCols();

      /*  Traincompanyapply  traincompanyapply = new Traincompanyapply();

        //保安服务许可证编号
        traincompanyapply.setAllownumber(tableCols.getBaoAnFuWuXuKeZhengBianHao());

        //法人身份证号
        traincompanyapply.setLegalcode(tableCols.getFaRenShenFenZhengHao());
        //法人姓名
        traincompanyapply.setLegalname(tableCols.getFaDingDaiBiaoRenXingMing());
        //法人手机号码
        traincompanyapply.setLegalphone(tableCols.getFaRenDaiBiaoShouJiHao());
        //公司用房面积
        traincompanyapply.setCompanyHoseArea(tableCols.getGongSiYongFangMianJi());


        //单位名称
        traincompanyapply.setCompanyname(tableCols.getDanWeiMingChen());

        //单位地址
        traincompanyapply.setAddress(tableCols.getDanWeiDiZhi());

        //邮政编码
        traincompanyapply.setZipcode(tableCols.getYouZhengBianMa());
        //专用运输车辆数
        if(StringUtil.isNotEmpty(tableCols.getZhuanYongYunShuCheLiangShu())) {
            traincompanyapply.setAscriptionvehicle(Integer.valueOf(tableCols.getZhuanYongYunShuCheLiangShu()));
        }
        //营业执照编号
        traincompanyapply.setBusinessnumber(tableCols.getYingYeZhiZhaoBianHao());

        // 拟设保安培训机构名称
        traincompanyapply.setTraincompanyname(tableCols.getDanWeiMingChen2());
        // 拟设保安培训机构名称邮政编码
        traincompanyapply.setTrainzipcode(tableCols.getYouZhengBianMa2());


        *//**
         * 单位性质
         *//*
        traincompanyapply.setCompanytype(tableCols.getDanWeiXingZhi());


        *//***
         * 拟设保安培训机构名称
         *//*
        traincompanyapply.setTraincreditcode(tableCols.getFaRenShenFenZhengHao2());

        *//**
         * 拟设保安培训法人姓名
         *//*
        traincompanyapply.setTrainlegalname(tableCols.getFaRenXingMing2());
        *//**
         * 拟设保安培训法人手机
         *//*
        traincompanyapply.setTrainphone(tableCols.getFaRenShouJiHao2());
        *//**
         * 学校、职业培训机构批准机关及文号
         *//*
        traincompanyapply.setOrgansallownumber(tableCols.getXueXiaoZhiYePeiXunJiGouPiZhunJ());
        *//***
         * 拟设保安培训地址
         *//*
        traincompanyapply.setTrainaddress(tableCols.getDanWeiDiZhi2());


        *//**
         * 培训内容
         *//*
        traincompanyapply.setTraincontent(tableCols.getPeiXunNaRong());


        *//**
         * 产权归属
         *//*
        traincompanyapply.setAscription(tableCols.getChanQuanGuiShu());

        *//***
         * 防爆枪支数
         *//*
        if(StringUtil.isNotEmpty(tableCols.getFangBaoQiangZhiShu())) {
            traincompanyapply.setGunnum(Integer.valueOf(tableCols.getFangBaoQiangZhiShu()));
        }

        *//**
         * 培训规模
         *//*
        traincompanyapply.setTrainsize(tableCols.getPeiXunGuiMo());*/







        /* System.out.println(data);

        TableCols tableCols = data.getData().getIntegratedSpshenqin().getIntegratedXML_data().getSPItemListDef().getTableCols();
        Sponsorlicense sponsorlicense = new Sponsorlicense();
        //公司名称
        sponsorlicense.setCompanyname(tableCols.getGongSiMingChen()+"一体化");
        //地址
        sponsorlicense.setAddress(tableCols.getGongSiDiZhi());
        //企业类型
        sponsorlicense.setEnterprisetype(tableCols.getQiYeLeiXing());
        //服务范围
        StringBuffer management = new StringBuffer();
        String JingYingFanWei = tableCols.getJingYingFanWei();
        if ("门卫".equals(JingYingFanWei)) {
            management.append("1,");
        } else if ("巡逻".equals(JingYingFanWei)) {
            management.append("2,");
        } else if ("守护".equals(JingYingFanWei)) {
            management.append("3,");
        } else if ("随身护卫".equals(JingYingFanWei)) {
            management.append("4,");
        } else if ("押运".equals(JingYingFanWei)) {
            management.append("5,");
        } else if ("区域秩序维护".equals(JingYingFanWei)) {
            management.append("6,");
        } else if ("安全检查".equals(JingYingFanWei)) {
            management.append("7,");
        } else if ("安全风险评估".equals(JingYingFanWei)) {
            management.append("8,");
        } else if ("安全技术防范".equals(JingYingFanWei)) {
            management.append("9,");
        }
        sponsorlicense.setManagement(management.toString());
        //邮编
        sponsorlicense.setZipcode(tableCols.getYouBian());
        //注册资本验资或评估机构
        sponsorlicense.setAssessmentorg(tableCols.getZhuCeZiBenYanZiHuoPingGuJiGou());
        //电话
        sponsorlicense.setTel(tableCols.getDianHua());
        //公司管理人员数
        if(StringUtil.isNotEmpty(tableCols.getGongSiGuanLiRenYuanShu())) {
            sponsorlicense.setCompanymanger(Integer.valueOf(tableCols.getGongSiGuanLiRenYuanShu()));
        }
        //专业技术人员数
        if(StringUtil.isNotEmpty(tableCols.getZhuanYeJiShuRenYuanShu())) {
            sponsorlicense.setTechnologynum(Integer.valueOf(tableCols.getZhuanYeJiShuRenYuanShu()));
        }
        //公司用房面积
        sponsorlicense.setAreanum(tableCols.getGongSiYongFangMianJi());

        if(StringUtil.isNotEmpty(tableCols.getZhuCeZiBen())) {
            sponsorlicense.setRegcapital(Integer.valueOf(tableCols.getZhuCeZiBen()));
        }

        //货币资本
        if(StringUtil.isNotEmpty(tableCols.getHuoBiZiBen())) {
            sponsorlicense.setCurrency(Integer.valueOf(tableCols.getHuoBiZiBen()));
        }
        //货币资本占比
        sponsorlicense.setCurrencybf(tableCols.getHuoBiZiBenZhanBi());


        //货币评估资本
        if(StringUtil.isNotEmpty(tableCols.getZiChanPingGuJiaZhi())){
            sponsorlicense.setCurrencyvalue(Integer.valueOf(tableCols.getZiChanPingGuJiaZhi()));
        }

        //归属
        sponsorlicense.setAscription(tableCols.getChanQuanGuiShu());

        //货币评估资本占比
        sponsorlicense.setCurrencyvaluebf(tableCols.getHuoBiPingGuZiBenZhanBi());

        //专用运输车辆数
        if(StringUtil.isNotEmpty(tableCols.getZhuanYongYunShuCheLiangShu())) {

            sponsorlicense.setAscriptionvehicle(Integer.valueOf(tableCols.getZhuanYongYunShuCheLiangShu()));
        }

        //防爆枪支数
        if(StringUtil.isNotEmpty(tableCols.getFangBaoQiangZhiShu())) {
            sponsorlicense.setGunnum(Integer.valueOf(tableCols.getFangBaoQiangZhiShu()));
        }
        //法人姓名
       // sponsorlicense.setRepresentative(integratedSprenyuan.getNAME());


        //法人身份证号
        sponsorlicense.setLegalPersonNo(tableCols.getFaRenShenFenZhengHao());*/


        //法人手机
      //  sponsorlicense.setPhone(integratedSprenyuan.getLINKPHONE());




        //获取材料附件
      /*  Map<String,Object> params2 =  new HashMap<>();
        params2.put("token",token);
        params2.put("xmlStr","<APPROVEDATAINFO><SBLSH_SHORT>"+SBLSH_SHORT+"</SBLSH_SHORT><SXBM>"+SXBM+"</SXBM><GDBSSPCL></GDBSSPCL></APPROVEDATAINFO>");
        System.out.println(HttpClientUtils.doPostHttpURL("http://221.7.197.161:90/rest/apidd/getApplyAttaInfo",params2));*/
        //推送接收过程
        /*Map<String,Object> params3 =  new HashMap<>();
        params3.put("token",token);
        params3.put("xmlStr","<APPROVEDATAINFO><SBLSH_SHORT>"+SBLSH_SHORT+"</SBLSH_SHORT><SXBM>"+SXBM+"</SXBM>" +
                "<GDBSSPCL>" +
                "   <SBLSH_SHORT>"+SBLSH_SHORT+"</SBLSH_SHORT>" +
                "   <SBLSH>null</SBLSH>" +
                "   <SXBM>"+SXBM+"</SXBM>" +
                "   <SXBM_SHORT>null</SXBM_SHORT>" +
                "   <SXQXBM>1</SXQXBM>" +
                "   <SPHJDM>2</SPHJDM>" +
                "   <SPHJMC>sp_shenpi_chuli</SPHJMC>" +
                "   <SPBMMC>审批</SPBMMC>" +
                "   <SPBMZZJDMD>212</SPBMZZJDMD>" +
                "   <XZQHDM>南宁</XZQHDM>" +
                "   <SPRXM>李测试</SPRXM>" +
                "   <SPRZWDM>1</SPRZWDM>" +
                "   <SPRZWMC>科长</SPRZWMC>" +
                "   <SPYJ>同意申报</SPYJ>" +
                "   <SPSJ>"+ DateUtil.getCurrentDateTime() +"</SPSJ>" +
                "   <SPHJZTDM>1</SPHJZTDM>" +
                "   <REC_FLAG>1</REC_FLAG>" +
                "   <D_ZZJGDM>111</D_ZZJGDM>" +
                "</GDBSSPCL></APPROVEDATAINFO>");
        System.out.println(HttpUtil.post("http://221.7.197.161:90/rest/apidd/receiveCourseInfo",params3));
*/





        /*String methodUrl = "http://221.7.197.161:90/rest/apidd/receiveCourseInfo";
        String xmlStr1 ="<APPROVEDATAINFO><SBLSH_SHORT>"+SBLSH_SHORT+"</SBLSH_SHORT><SXBM>"+SXBM+"</SXBM>" +
                "<GDBSSPCL>" +
                "   <SBLSH_SHORT>"+SBLSH_SHORT+"</SBLSH_SHORT>" +
                "   <SBLSH>null</SBLSH>" +
                "   <SXBM>"+SXBM+"</SXBM>" +
                "   <SXBM_SHORT>null</SXBM_SHORT>" +
                "   <SXQXBM>1</SXQXBM>" +
                "   <SPHJDM>2</SPHJDM>" +
                "   <SPHJMC>sp_shenpi_chuli</SPHJMC>" +
                "   <SPBMMC>审批</SPBMMC>" +
                "   <SPBMZZJDMD>212</SPBMZZJDMD>" +
                "   <XZQHDM>南宁</XZQHDM>" +
                "   <SPRXM>李测试</SPRXM>" +
                "   <SPRZWDM>1</SPRZWDM>" +
                "   <SPRZWMC>科长</SPRZWMC>" +
                "   <SPYJ>同意申报</SPYJ>" +
                "   <SPSJ>"+ DateUtil.getCurrentDateTime() +"</SPSJ>" +
                "   <SPHJZTDM>1</SPHJZTDM>" +
                "   <REC_FLAG>1</REC_FLAG>" +
                "   <D_ZZJGDM>111</D_ZZJGDM>" +
                "</GDBSSPCL></APPROVEDATAINFO>";
        HttpURLConnection connection = null;
        OutputStreamWriter osw = null;
        BufferedReader reader = null;
        String line = null;
        try {
            URL url = new URL(methodUrl);
            connection = (HttpURLConnection) url.openConnection();
            // 设置连接请求方式
            connection.setRequestMethod("POST");
            // 设置连接主机服务器超时时间：15000毫秒
            connection.setConnectTimeout(15000);
            // 设置读取主机服务器返回数据超时时间：60000毫秒
            connection.setReadTimeout(60000);
            // 默认值为：false，当向远程服务器传送数据/写数据时，需要设置为true
            connection.setDoOutput(true);   //需要输出
            // 默认值为：true，当前向远程服务读取数据时，设置为true，该参数可有可无
            connection.setDoInput(true);
            //不允许缓存
            connection.setUseCaches(false);
            // 设置传入参数的格式:请求参数应该是 name1=value1&name2=value2 的形式。
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            connection.setRequestProperty("Charset", "UTF-8");

            osw = new OutputStreamWriter(connection.getOutputStream());
            osw.write("token="+token+"&xmlStr="+xmlStr1);
            osw.flush();
            if (connection.getResponseCode() == HttpURLConnection.HTTP_OK) {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));// 发送http请求
                StringBuilder result = new StringBuilder();
                // 循环读取流
                while ((line = reader.readLine()) != null) {
                    result.append(line).append(System.getProperty("line.separator"));// "\n"
                }
                System.out.println("result:"+result.toString());
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if(reader != null){
                    reader.close();
                }
                if(osw !=null){
                    osw.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            connection.disconnect();
        }
*/
        //办结
      /*  Map<String,Object> params4 =  new HashMap<>();
        params4.put("token",token);
        params4.put("xmlStr","<APPROVEDATAINFO><SBLSH_SHORT>"+SBLSH_SHORT+"</SBLSH_SHORT><SXBM>"+SXBM+"</SXBM>" +
                "<SPBANJIE>" +
                "   <SBLSH_SHORT>"+SBLSH_SHORT+"</SBLSH_SHORT>" +
                "   <SBLSH>null</SBLSH>" +
                "   <SXBM>"+SXBM+"</SXBM>" +
                "   <SXBM_SHORT>null</SXBM_SHORT>" +
                "   <SXQXBM>1</SXQXBM>" +
                "   <BJBMMC>区厅</BJBMMC>" +
                "   <BJBMZZJDDM>1234564</BJBMZZJDDM>" +
                "   <XZQHDM>450100</XZQHDM>" +
                "   <SPRXM>蓝测试</SPRXM>" +
                "   <SPRDM>001</SPRDM>" +
                "   <BJJGDM>0</BJJGDM>" +
                "   <BJJGMS>已办理</BJJGMS>" +
                "   <SFJE>0</SFJE>" +
                "   <JEDWDM>1</JEDWDM>" +
                "   <BJSJ>"+DateUtil.getCurrentDateTime()+"</BJSJ>" +
                "</SPBANJIE>" +
                "</APPROVEDATAINFO>");
        System.out.println(HttpUtil.post("http://221.7.197.161:90/rest/apidd/receiveBusinessFinish",params4));*/


        //下载附件



    }

/*
    public static String startUploadService(Map<String, String> params,
                                            String file_url, String server_url) {
        try {
// 开启上传队列
            File file = null;
            if(!file_url.equals("")){
                file = new File(file_url);
            }

            HttpClient httpclient = new DefaultHttpClient();
// 设置通信协议版本
            httpclient.getParams().setParameter(
                    CoreProtocolPNames.PROTOCOL_VERSION, HttpVersion.HTTP_1_1);
// 文件参数设置
            HttpPost httppost = new HttpPost(server_url);
            MultipartEntity mpEntity = new MultipartEntity(
                    HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName(CHARSET));
            if (params != null && !params.isEmpty()) {
// 编码参数
*//*for (String k : params.keySet()) {
StringBody valueBody = new StringBody(params.get(k),Charset.forName(CHARSET));
mpEntity.addPart(k, valueBody);
}*//*

                for(Entry<String, String> entry: params.entrySet()){
                    StringBody valueBody = new StringBody(entry.getValue(),Charset.forName(CHARSET));
                    mpEntity.addPart(entry.getKey(), valueBody);
                }

            }
            ContentBody cbFile = new FileBody(file);
            mpEntity.addPart("file", cbFile);
            httppost.setEntity(mpEntity);
            HttpResponse response = httpclient.execute(httppost);
            HttpEntity resEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() != HttpStatus.SC_OK) {
                EntityUtils.toString(response.getEntity(), CHARSET);
//String sss = EntityUtils.toString(response.getEntity(), CHARSET);
// throw new RuntimeException("请求失败");
                return "{\"code\":\"4000\", \"msg\":\"URL请求失败\", \"result\":\'"
                        + response.getStatusLine().toString() + "\'}";
            }
            String result = (resEntity == null) ? null : EntityUtils.toString(resEntity,
                    CHARSET);
            return result;
        } catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
            return "{\"code\":\"4002\", \"msg\":\"URL请求失败\", \"result\":\'UnsupportedEncodingException:"
                    + e.getMessage() + "\'}";
        } catch (ClientProtocolException e) {
            System.out.println(e.getMessage());
            return "{\"code\":\"4003\", \"msg\":\"URL请求失败\", \"result\":\'ClientProtocolException:"
                    + e.getMessage() + "\'}";
        } catch (IOException e) {
            System.out.println(e.getMessage());
            return "{\"code\":\"4001\", \"msg\":\"URL请求失败\", \"result\":\'IOException:"
                    + e.getMessage() + "\'}";
        }
    }*/

}
