package com.bcxin.ars.service.gen.impl;

import com.bcxin.ars.dao.gen.GenTableColumnDao;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.gen.GenTableColumn;
import com.bcxin.ars.service.gen.GenTableColumnService;

import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

import java.util.List;
/**
 * 代码生成业务表字段Service实现类
 *
 * @author linqinglin
 * @Date 2020-08-09 08:12:10
 */
@Service
@Transactional
public class GenTableColumnServiceImpl implements GenTableColumnService {

    Logger logger = LoggerFactory.getLogger(GenTableColumnServiceImpl.class);

    @Autowired
    private GenTableColumnDao genTableColumnDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(GenTableColumn genTableColumn) {
        User currentUser = arsUtil.getCurrentUser();
        genTableColumn.setUpdateTime(new Date());
        genTableColumn.setUpdateBy(currentUser.getUsername());
        return genTableColumnDao.delete(genTableColumn);
    }

    @Override
    public int save(GenTableColumn genTableColumn) {
        User currentUser = arsUtil.getCurrentUser();
        if(genTableColumn.getId() == null){
            genTableColumn.setCreateTime(new Date());
        }else{
            GenTableColumn dbGenTableColumn = genTableColumnDao.findById(genTableColumn.getId());
            BeanUtils.copyPropertiesIgnore(genTableColumn,dbGenTableColumn,true);
            BeanUtils.copyPropertiesIgnore(dbGenTableColumn,genTableColumn,false);
        }

        genTableColumn.setActive(true);
        genTableColumn.setUpdateBy(currentUser.getUsername());
        genTableColumn.setUpdateTime(new Date());
        return genTableColumnDao.save(genTableColumn);
    }

    @Override
    public GenTableColumn findById(Long id) {
        return genTableColumnDao.findById(id);
    }

    @Override
    public void importBatch(List<GenTableColumn> list) {
        List<GenTableColumn> dbList = genTableColumnDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (GenTableColumn genTableColumn : list) {
                genTableColumn.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        genTableColumn.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, genTableColumn.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            genTableColumnDao.saveBatch(list);
        }
    }

    @Override
    public List<GenTableColumn> findByBatchId(List<GenTableColumn> list) {
        return genTableColumnDao.findByBatchId(list);
    }

    @Override
    public void search(GenTableColumn genTableColumn, AjaxPageResponse<GenTableColumn> page) {
        page.setData(genTableColumnDao.findByTableId(genTableColumn.getTableId()));
    }

    @Override
    public void updateSelective(GenTableColumn genTableColumn) {
        User currentUser = arsUtil.getCurrentUser();
        genTableColumn.setUpdateTime(new Date());
        genTableColumn.setUpdateBy(currentUser.getUsername());
        genTableColumnDao.updateSelective(genTableColumn);
    }
}
