package com.bcxin.ars.service.exam.impl;

import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.MSGConstants;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.exam.TrainExamInfoDao;
import com.bcxin.ars.dao.exam.TrainExamPersonDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.AppNoticeDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.exam.TrainExamPersonHistoryDto;
import com.bcxin.ars.dto.exam.TrainExamPersonSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.exam.TrainExamInfo;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.task.AppNotice;
import com.bcxin.ars.service.bean.factory.CustomPersoncertificateBeanFactory;
import com.bcxin.ars.service.exam.TrainExamPersonService;
import com.bcxin.ars.service.sb.CustomPersoncertificateService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.service.util.excel.ExcelUtil;
import com.bcxin.ars.service.util.excel.excelbean.exam.TrainExamPersonResultExportExcelBean;
import com.bcxin.ars.service.util.excel.excelbean.exam.TrainExamPersonResultTemplateExcelBean;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.JPushUtil;
import com.bcxin.ars.util.MessageUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 考试人员信息管理
 *
 * @author wangjianchi
 * @since 1.1
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = TrainExamPerson.class)
public class TrainExamPersonServiceImpl implements TrainExamPersonService {

	private static Logger logger = LoggerFactory.getLogger(TrainExamPersonServiceImpl.class);

	@Autowired
	private TrainExamInfoDao trainExamInfoDao;
	@Autowired
	private TrainExamPersonDao trainExamPersonDao;
	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private PersoncertificateDao personcertificateDao;

	@Autowired
	private PersoncertificateDaoAop personcertificateDaoAop;

	@Autowired
	private SecurityPersonDao securityPersonDao;

	@Autowired
	private MessageLogDao messageLogDao;

	@Autowired
	private AppNoticeDao appNoticeDao;
	@Autowired
	private ApprovalService approvalService;

	@Autowired
	private SecurityCertificateDao  securityCertificateDao;

	@Autowired
	private ConfigUtils configUtils;

	@Override
	public PageResult query(TrainExamPersonSearchDto dto) {
		AjaxPageResponse<TrainExamPersonSearchDto> page = new AjaxPageResponse<TrainExamPersonSearchDto>();
		if (dto.getPageNum() == 0) {
			page.setPageNumber(1);
		} else {
			page.setPageNumber(dto.getPageNum() + 1);
		}
		page.setPageSize(dto.getNumPerPage());
		trainExamPersonDao.query(dto, page);
		return new PageResult((int) page.getTotal(), page.getData());
	}

	@Override
	public PageResult queryHistory(TrainExamPersonSearchDto dto) {
		AjaxPageResponse<TrainExamPersonHistoryDto> page = new AjaxPageResponse<TrainExamPersonHistoryDto>();
		if (dto.getPageNum() == 0) {
			page.setPageNumber(1);
		} else {
			page.setPageNumber(dto.getPageNum() + 1);
		}
		page.setPageSize(dto.getNumPerPage());
		trainExamPersonDao.queryHistory(dto, page);
		return new PageResult((int) page.getTotal(), page.getData());
	}

	@Override
	public List<TrainExamPerson> list(TrainExamPersonSearchDto dto) {
		return trainExamPersonDao.list(dto);
	}

	@Override
	public TrainExamPerson findById(Long id) {
		return trainExamPersonDao.findById(id);
	}

	@Override
	public void deleteById(Long id) {
		TrainExamPerson dbTrainExamPerson = trainExamPersonDao.findById(id);
		if (dbTrainExamPerson != null) {
			if (dbTrainExamPerson.getSumScore() != null) {
				throw new ArsException("姓名[" + dbTrainExamPerson.getFullname() + "]成绩已录入，则不能删除！");
			} else {
				// 判断是否已发送考试通知，如果已发送，则发送取消通知给考生,未发送过考试通知，则直接删除考试人员信息
				if (dbTrainExamPerson.getNoticeState().equals(Constants.NOTICESTATECODE_YES)) {
					Personcertificate personcertificate = personcertificateDao
							.findById(dbTrainExamPerson.getBbdPersonID());
					if (personcertificate != null) {
						personcertificate.setExamState(Constants.EXAM_STATE_WAP);// 未安排
						Config config = configDao.findByKey(Constants.POLICE);
						if (config != null && StringUtil.isNotEmpty(config.getValue())
								&& "1".equals(config.getValue())) {
							// 内网
							personcertificate.setUpdateflag(true);
							personcertificateDaoAop.update(personcertificate);
						} else {
							// 外网：考试安排短信通知
							personcertificateDaoAop.update(personcertificate);
							String title = "";// 标题
							String appContent = "";// APP通知
							String msgContent = ""; // 短信通知
							String name = personcertificate.getName();
							SimpleDateFormat parseDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
							SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy年MM月dd日");
							SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
							title = Constants.EXAM_CANCEL_NOTE_TITLE;
							appContent = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CANCEL_CONTENT_APP_V1171;
							try {
								appContent = appContent.replace("{name}", name)
										.replace("{examDate}",
												dateFormat.format(
														parseDateFormat.parse(personcertificate.getExamStart())))
										.replace("{examStart}",
												timeFormat.format(
														parseDateFormat.parse(personcertificate.getExamStart())))
										.replace("{examEnd}",
												timeFormat
														.format(parseDateFormat.parse(personcertificate.getExamEnd())))
										.replace("{staminaDate}", dateFormat
												.format(parseDateFormat.parse(personcertificate.getStaminaStartDate())))

										.replace("{staminaStartDate}",
												timeFormat.format(
														parseDateFormat.parse(personcertificate.getStaminaStartDate())))
										.replace("{staminaEndDate}", timeFormat
												.format(parseDateFormat.parse(personcertificate.getStaminaEndDate())));
							} catch (ParseException e) {
								e.printStackTrace();
							}
							msgContent = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CANCEL_CONTENT_MSG_V1171;
							this.sendMsg(personcertificate, title, msgContent, appContent,Constants.NOTICE_PERSON_YES);
						}
					} else {
						throw new ArsException("姓名[" + dbTrainExamPerson.getFullname() + "]查找不到考试报名信息，删除失败！");
					}
				}
				trainExamPersonDao.deleteById(id);
			}
		}
	}

	@Override
	public TrainExamPerson updateScore(TrainExamPerson trainExamPerson) {
		User currentUser = arsUtil.getCurrentUser();
		TrainExamPerson dbTrainExamPerson = trainExamPersonDao.findById(trainExamPerson.getId());
		if (dbTrainExamPerson != null) {
			TrainExamInfo dbTrainExamInfo = trainExamInfoDao.selectByPrimaryKey(dbTrainExamPerson.getExamID());
			int writtenRatio = dbTrainExamInfo.getWrittenRatio();// 笔试成绩比例
			int operateRatio = dbTrainExamInfo.getOperateRatio();// 体能成绩比例
			int writtenPassScore = dbTrainExamInfo.getWrittenPassScore(); // 笔试成绩通过分数
			int operatePassScore = dbTrainExamInfo.getOperatePassScore();// 体能成绩通过分数
			int examStandard = dbTrainExamInfo.getExamStandard();// 合格标准

			int operateScore = trainExamPerson.getOperateScore();// 体能成绩
			int writtenScore = trainExamPerson.getWrittenScore();// 笔试成绩
			Boolean isOperate = false, isWritten = false;
			// 判断考试类型
			if (dbTrainExamInfo.getIsComputerExam() > 0 && dbTrainExamInfo.getIsStamina() < 1) {
				operateScore = 0;
				isWritten = true;
			} else if (dbTrainExamInfo.getIsComputerExam() < 1 && dbTrainExamInfo.getIsStamina() > 0) {
				writtenScore = 0;
				isOperate = true;
			} else {
				isWritten = true;
				isOperate = true;
			}
			// 后判断考试规则
			if (dbTrainExamInfo.getExamRules() == Constants.EXAMRULES_ONE) {
				BigDecimal sumScore = BigDecimal.valueOf(operateScore + writtenScore);
				dbTrainExamPerson.setSumScore(sumScore);
				if (writtenScore >= writtenPassScore && operateScore >= operatePassScore) {
					dbTrainExamPerson.setTestState(Constants.TESTSTATE_YES);// 总成绩大于等于双科及格分数则考试状态为合格
				} else {
					dbTrainExamPerson.setTestState(Constants.TESTSTATE_NO);
				}
			} else if (dbTrainExamInfo.getExamRules() == Constants.EXAMRULES_TOW) {
				BigDecimal sumScore = BigDecimal
						.valueOf((operateScore * operateRatio + writtenScore * writtenRatio) * 0.01);
				dbTrainExamPerson.setSumScore(sumScore);
				if (sumScore.compareTo(BigDecimal.valueOf(Long.valueOf(examStandard))) >= 0) {
					dbTrainExamPerson.setTestState(Constants.TESTSTATE_YES);// 总成绩大于等于合格标准则考试状态为合格
				} else {
					dbTrainExamPerson.setTestState(Constants.TESTSTATE_NO);
				}
			}
			if (isOperate) {
				dbTrainExamPerson.setOperateScore(operateScore);
			}
			if (isWritten) {
				dbTrainExamPerson.setWrittenScore(writtenScore);
			}
			dbTrainExamPerson.setUpdateBy(currentUser.getUsername());
			dbTrainExamPerson.setUpdateTime(new Date());
			trainExamPersonDao.updateScore(dbTrainExamPerson);
			List<TrainExamPerson> systemExamPersonList = new ArrayList<>();

			systemExamPersonList.add(dbTrainExamPerson);
			personcertificateDao.updateIsMakeUp(systemExamPersonList);
		}
		return dbTrainExamPerson;
	}
	@Override
	public  void deleteTestForApporvalId(Long[] ids){
		trainExamPersonDao.deleteTestForApporvalId(ids);
	}

	@Override
	public String batchSave(List<TrainExamPerson> trainExamPersons) {
		User currentUser = arsUtil.getCurrentUser();
		IdWorker idWorker = new IdWorker();
		int addSum = 0;// 新增总人数
		int errorAddSum = 0; // 新增失败人数
		StringBuffer errorSb = new StringBuffer("");
		String resultMsg = "";// 返回结果
		if (trainExamPersons != null && trainExamPersons.size() > 0) {
			List<String> idCards = new ArrayList<String>();
			for (TrainExamPerson item : trainExamPersons) {
				idCards.add(item.getIdentitynumber());
				addSum++;
				item.setId(idWorker.nextId());
				item.setCreateTime(new Date());
				item.setUpdateTime(new Date());
				item.setUpdateBy(currentUser.getUsername());
				item.setCreateBy(currentUser.getUsername());
			}
			// 校验考试人员是否已安排过该考场
			List<TrainExamPerson> isExitPersonList = trainExamPersonDao.checkPersonInExam(idCards);
			if (isExitPersonList != null && isExitPersonList.size() > 0) {
				// 去除重复人员名单
				for (TrainExamPerson isExitItem : isExitPersonList) {
					for (TrainExamPerson item : trainExamPersons) {
						if (isExitItem.getIdentitynumber().equals(item.getIdentitynumber())) {
							trainExamPersons.remove(item);
							errorSb.append("身份证号：" + item.getTicket() + ",姓名：" + item.getFullname() + "已经安排过考试");
							errorAddSum++;
							break;
						}
					}
				}
			}
			if (trainExamPersons != null && trainExamPersons.size() > 0) {
				trainExamPersonDao.batchSave(trainExamPersons);
			}
			if (errorAddSum > 0) {
				resultMsg = MessageFormat.format("添加考试人员完成：添加条数【{0}】,其中成功条数:{1},失败条数:{2}<br>", addSum,
						addSum - errorAddSum, errorAddSum);
				resultMsg = resultMsg + errorSb.toString();
			}
		}
		return resultMsg;
	}

	@Override
	public AjaxResult exportData(Long examID) {
		AjaxResult result = new AjaxResult();
		TrainExamInfo dbTrainExamInfo = trainExamInfoDao.selectByPrimaryKey(examID);
		if (dbTrainExamInfo == null) {
			throw new ArsException("查无此考场信息！");
		}
		//ConvertUtils.register(new DateConverter(), java.util.Date.class);
		ConvertUtils.register(new SqlDateConverter(null), java.sql.Date.class);
		ConvertUtils.register(new BigDecimalConverter(null), java.math.BigDecimal.class);

		TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
		trainExamPersonSearchDto.setExamID(examID);
		List<TrainExamPerson> list = trainExamPersonDao.list(trainExamPersonSearchDto);



		List<TrainExamPersonResultExportExcelBean> resultBeans = new ArrayList<TrainExamPersonResultExportExcelBean>();
		int index = 1;
		for (TrainExamPerson item : list) {
			TrainExamPersonResultExportExcelBean bean = new TrainExamPersonResultExportExcelBean();
			BeanUtils.copyProperties(item, bean);

			SecurityCertificate securityCertificate = securityCertificateDao.findByIdnum(item.getIdentitynumber());
			if(null!=securityCertificate){
				bean.setZsbh(securityCertificate.getZsbh());
			}else{
				bean.setZsbh("");
			}
			bean.setIndex(index);
			index++;
			if (bean.getTestState() != null) {
				if (bean.getTestState().equals(Constants.TESTSTATE_NO)) {
					bean.setTestState("不合格");
				} else if (bean.getTestState().equals(Constants.TESTSTATE_YES)) {
					bean.setTestState("合格");
				}
			}
			if (bean.getNoticeState() != null) {
				if (bean.getNoticeState().equals(Constants.NOTICESTATECODE_NO)) {
					bean.setNoticeState("未通知");
				} else if (bean.getNoticeState().equals(Constants.NOTICESTATECODE_YES)) {
					bean.setNoticeState("已通知");
				}
			}
			if (bean.getScoreMsgState() != null) {
				if (bean.getScoreMsgState().equals(Constants.SCOREMSGSTATECODE_NO)) {
					bean.setScoreMsgState("未通知");
				} else if (bean.getScoreMsgState().equals(Constants.SCOREMSGSTATECODE_YES)) {
					bean.setScoreMsgState("已通知");
				}
			}
			if (bean.getCardState() != null) {
				if (bean.getCardState().equals(Constants.CARDSTATECODE_NO)) {
					bean.setCardState("未制证");
				} else if (bean.getCardState().equals(Constants.CARDSTATECODE_YES)) {
					bean.setCardState("已制证");
				}
			}
			resultBeans.add(bean);
			result.setData(resultBeans);
		}
		return result;
	}

	@Override
	public void downLoad(String resultBeansJSON, OutputStream os) {
		ExcelUtil<TrainExamPersonResultExportExcelBean> util = new ExcelUtil<TrainExamPersonResultExportExcelBean>(
				TrainExamPersonResultExportExcelBean.class);
		if (StringUtil.isNotEmpty(resultBeansJSON)) {
			List<TrainExamPersonResultExportExcelBean> resultBeans = JSON.parseArray(resultBeansJSON,
					TrainExamPersonResultExportExcelBean.class);
			util.exportExcel(resultBeans, "学员成绩信息汇总表", 65535, os);
		}
	}

	@Override
	public AjaxResult template(Long examID, OutputStream os) {
		AjaxResult result = new AjaxResult();
		TrainExamInfo dbTrainExamInfo = trainExamInfoDao.selectByPrimaryKey(examID);
		if (dbTrainExamInfo == null) {
			throw new ArsException("查无此考场信息！");
		}
		//ConvertUtils.register(new DateConverter(), java.util.Date.class);
		ConvertUtils.register(new SqlDateConverter(null), java.sql.Date.class);
		ConvertUtils.register(new BigDecimalConverter(null), java.math.BigDecimal.class);

		TrainExamPersonSearchDto trainExamPersonSearchDto = new TrainExamPersonSearchDto();
		trainExamPersonSearchDto.setExamID(examID);
		List<TrainExamPerson> list = trainExamPersonDao.list(trainExamPersonSearchDto);

		List<TrainExamPersonResultTemplateExcelBean> resultBeans = new ArrayList<TrainExamPersonResultTemplateExcelBean>();
		for (TrainExamPerson item : list) {
			TrainExamPersonResultTemplateExcelBean bean = new TrainExamPersonResultTemplateExcelBean();
			BeanUtils.copyProperties(item, bean);
			if (StringUtil.isEmpty(item.getTestState())) {
				bean.setWrittenScore(null);
				bean.setOperateScore(null);
			}
			resultBeans.add(bean);
		}
		ExcelUtil<TrainExamPersonResultTemplateExcelBean> util = new ExcelUtil<TrainExamPersonResultTemplateExcelBean>(
				TrainExamPersonResultTemplateExcelBean.class);
		util.exportExcel(resultBeans, "学员成绩名单表", 65535, os);
		result.setSuccessful(true);
		return result;
	}

	@Override
	public AjaxResult importResult(Long examID, InputStream inputStream, String fileType) throws IOException {
		AjaxResult result = new AjaxResult();
		String resultMsg = "";
		TrainExamInfo dbTrainExamInfo = trainExamInfoDao.selectByPrimaryKey(examID);
		if (dbTrainExamInfo == null) {
			throw new ArsException("查无此考场信息！");
		}
		// 获取导入文件
		ExcelUtil<TrainExamPersonResultTemplateExcelBean> beanUtil = new ExcelUtil<TrainExamPersonResultTemplateExcelBean>(
				TrainExamPersonResultTemplateExcelBean.class);
		List<TrainExamPersonResultTemplateExcelBean> srclist = beanUtil.importExcel(inputStream, fileType);
		inputStream.close();
		int importCount = beanUtil.getImportCount();
		int importErrorCount = beanUtil.getImportError();
		if (importErrorCount > 0) {
			result.setSuccessful(false);
			resultMsg = "导入失败：<br>" + beanUtil.getErrorMsg();
			result.setMsg(resultMsg);
		} else {
			Integer unqualified = updatePerson(beanUtil, srclist, dbTrainExamInfo);
			importCount = beanUtil.getImportCount();
			importErrorCount = beanUtil.getImportError();
			if (importErrorCount > 0) {
				result.setSuccessful(false);
				String resultImport = MessageFormat.format("导入完成：导入条数【{0}】,其中成功条数:{1},失败条数:{2}<br>${3}", importCount,
						importCount - importErrorCount, importErrorCount,unqualified);
				resultMsg = resultImport + beanUtil.getErrorMsg();
				result.setMsg(resultMsg);
			} else if(importCount >0) {
				result.setSuccessful(true);
				result.setData(srclist);
				String resultImport = MessageFormat.format("导入完成：导入条数【{0}】,其中成功条数:{1},失败条数:{2}<br>${3}", importCount,
						importCount - importErrorCount, importErrorCount,unqualified);
				resultMsg = resultImport + beanUtil.getErrorMsg();
				result.setMsg(resultMsg);
			} else{
				result.setSuccessful(false);
				result.setMsg("导入失败，已经成绩通知不得重新导入！！！");
			}
		}
		return result;
	}

	/**
	 * 批量更新学员成绩
	 *
	 * @param beanUtil
	 * @param srclist
	 * @param dbTrainExamInfo
	 */
	Integer updatePerson(ExcelUtil<TrainExamPersonResultTemplateExcelBean> beanUtil,
			List<TrainExamPersonResultTemplateExcelBean> srclist, TrainExamInfo dbTrainExamInfo) {
		User currentUser = arsUtil.getCurrentUser();
		int index = 1;
		//不合格人数
		int unqualified =0;
		List<TrainExamPerson> systemExamPersonList = new ArrayList<TrainExamPerson>();
		if (srclist != null && srclist.size() > 0) {
			for (TrainExamPersonResultTemplateExcelBean item : srclist) {
				++index;
				TrainExamPersonSearchDto paramObj = new TrainExamPersonSearchDto();
				paramObj.setExamID(dbTrainExamInfo.getId());
				paramObj.setIdentitynumber(item.getTicket());
				List<TrainExamPerson> list = trainExamPersonDao.list(paramObj);
				// 存在该考场下的学员信息
				if (list != null && list.size() > 0) {
					TrainExamPerson person = list.get(0);
					//如果成绩已经通知，则不更新成绩
					if(Constants.SCOREMSGSTATECODE_YES.equals(person.getScoreMsgState())){
						beanUtil.setImportCount(beanUtil.getImportCount()-1);
						continue;
					}
					person.setWrittenScore(item.getWrittenScore());
					person.setOperateScore(item.getOperateScore());
					TrainExamPerson ob = trainExamPersonDao.findById(person.getId());
					if (ob != null) {
						int writtenRatio = dbTrainExamInfo.getWrittenRatio();// 笔试成绩比例
						int operateRatio = dbTrainExamInfo.getOperateRatio();// 体能成绩比例
						int writtenPassScore = dbTrainExamInfo.getWrittenPassScore(); // 笔试成绩通过分数
						int operatePassScore = dbTrainExamInfo.getOperatePassScore();// 体能成绩通过分数
						int examStandard = dbTrainExamInfo.getExamStandard();// 合格标准

						int operateScore = person.getOperateScore();// 体能成绩
						int writtenScore = person.getWrittenScore();// 笔试成绩

						Boolean isOperate = false, isWritten = false;

						// 判断考试类型
						if (dbTrainExamInfo.getIsComputerExam() > 0 && dbTrainExamInfo.getIsStamina() < 1) {
							operateScore = 0;
							isWritten = true;
						} else if (dbTrainExamInfo.getIsComputerExam() < 1 && dbTrainExamInfo.getIsStamina() > 0) {
							writtenScore = 0;
							isOperate = true;
						} else {
							isWritten = true;
							isOperate = true;
						}
						// 后判断考试规则
						if (dbTrainExamInfo.getExamRules() == Constants.EXAMRULES_ONE) {
							BigDecimal sumScore = BigDecimal.valueOf(operateScore + writtenScore);
							ob.setSumScore(sumScore);
							if (writtenScore >= writtenPassScore && operateScore >= operatePassScore) {
								// 总成绩大于等于双科及格分数则考试状态为合格
								ob.setTestState(Constants.TESTSTATE_YES);
							} else {
								ob.setTestState(Constants.TESTSTATE_NO);
								unqualified++;
							}
						} else if (dbTrainExamInfo.getExamRules() == Constants.EXAMRULES_TOW) {
							BigDecimal sumScore = BigDecimal
									.valueOf((operateScore * operateRatio + writtenScore * writtenRatio) * 0.01);
							ob.setSumScore(sumScore);
							if (sumScore.compareTo(BigDecimal.valueOf(Long.valueOf(examStandard))) >= 0) {
								ob.setTestState(Constants.TESTSTATE_YES);// 总成绩大于等于合格标准则考试状态为合格
							} else {
								ob.setTestState(Constants.TESTSTATE_NO);
								unqualified++;
							}
						}
						if (isOperate) {
							ob.setOperateScore(operateScore);
						}
						if (isWritten) {
							ob.setWrittenScore(writtenScore);
						}
						ob.setUpdateBy(currentUser.getUsername());
						ob.setUpdateTime(new Date());
						systemExamPersonList.add(ob);
					}
				} else {
					String errorMsg = MessageFormat.format("第【{0}】行数据不存在该考场学员,学员姓名为【{1}】<br>", index,
							item.getFullname());
					beanUtil.getErrorMsg().append(errorMsg);
					beanUtil.setImportError(beanUtil.getImportError() + 1);
					continue;
				}
			}
			// 批量修改学员信息
			if (systemExamPersonList != null && systemExamPersonList.size() > 0) {
				trainExamPersonDao.updatePScore(systemExamPersonList);
				//批量更新是否补考状态
				personcertificateDao.updateIsMakeUp(systemExamPersonList);
			}
		}
		return unqualified;
	}

	@Override
	public String sendExamNotice(TrainExamPersonSearchDto trainExamPersonSearchDto) {
		trainExamPersonSearchDto.setNoticeState(Constants.NOTICESTATECODE_NO);
		List<TrainExamPerson> list = trainExamPersonDao.list(trainExamPersonSearchDto);
		TrainExamInfo trainExamInfo = trainExamInfoDao.selectByPrimaryKey(trainExamPersonSearchDto.getExamID());
		int noticeSum = 0;// 通知总人数
		int errorNoticeSum = 0; // 通知失败人数
		StringBuffer errorSb = new StringBuffer("");
		String resultMsg = "";// 返回消息
		if (list != null && list.size() > 0) {
			noticeSum = list.size();
			// 考试信息通知：未通知学员
			List<Long> ids = new ArrayList<Long>();
			Config config = configDao.findByKey(Constants.POLICE);
			for (TrainExamPerson item : list) {
				try {
					Personcertificate personcertificate = personcertificateDao.findById(item.getBbdPersonID());
					//已结束不能再通知
					if (personcertificate != null && Constants.PROSTATE_YES.equals(personcertificate.getProState())) {
						errorSb.append("准考证号：" + item.getTicket() + ",姓名：" + item.getFullname() + "考试已结束，不能再通知" + "<br>");
						errorNoticeSum++;
						continue;
					}
					if (personcertificate != null) {
						// 外网：发送考试通知给考生
						if (config != null && StringUtil.isNotEmpty(config.getValue())
								&& "0".equals(config.getValue())) {
							// 考试安排短信通知
							SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy年MM月dd日");
							SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
							String title = "";// 标题
							String appContent = "";// APP通知内容
							String msgContent = "";// 短信通知内容
							String name = item.getFullname();
							title = Constants.EXAM_NEW_NOTE_TITLE;
							msgContent = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CONTENT_MSG_V1171;
							msgContent = msgContent.replace("{name}", name)
									.replace("{examDate}", dateFormat.format(trainExamInfo.getComputerStartDate()))
									.replace("{examStart}", timeFormat.format(trainExamInfo.getComputerStartDate()))
									.replace("{examEnd}", timeFormat.format(trainExamInfo.getComputerEndDate()))
									.replace("{examAddress}", trainExamInfo.getTheoreticalAddress())
									.replace("{staminaDate}", dateFormat.format(trainExamInfo.getStaminaStartDate()))
									.replace("{staminaStartDate}",
											timeFormat.format(trainExamInfo.getStaminaStartDate()))
									.replace("{staminaEndDate}", timeFormat.format(trainExamInfo.getStaminaEndDate()))
									.replace("{staminaAddress}", trainExamInfo.getStaminaAddress());
							appContent = Constants.APPROVAL_PERSONCERTIFICATE_EXAM_CONTENT_APP_V1171;
							appContent = appContent.replace("{name}", name)
									.replace("{examDate}", dateFormat.format(trainExamInfo.getComputerStartDate()))
									.replace("{examStart}", timeFormat.format(trainExamInfo.getComputerStartDate()))
									.replace("{examEnd}", timeFormat.format(trainExamInfo.getComputerEndDate()))
									.replace("{examAddress}", trainExamInfo.getTheoreticalAddress())
									.replace("{staminaDate}", dateFormat.format(trainExamInfo.getStaminaStartDate()))
									.replace("{staminaStartDate}",
											timeFormat.format(trainExamInfo.getStaminaStartDate()))
									.replace("{staminaEndDate}", timeFormat.format(trainExamInfo.getStaminaEndDate()))
									.replace("{staminaAddress}", trainExamInfo.getStaminaAddress());
								/****************华为短信*****************/
								String smsCode = MSGConstants.SMSCODE_B66;
								String[] msgParams =  new String[]{
										dateFormat.format(trainExamInfo.getComputerStartDate()),
										timeFormat.format(trainExamInfo.getComputerStartDate()),
										timeFormat.format(trainExamInfo.getComputerEndDate()),
										trainExamInfo.getTheoreticalAddress(),
										dateFormat.format(trainExamInfo.getStaminaStartDate()),
										timeFormat.format(trainExamInfo.getStaminaStartDate()),
										timeFormat.format(trainExamInfo.getStaminaEndDate()),
										trainExamInfo.getStaminaAddress()

								};
							/**
							 * 北京环境不发
							 */
							if(!Constants.BEIJING.equals(configUtils.getCurrentNative())) {
								this.sendMsgHeiWei(personcertificate, title, msgContent, appContent, trainExamPersonSearchDto.getSendMsg(), msgParams, smsCode);
							}
								/*****************华为短信****************/

						}
						ids.add(item.getId());
					}
				} catch (Exception e) {
					errorSb.append("准考证号：" + item.getTicket() + ",姓名：" + item.getFullname() + "发送考试通知失败");
					errorNoticeSum++;
					continue;
				}
			}
			if (ids != null && ids.size() > 0) {
				trainExamPersonDao.updateBatchYesNoticeStateByPrimaryKey(ids);
				// 批量设置考试安排信息
				if (config != null && StringUtil.isNotEmpty(config.getValue()) && "1".equals(config.getValue())) {
					// 公安内网
					personcertificateDao.updateInnerBatchByExamPersonIds(ids);
				} else {
					// 公安外网
					personcertificateDao.updateOutBatchByExamPersonIds(ids);
				}
			}
		}
		if (errorNoticeSum > 0) {
			resultMsg = MessageFormat.format("发送考试通知完成：发送条数【{0}】,其中成功条数:{1},失败条数:{2}<br>", noticeSum,
					noticeSum - errorNoticeSum, errorNoticeSum);
			resultMsg = resultMsg + errorSb.toString();
		} else {
			resultMsg = MessageFormat.format("发送考试通知完成：发送条数【{0}】,其中成功条数:{1},失败条数:{2}<br>", noticeSum,
					noticeSum - errorNoticeSum, errorNoticeSum);
		}
		return resultMsg;
	}

	@Override
	public String sendScoreNotice(TrainExamPersonSearchDto trainExamPersonSearchDto) {
		trainExamPersonSearchDto.setScoreMsgState(Constants.SCOREMSGSTATECODE_NO);
		List<TrainExamPerson> list = trainExamPersonDao.list(trainExamPersonSearchDto);
		int noticeSum = 0;// 通知总人数
		int errorNoticeSum = 0; // 通知失败人数
		StringBuffer errorSb = new StringBuffer("");
		String resultMsg = "";// 返回消息
		if (list != null && list.size() > 0) {
			noticeSum = list.size();
			// 考试成绩通知：未通知学员
			List<Long> ids = new ArrayList<Long>();
			for (TrainExamPerson item : list) {
				try {
					Personcertificate personcertificate = personcertificateDao.findById(item.getBbdPersonID());
					if (personcertificate == null) {
						errorSb.append("准考证号：" + item.getTicket() + ",姓名：" + item.getFullname() + "找不到报名信息" + "<br>");
						errorNoticeSum++;
						continue;
					}
					//已结束不能再通知
					if (personcertificate != null && Constants.PROSTATE_YES.equals(personcertificate.getProState())) {
						errorSb.append("准考证号：" + item.getTicket() + ",姓名：" + item.getFullname() + "考试已结束，不能再通知" + "<br>");
						errorNoticeSum++;
						continue;
					}
                    //还没考试通知不能成绩通知
                    if (personcertificate != null &&
                            (
                                            personcertificate.getExamState()== null ||
                                            "".equals(personcertificate.getExamState()) ||
                                            Constants.EXAMSTATE_NORMAL.equals(personcertificate.getExamState())
                                    )
                            ) {
                        errorSb.append("准考证号：" + item.getTicket() + ",姓名：" + item.getFullname() + "还没考试通知，不能成绩通知" + "<br>");
                        errorNoticeSum++;
                        continue;
                    }
					int examTimes = 1;// 考试次数
					personcertificate.setWrittenScore(item.getWrittenScore());
					// 理论成绩
					personcertificate.setOperateScore(item.getOperateScore());
					// 实操成绩
					personcertificate.setSumScore(item.getSumScore().doubleValue());//
					// 总成绩
					personcertificate.setTestState(item.getTestState());
					personcertificate.setExamTimes(examTimes);
					personcertificate.setUpdateTime(new Date());

					// 读取配置文件
					Config config = configDao.findByKey(Constants.POLICE);
					if (config != null && StringUtil.isNotEmpty(config.getValue()) && "0".equals(config.getValue())) {
						/*********华为短信********/
						String smsCode ="";
						String[] msgParams =null;
						/*********华为短信********/

						// 公安外网
						// edit subh 2018-06-29 修改成根据身份证获取保安员证信息 start
						Personcertificate dbPersoncertificate = personcertificateDao
								.findById(personcertificate.getId());
						// edit subh 2018-06-29 修改成根据身份证获取保安员证信息 end
						if (Constants.TEST_STATE_WTG.equals(dbPersoncertificate.getTestState())) {
							//考试不通过
							//personcertificate.setApprovalstate(ApprovalState.SPZ);
							//补考不通过
							if(Constants.MAKEUP_YES.equals(personcertificate.getIsMakeUp())){
								personcertificate.setMakeUpstate(Constants.MAKEUP_STATE_BTG);
							}

							/*********华为短信********/
							smsCode = MSGConstants.SMSCODE_B70;
							/*********华为短信********/
						} else if (Constants.TEST_STATE_TG.equals(dbPersoncertificate.getTestState())) {
							//补考通过
							if(Constants.MAKEUP_YES.equals(personcertificate.getIsMakeUp())){
								personcertificate.setMakeUpstate(Constants.MAKEUP_STATE_TG);
								personcertificate.setApprovalstate(ApprovalState.SPZ);
							}
							/*********华为短信********/
							smsCode = MSGConstants.SMSCODE_B71;
							/*********华为短信********/
						}

						/**
						 * 获取百课堂传过来的笔试成绩，判断是否为空，为空则赋值空字符串，不为空转换成字符串
						 */
						String  writtenScore =   personcertificate.getWrittenScore() == null ? "": personcertificate.getWrittenScore().toString();
						/**
						 * 获取 百课堂传过来的实操成绩，判断是否为空，为空则赋值空字符串，不为空转换成字符串
						 */
						String operateScore = personcertificate.getOperateScore() == null ? "": personcertificate.getOperateScore().toString();

						CustomPersoncertificateService customPersoncertificateService = CustomPersoncertificateBeanFactory.getPersoncertificateBean();

						// 考试通过通知
						String title = Constants.EXAM_NOTE_TITLE;// 考试通知标题

						//信息内容
						String content = customPersoncertificateService.getMsgTemp_V1171(Constants.TEMPTYPE_CONTENT,personcertificate.getTestState());
						//信息标题
						String newstitle = customPersoncertificateService.getMsgTemp_V1171(Constants.TEMPTYPE_TITLE,personcertificate.getTestState());
						//信息内容
							content = content.replace("{writtenScore}",writtenScore)
								.replace("{operateScore}", operateScore);
						//信息标题
						newstitle = newstitle.replace("{name}", personcertificate.getName())
								.replace("{writtenScore}", writtenScore)
								.replace("{operateScore}", operateScore);

						/*********华为短信********/
						msgParams =new String[]{
								writtenScore,
								operateScore
						};
						if(StringUtil.isNotEmpty(smsCode)){
							this.sendMsgHeiWei(personcertificate, title, newstitle, content, Constants.NOTICE_PERSON_YES,msgParams,smsCode);
						}else {
							this.sendMsg(personcertificate, title, newstitle, content, Constants.NOTICE_PERSON_YES);
						}
						/*********华为短信********/
					} else {
						try {
							// 公安内网，走审批流程
							ApprovalDTO approvalDTO = new ApprovalDTO();
							//配置 是否需要流程
							Config isNeedActivity = configDao.findByKey(Constants.IS_NEED_ACTIVITY);
							if(null!=isNeedActivity&&Constants.IS_NEED_ACTIVITY_NO.equals(isNeedActivity.getValue())){
								approvalDTO.setIsNeedActivity(Constants.IS_NEED_ACTIVITY_NO);
							}
							approvalDTO.setProstate(personcertificate.getProState());
							if (!Constants.PROSTATE_YES.equals(personcertificate.getProState())) {
								// 如果考试状态为通过，则制证状态为提交审核
								if (personcertificate.getTestState().equals(Constants.TEST_STATE_TG)) {
                                    //补考通过
                                    if(Constants.MAKEUP_YES.equals(personcertificate.getIsMakeUp())){
                                        personcertificate.setMakeUpstate(Constants.MAKEUP_STATE_TG);
                                        personcertificate.setApprovalstate(ApprovalState.SPZ);
                                    }
                                    // 审核通过,调用方法
                                    approvalDTO.setBusinesstype(BusinessType.BAYZ);
                                    approvalDTO.setBusinessid(personcertificate.getId());
                                    approvalDTO.setApprovalstate(ApprovalState.SHTG);
                                    approvalDTO.setApprovalreason("自动审批通过");
                                    approvalService.saveApprovalForZZ(approvalDTO);
                                } else {
                                    //补考不通过
                                    if(Constants.MAKEUP_YES.equals(personcertificate.getIsMakeUp())){
                                        personcertificate.setMakeUpstate(Constants.MAKEUP_STATE_BTG);
                                    }
                                    //考试不通过
                                    //personcertificate.setApprovalstate(ApprovalState.SPZ);
                                    // 审核不通过,调用方法
                                    approvalDTO.setBusinesstype(BusinessType.BAYZ);
                                    approvalDTO.setBusinessid(personcertificate.getId());
                                    approvalDTO.setApprovalstate(ApprovalState.SHBTG);
                                    approvalDTO.setApprovalreason("自动审批不通过");
                                    approvalService.saveApprovalForZZ(approvalDTO);
                                }
							}
						} catch (Exception e) {
							throw new ArsException("发送考试成绩通知失败:启用审批流程配置出错！");
						}
					}
					if(Constants.PROSTATE_YES.equals(personcertificate.getProState())){
						personcertificate.setApprovalstate(ApprovalState.SHBTG);
					}
					personcertificateDaoAop.updateSelective(personcertificate);
					ids.add(item.getId());
				} catch (Exception e) {
					e.printStackTrace();
					if (e instanceof ArsException) {
						throw new ArsException("发送考试成绩通知失败:启用审批流程出错！");
					} else {
						errorSb.append("准考证号：" + item.getTicket() + ",姓名：" + item.getFullname() + "发送成绩通知失败");
						errorNoticeSum++;
						continue;
					}
				}
			}
			if (ids != null && ids.size() > 0) {
				trainExamPersonDao.updateBatchYesScoreStateByPrimaryKey(ids);
			}
		}
		if (errorNoticeSum > 0) {
			resultMsg = MessageFormat.format("发送成绩通知完成：发送条数【{0}】,其中成功条数:{1},失败条数:{2}<br>", noticeSum,
					noticeSum - errorNoticeSum, errorNoticeSum);
			resultMsg = resultMsg + errorSb.toString();
		} else {
			resultMsg = MessageFormat.format("发送成绩通知完成：发送条数【{0}】,其中成功条数:{1},失败条数:{2}<br>", noticeSum,
					noticeSum - errorNoticeSum, errorNoticeSum);
		}
		return resultMsg;
	}

	/**
	 * 导入考试人员信息
	 * 
	 * @param searchDto
	 * @return
	 */
	@Override
	public List<TrainExamPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return trainExamPersonDao.searchForDataSynchronization(searchDto);
	}

	/**
	 * 数据导入
	 * 
	 * @param trainExamPerson
	 */
	@Override
	public void saveOrUpdateForDS(TrainExamPerson trainExamPerson) {

		if (trainExamPerson.getActive() == null) {
			trainExamPerson.setActive(true);
		}
		TrainExamPerson dbTrainExamPerson = trainExamPersonDao.findById(trainExamPerson.getId());
		if (dbTrainExamPerson != null) {
			if (trainExamPerson.getUpdateTime().getTime() > dbTrainExamPerson.getUpdateTime().getTime()) {
				trainExamPersonDao.updateForDS(trainExamPerson);

			}
		} else {
			trainExamPersonDao.saveForDS(trainExamPerson);
		}

	}

	/**
	 * 
	 * @param personcertificate
	 * @param title
	 *            标题
	 * @param msgContent
	 *            短信通知内容
	 * @param appContent
	 *            APP通知内容
	 */
	private void sendMsg(Personcertificate personcertificate, String title, String msgContent, String appContent,String sendMsg) {
		if (StringUtils.isEmpty(title) || StringUtils.isEmpty(msgContent) || StringUtils.isEmpty(appContent)) {
			logger.error("TrainExamPersonServiceImpl类sendMsg方法：发送消息通知传递参数title或者msgContent或者appContent为空");
			return;
		}
		new Thread(() -> {
			try {
				if (personcertificate.getPersonid() == null) {
					// 自然人考试报名,手机号码不为空则发送短信
					if(Constants.NOTICE_PERSON_YES.equals(sendMsg)){
						if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
							MessageUtil.sendMessage(personcertificate.getPhone(), msgContent, messageLogDao);
						}
					}
				} else {
					// 判断是否有app
					boolean hasApp = false;
					// 推送ID
					String registrationID = "";
					SecurityPerson person = securityPersonDao.findById(personcertificate.getPersonid());
					// 判断考试人员是否在职
					if (personcertificate.getCompanyid() != null) {
						// 有APP登陆信息，则发送APP推送通知、APP站内消息
						if (hasApp) {
							AppNotice appNotice = new AppNotice();
							appNotice.setNoticeTitle(title);
							appNotice.setCreateTime(new Date());
							appNotice.setActive(true);
							appNotice.setNoticeContent("【考试通知】" + appContent.replaceAll("，", "\\\\n"));
							appNotice.setNoticeTypeID(2L);
							appNotice.setPersonId(person.getId());
							appNotice.setReadStatus("0");
							appNotice.setUpdateTime(new Date());
							appNoticeDao.save(appNotice);
							JPushUtil.sendMessage(title, "【考试通知】" + appContent, registrationID);
						} else {
							// 发送短信通知
							if(Constants.NOTICE_PERSON_YES.equals(sendMsg)){
								if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
									MessageUtil.sendMessage(personcertificate.getPhone(), msgContent, messageLogDao);
								}
							}
						}
					}
				}
			} catch (Exception e) {
				logger.error(e.getMessage(),e);
			}
		}).start();
	}


	/**
	 *  华为短信
	 * @param personcertificate
	 * @param title
	 *            标题
	 * @param msgContent
	 *            短信通知内容
	 * @param appContent
	 *            APP通知内容
	 */
	private void sendMsgHeiWei(Personcertificate personcertificate, String title, String msgContent, String appContent,String sendMsg,String[] params,String smsCode) {
		if (StringUtils.isEmpty(title) || StringUtils.isEmpty(msgContent) || StringUtils.isEmpty(appContent)) {
			logger.error("TrainExamPersonServiceImpl类sendMsg方法：发送消息通知传递参数title或者msgContent或者appContent为空");
			return;
		}
		new Thread(() -> {
			try {
				if (personcertificate.getPersonid() == null) {
					// 自然人考试报名,手机号码不为空则发送短信
					if(Constants.NOTICE_PERSON_YES.equals(sendMsg)){
						if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
							MessageUtil.sendMessageHuaWei(personcertificate.getPhone(), msgContent, messageLogDao,params,smsCode);
						}
					}
				} else {
					// 判断是否有app
					boolean hasApp = false;
					// 推送ID
					String registrationID = "";
					SecurityPerson person = securityPersonDao.findById(personcertificate.getPersonid());
					// 判断考试人员是否在职
					if (personcertificate.getCompanyid() != null) {
						// 有APP登陆信息，则发送APP推送通知、APP站内消息
						if (hasApp) {
							AppNotice appNotice = new AppNotice();
							appNotice.setNoticeTitle(title);
							appNotice.setCreateTime(new Date());
							appNotice.setActive(true);
							appNotice.setNoticeContent("【考试通知】" + appContent.replaceAll("，", "\\\\n"));
							appNotice.setNoticeTypeID(2L);
							appNotice.setPersonId(person.getId());
							appNotice.setReadStatus("0");
							appNotice.setUpdateTime(new Date());
							appNoticeDao.save(appNotice);
							JPushUtil.sendMessage(title, "【考试通知】" + appContent, registrationID);
						} else {
							// 发送短信通知
							if(Constants.NOTICE_PERSON_YES.equals(sendMsg)){
								if (StringUtils.isNotEmpty(personcertificate.getPhone())) {
									MessageUtil.sendMessageHuaWei(personcertificate.getPhone(), msgContent, messageLogDao,params,smsCode);
								}
							}
						}
					}
				}
			} catch (Exception e) {
				logger.error(e.getMessage(),e);
			}
		}).start();
	}
}