package com.bcxin.ars.service.epidemic;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.epidemic.EpidemicDao;
import com.bcxin.ars.dao.epidemic.EpidemicDaoAop;
import com.bcxin.ars.dao.epidemic.RiskAreaDao;
import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.epidemic.EpidemicSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.epidemic.Epidemic;
import com.bcxin.ars.model.epidemic.RiskArea;
import com.bcxin.ars.model.task.ComTask;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/***
 * 疫情防控
 * @author subh
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = Epidemic.class)
public class EpidemicServiceImpl implements EpidemicService {

    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private EpidemicDao epidemicDao;

    @Autowired
    private EpidemicDaoAop epidemicDaoAop;
    @Autowired
    private ComTaskDao comTaskDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private RiskAreaDao riskAreaDao;

    /***
     * 设置街道名称
     * @param record
     */
    private void queryStreet(Epidemic record){
        if(record.getStreetId() != null ) {
            RiskArea riskArea = riskAreaDao.findById(record.getStreetId());
            //街道名称
            record.setStreetName(riskArea.getStreetName());
            //风险级别
            record.setRiskLevel(riskArea.getRiskLevel());
        }
    }
    @Override
    public int insert(Epidemic record) {
        //当前用户
        User currentUser = arsUtil.getCurrentUser();
        if(currentUser==null){
            throw new ArsException("用户信息缺失，请刷新页面！");
        }
        //公司
        record.setUserId( currentUser.getId());
        //判断是否重复录入驻勤点信息
        List<Epidemic> list  = new ArrayList();
        Epidemic queryP  =new Epidemic();
        queryP.setUserId(currentUser.getId());
        if(record.getTaskId()!=null){
            queryP.setTaskId(record.getTaskId());
        }else{
            queryP.setTaskName(record.getTaskName());
        }
        list  = epidemicDao.find(queryP);
        if(list!=null && list.size()>0){
            if(Constants.FILLEDTYPE_Y.equals(record.getFilledType())) {
                throw new ArsException("今日已填写驻勤点【" + record.getTaskName() + "】疫情防控信息");
            }else{
                throw new ArsException("今日已填写疫情防控信息");
            }
        }
        //获取企业信息
        queryCompanyInfo(record);
        //设置驻勤点信息
        queryTask(record);
        //设置街道名称
        queryStreet(record);
        //有效状态
        record.setActive(true);
        //创建时间
        record.setCreateTime(new Date());
        record.setFilledByTime(new Date());
        //更新时间
        record.setUpdateTime(new Date());
        //更新者
        record.setUpdateBy(currentUser == null ? "system":currentUser.getUsername());
        return epidemicDao.insert(record);
    }

    @Override
    public Epidemic findById(Long id) {
        return epidemicDao.findById(id);
    }

    /***
     * 获取企业信息
     * @param record
     */
    private void queryCompanyInfo(Epidemic record){
        //当前用户
        User currentUser = arsUtil.getCurrentUser();
        //获取公司信息
        SecurityCompany company = securityCompanyDao.findByUserid(currentUser.getId());
        if(company!=null) {
            //监管机构信息
            record.setOrgId(company.getOrgId()!=null?Long.valueOf(company.getOrgId()):null);
            //所属区域
            record.setAreaCode(company.getAreaCode());
            //监控机构
            record.setOrgName(company.getOrgName());
            //公司名称
            record.setCompanyName(company.getName());
        }
    }

    /***
     * 设置驻勤点信息
     * @param record
     */
    private void queryTask(Epidemic record){
        if(record.getTaskId()!=null){
            ComTask task = comTaskDao.findById(record.getTaskId());
            record.setTaskAddress(task.getTaskAddress());
            record.setTaskName(task.getTaskName());
        }
    }

    @Override
    public int update(Epidemic record) throws Exception {
        //当前用户
        User currentUser = arsUtil.getCurrentUser();
        if(currentUser==null){
            throw new ArsException("用户信息缺失，请刷新页面！");
        }
        Epidemic dbEpidemic = findById(record.getId());
        if(!DateUtil.convertDateToString(dbEpidemic.getCreateTime(),DateUtil.FORMAT2).equals(DateUtil.getCurrentDate()) ){
            throw new ArsException("只能修改当天的数据！");
        }
        //判断今天是否有录入同样的驻勤点
        record.setUserId( currentUser.getId());
        List list  = new ArrayList();
        Epidemic queryP  =new Epidemic();
        queryP.setId(record.getId());
        queryP.setUserId(currentUser.getId());
        if(record.getTaskId()!=null){
            queryP.setTaskId(record.getTaskId());
        }else{
            queryP.setTaskName(record.getTaskName());
        }
        list  = epidemicDao.find(queryP);
        if(list!=null && list.size()>0){
            if(Constants.FILLEDTYPE_Y.equals(record.getFilledType())) {
                throw new ArsException("今日已填写驻勤点【" + record.getTaskName() + "】疫情防控信息");
            }else{
                throw new ArsException("今日已填写疫情防控信息");
            }
        }
        //获取企业信息
        queryCompanyInfo(record);
        //设置驻勤点信息
        queryTask(record);
        //设置街道名称
        queryStreet(record);
        //更新时间
        record.setUpdateTime(new Date());
        //有效状态
        record.setActive(true);
        //更新者
        record.setUpdateBy(currentUser == null ? "system":currentUser.getUsername());
        return epidemicDaoAop.update(record);
    }

    @Override
    public long findByStreetCount(Epidemic epidemic) {
        return epidemicDao.findByStreetCount(epidemic);
    }

    @Override
    public List<Epidemic> searchForPage(EpidemicSearchDto searchDto, AjaxPageResponse<Epidemic> page) {
        //当前用户
        User currentUser = arsUtil.getCurrentUser();
        //单位
        if (currentUser.getPlatform() == Constants.PLATFORM_COMPANY){
            searchDto.setUserId(currentUser.getId());
        //公安
        }else if(currentUser.getPlatform() == Constants.PLATFORM_POLICE){
            //数据权限
            arsUtil.setPoliceSearchAll(searchDto);
        }
        return epidemicDao.searchForPage(searchDto,page);
    }
    @Override
    public void saveOrUpdateForDS(Epidemic epidemic){
        Epidemic dbEpidemic =findById(epidemic.getId());
        if (dbEpidemic != null && epidemic.getUpdateTime().getTime() >= dbEpidemic.getUpdateTime().getTime()) {
            epidemicDao.update(epidemic);
        }else {
            epidemicDao.insert(epidemic);
        }
    }
    @Override
    public List<Epidemic> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return epidemicDao.searchForDataSynchronization(searchDto);
    }
    @Override
    public int del(Epidemic record) {
        //获取记录
        record =  findById(record.getId());
        Epidemic dbEpidemic = findById(record.getId());
        if(!DateUtil.convertDateToString(dbEpidemic.getCreateTime(),DateUtil.FORMAT2).equals(DateUtil.getCurrentDate())){
            throw new ArsException("只能删除当天的的数据！");
        }
        //有效状态
        record.setActive(false);
        return epidemicDaoAop.update(record);
    }

    @Override
    public Epidemic findNew(Long userId) {
        List<Epidemic> list  = epidemicDao.findByUserId(userId);
        if(list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Override
    public void saveCopyYesterdayData() {
        Epidemic epidemic =  new Epidemic();
        //当前用户
        User currentUser = arsUtil.getCurrentUser();
        //用户ID
        epidemic.setUserId(currentUser.getId());
        //填报时间
        epidemic.setFilledByTime(new Date());
        //保存列表
        List<Epidemic> saveList = new ArrayList();
        //今天数据
        List<Epidemic> toDayList = epidemicDao.findUserIdAndDate(epidemic);
        epidemic.setFilledByTime(DateUtil.convertStringToDate(DateUtil.getYesterday()));
        //昨天数据
        List<Epidemic> yesterdayList = epidemicDao.findUserIdAndDate(epidemic);
        if(yesterdayList.size() == 0){
            throw new ArsException("昨天未填报，无数据可复制!");
        }
        //新建数据
        for (Epidemic e:yesterdayList
             ) {
            //标识是否要新增
            boolean addflag = true;
            for (Epidemic tmp:toDayList
                 ) {
                //判断是为长期驻勤点
                if(e.getTaskId()!=null){
                    //如果今日已新增的话，则不复制
                    if(e.getTaskId().equals(tmp.getTaskId())){
                        addflag=false;
                        break;
                    }
                }else{
                    //临时驻勤点按名称来复制，如果今天已新增同样的名称，则不复制
                    if(e.getTaskName()!=null && e.getTaskName().equals(tmp.getTaskName())){
                        addflag=false;
                        break;
                    }
                }
            }
            //需要复制
            if(addflag){
                //将复制对象加到内容中
                Epidemic newEpdiemic = new Epidemic();
                BeanUtils.copyPropertiesIgnore(e,newEpdiemic);
                newEpdiemic.setId(null);
                newEpdiemic.setCreateTime(new Date());
                newEpdiemic.setFilledByTime(new Date());
                newEpdiemic.setUpdateTime(new Date());
                //设置街道信息
                queryStreet(newEpdiemic);
                saveList.add(newEpdiemic);
            }
        }
        //判断有没有复制列表，没有则提示
        if(saveList.size()>0){
            epidemicDao.saveBatch(saveList);
        }else{
            throw new ArsException("昨天数据已全部复制，无须再操作");
        }
    }
}
