package com.bcxin.ars.service.enums;

import com.bcxin.ars.service.enums.impl.*;

/**
 * 通用导出公式的枚举类型
 */
public enum ExportExcelType {
    //取字段名的对应值
    FILED_NAME{
        @Override
        public ExportFormula getFormula() {
            return new FileNameExportRoster();
        }
    },
    SUM{
        @Override
        public ExportFormula getFormula() {
            return new SumFileNameExportRoster();
        }
    },
    SYS_CODE{
        @Override
        public ExportFormula getFormula() {
            return new CodeLableExportRoster();
        }
    },
    DATE_FOMAT{
        @Override
        public ExportFormula getFormula() {
            return new DateFormateExportRoster();
        }
    },
    SAVE_ONEPOINT{
        @Override
        public ExportFormula getFormula() {
            return new SaveOnePointExcportRoster();
        }
    }
    ;
    public abstract ExportFormula getFormula();
}
