package com.bcxin.ars.service.datasync.impl;


import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.datasync.DataSyncLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.datasync.DataSyncDto;
import com.bcxin.ars.dto.page.DataSyncLogPageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.bcxin.ars.service.datasync.DataSyncLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 数据同步记录Service业务层处理
 * 
 * @author lin
 * @date 2020-12-07
 */
@Service
public class DataSyncLogServiceImpl implements DataSyncLogService {
    
    Logger logger = LoggerFactory.getLogger(DataSyncLogServiceImpl.class);
    
    @Autowired
    private DataSyncLogDao dataSyncLogDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(DataSyncLog dataSyncLog) {
        User currentUser = arsUtil.getCurrentUser();
        dataSyncLog.setUpdateTime(new Date());
        dataSyncLog.setUpdateBy(currentUser.getUsername());
        return dataSyncLogDao.delete(dataSyncLog);
    }

    @Override
    public int save(DataSyncLog dataSyncLog) {
        if(dataSyncLog.getId() == null){
            dataSyncLog.setCreateTime(new Date());
        }else{
            DataSyncLog dbDataSyncLog = dataSyncLogDao.findById(dataSyncLog.getId());
            BeanUtils.copyPropertiesIgnore(dataSyncLog,dbDataSyncLog,true);
            BeanUtils.copyPropertiesIgnore(dbDataSyncLog,dataSyncLog,false);
        }

        dataSyncLog.setActive(true);
        dataSyncLog.setUpdateTime(new Date());
        dataSyncLog.setUpdateflag(true);
        return dataSyncLogDao.save(dataSyncLog);
    }

    @Override
    public void callback(DataSyncLog dataSyncLog) {
        DataSyncLog dbDataSyncLog = dataSyncLogDao.findByMsgId(dataSyncLog.getMsgId());
        if(dbDataSyncLog != null){
            dbDataSyncLog.setActive(true);
            dbDataSyncLog.setUpdateTime(new Date());
            dbDataSyncLog.setUpdateflag(true);
            dataSyncLogDao.save(dbDataSyncLog);
        }
    }

    @Override
    public void receive(DataSyncDto dataSyncDto) throws Exception {
        DataSyncLog dataSyncLog = JSON.parseObject(dataSyncDto.getData(),DataSyncLog.class);
        try {
            FileUtil.downloadFile(dataSyncDto.getFilePaths(),dataSyncLog.getFilePath().replace(dataSyncLog.getBasePath(),configUtils.baseFolder));
        }catch (Exception e){
            e.printStackTrace();
            throw new ArsException("文件不存在："+dataSyncDto.getFilePaths());
        }
        dataSyncLog.setDataSyncState(Constants.DATASYNCSTATE_1);
        dataSyncLog.setErrorInfo(null);
        dataSyncLog.setUpdateTime(new Date());
        dataSyncLogDao.save(dataSyncLog);
    }

    @Override
    public DataSyncLog findById(Long id) {
        return dataSyncLogDao.findById(id);
    }

    @Override
    public void searchForPage(DataSyncLogPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        dataSyncLogDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<DataSyncLog> list) {
        List<DataSyncLog> dbList = dataSyncLogDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (DataSyncLog dataSyncLog : list) {
                dataSyncLog.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        dataSyncLog.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, dataSyncLog.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dataSyncLogDao.saveBatch(list);
        }
    }

    @Override
    public List<DataSyncLog> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return dataSyncLogDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<DataSyncLog> findDSOutList(String startDate) {
        return dataSyncLogDao.findDSOutList(startDate);
    }

    @Override
    public List<DataSyncLog> findByBatchId(List<DataSyncLog> list) {
        return dataSyncLogDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(DataSyncLog dataSyncLog) {
        dataSyncLog.setUpdateTime(new Date());
        dataSyncLogDao.updateSelective(dataSyncLog);
    }
}
