package com.bcxin.ars.service.conference.impl;

import com.bcxin.ars.dao.conference.ConferenceMemberDao;
import com.bcxin.ars.dto.conference.ConferenceMemberSearchDto;
import com.bcxin.ars.service.conference.ConferenceMemberService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/***
 * 会议成员服务实现层
 * @author subh
 */
@Service
@Transactional
public class ConferenceMemberServiceImpl implements ConferenceMemberService {

    /****
     * 日志
     */
    public final static Logger logger = LoggerFactory.getLogger(ConferenceMemberServiceImpl.class);

    @Autowired
    ConferenceMemberDao conferenceMemberDao;

    @Override
    public void searchForPage(ConferenceMemberSearchDto searchDto, AjaxPageResponse page) {
        conferenceMemberDao.searchForPage(searchDto,page);
    }
}
