package com.bcxin.ars.service.conference.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.conference.ConferenceAccountDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.conference.ComAccountZTree;
import com.bcxin.ars.dto.conference.MeetComDto;
import com.bcxin.ars.dto.conference.PoliceAccountSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.conference.ConferenceAccountService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/***
 * 会议帐号信息服务实现层
 * @author subh
 */
@Service
@Transactional
public class ConferenceAccountServiceImpl implements ConferenceAccountService {

    /****
     * 日志
     */
    public final static Logger logger = LoggerFactory.getLogger(ConferenceAccountServiceImpl.class);


    @Autowired
    private ConferenceAccountDao conferenceAccountDao;

    @Autowired
    private ConfigUtils configUtils;


    @Value("${heiweiPrefixKey}")
    private String heiweiPrefixKey;

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Override
    public List<ZTree> getPoliceAccountTree(PoliceAccountSearchDto searchDto) {
        return conferenceAccountDao.getPoliceAccountTree(searchDto);
    }

    @Override
    public List<ComAccountZTree> getcomList() {
        Map<String,Object> paramMap = new HashMap<>();
        Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_PROVINCE);
        //预发布固定
        if("ARS_arspre_".equals(heiweiPrefixKey)){
            paramMap.put("regProvince", "650000");
        }else {
            paramMap.put("regProvince", provinceConfig.getValue());
        }
        AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_MEET_COM_LIST,paramMap);


        if(result.isSuccessful()){
            List<MeetComDto> meetComList = JSONArray.parseArray(JSON.toJSONString(result.getData()),MeetComDto.class);

            List<ComAccountZTree> ztrees = new ArrayList<>();
            ComAccountZTree ztree = null;
            for (MeetComDto meetComDto : meetComList) {
                if(Constants.LOCAL_NO.equals(meetComDto.getIsOpenMeet())){
                    continue;
                }
                ztree = new ComAccountZTree();
                ztree.setId(meetComDto.getComId());
                ztree.setLabel(meetComDto.getComName());
                ztree.setType("0");
                ztrees.add(ztree);
            }

            return ztrees;
        }

        return null;
    }

    @Override
    public List<ComAccountZTree> getPersonAccountList(String comId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("comId",comId);
        paramMap.put("pageNumber",1);
        paramMap.put("pageSize",200000);


        AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_MEET_PERSON_LIST,paramMap);

        if(result.isSuccessful()){
            JSONObject data = JSONObject.parseObject(JSON.toJSONString(result.getData()));


            List<MeetComDto> meetComList = JSONArray.parseArray(JSON.toJSONString(data.get("data")),MeetComDto.class);

            List<ComAccountZTree> ztrees = new ArrayList<>();
            ComAccountZTree ztree = null;
            for (MeetComDto meetComDto : meetComList) {
                if(Constants.LOCAL_NO.equals(meetComDto.getIsOpenMeet())){
                    continue;
                }
                ztree = new ComAccountZTree();
                ztree.setPId(comId);
                ztree.setId(meetComDto.getPerId());
                ztree.setLabel(meetComDto.getName()+ (StringUtil.isEmpty(meetComDto.getRegulatorMeetChargeType()) ? "" : "("+meetComDto.getRegulatorMeetChargeType()+")"));
                ztree.setHuaweiSipName(meetComDto.getHuaweiSipName());
                ztree.setIsLeaf(true);
                ztree.setRoleName(meetComDto.getRegulatorMeetChargeType());
                ztree.setMobilePhone(meetComDto.getMobilePhone());
                ztree.setType("1");
                ztrees.add(ztree);
            }

            return ztrees;
        }

        return null;
    }

    @Override
    public Object searchForPage(PoliceAccountSearchDto searchDto, AjaxPageResponse<MeetComDto> page) {
        searchDto.setRegProvince(configUtils.getCurrentProvince());
        AjaxResult result = saasInterfaceUtil.callInterface(Constants.SAAS_MEET_PERSON_PAGE_LIST, searchDto);
        return result.getData();
    }
}
