package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.bcxin.ars.dao.certificate.GradeCertificateDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.certificate.GradeCertificateSearchDto;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.service.certificate.GradeCertificateService;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/***
 * 等级证信息服务层实现
 * @author subh
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = GradeCertificate.class,getSeq=20000,getDataSyncType = SyncType.SYNC)
public class GradeCertificateServiceImpl implements GradeCertificateService {

    @Autowired
    private GradeCertificateDao gradeCertificateDao;

    @Override
    public List<GradeCertificate> query(GradeCertificateSearchDto dto, AjaxPageResponse<GradeCertificate> ajaxPageResponse) {
        return gradeCertificateDao.query(dto,ajaxPageResponse);
    }

    @Override
    public GradeCertificate findById(Long id) {
        return gradeCertificateDao.findById(id);
    }

    @Override
    public void update(GradeCertificate gradeCertificate) {
        GradeCertificate dbGradeCertificate = findById(gradeCertificate.getId());
        //复制值
        BeanUtils.copyPropertiesIgnore(gradeCertificate,dbGradeCertificate,true);
        dbGradeCertificate.setUpdateTime(new Date());
        gradeCertificateDao.update(dbGradeCertificate);
    }


    @Override
    public void saveOrUpdateForDS(GradeCertificate gradeCertificate){
        GradeCertificate dbGradeCertificate = gradeCertificateDao.findById(gradeCertificate.getId());
        if (dbGradeCertificate != null) {
            if(gradeCertificate.getUpdateTime().getTime() > dbGradeCertificate.getUpdateTime().getTime()) {
                gradeCertificateDao.update(gradeCertificate);
            }
        }else {
            gradeCertificateDao.save(gradeCertificate);
        }
    }

    @Override
    public List<Map<String, String>> insertBatchForImport(List<Map<String, String>> dataList) {
        Long importBatchId = new IdWorker().nextId();
        /**** 数据量太大导致java内存溢出 ,这里分批插入 ****/
        int insertLength = dataList.size();
        int i = 0;
        while (insertLength > 2000) {
            gradeCertificateDao.insertTempBatchGradeCertificateImport(dataList.subList(i, i + 2000), importBatchId);
            i = i + 2000;
            insertLength = insertLength - 2000;
        }
        if (insertLength > 0) {
            gradeCertificateDao.insertTempBatchGradeCertificateImport(dataList.subList(i, i + insertLength), importBatchId);
        }
        /***** 导入逻辑 start ***/
        /******验证导入的Excel是否有重复身份证数据**************/
        gradeCertificateDao.checkIdNumNoRepeat(importBatchId);
        /******验证需要导入的数据身份证是否已存在等级库**************/
        gradeCertificateDao.checkInOtherCom(importBatchId);
        /******检查比对人员**************/
        gradeCertificateDao.checkComparisonPerson(importBatchId);
        /******对比人员是否在比对人员信息**************/
        gradeCertificateDao.checkGradePerson(importBatchId);
        /***** 插入数据 ***/
        gradeCertificateDao.insertGradeCertificateInfo(importBatchId);
        /***** 导入逻辑 end ***/
        /***** 查询本次校验失败的导入等级证信息 ****/
        List<Map<String, String>> tempInputPerList = gradeCertificateDao.getTempImportGradeCertificateList(importBatchId);
        /***** 删除本次导入的保安师信息 ****/
        gradeCertificateDao.deleteTempBatchGradeCertificateImport(importBatchId);
        return tempInputPerList;
    }

    @Override
    public List<GradeCertificate> findUnPushToSAAS() {
        return gradeCertificateDao.findUnPushToSAAS();
    }

    @Override
    public void batchUpdatePushState(List<GradeCertificate> certificates) {
        gradeCertificateDao.batchUpdatePushState(certificates);
    }
    @Override
    public void batchUpdatePersonGradeCertificate(List<GradeCertificate> certificates) {
        gradeCertificateDao.batchUpdatePersonGradeCertificate(certificates);
    }

    /**
     * 查询需要生成同步文件的保安员资格证记录
     * @param dto
     * @return
     */
    @Override
    public List<GradeCertificate> searchForDataSynchronization(DataSynchronizationSearchDto dto){
        return gradeCertificateDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<GradeCertificate> findByIdNums(String[] idNumArr) {
        return gradeCertificateDao.findByIdNums(idNumArr);
    }

}
