package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.bcxin.ars.dao.certificate.CertificatePrintLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CertificatePrintLogSearchDto;
import com.bcxin.ars.model.certificate.CertificatePrintLog;
import com.bcxin.ars.service.certificate.CertificatePrintLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
/***
 * 资格证打印日志服务层实现
 * @author subh
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = CertificatePrintLog.class,getSeq=20000,getDataSyncType = SyncType.SYNC)
public class CertificatePrintLogServiceImpl implements CertificatePrintLogService {

    @Autowired
    private CertificatePrintLogDao certificatePrintLogDao;
    @Autowired
    private ArsUtil arsUtil;
    @Override
    public List<CertificatePrintLog> query(CertificatePrintLogSearchDto searchDto, AjaxPageResponse<CertificatePrintLog> ajaxPageResponse) {
        arsUtil.setPoliceSearch(searchDto);
        return certificatePrintLogDao.query(searchDto,ajaxPageResponse);
    }

    @Override
    public List<CertificatePrintLog> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return certificatePrintLogDao.searchForDataSynchronization(dto);
    }

    @Override
    public void saveOrUpdateForDS(CertificatePrintLog certificatePrintLog) {
        CertificatePrintLog dbCertificatePrintLog = certificatePrintLogDao.findById(certificatePrintLog.getId());
        if (dbCertificatePrintLog == null) {
            certificatePrintLogDao.save(certificatePrintLog);
        }
    }
}
