package com.bcxin.ars.service.approve.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.approve.*;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.approve.ApproveLinkProDetailDto;
import com.bcxin.ars.dto.approve.ApproveTempLinkRelaDto;
import com.bcxin.ars.dto.approve.CheckTempConfigDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.*;
import com.bcxin.ars.service.approve.ApproveTempLinkService;
import com.bcxin.ars.service.util.ApprovalActivityUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = ApproveTempLinkRela.class,getMethodName = "updateFlagForOutToIn",getImportType = ImportType.BATCH)
public class ApproveTempLinkServiceImpl implements ApproveTempLinkService {

	private static final Logger logger = LoggerFactory.getLogger(ApproveTempLinkServiceImpl.class);
	@Autowired
	private ApproveTempLinkDao approveTempLinkDao;

	@Autowired
	private ApproveTempLinkRelaDao approveTempLinkRelaDao;

	@Autowired
	private ApproveTempDao approveTempDao;
    @Autowired
    private ConfigUtils configUtils;
	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ApproveAreaProcessDao approveAreaProcessDao;

	@Autowired
	private ApproveLinkProDetailDao approveLinkProDetailDao;

	@Autowired
	private ApproveAreaProDetailDao approveAreaProDetailDao;

	@Autowired
	private ApproveTempProcessDao approveTempProcessDao;

	@Autowired
	private ApproveLinkLevelDao approveLinkLevelDao;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private ApproveLinkDao approveLinkDao;

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private ApproveTempConfigDao approveTempConfigDao;

	@Override
	public void save(Long linkId, Long tempId) {

		// 查询
		ApproveLink approveLink = approveLinkDao.findById(linkId);

		List<ApproveTemp> allApproveTempList = new ArrayList<ApproveTemp>();
		// 添加本机构模板
		ApproveTemp curApproveTemp = new ApproveTemp();
		curApproveTemp = approveTempDao.findById(tempId);

		// 如果是非保安员资格考试报名业务，则不允许添加特殊环节(指派民警除外)
		if (curApproveTemp.getTempCode()!=null && curApproveTemp.getTempCode().indexOf(Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE) == -1) {
			if (approveLink.getLinkType() != null && !" ".equals(approveLink.getLinkType())
					&& !"5".equals(approveLink.getLinkType()) && !"".equals(approveLink.getLinkType())) {
				throw new ArsException("不允许添加特殊环节！");
			}
		}
		allApproveTempList.add(curApproveTemp);
		User currentUser = arsUtil.getCurrentUser();
		String orgtype = currentUser.getPolice().getOrgtype();// 机构类型
		String createType = "";// 创建机构类型(1省级机构，其他市级机构)
		if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
			// 省级机构，则要查出所有的市级机构模板进行添加环节
			List<ApproveTemp> approveTempCityList = approveTempDao.findByParentTempId(tempId);
			allApproveTempList.addAll(approveTempCityList);
			createType = "1";
		} else {
			createType = "0";
		}
		if (allApproveTempList != null && allApproveTempList.size() > 0) {
			for (ApproveTemp item : allApproveTempList) {
				ApproveTempLink dbapproveTempLink = approveTempLinkDao.findByTempAndLink(linkId, item.getId());
				if (dbapproveTempLink != null) {
					if (dbapproveTempLink.getActive()) {
						throw new ArsException("该审批环节已存在！");
					}
				}
			}
			// 排除不需要生成省级环节的市级机构列表
			List<ApproveTempConfig> approveTempConfigList = approveTempConfigDao.find(tempId);
			for (ApproveTemp item : allApproveTempList) {
				Long policeId = item.getPoliceId(); // 机构ID
				boolean is_exitConfig = false;
				if (approveTempConfigList != null && approveTempConfigList.size() > 0) {
					for (ApproveTempConfig approveTempConfig : approveTempConfigList) {
						if (approveTempConfig.getPoliceId().equals(policeId)) {
							is_exitConfig = true;
							break;
						}
					}
				}
				// 如果存在排除省环节市级机构信息，则市级不添加省级环节
				if (is_exitConfig) {
					continue;
				}
				Long tempID_temp = item.getId(); // 模板ID
				Long linkID_temp = linkId; // 环节ID
				// 判断环节是否存在，如果不存在则新增
				List<ApproveTempLink> approveTempLinkList = approveTempLinkDao.findByTempId(tempID_temp);

				int countSj = 0;
				// 其他节点序号依次增1
				for (ApproveTempLink approveTempLink1 : approveTempLinkList) {
					// 不是省级操作，且节点是省级节点
					if (!orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
						// 节点序号依次递增1
						approveTempLink1.setSeq(approveTempLink1.getSeq() + 1);
						approveTempLinkDao.update(approveTempLink1);
					} else {
						// 省级操作 省节点序号依次递增1
						if (approveTempLink1.getCreateType().equals(Constants.POLICE_ORGTYPE_SHENG)) {
							approveTempLink1.setSeq(approveTempLink1.getSeq() + 1);
							approveTempLinkDao.update(approveTempLink1);
						} else {
							// 统计子模板市级的节点个数
							countSj++;
						}

					}

				}

				ApproveTempLink approveTempLink = new ApproveTempLink();
				approveTempLink = approveTempLinkDao.findByTempAndLink(linkID_temp, tempID_temp);

				if (approveTempLink == null) {
					approveTempLink = new ApproveTempLink();
					ApproveLink approveLinkNew = new ApproveLink();
					approveLinkNew.setId(linkID_temp);
					ApproveTemp approveTempAdd = new ApproveTemp();
					approveTempAdd.setId(tempID_temp);
					approveTempLink.setApproveLink(approveLinkNew);
					approveTempLink.setApproveTemp(approveTempAdd);
					approveTempLink.setActive(true);
					approveTempLink.setCreateTime(new Date());

					// approveTempLink.setSeq(approveTempLinkList.size() + 1);
					// 省级操作添加省级节点
					if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)
							&& createType.equals(Constants.POLICE_ORGTYPE_SHENG)) {
						if (item.getParentTempId() == null || "".equals(item.getParentTempId())) {
							approveTempLink.setSeq(1);
						} else {
							approveTempLink.setSeq(countSj + 1);
						}

					} else {
						approveTempLink.setSeq(1);
					}
					approveTempLink.setCreateType(createType);
					approveTempLinkDao.save(approveTempLink);
				} else {
					approveTempLink.setActive(true);

					approveTempLink.setUpdateBy(currentUser.getUsername());
					approveTempLink.setUpdateTime(new Date());
					approveTempLink.setCreateType(createType);
					approveTempLinkDao.update(approveTempLink);
				}
				// 如果该环节的审批模板主流程信息完成则需要将状态改为无效（主流程完成才要完全修改）
				deleteApproveTempProcess(approveTempLink);
				// 更新模板为配置中状态
				item.setApproveSetStatus(Constants.CONFIGURATION_CONFIGURED_DOING);
				approveTempDao.update(item);
			}
		}
	}

	private void deleteApproveTempProcess(ApproveTempLink approveTempLink) {
		// 如果该环节的审批模板主流程信息完成则需要将状态改为无效（主流程完成才要完全修改）
		ApproveTemp approveTemp = approveTempDao.findById(approveTempLink.getApproveTemp().getId());
		if (StringUtil.equals(approveTemp.getApproveSetStatus(), Constants.CONFIGURATION_CONFIGURED)) {
			approveTemp.setApproveSetStatus(Constants.CONFIGURATION_NOT_CONFIGURED);
			approveTemp.setFailureTime(new Date());
			approveTemp.setUpdateTime(new Date());
			approveTemp.setUpdateBy("2");
			approveTempDao.update(approveTemp);
			// 将配置信息全部改为无效
			approveTempProcessDao.batchUpdateByApproveTempId(approveTemp);
		}
	}

	@Override
	public void update(ApproveTempLink approveTempLink) {
		approveTempLink.setUpdateTime(new Date());
		approveTempLinkDao.update(approveTempLink);

		// 如果该环节的审批模板主流程信息完成则需要将状态改为无效（主流程完成才要完全修改）
		deleteApproveTempProcess(approveTempLink);
	}

	@Override
	public void delete(Long tempLinkId) {
		List<ApproveTempLink> allApproveTempLinkList = new ArrayList<ApproveTempLink>();// 要删除环节集合
		ApproveTempLink approveTempLinkCur = approveTempLinkDao.findById(tempLinkId);
		allApproveTempLinkList.add(approveTempLinkCur);
		User currentUser = arsUtil.getCurrentUser();
		String orgtype = currentUser.getPolice().getOrgtype();// 机构类型
		List<ApproveTemp> approveTempCityList = null; // 市级模板
		// 省级机构删除需要把所属市级机构模板的一样环节一起删除
		if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {// 省级机构
			// 1、查出子模板列表
			Long tempId = approveTempLinkCur.getApproveTemp().getId();
			Long linkId = approveTempLinkCur.getApproveLink().getId();
			approveTempCityList = approveTempDao.findByParentTempId(tempId);
			// 2、查出子模板环节列表
			if (approveTempCityList != null && approveTempCityList.size() > 0) {
				for (ApproveTemp approveTempCity : approveTempCityList) {
					ApproveTempLink cityApproveTempLink = approveTempLinkDao.findByTempAndLink(linkId,
							approveTempCity.getId());
					if (cityApproveTempLink != null) {
						allApproveTempLinkList.add(cityApproveTempLink);
					}
				}
			}
		}
		if (allApproveTempLinkList != null && allApproveTempLinkList.size() > 0) {
			for (ApproveTempLink approveTempLink : allApproveTempLinkList) {
				// 1.删除环节关联
				approveTempLink.setUpdateTime(new Date());
				// approveTempLink.setUpdateBy(arsUtil.getCurrentUser().getUsername());
				approveTempLinkDao.delete(approveTempLink);
				// 2.删除相关的审批环节层级 及区域审批流程
				approveAreaProcessDao.deleteByApproveTempLinkId(approveTempLink);
				// 3.删除相关的审批环节流程明细
				approveLinkProDetailDao.deleteByApproveTempLinkId(approveTempLink);
				// 4. 删除相关的流程配置和流程人员配置以及审批环节流程明细
				approveAreaProDetailDao.deleteByApproveTempLinkId(approveTempLink);

				// 如果该环节的审批模板主流程信息完成则需要将状态改为无效（主流程完成才要完全修改）
				deleteApproveTempProcess(approveTempLink);

				// 根据模板查得被删除之后的所有环节
				List<ApproveTempLink> approveTempLinkList = approveTempLinkDao.findByMtSeq(approveTempLink.getSeq(),
						approveTempLink.getApproveTemp().getId());
				// 根据是否是最后一个审批关联环节修改模板状态
				List<ApproveTempLink> approveTempLinkList1 = approveTempLinkDao
						.findByTempId(approveTempLink.getApproveTemp().getId());
				if (approveTempLinkList1.size() <= 0) {
					// 更新模板为未配置状态
					ApproveTemp approveTemp = approveTempDao.findById(approveTempLink.getApproveTemp().getId());
					if (approveTemp != null) {
						approveTemp.setApproveSetStatus(Constants.CONFIGURATION_NOT_CONFIGURED);
						if (approveTemp.getId() != null) {
							// 获取sql的实体
							ApproveTemp dbApproveTemp = approveTempDao.findById(approveTemp.getId());
							dbApproveTemp.setUpdateBy(currentUser.getUsername());
							dbApproveTemp.setUpdateTime(new Date());
							// 如果不为空，则更新相应字段的值
							if (!StringUtils.isEmpty(approveTemp.getTempName())) {
								dbApproveTemp.setTempName(approveTemp.getTempName());
							}
							if (!StringUtils.isEmpty(approveTemp.getApproveSetStatus())) {
								dbApproveTemp.setApproveSetStatus(approveTemp.getApproveSetStatus());
							}
							if (!StringUtils.isEmpty(approveTemp.getNoticeTemp())) {
								dbApproveTemp.setNoticeTemp(approveTemp.getNoticeTemp());
							}
							if (!StringUtils.isEmpty(approveTemp.getRepulseExplain())) {
								dbApproveTemp.setRepulseExplain(approveTemp.getRepulseExplain());
							}
							approveTempDao.update(dbApproveTemp);
						}
					}
				}
				// 循环改变顺序
				for (ApproveTempLink a : approveTempLinkList) {
					a.setSeq(a.getSeq() - 1);
					a.setUpdateTime(new Date());
					approveTempLinkDao.update(a);
					// 如果该环节的审批模板主流程信息完成则需要将状态改为无效（主流程完成才要完全修改）
					deleteApproveTempProcess(a);
				}
				ApproveTemp approveTemp = approveTempLink.getApproveTemp();
				// 生成并启动审批主流程(省级模板不启动审批主流程，市级模板才启动审批主流程)
				if (approveTemp.getParentTempId() != null || Constants.BEIJING.equals(configUtils.getCurrentNative())) {
					try {
						saveMainProcess(approveTemp);
					} catch (Exception e) {
						logger.debug(e.getMessage());
					}
				}
			}
		}
	}

	private String saveMainProcess(ApproveTemp approveTemp) throws Exception {
		// get审批流程配置ID
		Long approveTempId = approveTemp.getId();
		// 将配置信息全部改为无效
		approveTemp = approveTempDao.findById(approveTempId);
		// get流程名称
		String approveTempName = approveTemp.getTempName();
		// get唯一标识ID
		String tempCode = approveTemp.getTempCode();
		String businessTypeCode = "";

		String groupId = "";
		// 科长账号
		Config kzConfig = configDao.findByKey(Constants.KZZHID);
		if (kzConfig != null && StringUtil.isNotEmpty(kzConfig.getValue())) {
			groupId = kzConfig.getValue();
		}
		// 业务类型code
		if (tempCode.contains("-")) {
			businessTypeCode = BusinessType.getBusinessType(tempCode.split("-")[0]);
		}
		String maxApproveLevel = approveTempDao.getMaxApproveLevelByApproveTempId(approveTempId);
		String configMsg = ""; // 配置结果
		if (StringUtil.isNotEmpty(maxApproveLevel)) {
			User user = arsUtil.getCurrentUser();
			String orgtype = user.getPolice().getOrgtype(); // 当前机构类型
			String superAreaCode = ""; // 上级机构编码
			String superOrgtype = ""; // 上级机构类别
			Long policeId = user.getPolice().getId(); // 当前机构ID
			String areaCode = user.getPolice().getAreacode(); // 当前机构所在地区,地区只有6位
			if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
				// 省级
				areaCode = areaCode.substring(0, 2);
			} else if (orgtype.equals(Constants.POLICE_ORGTYPE_SHI)) {
				// 市级
				areaCode = areaCode.substring(0, 2);
				superAreaCode = areaCode.substring(0, 2) + "0000";
				superOrgtype = Constants.POLICE_ORGTYPE_SHENG;
			} else if (orgtype.equals(Constants.POLICE_ORGTYPE_QX)) {
				// 区县
				superAreaCode = areaCode.substring(0, 4) + "00";
				superOrgtype = Constants.POLICE_ORGTYPE_SHI;
			} else {
				// 派出所
				superAreaCode = areaCode;
				superOrgtype = Constants.POLICE_ORGTYPE_QX;
			}
			if (!orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
				/**
				 * 判断审批模板当前机构的所属上级机构是否都配置完成，如果未配置完成则不能启动主流程,省级机构除外
				 */
				CheckTempConfigDto checkDto = new CheckTempConfigDto();
				checkDto.setTempId(approveTempId);
				checkDto.setAreaCode(superAreaCode);
				checkDto.setOrgtype(superOrgtype);
				Long check = approveTempLinkRelaDao.checkTempConfigCompleteByOrgTypeAndCityCode(checkDto);
				if (check != null && check > 0) {
					configMsg = "模板环节上级机构未配置完成！";
					logger.info(configMsg);
					return configMsg;
				}
			}
			List<ApproveTempLinkRela> approveTempLinkRelaList = approveTempLinkRelaDao
					.findByApproveTempIdList(approveTempId);
			List<Police> policeList = new ArrayList<Police>();
			if (orgtype.equals(Constants.POLICE_ORGTYPE_PCS)) {
				// 派出所，只查询自己机构信息
				Police police = policeDao.findById(policeId);
				policeList.add(police);
			} else {
				// 非派出所，则取本级机构以及下属机构信息
				policeList = policeDao.findPoliceByOrgTypeAndLikeAreacode(maxApproveLevel, areaCode);
			}
			if (policeList != null && policeList.size() > 0) {
				List<ApproveTempProcess> approveTempProcessList = new ArrayList<>();
				for (Police police : policeList) {
					String[] policeIds = police.getPath().split("/");
					ApproveLinkProDetailDto searchDto = new ApproveLinkProDetailDto();
					searchDto.setPoliceIds(policeIds);
					List<ApproveTempLinkRelaDto> approveTempLinkRelaDtoList = new ArrayList<ApproveTempLinkRelaDto>();
					if (approveTempLinkRelaList != null && approveTempLinkRelaList.size() > 0) {
						int tempLinkSize = approveTempLinkRelaList.size();
						for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
							Long tempLinkRelaId = approveTempLinkRela.getId();
							String approveLevel = approveLinkLevelDao
									.getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);

							// 类型是1、报名确认， 2、缴费确认， 3、指纹获取，4、考试安排没有审批层次
							if (StringUtil.isEmpty(approveLevel)) {
								ApproveLink approveLink = approveLinkDao
										.findById(approveTempLinkRela.getApproveLinkId());
								if (approveLink != null) {
									/*
									 * 1、判断未设置环境是不是特殊节点：保安资格证特殊节点有报名确认、缴费确认、指纹获取
									 * 、考试安排。另外模板用到指派民警
									 * 2、如果不是特殊节点，则环境未配置地区则不启动整体流程
									 */
									if (StringUtils.isEmpty(approveLink.getLinkType())) {
										// 非特殊节点，则不启动整体流程
										configMsg = "审批流程未启动：存在未配置审批单位的审批环节";
										return configMsg;
									} else {
										// 特殊节点
										ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
										approveTempLinkRelaDto.setLinkName(approveLink.getLinkName());
										approveTempLinkRelaDto.setLinkType(approveLink.getLinkType());
										approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
									}
								}
							} else {
								searchDto.setTempLinkRelaId(tempLinkRelaId);
								searchDto.setApproveLevel(approveLevel);
								ApproveLinkProDetail pproveLinkProDetail = approveLinkProDetailDao
										.findListByTempLinkRelaIdAndPoliceIds(searchDto);
								if (pproveLinkProDetail != null) {
									ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
									approveTempLinkRelaDto = approveTempLinkRelaDao
											.findDtoById(pproveLinkProDetail.getTempLinkRelaId());
									approveTempLinkRelaDto.setApproveLinkProDetailId(pproveLinkProDetail.getId());
									approveTempLinkRelaDto
											.setApproveAreaProId(pproveLinkProDetail.getApproveAreaProId());
									approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
								} else {
									// 找不到流程配置信息则不继续循环，循环下一个机构
									break;
								}
							}
						}
						// 环节阶段都配置完成才可以启动主流程
						if (approveTempLinkRelaDtoList != null && approveTempLinkRelaDtoList.size() > 0
								&& tempLinkSize == approveTempLinkRelaDtoList.size()) {
							// 如果为保安服务公司年度报告备案要把最后流程的人员ID修改为annals
							if (businessTypeCode.equals(BusinessType.NDBG)) {
								List<ApproveAreaProcess> approveAreaProcessList = new ArrayList<ApproveAreaProcess>();
								ApproveAreaProcess approveAreaProcess = approveAreaProcessDao
										.findById(approveTempLinkRelaDtoList.get(approveTempLinkRelaDtoList.size() - 1)
												.getApproveAreaProId());
								if (approveAreaProcess != null) {
									approveAreaProcessList.add(approveAreaProcess);
								}
								if (approveTempLinkRelaDtoList.size() > 1) {
									approveAreaProcess = approveAreaProcessDao.findById(approveTempLinkRelaDtoList
											.get(approveTempLinkRelaDtoList.size() - 2).getApproveAreaProId());
									if (approveAreaProcess != null) {
										approveAreaProcessList.add(approveAreaProcess);
									}
								}
								ApprovalActivityUtil.thirdJsonUpdate(approveAreaProcessList);
							}
							ApproveTempProcess approveTempProcess = new ApproveTempProcess();
							approveTempProcess.setCreateTime(new Date());
							approveTempProcess.setUpdateTime(new Date());
							approveTempProcess.setActive(true);
							approveTempProcess.setApproveTempId(approveTempId);
							approveTempProcess.setRegionLevel(police.getOrgtype());
							approveTempProcess.setPoliceCode(StringUtil.isNotEmpty(police.getCode())?police.getCode().toString():"");
							approveTempProcess.setPoliceId(police.getId());
							String processID = tempCode + "-" + police.getId().toString();
							String processName = approveTempName + police.getOrgname();
							approveTempProcess.setProcessInfo(ApprovalActivityUtil.oneJson(approveTempLinkRelaDtoList,
									processID, processName, groupId));
							approveTempProcessList.add(approveTempProcess);
						}
					}
				}
				if (approveTempProcessList != null && approveTempProcessList.size() > 0) {
					approveTempProcessDao.batchSave(approveTempProcessList);
					ApproveTemp approveTempSave = approveTempDao.findById(approveTempId);
					approveTempSave.setEffectTime(new Date());
					approveTempSave.setUpdateTime(new Date());
					approveTempSave.setApproveSetStatus(Constants.CONFIGURATION_CONFIGURED);
					approveTempDao.update(approveTempSave);
				}
			}
		} else {
			configMsg = "审批环节未配置";
		}
		return configMsg;
	}

	@Override
	public ApproveTempLink findById(Long id) {
		return approveTempLinkDao.findById(id);
	}

	@Override
	public List<ApproveTempLink> findByTempId(Long tempId) {
		return approveTempLinkDao.findByTempId(tempId);
	}

	@Override
	public List<ApproveTempLink> findByLinkId(Long linkId) {
		return approveTempLinkDao.findByLinkId(linkId);
	}

	@Override
	public List<ApproveTempLink> findByMtSeq(Long seq, Long tempId) {
		return approveTempLinkDao.findByMtSeq(seq, tempId);
	}

	@Override
	public void insertBatchTemp(List<ApproveTempLinkRela> approveList) {
		approveTempLinkRelaDao.insertBatchTemp(approveList);
	}

	@Override
	public List<ApproveTempLinkRela> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return approveTempLinkRelaDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public ApproveTempLink findByMtSeqUp(Long seq, Long tempId) {
		return approveTempLinkDao.findByMtSeqUp(seq, tempId);
	}

	@Override
	public ApproveTempLink findByMtSeqDown(Long seq, Long tempId) {
		return approveTempLinkDao.findByMtSeqDown(seq, tempId);
	}

	@Override
	public void updateOrderUp(Long[] idArray) {
		// 上移
		User currentUser = arsUtil.getCurrentUser();
		String orgtype = currentUser.getPolice().getOrgtype();// 机构类型
		// 省级机构删除需要把所属市级机构模板的一样环节一起修改
		if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
			// 省级机构
			for (int i = 0; i < idArray.length; i++) {
				List<ApproveTempLink> allApproveTempLinkList = new ArrayList<ApproveTempLink>();// 要修改环节集合
				ApproveTempLink approveTempLinkCur = approveTempLinkDao.findById(idArray[i]);
				allApproveTempLinkList.add(approveTempLinkCur);
				// 1、查出子模板列表
				List<ApproveTemp> approveTempCityList = null; // 市级模板
				Long tempId = approveTempLinkCur.getApproveTemp().getId();
				Long linkId = approveTempLinkCur.getApproveLink().getId();
				approveTempCityList = approveTempDao.findByParentTempId(tempId);
				// 2、查出子模板环节列表
				if (approveTempCityList != null && approveTempCityList.size() > 0) {
					for (ApproveTemp approveTempCity : approveTempCityList) {
						ApproveTempLink cityApproveTempLink = approveTempLinkDao.findByTempAndLink(linkId,
								approveTempCity.getId());
						if (cityApproveTempLink != null) {
							allApproveTempLinkList.add(cityApproveTempLink);
						}
					}
				}
				if (allApproveTempLinkList != null && allApproveTempLinkList.size() > 0) {
					for (ApproveTempLink approveTempLink : allApproveTempLinkList) {
						long seq = approveTempLink.getSeq();
						ApproveTempLink approveTempLinkUp = approveTempLinkDao.findByMtSeqUp(approveTempLink.getSeq(),
								approveTempLink.getApproveTemp().getId());
						approveTempLink.setSeq(approveTempLinkUp.getSeq());
						approveTempLinkUp.setSeq(seq);
						approveTempLinkDao.update(approveTempLink);
						approveTempLinkDao.update(approveTempLinkUp);
						ApproveTemp approveTemp = approveTempLink.getApproveTemp();
						// 生成并启动审批主流程(省级模板不启动审批主流程，市级模板才启动审批主流程)
						if (approveTemp.getParentTempId() != null || Constants.BEIJING.equals(configUtils.getCurrentNative())) {
							try {
								saveMainProcess(approveTemp);
							} catch (Exception e) {
								logger.debug(e.getMessage());
							}
						}
					}
				}
			}

		} else {
			// 市级机构
			Long approveTempId = null;
			for (int i = 0; i < idArray.length; i++) {
				ApproveTempLink approveTempLink = approveTempLinkDao.findById(idArray[i]);
				if (i == 0) {
					approveTempId = approveTempLink.getApproveTemp().getId();
				}
				long seq = approveTempLink.getSeq();
				ApproveTempLink approveTempLinkUp = approveTempLinkDao.findByMtSeqUp(approveTempLink.getSeq(),
						approveTempLink.getApproveTemp().getId());
				approveTempLink.setSeq(approveTempLinkUp.getSeq());
				approveTempLinkUp.setSeq(seq);
				approveTempLinkDao.update(approveTempLink);
				approveTempLinkDao.update(approveTempLinkUp);
			}
			ApproveTemp approveTemp = new ApproveTemp();
			approveTemp.setId(approveTempId);
			try {
				saveMainProcess(approveTemp);
			} catch (Exception e) {
				logger.debug(e.getMessage());
			}
		}
	}

	@Override
	public void updateOrderDown(Long[] idArray) {
		// 下移
		User currentUser = arsUtil.getCurrentUser();
		String orgtype = currentUser.getPolice().getOrgtype();// 机构类型
		// 省级机构删除需要把所属市级机构模板的一样环节一起修改
		if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
			// 省级机构
			for (int i = 0; i < idArray.length; i++) {
				List<ApproveTempLink> allApproveTempLinkList = new ArrayList<ApproveTempLink>();// 要修改环节集合
				ApproveTempLink approveTempLinkCur = approveTempLinkDao.findById(idArray[i]);
				allApproveTempLinkList.add(approveTempLinkCur);
				// 1、查出子模板列表
				List<ApproveTemp> approveTempCityList = null; // 市级模板
				Long tempId = approveTempLinkCur.getApproveTemp().getId();
				Long linkId = approveTempLinkCur.getApproveLink().getId();
				approveTempCityList = approveTempDao.findByParentTempId(tempId);
				// 2、查出子模板环节列表
				if (approveTempCityList != null && approveTempCityList.size() > 0) {
					for (ApproveTemp approveTempCity : approveTempCityList) {
						ApproveTempLink cityApproveTempLink = approveTempLinkDao.findByTempAndLink(linkId,
								approveTempCity.getId());
						if (cityApproveTempLink != null) {
							allApproveTempLinkList.add(cityApproveTempLink);
						}
					}
				}
				if (allApproveTempLinkList != null && allApproveTempLinkList.size() > 0) {
					for (ApproveTempLink approveTempLink : allApproveTempLinkList) {
						long seq = approveTempLink.getSeq();
						ApproveTempLink approveTempLinkDown = approveTempLinkDao
								.findByMtSeqDown(approveTempLink.getSeq(), approveTempLink.getApproveTemp().getId());
						approveTempLink.setSeq(approveTempLinkDown.getSeq());
						approveTempLinkDown.setSeq(seq);
						approveTempLinkDao.update(approveTempLink);
						approveTempLinkDao.update(approveTempLinkDown);

						ApproveTemp approveTemp = approveTempLink.getApproveTemp();
						// 生成并启动审批主流程(省级模板不启动审批主流程，市级模板才启动审批主流程)
						if (approveTemp.getParentTempId() != null || Constants.BEIJING.equals(configUtils.getCurrentNative())) {
							try {
								saveMainProcess(approveTemp);
							} catch (Exception e) {
								logger.debug(e.getMessage());
							}
						}
					}
				}
			}
		} else {
			// 市级机构
			Long approveTempId = null;
			for (int i = 0; i < idArray.length; i++) {
				ApproveTempLink approveTempLink = approveTempLinkDao.findById(idArray[i]);
				if (i == 0) {
					approveTempId = approveTempLink.getApproveTemp().getId();
				}
				long seq = approveTempLink.getSeq();
				ApproveTempLink approveTempLinkDown = approveTempLinkDao.findByMtSeqDown(approveTempLink.getSeq(),
						approveTempLink.getApproveTemp().getId());
				approveTempLink.setSeq(approveTempLinkDown.getSeq());
				approveTempLinkDown.setSeq(seq);
				approveTempLinkDao.update(approveTempLink);
				approveTempLinkDao.update(approveTempLinkDown);
			}
			ApproveTemp approveTemp = new ApproveTemp();
			approveTemp.setId(approveTempId);
			try {
				saveMainProcess(approveTemp);
			} catch (Exception e) {
				logger.debug(e.getMessage());
			}
		}
	}

	@Override
	public void updateFlagForOutToIn(List<ApproveTempLinkRela> linkRelaList) {
		approveTempLinkRelaDao.updateFlagForOutToIn(linkRelaList);
	}

}
