package com.bcxin.ars.service.approve.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.dao.approve.ApproveLinkDao;
import com.bcxin.ars.dto.approve.ApproveLinkSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.ApproveLink;
import com.bcxin.ars.service.approve.ApproveLinkService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;

/**
 * @author：lql
 * @date：2018/01/17 17:00
 * @description：审批环节Service实现
 */
@Service
@Transactional
public class ApproveLinkServiceImpl implements ApproveLinkService {

	@Autowired
	private ApproveLinkDao approveLinkDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@Override
	public void delete(ApproveLink approveLink) {
		User currentUser = arsUtil.getCurrentUser();
		approveLink.setActive(false);
		approveLink.setUpdateBy(currentUser.getUsername());
		approveLink.setUpdateTime(new Date());
		approveLinkDao.delete(approveLink);
	}

	@Override
	public void saveOrUpdate(ApproveLink approveLink) {
		User currentUser = arsUtil.getCurrentUser();
		ApproveLink checkApproveLink = approveLinkDao.findByLinkName(approveLink.getLinkName());
		//如果是修改，则判断审批环节名称非本条记录，是否有重复
		if(checkApproveLink != null) {
			if(approveLink.getId() == null &&  approveLink.getId()!=null && checkApproveLink.getId() != approveLink.getId()) {
				throw new ArsException("审批环节名称已存在!");
			}
		}
			
		if(StringUtil.isNotEmpty(approveLink.getLinkType())) {
			checkApproveLink = approveLinkDao.findByLinkType(approveLink.getLinkType());
			String typeName="";
			switch (approveLink.getLinkType()){
				case "1":typeName = "报名确认";
				    break;
				case "2":typeName = "缴费确认";
					break;
				case "3":typeName = "指纹获取";
					break;
				case "4":typeName = "考试安排";
					break;
			}
			if(checkApproveLink != null) {
				if(approveLink.getId() == null || (approveLink.getId()!=null && checkApproveLink.getId() != approveLink.getId())){
					throw new ArsException(approveLink.getLinkName()+"已设置"+typeName+"，请勿重复选择!");
				}
			}
		}
		
		if(approveLink.getId() == null){
			approveLink.setActive(true);
			approveLink.setCreateTime(new Date());
			approveLink.setUpdateBy(currentUser.getUsername());
			approveLink.setUpdateTime(new Date());
			approveLinkDao.save(approveLink);
		}else{
			ApproveLink dbApproveLink = approveLinkDao.findById(approveLink.getId());
			dbApproveLink.setLinkName(approveLink.getLinkName());
			dbApproveLink.setLinkType(approveLink.getLinkType());
			dbApproveLink.setSeq(approveLink.getSeq());
			dbApproveLink.setUpdateBy(currentUser.getUsername());
			dbApproveLink.setUpdateTime(new Date());
			approveLinkDao.update(dbApproveLink);
		}
		
	}

	@Override
	public ApproveLink findById(Long id) {
		return approveLinkDao.findById(id);
	}

	@Override
	public ApproveLinkSearchDto search(ApproveLinkSearchDto searchDto) {
		List<ApproveLink> linkList = approveLinkDao.search(searchDto);
		Long count = approveLinkDao.searchCount(searchDto);
		searchDto.setData(linkList);
		searchDto.setTotalCount(count);
		return searchDto;
	}

	@Override
	public List<ApproveLink> findByApproveTempId(Long approveTempId) {
		return approveLinkDao.findByApproveTempId(approveTempId);
	}


}
