package com.bcxin.ars.service.approve.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.approve.*;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.approve.ApproveLinkLevelDto;
import com.bcxin.ars.dto.approve.ApproveLinkProDetailDto;
import com.bcxin.ars.dto.approve.ApproveTempLinkRelaDto;
import com.bcxin.ars.dto.approve.CheckTempConfigDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.*;
import com.bcxin.ars.service.approve.ApproveLinkLevelService;
import com.bcxin.ars.service.util.ApprovalActivityUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.BusinessType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author：wangcy @date：2018/01/19 0019 14:55
 * @description：审批环节层级service层
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = ApproveLinkLevel.class,getMethodName = "updateFlagForOutToIn",getImportType = ImportType.BATCH)
public class ApproveLinkLevelServiceImpl implements ApproveLinkLevelService {

	private static final Logger logger = LoggerFactory.getLogger(ApproveLinkLevelServiceImpl.class);
	@Autowired
	private ApproveLinkLevelDao approveLinkLevelDao;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ApproveAreaProcessDao approveAreaProcessDao;

	@Autowired
	private PoliceDao policeDao;

	@Autowired
	private ApproveTempDao approveTempDao;

	@Autowired
	private ApproveTempLinkRelaDao approveTempLinkRelaDao;

	@Autowired
	private ApproveTempProcessDao approveTempProcessDao;

	@Autowired
	private ConfigDao configDao;

	@Autowired
	private ApproveLinkDao approveLinkDao;
	@Autowired
	private ApproveLinkProDetailDao approveLinkProDetailDao;

	/**
	 * @Author: wangcy
	 * @Description:查询属于这个环节的层级
	 * @Date: 2018/01/19 0019 15:31
	 */
	@Override
	public List<ApproveLinkLevel> findByTempLinkRelaId(Long tempLinkRelaId) {
		return approveLinkLevelDao.findListByTempLinkRelaId(tempLinkRelaId);
	}

	/**
	 * @Author: wangcy
	 * @Description:删除环节的层级
	 * @Date: 2018/01/19 0019 15:54
	 */
	@Override
	public void delete(ApproveLinkLevel approveLinkLevel) {
		User currentUser = arsUtil.getCurrentUser();
		ApproveLinkLevel approveLinkLeveldb = approveLinkLevelDao.findById(approveLinkLevel.getId());
		// 为空说明已经删除了不再次删除
		if (approveLinkLeveldb != null) {
			approveLinkLevel.setUpdateTime(new Date());
			approveLinkLevel.setUpdateBy(currentUser.getUsername());
			approveLinkLevelDao.delete(approveLinkLevel);
		}

	}

	/**
	 * @Author: wangcy
	 * @Description:修改或者新增环节的层级
	 * @Date: 2018/01/19 0019 15:54
	 */
	@Override
	public void saveOrUpdate(ApproveLinkLevelDto approveLinkLevelDto) {
		/**
		 * 1、省级机构修改环节信息，则需要把市的省环节一起修改 2、市级机构则修改本市环节
		 */
		String orgtype = approveLinkLevelDto.getOrgType();// 机构类型
		Long tempId = approveLinkLevelDto.getApproveTempId();// 模板ID
		Long tempLinkRelaId = approveLinkLevelDto.getTempLinkRelaId();// 模板环节ID
		List<ApproveTemp> allApproveTempList = new ArrayList<ApproveTemp>();// 模板列表
		List<ApproveTempLinkRela> allApproveTempLinkList = new ArrayList<ApproveTempLinkRela>();// 模板环节ID列表
		ApproveTemp curApproveTemp = new ApproveTemp();
		curApproveTemp = approveTempDao.findById(tempId);
		allApproveTempList.add(curApproveTemp);
		ApproveTempLinkRela curApproveTempLinkRela = approveTempLinkRelaDao.findById(tempLinkRelaId);
		allApproveTempLinkList.add(curApproveTempLinkRela);
		// 获取环节类型
		/**
		 * 环节类型 1、 报名确认 2、缴费确认 3、指纹获取 4、考试安排 5、指派民警
		 */
		String linkType = "";
		ApproveLink approveLink = approveLinkDao.findById(curApproveTempLinkRela.getApproveLinkId());
		if (approveLink != null) {
			linkType = approveLink.getLinkType();
		}
		if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {// 省级机构
			// 1、查出子模板列表
			List<ApproveTemp> approveTempCityList = approveTempDao.findByParentTempId(tempId);
			// 2、查出子模板模板环节列表
			if (approveTempCityList != null && approveTempCityList.size() > 0) {
				List<ApproveTemp> deleteApproveTempCityList = new ArrayList<ApproveTemp>();
				for (ApproveTemp approveTempCity : approveTempCityList) {
					ApproveTempLinkRela cityApproveTempLinkRela = approveTempLinkRelaDao.findByActiveTempAndLink(
							curApproveTempLinkRela.getApproveLinkId(), approveTempCity.getId());
					if (cityApproveTempLinkRela != null) {
						allApproveTempLinkList.add(cityApproveTempLinkRela);
					} else {
						deleteApproveTempCityList.add(approveTempCity);
					}
				}
				if (deleteApproveTempCityList != null && deleteApproveTempCityList.size() > 0) {
					approveTempCityList.removeAll(deleteApproveTempCityList);
				}
				if (approveTempCityList != null) {
					allApproveTempList.addAll(approveTempCityList);
				}
			}
		}
		Police police = policeDao.findById(approveLinkLevelDto.getOrgId());
		List<ApproveLinkLevel> approveLinkLevelList = JSON.parseArray(approveLinkLevelDto.getApproveLinkLevelList(),
				ApproveLinkLevel.class); // 审批环节层级
		// 获取模板环节列表
		if (allApproveTempList != null && allApproveTempList.size() > 0) {
			for (int index = 0; index < allApproveTempList.size(); index++) {
				// 1查询List用来比较删除和添加（失效和有效都查询）
				Long tempLinkRelaIdChange = allApproveTempLinkList.get(index).getId();// 模板环节ID
				ApproveTemp approveTempChange = allApproveTempList.get(index);// 模板对象
				List<ApproveLinkLevel> approveLinkLevelLisTuretdb = approveLinkLevelDao
						.findListTureByAllApproveLinkId(tempLinkRelaIdChange);
				List<ApproveLinkLevel> approveLinkLevelListdb = approveLinkLevelDao
						.findListByAllApproveLinkId(tempLinkRelaIdChange);

				// 2修改
				if (approveLinkLevelListdb.size() > 0) {
					// 如果和数据库的启动相同则不需要修改
					// 定义一个比较标志
					int flag = 0;
					if (approveLinkLevelLisTuretdb.size() == approveLinkLevelList.size()) {
						for (int i = 0; i < approveLinkLevelLisTuretdb.size(); i++) {
							if (StringUtil.equals(approveLinkLevelLisTuretdb.get(i).getApproveLevel(),
									approveLinkLevelList.get(i).getApproveLevel())) {
								flag++;
							}
						}
						if (approveLinkLevelLisTuretdb.size() == flag) {
							break;
						}
					}
					// 如果环节完成则将该环节的状态修改
					ApproveTempLinkRela approveTempLinkRela = approveTempLinkRelaDao.findById(tempLinkRelaIdChange);
					approveTempLinkRela.setLinkSetStatus("0");
					approveTempLinkRela.setUpdateTime(new Date());
					// approveTempLinkRela.setUpdateBy(currentUser.getUsername());
					approveTempLinkRelaDao.update(approveTempLinkRela);

					// 如果该环节的审批模板主流程信息完成则需要将状态改为无效（主流程完成才要完全修改）
					if (StringUtil.equals(approveTempChange.getApproveSetStatus(),
							Constants.CONFIGURATION_CONFIGURED)) {
						approveTempChange.setApproveSetStatus(Constants.CONFIGURATION_NOT_CONFIGURED);
						approveTempChange.setFailureTime(new Date());
						approveTempChange.setUpdateTime(new Date());
						approveTempChange.setUpdateBy("1");
						approveTempDao.update(approveTempChange);
						// 将配置信息全部改为无效
						approveTempProcessDao.batchUpdateByApproveTempId(approveTempChange);
					}

					// 2.1如果不为空则将list 改为map
					Map<String, ApproveLinkLevel> stringApproveLinkLevelMap = new HashMap<>();
					for (ApproveLinkLevel approveLinkLevel : approveLinkLevelListdb) {
						stringApproveLinkLevelMap.put(approveLinkLevel.getApproveLevel(), approveLinkLevel);
					}
					// 2.2将下属所有配置清空(流程配置和流程人员配置以及审批环节流程明细)
					approveLinkLevelDao.deleteSubordinate(police.getAreacode().substring(0, 2),
							police.getOrgname(), tempLinkRelaIdChange);
					// TODO表字段变更
					approveLinkLevelDao.deleteApproveDetail(police.getAreacode().substring(0, 2),
							police.getOrgname(), tempLinkRelaIdChange);
					// 2.3修改的审批环节层次修改信息
					for (int i = 0; i < approveLinkLevelList.size(); i++) {

						// 2.3.2如果本次为第一循环则不用 审批环节层次上层id 设为null
						if (i == 0) {
							ApproveLinkLevel approveLinkLevel = stringApproveLinkLevelMap
									.get(approveLinkLevelList.get(i).getApproveLevel());
							approveLinkLevel.setParentId(null);
							approveLinkLevel.setUpdateTime(new Date());
							approveLinkLevel.setActive(true);
							// approveLinkLevel.setUpdateBy(currentUser.getUsername());
							stringApproveLinkLevelMap.remove(approveLinkLevelList.get(i).getApproveLevel());
							// 为下一次循环做好准备
							approveLinkLevelList.get(i).setId(approveLinkLevel.getId());
							approveLinkLevelDao.update(approveLinkLevel);
							// 1.1 创建该地区下的所有的派出所的区域审批流程，状态为失效
							approveAreaProcessDao.saveAreaProcessByAreacodeFailure(police.getAreacode().substring(0, 2),
									approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
							// 2.3.2.1.将该地区下所有的派出所的区域审批流程的状态改为有效
							approveAreaProcessDao.updateAreaProcessByAreacode(police.getAreacode().substring(0, 2),
									approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
							// 2.3.3其他则需要修改上层ID
						} else {
							ApproveLinkLevel approveLinkLevel = stringApproveLinkLevelMap
									.get(approveLinkLevelList.get(i).getApproveLevel());
							approveLinkLevel.setParentId(approveLinkLevelList.get(i - 1).getId());
							approveLinkLevel.setUpdateTime(new Date());
							approveLinkLevel.setActive(true);
							// approveLinkLevel.setUpdateBy(currentUser.getUsername());
							stringApproveLinkLevelMap.remove(approveLinkLevelList.get(i).getApproveLevel());
							// 为下一次循环做好准备
							approveLinkLevelList.get(i).setId(approveLinkLevel.getId());
							approveLinkLevelDao.update(approveLinkLevel);
							// 1.1 创建该地区下的所有的派出所的区域审批流程，状态为失效
							approveAreaProcessDao.saveAreaProcessByAreacodeFailure(police.getAreacode().substring(0, 2),
									approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
							// 2.3.3.1.将该地区下所有的派出所的区域审批流程的状态改为无效
							approveAreaProcessDao.updateAreaProcessByAreacode(police.getAreacode().substring(0, 2),
									approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
						}
					}
					// 2.4将没有用到的approveLinkLevel修改为失效状态
					Iterator<Map.Entry<String, ApproveLinkLevel>> it = stringApproveLinkLevelMap.entrySet().iterator();
					while (it.hasNext()) {
						Map.Entry<String, ApproveLinkLevel> entry = it.next();
						ApproveLinkLevel approveLinkLevel = entry.getValue();
						approveLinkLevel.setUpdateTime(new Date());
						approveLinkLevel.setActive(false);
						approveLinkLevelDao.delete(approveLinkLevel);
						approveAreaProcessDao.updateAreaProcessByAreacodeFailure(police.getAreacode().substring(0, 2),
								approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());

					}

				} else {
					Map<String, ApproveLinkLevel> stringApproveLinkLevelMap = new HashMap<>();
					// 1.如果没有存在则为用户新建四个层次(省，市，县，公安局)
					for (int i = 1; i <= 4; i++) {
						ApproveLinkLevel approveLinkLevel = new ApproveLinkLevel();
						approveLinkLevel.setCreateTime(new Date());
						approveLinkLevel.setUpdateTime(new Date());
						// TODO表字段变更
						approveLinkLevel.setTempLinkRelaId(tempLinkRelaIdChange);
						approveLinkLevel.setApproveLevel(String.valueOf(i));
						approveLinkLevel.setActive(false);
						approveLinkLevelDao.save(approveLinkLevel);
						approveLinkLevel.setId(approveLinkLevel.getId());
						// 1.1 创建该地区下的所有的派出所的区域审批流程，状态为失效
						approveAreaProcessDao.saveAreaProcessByAreacodeFailure(police.getAreacode().substring(0, 2),
								approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
						stringApproveLinkLevelMap.put(String.valueOf(i), approveLinkLevel);
					}
					// 2.修改的审批环节层次修改信息
					for (int i = 0; i < approveLinkLevelList.size(); i++) {
						// 2.1如果本次为第一循环则不用 审批环节层次上层id 设为null
						if (i == 0) {
							ApproveLinkLevel approveLinkLevel = stringApproveLinkLevelMap
									.get(approveLinkLevelList.get(i).getApproveLevel());
							approveLinkLevel.setParentId(null);
							approveLinkLevel.setUpdateTime(new Date());
							approveLinkLevel.setActive(true);
							// approveLinkLevel.setUpdateBy(currentUser.getUsername());
							// 为下一次循环做好准备
							approveLinkLevelList.get(i).setId(approveLinkLevel.getId());
							approveLinkLevelDao.update(approveLinkLevel);
							// 2.1.1.将该地区下所有的派出所的区域审批流程的状态改为有效
							approveAreaProcessDao.updateAreaProcessByAreacode(police.getAreacode().substring(0, 2),
									approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
							// 2.2其他则需要修改上层ID
						} else {
							ApproveLinkLevel approveLinkLevel = stringApproveLinkLevelMap
									.get(approveLinkLevelList.get(i).getApproveLevel());
							approveLinkLevel.setParentId(approveLinkLevelList.get(i - 1).getId());
							approveLinkLevel.setUpdateTime(new Date());
							approveLinkLevel.setActive(true);
							// approveLinkLevel.setUpdateBy(currentUser.getUsername());
							// 为下一次循环做好准备
							approveLinkLevelList.get(i).setId(approveLinkLevel.getId());
							// 2.1.2.将该地区下所有的派出所的区域审批流程的状态改为有效
							approveAreaProcessDao.updateAreaProcessByAreacode(police.getAreacode().substring(0, 2),
									approveLinkLevel.getId(), approveLinkLevel.getApproveLevel());
							approveLinkLevelDao.update(approveLinkLevel);
						}
					}

				}
			}
		}

		// 判断是否是特殊节点，如果是特殊节点则需要启动主流程
		boolean isSpecial = false;
		if (StringUtils.isEmpty(linkType)) {
			isSpecial = true;
		} else {
			switch (linkType) {
			case "1":
				isSpecial = true;
				break;
			case "2":
				isSpecial = true;
				break;
			case "3":
				isSpecial = true;
				break;
			case "4":
				isSpecial = true;
				break;
			case "5":
				isSpecial = true;
				break;
			default:
				break;
			}
		}
		if (isSpecial) {
			if (allApproveTempList != null && allApproveTempList.size() > 0) {
				for (int index = 0; index < allApproveTempList.size(); index++) {
					ApproveTemp approveTempChange = allApproveTempList.get(index);// 模板对象
					// 生成并启动审批主流程(省级模板不启动审批主流程，市级模板才启动审批主流程)
					if (approveTempChange.getParentTempId() != null) {
						try {
							saveMainProcess(approveTempChange);
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				}
			}
		}
	}

	private String saveMainProcess(ApproveTemp approveTemp) throws Exception {
		// get审批流程配置ID
		Long approveTempId = approveTemp.getId();
		// 将配置信息全部改为无效
		approveTemp = approveTempDao.findById(approveTempId);
		// get流程名称
		String approveTempName = approveTemp.getTempName();
		// get唯一标识ID
		String tempCode = approveTemp.getTempCode();
		String businessTypeCode = "";

		String groupId = "";
		// 科长账号
		Config kzConfig = configDao.findByKey(Constants.KZZHID);
		if (kzConfig != null && StringUtil.isNotEmpty(kzConfig.getValue())) {
			groupId = kzConfig.getValue();
		}
		// 业务类型code
		if (tempCode.contains("-")) {
			businessTypeCode = BusinessType.getBusinessType(tempCode.split("-")[0]);
		}
		String maxApproveLevel = approveTempDao.getMaxApproveLevelByApproveTempId(approveTempId);
		String configMsg = ""; // 配置结果
		if (StringUtil.isNotEmpty(maxApproveLevel)) {
			User user = arsUtil.getCurrentUser();
			String orgtype = user.getPolice().getOrgtype(); // 当前机构类型
			String superAreaCode = ""; // 上级机构编码
			String superOrgtype = ""; // 上级机构类别
			Long policeId = user.getPolice().getId(); // 当前机构ID
			String areaCode = user.getPolice().getAreacode(); // 当前机构所在地区,地区只有6位
			if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
				// 省级
				areaCode = areaCode.substring(0, 2);
			} else if (orgtype.equals(Constants.POLICE_ORGTYPE_SHI)) {
				// 市级
				areaCode = areaCode.substring(0, 4);
				superAreaCode = areaCode.substring(0, 2) + "0000";
				superOrgtype = Constants.POLICE_ORGTYPE_SHENG;
			} else if (orgtype.equals(Constants.POLICE_ORGTYPE_QX)) {
				// 区县
				superAreaCode = areaCode.substring(0, 4) + "00";
				superOrgtype = Constants.POLICE_ORGTYPE_SHI;
			} else {
				// 派出所
				superAreaCode = areaCode;
				superOrgtype = Constants.POLICE_ORGTYPE_QX;
			}
			if (!orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
				/**
				 * 判断审批模板当前机构的所属上级机构是否都配置完成，如果未配置完成则不能启动主流程,省级机构除外
				 */
				CheckTempConfigDto checkDto = new CheckTempConfigDto();
				checkDto.setTempId(approveTempId);
				checkDto.setAreaCode(superAreaCode);
				checkDto.setOrgtype(superOrgtype);
				Long check = approveTempLinkRelaDao.checkTempConfigCompleteByOrgTypeAndCityCode(checkDto);
				if (check != null && check > 0) {
					configMsg = "模板环节上级机构未配置完成！";
					logger.info(configMsg);
					return configMsg;
				}
			}

			List<ApproveTempLinkRela> approveTempLinkRelaList = approveTempLinkRelaDao
					.findByApproveTempIdList(approveTempId);
			List<Police> policeList = new ArrayList<Police>();
			if (orgtype.equals(Constants.POLICE_ORGTYPE_PCS)) {
				// 派出所，只查询自己机构信息
				Police police = policeDao.findById(policeId);
				policeList.add(police);
			} else {
				// 非派出所，则取本级机构以及下属机构信息
				policeList = policeDao.findPoliceByOrgTypeAndLikeAreacode(maxApproveLevel, areaCode);
			}
			if (policeList != null && policeList.size() > 0) {
				List<ApproveTempProcess> approveTempProcessList = new ArrayList<>();
				for (Police police : policeList) {
					String[] policeIds = police.getPath().split("/");
					ApproveLinkProDetailDto searchDto = new ApproveLinkProDetailDto();
					searchDto.setPoliceIds(policeIds);
					List<ApproveTempLinkRelaDto> approveTempLinkRelaDtoList = new ArrayList<ApproveTempLinkRelaDto>();
					if (approveTempLinkRelaList != null && approveTempLinkRelaList.size() > 0) {
						int tempLinkSize = approveTempLinkRelaList.size();
						for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
							Long tempLinkRelaId = approveTempLinkRela.getId();
							String approveLevel = approveLinkLevelDao
									.getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);

							// 类型是1、报名确认， 2、缴费确认， 3、指纹获取，4、考试安排没有审批层次
							if (StringUtil.isEmpty(approveLevel)) {
								ApproveLink approveLink = approveLinkDao
										.findById(approveTempLinkRela.getApproveLinkId());
								if (approveLink != null) {
									/*
									 * 1、判断未设置环境是不是特殊节点：保安资格证特殊节点有报名确认、缴费确认、指纹获取
									 * 、考试安排。另外模板用到指派民警
									 * 2、如果不是特殊节点，则环境未配置地区则不启动整体流程
									 */
									if (StringUtils.isEmpty(approveLink.getLinkType())) {
										// 非特殊节点，则不启动整体流程
										configMsg = "审批流程未启动：存在未配置审批单位的审批环节";
										return configMsg;
									} else {
										// 特殊节点
										ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
										approveTempLinkRelaDto.setLinkName(approveLink.getLinkName());
										approveTempLinkRelaDto.setLinkType(approveLink.getLinkType());
										approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
									}
								}
							} else {
								searchDto.setTempLinkRelaId(tempLinkRelaId);
								searchDto.setApproveLevel(approveLevel);
								ApproveLinkProDetail pproveLinkProDetail = approveLinkProDetailDao
										.findListByTempLinkRelaIdAndPoliceIds(searchDto);
								if (pproveLinkProDetail != null) {
									ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
									approveTempLinkRelaDto = approveTempLinkRelaDao
											.findDtoById(pproveLinkProDetail.getTempLinkRelaId());
									approveTempLinkRelaDto.setApproveLinkProDetailId(pproveLinkProDetail.getId());
									approveTempLinkRelaDto
											.setApproveAreaProId(pproveLinkProDetail.getApproveAreaProId());
									approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
								} else {
									// 找不到流程配置信息则不继续循环，循环下一个机构
									break;
								}
							}
						}
						// 环节阶段都配置完成才可以启动主流程
						if (approveTempLinkRelaDtoList != null && approveTempLinkRelaDtoList.size() > 0
								&& tempLinkSize == approveTempLinkRelaDtoList.size()) {
							// 如果为保安服务公司年度报告备案要把最后流程的人员ID修改为annals
							if (businessTypeCode.equals(BusinessType.NDBG)) {
								List<ApproveAreaProcess> approveAreaProcessList = new ArrayList<ApproveAreaProcess>();
								ApproveAreaProcess approveAreaProcess = approveAreaProcessDao
										.findById(approveTempLinkRelaDtoList.get(approveTempLinkRelaDtoList.size() - 1)
												.getApproveAreaProId());
								if (approveAreaProcess != null) {
									approveAreaProcessList.add(approveAreaProcess);
								}
								if (approveTempLinkRelaDtoList.size() > 1) {
									approveAreaProcess = approveAreaProcessDao.findById(approveTempLinkRelaDtoList
											.get(approveTempLinkRelaDtoList.size() - 2).getApproveAreaProId());
									if (approveAreaProcess != null) {
										approveAreaProcessList.add(approveAreaProcess);
									}
								}
								ApprovalActivityUtil.thirdJsonUpdate(approveAreaProcessList);
							}
							ApproveTempProcess approveTempProcess = new ApproveTempProcess();
							approveTempProcess.setCreateTime(new Date());
							approveTempProcess.setUpdateTime(new Date());
							approveTempProcess.setActive(true);
							approveTempProcess.setApproveTempId(approveTempId);
							approveTempProcess.setRegionLevel(police.getOrgtype());
							approveTempProcess.setPoliceCode(StringUtil.isNotEmpty(police.getCode())?police.getCode().toString():"");
							approveTempProcess.setPoliceId(police.getId());
							String processID = tempCode + "-" + police.getId().toString();
							String processName = approveTempName + police.getOrgname();
							approveTempProcess.setProcessInfo(ApprovalActivityUtil.oneJson(approveTempLinkRelaDtoList,
									processID, processName, groupId));
							approveTempProcessList.add(approveTempProcess);
						}
					}
				}
				if (approveTempProcessList != null && approveTempProcessList.size() > 0) {
					approveTempProcessDao.batchSave(approveTempProcessList);
					ApproveTemp approveTempSave = approveTempDao.findById(approveTempId);
					approveTempSave.setEffectTime(new Date());
					approveTempSave.setUpdateTime(new Date());
					approveTempSave.setApproveSetStatus(Constants.CONFIGURATION_CONFIGURED);
					approveTempDao.update(approveTempSave);
				}
			} else {
				if (approveTempLinkRelaList != null && approveTempLinkRelaList.size() > 0) {
					for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
						Long tempLinkRelaId = approveTempLinkRela.getId();
						String approveLevel = approveLinkLevelDao.getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);
						// 类型是1、报名确认， 2、缴费确认， 3、指纹获取，4、考试安排没有审批层次
						if (StringUtil.isEmpty(approveLevel)) {
							ApproveLink approveLink = approveLinkDao.findById(approveTempLinkRela.getApproveLinkId());
							if (approveLink != null) {
								/*
								 * 1、判断未设置环境是不是特殊节点：保安资格证特殊节点有报名确认、缴费确认、指纹获取
								 * 、考试安排。另外模板用到指派民警 2、如果不是特殊节点，则环境未配置地区则不启动整体流程
								 */
								if (StringUtils.isEmpty(approveLink.getLinkType())) {
									// 非特殊节点，则不启动整体流程
									configMsg = "审批流程未启动：存在未配置审批单位的审批环节";
									return configMsg;
								}
							}
						}
					}
				}
			}
		} else {
			configMsg = "审批环节未配置";
		}
		return configMsg;
	}

	/**
	 * @Author: wangcy
	 * @Description:根据ID查询
	 * @Date: 2018/01/19 0019 15:54
	 */
	@Override
	public ApproveLinkLevel findById(Long approveLinkLevelId) {
		return approveLinkLevelDao.findById(approveLinkLevelId);
	}

	@Override
	public List<ApproveLinkLevel> findListTureByApproveLinkIdAndLevel(Long tempLinkRelaId, String approveLevel) {
		return approveLinkLevelDao.findListTureByApproveLinkIdAndLevel(tempLinkRelaId, approveLevel);
	}

	@Override
	public void insertBatchTemp(List<ApproveLinkLevel> approveList) {
		approveLinkLevelDao.insertBatchTemp(approveList);
	}

	@Override
	public List<ApproveLinkLevel> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return approveLinkLevelDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void updateFlagForOutToIn(List<ApproveLinkLevel> linkLevelList) {
		approveLinkLevelDao.updateFlagForOutToIn(linkLevelList);
	}
}
