package com.bcxin.ars.service.appeal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersonGradeDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.service.appeal.AppealHandle;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/***
 * 等级证申诉处理
 * @author  subh
 */
@Service
public class GradeAppealHandle implements AppealHandle {


    @Autowired
    private PersonGradeDao personGradeDao;

    @Autowired
    private PersonGradeDaoAop personGradeDaoAop;

    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    @Override
    public void handle(Appeal appeal) {
        //获取等级证报名信息
        PersonGrade personGrade = personGradeDao.findById(appeal.getBusinessid());
        if(Constants.APPROVALSTATE_TG.equals(appeal.getAppealState())){
            //审批状态设置为审批中
            personGrade.setApprovalState(Constants.APPLYSTATUS_DSH);
            //背景筛查设置为通过
            personGrade.setCensorStatus(Constants.BACKGROUNDSTATUS_ZC);
            //审批原因设置为空
            personGrade.setApprovalReason(null);
            //更新最新时间
            personGrade.setUpdateTime(new Date());
        }else if(Constants.APPROVALSTATE_BTG.equals(appeal.getAppealState())){
            //审批状态设置为不通过
            personGrade.setApprovalState(Constants.APPLYSTATUS_SHBTG);
            //背景筛查设置为不通过
            personGrade.setCensorStatus(Constants.BACKGROUNDSTATUS_GZ);
            //审批原因
            personGrade.setApprovalReason(appeal.getAppealReson());
            //更新最新时间
            personGrade.setUpdateTime(new Date());
        }

        //更新
        personGradeDaoAop.update(personGrade);
    }

    @Override
    public void handle(List<Appeal> list) {
        if(list != null && list.size() >0) {
            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            List<PersonGrade> gradeList = new ArrayList<>();
            for (Appeal appeal : list) {
                //获取等级证报名信息
                PersonGrade personGrade = personGradeDao.findById(appeal.getBusinessid());
                if(Constants.APPROVALSTATE_TG.equals(appeal.getAppealState())){
                    //审批状态设置为审批中
                    personGrade.setApprovalState(Constants.APPLYSTATUS_DSH);
                    //背景筛查设置为通过
                    personGrade.setCensorStatus(Constants.BACKGROUNDSTATUS_ZC);
                    //审批原因设置为空
                    personGrade.setApprovalReason(null);
                    //更新最新时间
                    personGrade.setUpdateTime(new Date());
                }else if(Constants.APPROVALSTATE_BTG.equals(appeal.getAppealState())){
                    //审批状态设置为不通过
                    personGrade.setApprovalState(Constants.APPLYSTATUS_SHBTG);
                    //背景筛查设置为不通过
                    personGrade.setCensorStatus(Constants.BACKGROUNDSTATUS_GZ);
                    //审批原因
                    personGrade.setApprovalReason(appeal.getAppealReson());
                    //更新最新时间
                    personGrade.setUpdateTime(new Date());
                }

                param = new JSONObject();
                param.put("gradeApplyId", personGrade.getId()+"");
                param.put("backgroundStatus", personGrade.getCensorStatus());
                param.put("approvalState", personGrade.getApprovalState());
                param.put("backgroundFailReason", personGrade.getApprovalReason());
                /**
                 * 背景筛查类型
                 * 1. 系统自动比对
                 * 2. 申诉通道
                 */
                param.put("backgroundType", Constants.BACKGROUNDTYPE_APPEAL);
                paramArr.add(param);

                //更新
                gradeList.add(personGrade);
            }

            //TODO 背景筛查结果同步给百课堂
            Map<String,Object> paramMap = new HashMap<>();
            paramMap.put("personList", JSON.toJSONString(paramArr));
            AjaxResult result = bktInterfaceUtil.callInterface(Constants.BKT_PERSONGRADE_CENSOR_URL,paramMap);
            if(!result.isSuccessful()){
                throw new ArsException("【等级证报名申诉结果】"+result.getMsg());
            }

            personGradeDaoAop.saveBatch(gradeList);
        }

    }
}
