package com.bcxin.ars.service.appeal.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.SecurityPersonDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.service.appeal.AppealHandle;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/***
 * 认证申诉结果处理
 * @author subh
 */
@Service
public class AuthAppealHandle implements AppealHandle {

    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;

    @Autowired
    private SecurityPersonDaoAop securityPersonDaoAop;

    private static Map<String,String> saasMap = new HashMap<>();

    static {
        saasMap.put(Constants.APPEALSTATE_PASS,Constants.SAAS_APPEALSTATE_PASS);
        saasMap.put(Constants.APPEALSTATE_FAIL,Constants.SAAS_APPEALSTATE_FAIL);
    }

    @Override
    public void handle(Appeal appeal) {
        //调用saas认证结果接口 TODO
        if(saasMap.get(appeal.getAppealState()) != null) {
            List<Map<String, Object>> paramList = new ArrayList<>();
            Map<String, Object> detailMap = new HashMap<>();
            detailMap.put("perId", appeal.getBusinessid()+"");
            detailMap.put("appealState", saasMap.get(appeal.getAppealState()));
            detailMap.put("appealContext", appeal.getAppealContext());
            paramList.add(detailMap);
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("appeals", JSON.toJSONString(paramList));
            saasInterfaceUtil.callInterface(Constants.SAAS_AUTHAPPEAL, paramMap);
        }
    }

    @Override
    public void handle(List<Appeal> list) {
        if(list != null && list.size() >0) {
            Map<String, Object> paramMap = new HashMap<>();
            List<Map<String, Object>> paramList = new ArrayList<>();

            List<Appeal> passList = new ArrayList<>();
            for (Appeal appeal : list) {
                if(saasMap.get(appeal.getAppealState()) != null) {
                    Map<String, Object> detailMap = new HashMap<>();
                    detailMap.put("perId", appeal.getBusinessid()+"");
                    detailMap.put("approveStatus", saasMap.get(appeal.getAppealState()));
                    detailMap.put("approveContent", appeal.getAppealReson());
                    paramList.add(detailMap);

                    if(Constants.APPEALSTATE_PASS.equals(appeal.getAppealState())){
                        passList.add(appeal);
                    }
                }
            }

            if(passList.size() >0) {
                securityPersonDaoAop.updateBatchAuthState(passList);
            }

            if(paramList != null && paramList.size() >0) {
                paramMap.put("appeals", JSON.toJSONString(paramList));
                saasInterfaceUtil.callInterface(Constants.SAAS_AUTHAPPEAL, paramMap);
            }
        }
    }

}
