package com.bcxin.ars.service.appeal.impl;

import cn.hutool.extra.validation.BeanValidationResult;
import cn.hutool.extra.validation.ValidationUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.appeal.AppealDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.exception.ValidateException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.appeal.AppealService;
import com.bcxin.ars.service.bean.factory.AppealHandleBeanFactory;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.io.File;
import java.util.*;
import java.util.stream.Collectors;

/***
 * 申诉信息服务实现层
 * @author subh
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = Appeal.class)
@DataSyncOutAnnotation(getClazz = Appeal.class)
public class AppealServiceImpl extends BaseService implements AppealService  {
    /***
     * 日志
     */
    public static Logger logger = LoggerFactory.getLogger(AppealServiceImpl.class);

    private static BackGroupCensorService backGroupCensorService;

    @Autowired
    private AppealDao appealDao;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;

    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    @Value("${base-folder}")
    private String baseFolder;

    @Value("${upload-folder}")
    private String uploadFolder;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Resource
    private IdWorker idWorker;

    @Resource
    private PersonGradeDao personGradeDao;

    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    @Override
    public void searchForPage(AppealSearchDto searchDto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(searchDto);
        //查询机构时，能查询所在区的派出所
        String areaCodeQuery = searchDto.getAreaCodeQuery();
        if(!StringUtils.isEmpty(areaCodeQuery)){
            searchDto.setAreaCode(areaCodeQuery);
        }
        appealDao.searchForPage(searchDto,page);
    }

    @Override
    public List<Appeal> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return appealDao.searchForDataSynchronization(searchDto);
    }

    @Override
    public void saveOrUpdateForDS(Appeal appeal){
        getBackGroupCensorService();
        Appeal dbAppeal =findById(appeal.getId());
        if (dbAppeal != null) {
            if(appeal.getUpdateTime().getTime() >= dbAppeal.getUpdateTime().getTime()) {
                appealDao.update(appeal);
            }
        }else {
            //获取人口库照片 TODO
            try {
                String photo=backGroupCensorService.getPhoto(appeal.getIdnum(),appeal.getName());
                appeal.setPhoto(photo);
                savePhoto(appeal);
            }catch (Exception e){
                logger.error("内网读取同步申诉信息异常，获取人口库照片异常:"+e.getMessage());
            }

            appealDao.insert(appeal);
        }
    }
    /***
     * 图片base64位转换
     * @param appeal
     */
    private void savePhoto(Appeal appeal){
        if(StringUtil.isNotEmpty(appeal.getPhoto())){
            Date now = new Date();
            String fileName = now.getTime() +".jpg";
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(uploadFolder + dirDate);
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String key = "upload/" + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = baseFolder + key;

            if(ImgUtils.generateImage(appeal.getPhoto(),targetPath)) {
                appeal.setDataImg(url);
            }
            appeal.setPhoto(null);
        }
    }
    @Override
    public List<Appeal> findDSOutList(String startDate) {
        return appealDao.findDSOutList(startDate);
    }

    /**
     * 批量导入
     * @param list
     */
    @Override
    public void importBatch(List<Appeal> list){
        List<Appeal> dbList = appealDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);

        if (list.size()>0){
            Map<String,List<Appeal>> map = new HashMap<>();
            for(Appeal detail:list){
                detail.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()) {
                        detail.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, detail.getUpdateTime(), 1));
                    }
                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                }
                //根据不同的业务分类
                List<Appeal> businessList = map.get(detail.getBusinesstype());
                if(businessList == null){
                    businessList = new ArrayList<>();
                }
                businessList.add(detail);
                map.put(detail.getBusinesstype(),businessList);
            }

            //根据不同的业务执行 TODO
            map.keySet().forEach(businessType->{
                AppealHandleBeanFactory.getAppealHandleBean(businessType).handle(map.get(businessType));
            });
            //批量保存
            appealDao.saveBatch(list);
        }
    }

    @Override
    public Appeal findById(Long id){
        return appealDao.findById(id);
    }
    @Override
    public void save(Appeal appeal) {
        //当前用户
        User currentUser = arsUtil.getCurrentUser();
        //有效状态
        appeal.setActive(true);
        //创建时间
        appeal.setCreateTime(new Date());
        //更新时间
        appeal.setUpdateTime(new Date());
        //更新者
        appeal.setUpdateBy(currentUser == null ? "system":currentUser.getUsername());
        //待申诉
        appeal.setAppealState(Constants.APPROVALSTATE_DSP);
        //图片地址转换
        /***
         * 1.身份证正面
         */
        if (StringUtil.isNotEmpty(appeal.getCardImgPositive())) {
            appeal.setCardImgPositive(getPhotoPath(appeal.getCardImgPositive())) ;
        }
        /***
         * 2.身份证反面
         */
        if (StringUtil.isNotEmpty(appeal.getCardImgBack())) {
            appeal.setCardImgBack(getPhotoPath(appeal.getCardImgBack())) ;
        }
        /***
         * 3.手持身份证号
         */
        if (StringUtil.isNotEmpty(appeal.getCardHold())) {
            appeal.setCardHold(getPhotoPath(appeal.getCardHold())) ;
        }
        /***
         * 4.认证照片
         */
        if (StringUtil.isNotEmpty(appeal.getAuthImg())) {
            appeal.setAuthImg(getPhotoPath(appeal.getAuthImg())) ;
        }
        /***
         * 5.附件
         */
        if (StringUtil.isNotEmpty(appeal.getAttFile())) {
            appeal.setAttFile(getPhotoPath(appeal.getAttFile())) ;
        }
        //北京监管机构统一按分局层级进行展示，申诉管理需要按此规则进行调整
        if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            //获取securityCompany
            SecurityCompany company = securityCompanyDao.findByComId(appeal.getCompanyId());

            //如果有区县监管机构字段,则使用区县监管机构字段值districtOrgId/districtOrgName,
            //如果没有则用监管机构字段orgId/orgName
            String districtOrgId = company.getDistrictOrgId();
            boolean districtOrgIdIsNull = StringUtils.isEmpty(districtOrgId);
            //districtOrgId null ? orgId : districtOrgId
            appeal.setOrgId(districtOrgIdIsNull ? Long.valueOf(company.getOrgId()) : Long.valueOf(districtOrgId));

            //districtOrgId null ? orgName : districtOrgName
            appeal.setOrgName(districtOrgIdIsNull ? company.getOrgName() : company.getDistrictOrgName());

            appeal.setAreaCode(company.getAreaCode());

        }

        appealDao.insert(appeal);

        saveBusiness(appeal);
    }

    private void saveBusiness(Appeal appeal) {
        //北京申诉处理
        if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
            if (Constants.APPEALTYPE_PERSONCERTIFICATE.equals(appeal.getBusinesstype())) {
                Personcertificate personcertificate = personcertificateDao.findById(appeal.getBusinessid());
                personcertificate.setCensorStatus(Constants.CENSORSTATUS_APPEAL);
                personcertificate.setUpdateTime(new Date());
                personcertificate.setApprovalstate(ApprovalState.SPZ);
                personcertificateDaoAop.updateSelective(personcertificate);
            }
        }
    }

    @Override
    public void saveAppealApproval(Appeal appeal) {
        //获取数据库等级证班级信息
        Appeal dbAppeal = findById(appeal.getId());
        //复制值
        BeanUtils.copyPropertiesIgnore(appeal, dbAppeal, true);
        //当前用户信息
        User user = arsUtil.getCurrentUser();
        dbAppeal.setUpdateBy(user.getUsername());
        dbAppeal.setUpdateTime(new Date());
        dbAppeal.setUpdateflag(true);
        //更新
        appealDao.update(dbAppeal);
    }

    @Override
    public AjaxResult submitBackgroundAppeal(String appeal) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(appeal).getSubject();
        User currentUser = arsUtil.getCurrentUser();
        Appeal appealInfo = JSON.parseObject(subject, Appeal.class);
        // 参数校验
        BeanValidationResult beanValidationResult = ValidationUtil.warpValidate(appealInfo, ThirdPartyTrain.class);
        if (!beanValidationResult.isSuccess()) {
            Set<String> errorMessages = beanValidationResult.getErrorMessages().stream().map((BeanValidationResult.ErrorMessage::getMessage)).collect(Collectors.toSet());
            throw new ValidateException(errorMessages);
        }

        // 如果有待审查的记录则返回不可重复提交
        int count = appealDao.selectCountByBusinessId(appealInfo);
        if (count > 0) {
            ajaxResult.setMsg("不可重复提交");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }

        long appealId = idWorker.nextId();

        Date now = new Date();
        appealInfo.setActive(true);
        appealInfo.setCreateTime(now);
        appealInfo.setUpdateTime(now);
        appealInfo.setUpdateBy(currentUser.getUsername());
        appealInfo.setAppealState(Constants.APPROVALSTATE_DSP);
        appealInfo.setId(appealId);
        String businessType = appealInfo.getBusinesstype();
        Long businessId = appealInfo.getBusinessid();
        if (Constants.APPEALTYPE_PERSONGRADE.equals(businessType)) {
            // 等级证
            PersonGrade personGrade = personGradeDao.findById(businessId);
            if (personGrade == null) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("报名信息不存在");
                return ajaxResult;
            }
            appealInfo.setName(personGrade.getName());
            appealInfo.setIdnum(personGrade.getIdNum());
            appealInfo.setCompanyName(personGrade.getComName());
            appealInfo.setCompanyId(personGrade.getComId());
            Police police = policeDao.findByAreaCode(personGrade.getAreaCode());
            appealInfo.setAreaCode(personGrade.getAreaCode());
            appealInfo.setOrgId(police.getId());
            appealInfo.setOrgName(police.getOrgname());
        } else if (Constants.APPEALTYPE_PERSONCERTIFICATE.equals(businessType)) {
            // 资格证
            Personcertificate personCertificate = personcertificateDao.findById(businessId);
            if (personCertificate == null) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("报名信息不存在");
                return ajaxResult;
            }
            appealInfo.setName(personCertificate.getName());
            appealInfo.setIdnum(personCertificate.getCardnumber());
            appealInfo.setCompanyName(personCertificate.getCompanyname());
            appealInfo.setCompanyId(personCertificate.getCompanyid());
            Police police = policeDao.findByAreaCode(personCertificate.getDistrict());
            appealInfo.setAreaCode(personCertificate.getDistrict());
            appealInfo.setOrgId(police.getId());
            appealInfo.setOrgName(police.getOrgname());
        }
        appealDao.insert(appealInfo);
        ajaxResult.setData(JwtUtil.createJWT(String.valueOf(appealId)));
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("成功");
        return ajaxResult;
    }

    @Override
    public AjaxResult queryBackgroundAppealResult(String appealId) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(appealId).getSubject();
        // 根据id查询申诉结果
        String appealStatus = appealDao.findAppealStatusById(Long.valueOf(subject));
        ajaxResult.setData(JwtUtil.createJWT(appealStatus));
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("成功");
        return ajaxResult;
    }
    @Override
    public AjaxResult applyAppeal(Appeal appeal) {
        AjaxResult ajaxResult = new AjaxResult();
        Personcertificate personcertificate = this.personcertificateDao.findById(appeal.getBusinessid());
        boolean b = this.checkCarNumRepeat(personcertificate);
        if (b) {
            ajaxResult.setMsg("该人员已经报名考试，不得进行申诉!");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        } else {
            appeal.setBusinesstype("002");
            if (!StringUtils.isEmpty(personcertificate.getCardnumber())) {
                appeal.setIdnum(personcertificate.getCardnumber());
            }

            int count = appealDao.selectCountByBusIdAndNum(appeal);
            if (count > 0) {
                ajaxResult.setMsg("该人员存在申诉中记录，不可重复提交");
                ajaxResult.setSuccessful(false);
                return ajaxResult;
            } else {
                User currentUser = this.arsUtil.getCurrentUser();
                appeal.setActive(true);
                Date now = new Date();
                appeal.setCreateTime(now);
                appeal.setUpdateTime(now);
                appeal.setUpdateflag(true);
                appeal.setUpdateBy(currentUser == null ? "system" : currentUser.getUsername());
                appeal.setAppealState("002");
                long appealId = this.idWorker.nextId();
                appeal.setId(appealId);
                if (StringUtil.isNotEmpty(appeal.getAppealContext())) {
                    appeal.setAppealContext(appeal.getAppealContext());
                }

                if (!StringUtils.isEmpty(personcertificate.getOrgid())) {
                    appeal.setOrgId(personcertificate.getOrgid());
                    Police police = this.policeDao.findById(personcertificate.getOrgid());
                    if (!StringUtils.isEmpty(police.getOrgname())) {
                        appeal.setOrgName(police.getOrgname());
                    }

                    if (!StringUtils.isEmpty(police.getAreacode())) {
                        appeal.setAreaCode(police.getAreacode());
                    }
                }

                if (!StringUtils.isEmpty(personcertificate.getCompanyid())) {
                    appeal.setCompanyId(personcertificate.getCompanyid());
                }

                if (!StringUtils.isEmpty(personcertificate.getCompanyname())) {
                    appeal.setCompanyName(personcertificate.getCompanyname());
                }

                if (!StringUtils.isEmpty(personcertificate.getCardnumber())) {
                    appeal.setIdnum(personcertificate.getCardnumber());
                }

                if (!StringUtils.isEmpty(personcertificate.getName())) {
                    appeal.setName(personcertificate.getName());
                }

                if (!StringUtils.isEmpty(personcertificate.getIdCardFront())) {
                    appeal.setCardImgPositive(personcertificate.getIdCardFront());
                }

                if (!StringUtils.isEmpty(personcertificate.getIdCardReverse())) {
                    appeal.setCardImgBack(personcertificate.getIdCardReverse());
                }

                appealDao.insert(appeal);
                saveBusinesstype(personcertificate);
                ajaxResult.setSuccessful(true);
                ajaxResult.setMsg("提交成功");
                return ajaxResult;
            }
        }
    }

    private void saveBusinesstype(Personcertificate personcertificate) {
        if ("61".equals(this.configUtils.getCurrentNative())) {
            personcertificate.setCensorStatus("005");
            personcertificate.setUpdateTime(new Date());
            personcertificate.setUpdateflag(true);
            this.personcertificateDaoAop.updateSelective(personcertificate);
        }

    }

    public boolean checkCarNumRepeat(Personcertificate personcertificate) {
        Map<String, Object> map = new HashMap();
        map.put("cardNum", personcertificate.getCardnumber());
        List<String> notIncludeStateList = new ArrayList();
        notIncludeStateList.add("001");
        notIncludeStateList.add("004");
        notIncludeStateList.add("009");
        map.put("notincludestatelist", notIncludeStateList);
        map.put("filterId", personcertificate.getId());
        Personcertificate dbcheckpersoncertificate = this.personcertificateDao.checkCarNumRepeat(map);
        return null != dbcheckpersoncertificate;
    }

    @Override
    public Appeal findOneByBusinessIdAndType(String businessid, String businesstype) {
        return this.appealDao.findOneByBusinessIdAndType(businessid, businesstype);
    }

}
