package com.bcxin.ars.service.sys;

import com.bcxin.ars.dto.BankAccountExportDto;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.BankAccountPageSearchDto;
import com.bcxin.ars.model.sys.BankAccount;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 银行账号信息Service接口
 *
 * @author linqinglin
 * @Date 2020-05-13 14:37:13
 */
public interface BankAccountService {

   /****
     * 删除
     * @param bankAccount
     * @return
     */
    int delete(BankAccount bankAccount);

    /****
     * 保存
     * @param bankAccount
     * @return
     */
    int save(BankAccount bankAccount);

    /****
     * 选择性修改
     * @param bankAccount
     * @return
     */
    void updateSelective(BankAccount bankAccount);

    /****
     * 主键查询
     * @param id
     * @return
     */
    BankAccount findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(BankAccountPageSearchDto searchDto, AjaxPageResponse<BankAccountExportDto> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<BankAccount> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<BankAccount> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<BankAccount> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<BankAccount> findByBatchId(List<BankAccount> list);

    /**
     * 根据身份证查询
     * @param idNum
     * @return
     */
    BankAccount findByIdNum(String idNum);

}
