package com.bcxin.ars.service.subsidy;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterDto;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterSearchDto;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;


/**
 * @author  yyx
 * @date 2020-05-14
 * @desc 花名册
 */
public interface GradeSubsidyRosterService {

    //根据id查询
    GradeSubsidyRoster findById(Long id);
    /**
     * 查询全部
     * @param gradeSubsidyRosterSearchDto
     * @param page
     */
    void search(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRoster> page);

    void searchForApply(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRosterDto> page);
    /**
     * 保存
     * @param gradeSubsidyRoster
     */
    void save(GradeSubsidyRoster gradeSubsidyRoster);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<GradeSubsidyRoster> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<GradeSubsidyRoster> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<GradeSubsidyRoster> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<GradeSubsidyRoster> findByBatchId(List<GradeSubsidyRoster> list);

    /**
     * 等级证补贴比对结果同步百课堂
     *
     * @param rosterList
     */
    void compareStatusToBKT(List<GradeSubsidyRoster> rosterList);

    Map statistics(GradeSubsidyRosterSearchDto searchDto);


    /**
     * 人员补贴申请状态接口查询
     *
     * @param gradeSubsidyRoster 申请名单
     * @return 可申请/不可申请
     */
    AjaxResult listPersonnelSubsidyApplicationStatus(String gradeSubsidyRoster);
}
