package com.bcxin.ars.service.sb;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.YearReportInsuranceSearchDto;
import com.bcxin.ars.model.sb.YearReportInsurance;

import java.util.List;

/**
 * 保安公司保险信息信息
 * @author Ethan
 */
public interface YearReportInsuranceService {


	/**
	 * 新增或更新保安公司保险信息信息
	 * @param yearReportInsurance
	 */
	void saveOrUpdate(YearReportInsurance yearReportInsurance);

	/**
	 * 根据ID获取保安公司保险信息信息
	 * @param id
	 * @return
	 */
	public YearReportInsurance findById(long id);

	/**
	 * 删除保安公司保险信息信息
	 * @param yearReportInsurance
	 * @return
	 */
	void delete(YearReportInsurance yearReportInsurance);

	/**
	 * 查询保安公司保险信息信息
	 * @param dto
	 * @return
	 */
	public YearReportInsuranceSearchDto search(YearReportInsuranceSearchDto dto);

	List<YearReportInsurance> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(YearReportInsurance yearReportInsurance);

	List<YearReportInsurance> findByUserId(Long userId);
}
