package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.TrainChangeSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.TrainChange;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */
public interface TrainChangeService {

    TrainChange findById(long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:15
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Crosscompany>
     */
    List<TrainChange> findByBatchId(List<Approval> approvalList);
    /**
     *
     * @Decription:通过id查询处理签打印内容
     * @author：zhongjianhui
     * @method  searchForPrintf
     * @date：2018/10/12 17:08
     * @params： * @param id
     * @return java.util.Map
     */
    Map searchForPrintf(long id);
    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:24
     * @params： * @param list
     * @return void
     */
    void updateBatch(List<TrainChange> list);

    void saveOrUpdate(TrainChange trainChange);


    void saveOrUpdateForIntegrate(TrainChange trainChange, User currentUser);

    void saveOrUpdateForDS(TrainChange trainChange);

    TrainChangeSearchDto search(TrainChangeSearchDto dto);
    /***
     * 项目变更查询证书
     * @param dto
     * @return
     */
    TrainChangeSearchDto searchCompanyCertificate(TrainChangeSearchDto dto);

    void delete(TrainChange trainChange);

    TrainChange findByUser(Long userid);

    void updateAndSaveWorkExperience(TrainChange trainChange, Date[] startdate, Date[] enddate, String[] workCompanyname, String[] post);

    List<TrainChange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	List<TrainChange> findAll();

    PageResult searchTrainChangeList_table(Map<Object, Object> p);

    public void updatePoliceId(TrainChange trainChange);

    void saveOrUpdateForApproval(TrainChange trainChange);

    void updateCensorStatus(TrainChange trainChange);

    List<TrainChange> findApprovePassByCompanyId(Long companyId);

    void saveOrUpdateForApprovalImport(TrainChange trainChange);

    void searchForPage(TrainChangeSearchDto dto, AjaxPageResponse<TrainChange> page);
}
