package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.PerCheckRecordPageSearchDto;
import com.bcxin.ars.model.sb.PerCheckRecord;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 抽查记录Service接口
 *
 * @author lin
 * @date 2020-12-09
 */
public interface PerCheckRecordService {
    /****
     * 删除
     * @param perCheckRecord
     * @return
     */
    int delete(PerCheckRecord perCheckRecord);

    /****
     * 保存
     * @param perCheckRecord
     * @return
     */
    int save(PerCheckRecord perCheckRecord);

    /****
     * 选择性修改
     * @param perCheckRecord
     * @return
     */
    void updateSelective(PerCheckRecord perCheckRecord);

    /****
     * 主键查询
     * @param id
     * @return
     */
    PerCheckRecord findById(Long id);

    /**
     * 分页查询
     *
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(PerCheckRecordPageSearchDto searchDto, AjaxPageResponse<PerCheckRecord> page);

    /**
     * 外导内查询
     *
     * @param searchDto
     * @return
     */
    List<PerCheckRecord> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     *
     * @param startDate
     * @return
     */
    List<PerCheckRecord> findDSOutList(String startDate);

    /**
     * 批量保存
     *
     * @param list
     */
    void importBatch(List<PerCheckRecord> list);

    /**
     * 批量查询
     *
     * @param list
     * @return
     */
    List<PerCheckRecord> findByBatchId(List<PerCheckRecord> list);


}
