package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.GradePersonSearchDto;
import com.bcxin.ars.model.sb.GradePerson;
import com.bcxin.ars.model.sb.Personcertificate;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

/***
 * 等级证服务层
 * @author  subh
 */
public interface GradePersonService {
    /***
     * 根据ID获取详细
     * @param id 主键
     * @return
     */
    GradePerson findById(Long id);
    /***
     * 插入
     * @param gradePerson
     */
    void insert(GradePerson gradePerson);
    /***
     * 更新
     * @param gradePerson
     */
    void update(GradePerson gradePerson);

    /***
     * 申诉
     * @param gradePerson
     */
    void saveAppeal(GradePerson gradePerson);
    /***
     * 申诉
     * @param gradePerson
     */
    void saveAppealApproval(GradePerson gradePerson);
    /***
     * 批量插入插入
     * @param list 列表
     */
    List<Map<String, String>> insertBatchForImport(List<Map<String, String>> list);
    /***
     * 批量插入
     * @param list 列表
     */
    void importBatch(List<GradePerson> list);
    /***
     * 等级证查询
     * @param dto 查询条件参数
     * @param ajaxPageResponse 返回数据对象
     * @return 查询列表
     */
    List<GradePerson> query(GradePersonSearchDto dto, AjaxPageResponse<GradePerson> ajaxPageResponse);

    /**
     * 更新内网数据 --保存或者更新（更新到内网数据库）
     * @param gradePerson
     */
    void saveOrUpdateForDS(GradePerson gradePerson);
    /**
     * 查询需要生成同步文件的等级证记录
     * @param dto
     * @return
     */
    List<GradePerson> searchForDataSynchronization(DataSynchronizationSearchDto dto);


    /**
     *获取同步到外网的数据列表
     * @param startDate 开始日期
     */
    List<GradePerson> findDSOutList(String startDate);

    /***
     * 定时背景筛查
     */
    void autoUpdateCensorStatus();

    /***
     * 背景背景筛查
     * @param gradePersonList
     */
    void updateCensorStatusForAuto(List<GradePerson> gradePersonList);

    /**
     * 查询未背景筛查的
     * @return
     */
    List<GradePerson> findNoCensorStatus();

    /***
     * 查询批量号列表
     * @return
     */
    List<String> queryImportBatchIdList();
}
