package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ConfesscompanySearchDto;
import com.bcxin.ars.dto.sb.SubsidiarySearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.sb.Confesscompany;
import com.bcxin.ars.model.sb.Subsidiary;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

public interface ConfesscompanyService {

    Confesscompany findById(long id);
    /**
     *
     * @Decription:批量查询
     * @author：zhongjianhui
     * @method  findByBatchId
     * @date：2018/8/17 9:15
     * @params： * @param approvalList
     * @return java.util.List<com.bcxin.ars.model.sb.Confesscompany>
     */
    List<Confesscompany> findByBatchId(List<Approval> approvalList);

    /**
     *
     * @Decription:批量更新
     * @author：zhongjianhui
     * @method  updateBatch
     * @date：2018/8/17 9:24
     * @params： * @param list
     * @return void
     */
    void updateBatch(List<Confesscompany> list);
    void saveOrUpdate(Confesscompany confesscompany);

    void saveOrUpdateForDS(Confesscompany confesscompany);

    ConfesscompanySearchDto search(ConfesscompanySearchDto dto);

    Confesscompany findByUser(Long userid);

    List<Confesscompany> searchForDataSynchronization(DataSynchronizationSearchDto dto);

	List<Confesscompany> findAll();

    PageResult searchConfesscompanyList_table(Map<Object, Object> p);

    void delete(Confesscompany confesscompany);

    void saveOrUpdateForApproval(Confesscompany confesscompany);

    /**
     * 根据单据id查询申请人信息
     * @param id
     * @return
     */
    Map<String,Object> selectApplyUserInfoWithId(Long id);

    void updateCensorStatus(Confesscompany confesscompany);

    void saveOrUpdateForApprovalImport(Confesscompany confcesscompany);

    /**
     * 公安内网保存 =，无须走流程
     * @param confesscompany
     */
    void saveOrUpdateBypolice(Confesscompany confesscompany);

    void searchForPage(ConfesscompanySearchDto dto, AjaxPageResponse<Confesscompany> page);
}
