package com.bcxin.ars.service;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.MenuTree;
import com.bcxin.ars.dto.PoliceRoleSearchDto;
import com.bcxin.ars.dto.page.PoliceRoleDto;
import com.bcxin.ars.dto.page.RolePageSearchDto;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.SecurityGuard;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


public interface PoliceRoleService {

	PoliceRole findById(long id);

    /***
     * 保存角色信息
     * @param policeRole 角色信息
     * @param operationIds 功能权限列表
     * @param orgIds 数据权限列表
     */
	void saveOrUpdate(PoliceRole policeRole,Long[] operationIds,String orgIds);
	/***
	 * 获取审批角色
	 * @param dto
	 * @return
	 */
	String findApprovalRole(PoliceRoleSearchDto dto);

	/**
	 * 根据公安机构ID删除公安角色
	 * @param orgId
	 * by llc 2018-08-28
	 */
	void deleteRoleByOrgId(Long orgId);


	PoliceRoleSearchDto search(PoliceRoleSearchDto dto);

	void delete(PoliceRole policeRole);
	
	List<PoliceRole> findByUserId(Long userid);
	
	List<PoliceRole> findByRoleId(Long roleid);

	List<PoliceRole> findAll();

	void saveOrUpdateForDS(PoliceRole policeRole);

	PoliceRoleSearchDto searchForUser(PoliceRoleSearchDto dto);

	void autoExportPoliceRole();

	void saveOrUpdateForImport(PoliceRole policeRole);

	List<PoliceRole> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<PoliceRole> findDSOutList(String startDate);

	/**
	 * @Decription:批量保存修改
	 * @param list
	 * @return
	 */
	void importBatch(List<PoliceRole> list);
	/***
	 * 公安用户管理查询
	 * @param dto 查询条件参数
	 * @param page 返回数据对象
	 * @return 查询列表
	 */
    void searchForPage(RolePageSearchDto dto, AjaxPageResponse<PoliceRoleDto> page);

    void save(PoliceRole policeRole, String[] menuIds, String[] orgIds);
}
