package com.bcxin.ars.service;

import com.bcxin.ars.dto.page.FilerecordPageSearchDto;
import com.bcxin.ars.dto.sb.FilerecordSearchDto;
import com.bcxin.ars.model.Filerecord;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 文件记录信息
 * @author Ethan
 */
public interface FilerecordService {


	/**
	 * 新增或更新文件记录信息
	 * @param filerecord
	 */
	void saveOrUpdate(Filerecord filerecord);

	/**
	 * 根据ID获取文件记录信息
	 * @param id
	 * @return
	 */
	public Filerecord findById(long id);

	/**
	 * 根据filepath获取文件记录信息
	 * @param filepath
	 * @return
	 */
	public Filerecord findByFilepath(String filepath);



	void save(Filerecord filerecord);


	/**
	 *
	 * @Decription:查询一段日期内同步文件记录
	 * @author：wjb
	 * @method  findFilerecordByTime
	 * @date：2018年9月14日09:32:13
	 * @param startDate
	*@param endDate
	 * @return java.util.List<com.bcxin.ars.model.Filerecord>
	 */
    List<Filerecord> findFilerecordByTime(String startDate,String endDate);


	/**
	 *
	 * @Decription:批量查询ID是否有在列表中
	 * @author：wjb
	 * @method  findByBatchId
	 * @date：2018年9月14日10:28:57
	 * @params： * @param filerecordList
	 * @return@return java.util.List<com.bcxin.ars.model.Filerecord>
	 */
	List<Filerecord> findByBatchId(List<Filerecord> filerecordList);

	/**
	 *
	 * @Decription:批量插入同步文件记录
	 * @author：wjb
	 * @method  importBatchFilerecord
	 * @date：2018年9月14日10:11:45
	 * @params： * @param filerecordList
	 */
	void importBatchFilerecord(List<Filerecord> filerecordList);

	FilerecordSearchDto search(FilerecordSearchDto dto);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<Filerecord> findDSOutList(String startDate);

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	void searchForPage(FilerecordPageSearchDto searchDto, AjaxPageResponse<Filerecord> page);

    void delete(Long id);
}
