package com.bcxin.ars.service;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.DatasyncSearchDto;
import com.bcxin.ars.model.Datasync;

import java.util.List;

/**
 * 数据同步信息
 * @author Ethan
 */
public interface DatasyncService {


	/**
	 * 新增或更新数据同步信息
	 * @param datasync
	 */
	void saveOrUpdate(Datasync datasync);

	/**
	 * 根据ID获取数据同步信息
	 * @param id
	 * @return
	 */
	public Datasync findById(long id);

	/**
	 * 根据bID获取数据同步信息
	 * @param bid
	 * @return
	 */
	public Datasync findByBid(long bid);

	/**
	 * 删除数据同步信息
	 * @param datasync
	 * @return
	 */
	void delete(Datasync datasync);

	/**
	 * 查询
	 * @param datasyncSearchDto
	 * @return
	 */
	DatasyncSearchDto search(DatasyncSearchDto datasyncSearchDto);

	List<Datasync> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(Datasync datasync);

    void createToOutDataFile(String startDate);

    void createToOutDataFileByHttp(String startDate);
}
