package com.bcxin.ars.service;
import java.util.List;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.CyServerhtSearchDto;
import com.bcxin.ars.model.CyServerht;


/**
 * 服务合同管理
 * @author Ethan
 */
public interface CyServerhtService {


	/**
	 * 新增或更新服务合同信息
	 * @param cyserverht
	 */
	void saveOrUpdate(CyServerht cyserverht);

	/**
	 * 根据ID获取服务合同信息
	 * @param id
	 * @return
	 */
	public CyServerht findById(long id);

	/**
	 * 删除服务合同信息
	 * @param cyserverht
	 * @return
	 */
	void delete(CyServerht cyserverht);

	/**
	 * 查询服务合同信息
	 * @param dto
	 * @return
	 */
	public CyServerhtSearchDto search(CyServerhtSearchDto dto);

	AjaxResult relieveHt(Long htId);

	List<CyServerht> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(CyServerht cyServerht);


}
