package com.bcxin.ars.service;

import com.bcxin.ars.model.ComStateChangeLog;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ComStateChangeLogPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 自招单位状态变更日志Service接口
 * 
 * @author lin
 * @date 2020-11-04
 */
public interface ComStateChangeLogService{
    /****
     * 删除
     * @param comStateChangeLog
     * @return
     */
    int delete(ComStateChangeLog comStateChangeLog);

    /****
     * 保存
     * @param comStateChangeLog
     * @return
     */
    int save(ComStateChangeLog comStateChangeLog);

    /****
     * 选择性修改
     * @param comStateChangeLog
     * @return
     */
    void updateSelective(ComStateChangeLog comStateChangeLog);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ComStateChangeLog findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(ComStateChangeLogPageSearchDto searchDto, AjaxPageResponse<ComStateChangeLog> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComStateChangeLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComStateChangeLog> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<ComStateChangeLog> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComStateChangeLog> findByBatchId(List<ComStateChangeLog> list);


}
