/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASMessageDto;
import com.bcxin.ars.dto.SAASResultDto;
import com.bcxin.ars.dto.SaaSCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.xiaoleilu.hutool.http.HttpUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SAASInterfaceUtil {
    private static Logger logger = LoggerFactory.getLogger(SAASInterfaceUtil.class);
    @Autowired
    private InterfaceLogDao interfaceLogDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public AjaxResult callInterface(String url, Object paramObj) {
        Map paramMap = BeanUtil.beanToMap((Object)paramObj);
        return this.callInterface(url, paramMap);
    }

    public AjaxResult callInterface(String url, Map<String, Object> paramMap) {
        String msg = "";
        Boolean result = true;
        Object data = null;
        User currentUser = this.arsUtil.getCurrentUser();
        url = this.configUtils.saas_data_host + url;
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));
        if (currentUser != null) {
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            String resultStr = HttpUtil.post((String)url, paramMap);
            interfaceLog.setResult(resultStr);
            SAASResultDto resultDto = (SAASResultDto)JSONObject.parseObject((String)resultStr, SAASResultDto.class);
            if (resultDto != null && StringUtil.isNotEmpty((String)resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if (Constants.BTK_IS_SUCCESS.equals(retType)) {
                    data = resultDto.getData();
                    logger.info("\u767e\u4fdd\u76fe\u4e0eSaas\u540c\u6b65\u6210\u529f");
                } else {
                    result = false;
                    msg = resultDto.getMsg();
                    logger.error(resultStr);
                    logger.info("\u767e\u4fdd\u76fe\u4e0eSaas\u540c\u6b65\u5931\u8d25");
                }
            } else {
                result = false;
                msg = "\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c";
                logger.info("\u767e\u4fdd\u76fe\u4e0eSaas\u540c\u6b65\u5931\u8d25,\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c");
            }
        }
        catch (Exception e) {
            result = false;
            logger.error(e.getMessage(), (Throwable)e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result.booleanValue());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u767e\u4fdd\u76fe\u4e0eSaas\u540c\u6b65\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, data);
    }

    public AjaxResult delSaasMsg(SAASMessageDto message) {
        String url = "public/message/third/batch-delete";
        return this.callInterface(url, message);
    }

    public AjaxResult sendSaasMsg(SAASMessageDto message) {
        String url = "public/message/send-message";
        if (StringUtil.isEmpty((String)message.getSendPer())) {
            message.setSendPer("system");
        }
        if (StringUtil.isEmpty((String)message.getPlatId())) {
            message.setPlatId("11");
        }
        if (StringUtil.isEmpty((String)message.getWay())) {
            message.setWay("3");
        }
        return this.callInterface(url, message);
    }

    public List<SaaSCompany> querySaaSComId(String userNames) {
        List resultList = null;
        String url = "/thirdPlat/bbd-callBack/get-comid-list";
        SAASMessageDto messageDto = new SAASMessageDto();
        messageDto.setUserNames(userNames.toString());
        AjaxResult ajaxResult = this.callInterface(url, messageDto);
        if (ajaxResult.getData() != null) {
            resultList = JSON.parseArray((String)ajaxResult.getData().toString(), SaaSCompany.class);
        }
        return resultList;
    }

    public static void main(String[] args) {
        String url = "http://qiye.baibaodun.cn:9009//thirdPlat/bbd-callBack/batch-per-auth-result";
        HashedMap paramMap = new HashedMap();
        paramMap.put("authList", "[{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622701198909073438\",\"name\":\"\u4fe1\u4f1f\u4f1f\",\"perId\":\"859366421246668800\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"130984197810290634\",\"name\":\"\u65b9\u6d77\u519b\",\"perId\":\"859758876223307776\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"152825197904295014\",\"name\":\"\u859b\u98de\",\"perId\":\"859757317800751104\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622726196510051235\",\"name\":\"\u9648\u94f6\u4e11\",\"perId\":\"857649161364459520\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"370783198606213772\",\"name\":\"\u5f20\u6c38\u5efa\",\"perId\":\"859376346831749120\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622822200101164529\",\"name\":\"\u82cf\u7c89\u83b2\",\"perId\":\"843871599753252864\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"210504196706161877\",\"name\":\"\u80e1\u660e\u5f00\",\"perId\":\"859477932224966656\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622727199011274725\",\"name\":\"\u9f50\u96ea\u6885\",\"perId\":\"859388627141492736\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622727197102093533\",\"name\":\"\u80e1\u5c0f\u8fdb\",\"perId\":\"859389582986080256\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"15030319720607003X\",\"name\":\"\u5f20\u6cbb\u534e\",\"perId\":\"851864067041619968\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622701199003084514\",\"name\":\"\u7126\u5c0f\u4eae\",\"perId\":\"864093615198605312\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"62272219910709361X\",\"name\":\"\u738b\u52c7\",\"perId\":\"566191802059587584\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622826200302181531\",\"name\":\"\u9648\u5764\",\"perId\":\"869581883667279872\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622301196801091916\",\"name\":\"\u97e9\u94f6\u751f\",\"perId\":\"870249763299815424\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"630104196710201014\",\"name\":\"\u5218\u6c38\u536b\",\"perId\":\"871716013578162176\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"630104197706081018\",\"name\":\"\u7eb3\u8fd0\u6765\",\"perId\":\"871716276502302720\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"630104197204072533\",\"name\":\"\u6817\u7ecd\u6d3b\",\"perId\":\"871717643006668800\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"370125198512148512\",\"name\":\"\u6e29\u6d9b\",\"perId\":\"875030918151634944\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"152324200004043816\",\"name\":\"\u5f20\u660e\u6e05\",\"perId\":\"875350174094327808\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"130823199912152516\",\"name\":\"\u6797\u9633\",\"perId\":\"875387354023985152\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"612732200106224821\",\"name\":\"\u59ec\u5a1c\u5a1c\",\"perId\":\"875393863557677056\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"130533200102026616\",\"name\":\"\u891a\u53cc\u6811\",\"perId\":\"875412948081278976\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622726197311050234\",\"name\":\"\u9a6c\u632f\u519b\",\"perId\":\"768827402444292096\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"41148119940310126X\",\"name\":\"\u4e01\u4f73\u8389\",\"perId\":\"875419737746046976\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"522622199912090025\",\"name\":\"\u674e\u94ed\u6b23\",\"perId\":\"875354373325684736\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622722197103241727\",\"name\":\"\u5f90\u5de7\u6842\",\"perId\":\"875359697467080704\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"232126199611020217\",\"name\":\"\u90ed\u5e05\",\"perId\":\"875395042866888704\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"410322198101186842\",\"name\":\"\u675c\u7389\u5174\",\"perId\":\"875681684520534016\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"412728200008283850\",\"name\":\"\u5434\u65ed\u5eb7\",\"perId\":\"875690014244700160\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622822200109234712\",\"name\":\"\u674e\u6f47\",\"perId\":\"875711722309648384\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"513022199904015427\",\"name\":\"\u674e\u6653\u6dcb\",\"perId\":\"875730785233534976\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622726199910152899\",\"name\":\"\u9a6c\u6653\u521a\",\"perId\":\"875397825850507264\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"620121196803101930\",\"name\":\"\u9648\u4e07\u5e74\",\"perId\":\"875708314748026880\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622827199910192315\",\"name\":\"\u675c\u8f89\",\"perId\":\"876885940016111616\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"62282520030407061X\",\"name\":\"\u5f6d\u8d85\",\"perId\":\"880850072852656128\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622823197302183234\",\"name\":\"\u5b8b\u5c1a\u5764\",\"perId\":\"880850072865239040\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"612127197604094013\",\"name\":\"\u5362\u5efa\u519b\",\"perId\":\"882670037611778048\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"612726198912100076\",\"name\":\"\u859b\u6653\u9633\",\"perId\":\"883001290874056704\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"620421199310026127\",\"name\":\"\u8def\u6653\u53f6\",\"perId\":\"882711766813577216\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622701199506122535\",\"name\":\"\u9a6c\u6d77\u8d35\",\"perId\":\"883282525487304704\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"610321196908010444\",\"name\":\"\u738b\u5efa\u534e\",\"perId\":\"857346695524081664\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622726197702090372\",\"name\":\"\u8d3e\u519b\u5e73\",\"perId\":\"857346618105155584\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"620421196907063330\",\"name\":\"\u8d75\u7389\u56fd\",\"perId\":\"882698301638119424\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622826196602200432\",\"name\":\"\u5218\u5168\u79c0\",\"perId\":\"856860450460684288\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622726197604201497\",\"name\":\"\u5218\u80dc\u5229\",\"perId\":\"883283478429462528\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"41108219900529542X\",\"name\":\"\u7533\u8def\u5e73\",\"perId\":\"882684208374509568\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622727196505134737\",\"name\":\"\u9648\u5b8f\u658c\",\"perId\":\"850737740113092608\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"610326196805102233\",\"name\":\"\u674e\u65ed\",\"perId\":\"862347293718376448\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"152921198411095326\",\"name\":\"\u666f\u6dd1\u7ea2\",\"perId\":\"884019423411859456\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622727196405125913\",\"name\":\"\u66f9\u91d1\u660c\",\"perId\":\"884046956450705408\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622426199304121535\",\"name\":\"\u9a6c\u91d1\u864e\",\"perId\":\"859442888416587776\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622701199508063217\",\"name\":\"\u738b\u9e4f\",\"perId\":\"859123145838657536\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622726198801261653\",\"name\":\"\u5cb3\u968f\u82f1\",\"perId\":\"859105576415555584\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622727198906285615\",\"name\":\"\u5f90\u5e06\",\"perId\":\"864094301017763840\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622727199402151116\",\"name\":\"\u674e\u9ad8\u9633\",\"perId\":\"860898290304585728\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"620502199005053635\",\"name\":\"\u91d1\u65ed\u4e1c\",\"perId\":\"864164897965633536\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622726198801072617\",\"name\":\"\u53f2\u4e16\u7ea2\",\"perId\":\"859128364517978112\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622722198803232033\",\"name\":\"\u675c\u4fca\u4ec1\",\"perId\":\"883736844716150784\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622726199101181219\",\"name\":\"\u5f20\u6500\u5cf0\",\"perId\":\"883742149298556928\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"612728198510010863\",\"name\":\"\u827e\u9999\u9999\",\"perId\":\"884475924642992128\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"610323196701160050\",\"name\":\"\u5f20\u5f55\u8ba9\",\"perId\":\"859757724136079360\",\"updateTime\":\"2021-09-08 11:45:12\"},{\"authResult\":\"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002\",\"authStatus\":\"4\",\"idNumber\":\"622727199006174113\",\"name\":\"\u9648\u5e7f\u5468\",\"perId\":\"883394977873424384\",\"updateTime\":\"2021-09-08 11:45:12\"}]");
        String resultStr = HttpUtil.post((String)url, (Map)paramMap);
        System.out.println(resultStr);
    }
}

